/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.ElementSelectionObject;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.OS2200UIStartup;
import com.unisys.tde.ui.actions.ProjectLocationSelectionDialog;
import com.unisys.tde.ui.utils.OS2200ArchitectureUtils;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.session.ISession;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class Copy2200ProjectOperation {
    private MultiStatus errorStatus;
    private Shell parentShell;
    private String[] modelProviderIds;
    private ArrayList<ElementSelectionObject> copiedEsoList = new ArrayList();
    private String errElt = "";
    private String error = "";
    private boolean completed;
    private String destinationWorkfile;
    private String destinationProjectName;
    private String destinationLocation;
    private String destinationWorkfileShare;

    protected static boolean validateCopy(Shell shell, IProject iProject, String string, String[] stringArray) {
        IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = ResourceChangeValidator.getValidator().createDeltaFactory();
        iResourceChangeDescriptionFactory.copy((IResource)iProject, (IPath)new Path(string));
        return IDE.promptToConfirm((Shell)shell, (String)IDEWorkbenchMessages.CopyProjectAction_confirm, (String)NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_warning, (Object)iProject.getName()), (IResourceDelta)iResourceChangeDescriptionFactory.getDelta(), (String[])stringArray, (boolean)false);
    }

    public Copy2200ProjectOperation(Shell shell) {
        this.parentShell = shell;
    }

    public void copyProject(IProject iProject) {
        this.errorStatus = null;
        this.completed = false;
        ProjectLocationSelectionDialog projectLocationSelectionDialog = new ProjectLocationSelectionDialog(this.parentShell, iProject);
        projectLocationSelectionDialog.setTitle(IDEWorkbenchMessages.CopyProjectOperation_copyProject);
        projectLocationSelectionDialog.create();
        int n = projectLocationSelectionDialog.open();
        if (n != 0) {
            return;
        }
        ISession iSession = projectLocationSelectionDialog.getSession();
        String string = projectLocationSelectionDialog.getWorkfileName();
        String string2 = projectLocationSelectionDialog.getWorkfileShare();
        if (!Copy2200ProjectOperation.validateCopy(this.parentShell, iProject, projectLocationSelectionDialog.getName(), this.getModelProviderIds())) {
            return;
        }
        this.performProjectCopy(iProject, projectLocationSelectionDialog.getName(), projectLocationSelectionDialog.getPath(), string, string2, iSession, projectLocationSelectionDialog.getFullFileCopy());
        if (!this.completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.parentShell, (String)IDEWorkbenchMessages.CopyProjectOperation_copyFailedTitle, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    private void performProjectCopy(final IProject iProject, String string, String string2, String string3, String string4, final ISession iSession, final boolean bl) {
        Object object;
        this.destinationProjectName = string;
        this.destinationLocation = string2;
        this.destinationWorkfile = string3;
        this.destinationWorkfileShare = string4;
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                try {
                    Path path;
                    ElementSelectionObject elementSelectionObject;
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ArrayList arrayList = OS2200ProjectUpdate.getLinks((IProject)iProject);
                    iProgressMonitor.beginTask("", arrayList.size() * 2);
                    Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                    String string = properties.getProperty("workFile");
                    String string2 = properties.getProperty("hostID");
                    String string3 = OS2200FileInterface.getCIFSDir((Properties)properties);
                    Properties properties2 = new Properties();
                    properties2.setProperty("hostID", string2);
                    properties2.setProperty("workFile", Copy2200ProjectOperation.this.destinationWorkfile);
                    properties2.setProperty("CIFSDir", string3);
                    OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState((IProject)iProject);
                    properties2.setProperty("ShareState", share.toString());
                    switch (share) {
                        case stdShare: 
                        case cstShare: {
                            properties2.setProperty("OS2200Share", properties.getProperty("OS2200Share"));
                            break;
                        }
                        case nShare: {
                            properties2.setProperty("ProjectShare", Copy2200ProjectOperation.this.destinationWorkfileShare);
                        }
                    }
                    int n = 0;
                    while (n < arrayList.size()) {
                        elementSelectionObject = (ElementSelectionObject)arrayList.get(n);
                        path = new Path(elementSelectionObject.elementName);
                        elementSelectionObject.elementName = path.lastSegment();
                        elementSelectionObject.editOpen = false;
                        arrayList.set(n, elementSelectionObject);
                        ++n;
                    }
                    Copy2200ProjectOperation.this.native2200Copy(arrayList, string, Copy2200ProjectOperation.this.destinationWorkfile, bl, iSession, iProgressMonitor);
                    IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(Copy2200ProjectOperation.this.destinationProjectName);
                    elementSelectionObject = new Path(Copy2200ProjectOperation.this.destinationLocation);
                    if (Platform.getLocation().equals((Object)elementSelectionObject)) {
                        elementSelectionObject = null;
                    }
                    path = Copy2200ProjectOperation.this.createProjectDescription(iProject, Copy2200ProjectOperation.this.destinationProjectName, (IPath)elementSelectionObject);
                    OS2200ProjectUpdate.setBuilder((IProject)iProject2, (IProjectDescription)path);
                    OS2200ProjectUpdate.finishProject((IProject)iProject2, (IPath)elementSelectionObject, (IProjectDescription)path, (IProgressMonitor)new NullProgressMonitor());
                    iProject2.setDescription((IProjectDescription)path, 1, null);
                    OS2200ProjectUpdate.setProperties((IProject)iProject2, (Properties)properties2);
                    OS2200ProjectUpdate.setLinks((IProject)iProject2, (ArrayList)Copy2200ProjectOperation.this.copiedEsoList, (IProgressMonitor)iProgressMonitor);
                    final IResource[] iResourceArray = iProject2.members();
                    Thread thread = new Thread(Messages.getString((String)"Copy2200ProjectOperation_0")){

                        @Override
                        public void run() {
                            if (!OS2200ArchitectureUtils.startDownlodingElements(iResourceArray)) {
                                OS2200UIStartup.downloadUnInitializedFile();
                            }
                        }
                    };
                    thread.setPriority(1);
                    thread.start();
                    iProgressMonitor.done();
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)"Internal Unisys Error", (Throwable)coreException);
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.parentShell).run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            this.completed = false;
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getTargetException().getMessage();
            this.parentShell.getDisplay().syncExec(new Runnable((String)object){
                private final /* synthetic */ String val$message;
                {
                    this.val$message = string;
                }

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Copy2200ProjectOperation.this.parentShell, (String)IDEWorkbenchMessages.CopyProjectOperation_copyFailedTitle, (String)NLS.bind((String)IDEWorkbenchMessages.CopyProjectOperation_internalError, (Object)this.val$message));
                }
            });
            this.completed = false;
        }
        IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.destinationProjectName);
        try {
            object = OS2200ProjectUpdate.getProperties((IProject)iProject2);
            String string5 = ((Properties)object).getProperty("hostID");
            LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string5);
            HostAccount hostAccount = loginAccount.getHostAccount();
            IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
            iPreferenceStore.setValue(iProject2.getName(), String.valueOf(hostAccount.getCifsHostId()) + "#" + hostAccount.getCifsUserId() + "#" + hostAccount.getConnectionName());
            if (iPreferenceStore.needsSaving()) {
                try {
                    iPreferenceStore.putValue(iProject2.getName(), String.valueOf(hostAccount.getCifsHostId()) + "#" + hostAccount.getCifsUserId() + "#" + hostAccount.getConnectionName());
                    ((IPersistentPreferenceStore)iPreferenceStore).save();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Internal Unisys Error", (Throwable)coreException);
        }
        this.completed = true;
    }

    private void native2200Copy(ArrayList arrayList, String string, String string2, boolean bl, ISession iSession, IProgressMonitor iProgressMonitor) {
        try {
            iSession.SendCommand("@qual,r \n");
            if (string.contains("#")) {
                string = string.substring(string.indexOf("#") + 1);
            }
            if (string2.contains("#")) {
                string2 = string2.substring(string2.indexOf("#") + 1);
            }
            if (bl) {
                iProgressMonitor.setTaskName(Messages.getString((String)"Copy2200ProjectOperation_1"));
                iSession.SendCommand("@copy " + string + "," + string2 + "\n");
                this.copiedEsoList = arrayList;
                iProgressMonitor.worked(arrayList.size());
            } else {
                String string3 = "";
                this.error = "";
                this.errElt = "";
                int n = 0;
                while (n < arrayList.size()) {
                    ElementSelectionObject elementSelectionObject = (ElementSelectionObject)arrayList.get(n);
                    String string4 = elementSelectionObject.elementName.replace(".", "/");
                    iProgressMonitor.setTaskName(String.valueOf(Messages.getString((String)"Copy2200ProjectOperation_2")) + string4);
                    iSession.SendCommand("@copy,s " + string + string4 + "," + string2 + "\n");
                    String string5 = iSession.getOutput();
                    if (string5.contains("SYM NOT FOUND")) {
                        string3 = String.valueOf(string3) + string4 + " ";
                    }
                    if (string5.contains("*ERROR")) {
                        this.error = string5;
                        this.errElt = string4;
                        iProgressMonitor.worked(arrayList.size());
                        break;
                    }
                    iProgressMonitor.worked(1);
                    this.copiedEsoList.add(elementSelectionObject);
                    ++n;
                }
                if (string3.length() > 0) {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"Copy2200ProjectOperation_3"), (String)(String.valueOf(Messages.getString((String)"Copy2200ProjectOperation_4")) + string + ":" + "\n" + string3));
                }
                if (this.error.length() > 0) {
                    OS2200CorePlugin.logger.error((Object)this.error);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Copy2200ProjectOperation.this.parentShell, (String)Messages.getString((String)"Copy2200ProjectOperation_5"), (String)(String.valueOf(Messages.getString((String)"Copy2200ProjectOperation_6")) + Copy2200ProjectOperation.this.errElt + Messages.getString((String)"Copy2200ProjectOperation_7") + "\n" + Copy2200ProjectOperation.this.error.trim()));
                        }
                    });
                }
                iSession.SendCommand("@FREE " + string2 + "\n");
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Internal Unisys Error", (Throwable)exception);
        }
    }

    private IProjectDescription createProjectDescription(IProject iProject, String string, IPath iPath) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        iProjectDescription.setName(string);
        iProjectDescription.setLocation(iPath);
        return iProjectDescription;
    }

    private void recordError(CoreException coreException) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, IDEWorkbenchMessages.CopyProjectOperation_copyFailedMessage, (Throwable)coreException);
        }
        this.errorStatus.merge(coreException.getStatus());
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }
}

