/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui;

import com.unisys.os2200.editor.editors.UDTEditor;
import com.unisys.os2200.editor.editors.UDTEditorDocumentProvider;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.license.LicensePlugin;
import com.unisys.tde.plus.editor.PlusEditor;
import com.unisys.tde.plus.editor.PlusEditorDocumentProvider;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.freeformat.COBOLFreeFormatDocumentProvider;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.ValidatorMutable;
import org.eclipse.wst.validation.internal.model.GlobalPreferencesValues;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUIPlugin {
    public static UiPlugin plugin;
    private ResourceBundle resourceBundle;
    public static final String PLUGIN_ID = "com.unisys.tde.ui";
    private long stat;
    private IProject[] projects = null;
    private GlobalPreferencesValues _globalPreferences = ValManager.getDefault().getGlobalPreferences().asValues();
    private ValidatorMutable[] _validators;
    private Thread readXML = null;
    private Thread loadBundleThread = null;

    public UiPlugin() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                OS2200FileInterface.isOutlookConfigured = UiPlugin.this.isOutlookConfigured();
            }
        });
        this.readXML = new Thread(Messages.getString((String)"UiPlugin_0")){

            @Override
            public void run() {
                LoginAccount.getLoginAccount((String)"");
            }
        };
        this.readXML.start();
        this.loadBundleThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UiPlugin.this.resourceBundle = ResourceBundle.getBundle("com.unisys.tde.ui.UiPluginResources");
                }
                catch (MissingResourceException missingResourceException) {
                    UiPlugin.this.resourceBundle = null;
                }
            }
        });
        this.loadBundleThread.start();
        plugin = this;
        try {
            long l = System.currentTimeMillis();
            this.disableStartupPlugins();
            long l2 = System.currentTimeMillis();
            if (OS2200CorePlugin.logger.isInfoEnabled()) {
                OS2200CorePlugin.logger.info((Object)(" Total time consumed to execute disableStartupPlugins, " + (l2 - l) + " milliseconds."));
            }
            long l3 = System.currentTimeMillis();
            this.validateHosts();
            long l4 = System.currentTimeMillis();
            if (OS2200CorePlugin.logger.isInfoEnabled()) {
                OS2200CorePlugin.logger.info((Object)("Time consumed to validate host, " + (l4 - l3) + " milliseconds."));
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception);
        }
    }

    private boolean isOutlookConfigured() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        try {
            OleFrame oleFrame = new OleFrame((Composite)shell, 0);
            OleClientSite oleClientSite = new OleClientSite((Composite)oleFrame, 0, "OVCtl.OVCtl");
            int n = oleClientSite.doVerb(-5);
            if (n == 0) {
                OS2200CorePlugin.logger.debug((Object)"Send Via Email -- Outlook is configured.");
                return true;
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.warn((Object)("Send Via Email -- Outlook is not configured." + exception.getMessage()), (Throwable)exception);
            return false;
        }
        OS2200CorePlugin.logger.warn((Object)"Send Via Email -- Outlook is not configured.");
        return false;
    }

    public void start(BundleContext bundleContext) throws Exception {
        if (LicensePlugin.checkLicense()) {
            super.start(bundleContext);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = UiPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle != null ? resourceBundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void errorDialog(Shell shell, String string, String string2, IStatus iStatus) {
        UiPlugin.getDefault().log(iStatus);
        if (iStatus != null && string2.equals(iStatus.getMessage())) {
            string2 = null;
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public static void errorDialog(Shell shell, String string, String string2, Throwable throwable) {
        IStatus iStatus;
        UiPlugin.getDefault().log(throwable);
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
            if (iStatus != null && string2.equals(iStatus.getMessage())) {
                string2 = null;
            }
        } else {
            iStatus = new Status(4, PLUGIN_ID, -1, "Internal Error: ", throwable);
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public void log(Throwable throwable) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", throwable));
    }

    public void log(IStatus iStatus) {
        this.getLog().log(iStatus);
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void disableStartupPlugins() {
        if (OS2200CorePlugin.logger.isInfoEnabled()) {
            OS2200CorePlugin.logger.info((Object)"");
        }
        try {
            String string = "com.instantiations.eclipse.startup;com.objectaid.uml;com.stateofflow.eclipse.saveme;org.eclipse.cdt.codan.ui.cxx;org.eclipse.cdt.scripting;org.eclipse.epp.mpc.ui;org.eclipse.epp.usagedata.gathering;org.eclipse.epp.usagedata.recording;org.eclipse.equinox.p2.ui.sdk.scheduler;org.eclipse.jst.j2ee.webservice.ui;org.eclipse.jst.ws.jaxws.dom.runtime;org.eclipse.jst.ws.jaxws.utils;org.eclipse.m2e.discovery;org.eclipse.mylyn.team.ui;org.eclipse.update.scheduler;org.eclipse.mylyn.tasks.ui;";
            IPreferenceStore iPreferenceStore = PrefUtil.getInternalPreferenceStore();
            String string2 = iPreferenceStore.getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
            if (string2 != null && string2.trim().length() == 0) {
                iPreferenceStore.putValue("PLUGINS_NOT_ACTIVATED_ON_STARTUP", string);
                PrefUtil.savePrefs();
            }
            this._validators = this.getDefaultValidators();
            this.setAllValidators();
            ValManager valManager = ValManager.getDefault();
            valManager.replace(this._globalPreferences);
            ValPrefManagerGlobal valPrefManagerGlobal = ValPrefManagerGlobal.getDefault();
            valPrefManagerGlobal.savePreferences(valManager.getGlobalPreferences(), this._validators, null);
            this.saveV1Preferences();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception);
        }
    }

    private ValidatorMutable[] getDefaultValidators() {
        if (OS2200CorePlugin.logger.isInfoEnabled()) {
            OS2200CorePlugin.logger.info((Object)"");
        }
        ValidatorMutable[] validatorMutableArray = null;
        try {
            Validator[] validatorArray = ValManager.getDefault().getValidators();
            validatorMutableArray = new ValidatorMutable[validatorArray.length];
            int n = 0;
            while (n < validatorArray.length) {
                validatorMutableArray[n] = new ValidatorMutable(validatorArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception);
        }
        return validatorMutableArray;
    }

    private ValidatorMetaData[] getEnabledBuildValidators() {
        if (OS2200CorePlugin.logger.isInfoEnabled()) {
            OS2200CorePlugin.logger.info((Object)"");
        }
        LinkedList linkedList = new LinkedList();
        ValidatorMetaData[] validatorMetaDataArray = new ValidatorMetaData[linkedList.size()];
        linkedList.toArray(validatorMetaDataArray);
        return validatorMetaDataArray;
    }

    private ValidatorMetaData[] getEnabledManualValidators() {
        if (OS2200CorePlugin.logger.isInfoEnabled()) {
            OS2200CorePlugin.logger.info((Object)"");
        }
        LinkedList linkedList = new LinkedList();
        ValidatorMetaData[] validatorMetaDataArray = new ValidatorMetaData[linkedList.size()];
        linkedList.toArray(validatorMetaDataArray);
        return validatorMetaDataArray;
    }

    private void setAllValidators() {
        if (OS2200CorePlugin.logger.isInfoEnabled()) {
            OS2200CorePlugin.logger.info((Object)"");
        }
        ValidatorMutable[] validatorMutableArray = this._validators;
        int n = this._validators.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMutable validatorMutable = validatorMutableArray[n2];
            validatorMutable.setBuildValidation(false);
            validatorMutable.setManualValidation(false);
            ++n2;
        }
    }

    private void saveV1Preferences() {
        if (OS2200CorePlugin.logger.isInfoEnabled()) {
            OS2200CorePlugin.logger.info((Object)"");
        }
        try {
            GlobalConfiguration globalConfiguration = ConfigurationManager.getManager().getGlobalConfiguration();
            globalConfiguration.setDisableAllValidation(true);
            globalConfiguration.setEnabledManualValidators(this.getEnabledManualValidators());
            globalConfiguration.setEnabledBuildValidators(this.getEnabledBuildValidators());
            globalConfiguration.passivate();
            globalConfiguration.store();
        }
        catch (InvocationTargetException invocationTargetException) {
            ValidationPlugin.getPlugin().handleException((Throwable)invocationTargetException);
        }
    }

    static void openInternal(IFile iFile) {
        try {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)iFile, (boolean)true);
        }
        catch (PartInitException partInitException) {}
    }

    private void regListener() {
        ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = iCommandService.getCommand("org.eclipse.ui.file.refresh");
        command.addExecutionListener(new IExecutionListener(){

            public void preExecute(String string, ExecutionEvent executionEvent) {
            }

            public void postExecuteSuccess(String string, Object object) {
                IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                if (iEditorPart != null && iEditorInput instanceof OS2200FileEditorInput) {
                    PlusEditor plusEditor;
                    PlusEditorDocumentProvider plusEditorDocumentProvider;
                    OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
                    if (iEditorPart instanceof COBOLEditor) {
                        COBOLEditor cOBOLEditor = (COBOLEditor)iEditorPart;
                        COBOLFreeFormatDocumentProvider cOBOLFreeFormatDocumentProvider = (COBOLFreeFormatDocumentProvider)cOBOLEditor.getDocumentProvider();
                        if (!cOBOLFreeFormatDocumentProvider.isSynchronized((Object)oS2200FileEditorInput)) {
                            try {
                                cOBOLFreeFormatDocumentProvider.resetDocument((Object)oS2200FileEditorInput);
                            }
                            catch (CoreException coreException) {
                                OS2200CorePlugin.logger.error((Object)coreException.getMessage());
                            }
                        }
                    } else if (iEditorPart instanceof CEditor) {
                        CEditor cEditor = (CEditor)iEditorPart;
                        if (cEditor.getDocumentProvider().getModificationStamp((Object)oS2200FileEditorInput) != cEditor.getDocumentProvider().getSynchronizationStamp((Object)oS2200FileEditorInput)) {
                            try {
                                cEditor.getDocumentProvider().resetDocument((Object)oS2200FileEditorInput);
                            }
                            catch (CoreException coreException) {
                                OS2200CorePlugin.logger.error((Object)coreException.getMessage());
                            }
                        }
                    } else if (iEditorPart instanceof UDTEditor) {
                        UDTEditor uDTEditor = (UDTEditor)iEditorPart;
                        Path path = new Path(oS2200FileEditorInput.getFile().getPath());
                        if (path.segmentCount() == 4) {
                            try {
                                ((UDTEditorDocumentProvider)uDTEditor.getDocumentProvider()).resetDocument((Object)oS2200FileEditorInput);
                            }
                            catch (CoreException coreException) {
                                OS2200CorePlugin.logger.error((Object)coreException.getMessage());
                            }
                            return;
                        }
                        if (!((UDTEditorDocumentProvider)uDTEditor.getDocumentProvider()).isSynchronized((Object)oS2200FileEditorInput)) {
                            try {
                                ((UDTEditorDocumentProvider)uDTEditor.getDocumentProvider()).resetDocument((Object)oS2200FileEditorInput);
                            }
                            catch (CoreException coreException) {
                                OS2200CorePlugin.logger.error((Object)coreException.getMessage());
                            }
                        }
                    } else if (iEditorPart instanceof PlusEditor && !(plusEditorDocumentProvider = (PlusEditorDocumentProvider)(plusEditor = (PlusEditor)iEditorPart).getDocumentProvider()).isSynchronized((Object)oS2200FileEditorInput)) {
                        try {
                            plusEditorDocumentProvider.resetDocument((Object)oS2200FileEditorInput);
                        }
                        catch (CoreException coreException) {
                            OS2200CorePlugin.logger.error((Object)coreException.getMessage());
                        }
                    }
                }
            }

            public void postExecuteFailure(String string, ExecutionException executionException) {
            }

            public void notHandled(String string, NotHandledException notHandledException) {
            }
        });
    }

    private void validateHosts() {
        try {
            OS2200ProjectUpdate.setUiPluginExecuted((boolean)false);
            this.projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            if (this.projects == null || this.projects.length == 0) {
                return;
            }
            if (OS2200CorePlugin.logger.isInfoEnabled()) {
                OS2200CorePlugin.logger.info((Object)("Projects in workspace :" + this.projects.length));
            }
            while (this.readXML.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception);
                }
            }
            while (this.loadBundleThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception);
                }
            }
            OS2200ProjectUpdate.setUiPluginExecuted((boolean)true);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception);
        }
    }
}

