/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.ExclusiveFileLockChecker;
import com.unisys.os2200.util.FileInfo;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.os2200.util.UtilLogger;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.PDPCopyProc;
import com.unisys.tde.license.LicensePlugin;
import com.unisys.tde.ui.dialogs.CacheConflictDialog;
import com.unisys.tde.ui.dialogs.SaveConflictDialog;
import com.unisys.tde.ui.dialogs.SyncInfoObject;
import com.unisys.tde.ui.listeners.ConnectionStatusChecker;
import com.unisys.tde.ui.listeners.HostManagerViewEventSource;
import com.unisys.tde.ui.utils.OS2200ArchitectureUtils;
import com.unisys.tde.ui.utils.OS2200CompareUtils;
import com.unisys.tde.ui.utils.ScheduleTask;
import com.unisys.tde.ui.views.HostManagerViewModel;
import com.unisys.tde.ui.views.OS2200View;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.SaveablesList;

public class OS2200UIStartup
implements IStartup {
    private IEditorPart[] dirtyEditors = null;
    private TDECoreUtilities synchronizer = TDECoreUtilities.getInstance();
    private SyncInfoObject SyncInfoobj = null;
    private static HashSet<HostManagerViewModel> hostSet = null;
    public static Thread t1 = null;

    public void earlyStartup() {
        Thread thread;
        OS2200CorePlugin.logger.debug((Object)"");
        if (!LicensePlugin.checkLicense()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                try {
                    progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            try {
                                try {
                                    iProgressMonitor.beginTask(Messages.getString((String)"OS2200UIStartup_0"), 2);
                                    OS2200UIStartup.this.hookWorkbenchListener();
                                    iProgressMonitor.worked(1);
                                    try {
                                        OS2200UIStartup.this.checkForGoodPerspective();
                                    }
                                    catch (Throwable throwable) {
                                        OS2200CorePlugin.logger.error((Object)"Throwable doing startup ", throwable);
                                    }
                                    iProgressMonitor.worked(1);
                                }
                                catch (Exception exception) {
                                    OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                                    iProgressMonitor.done();
                                    iProgressMonitor.done();
                                }
                            }
                            finally {
                                iProgressMonitor.done();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        });
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        try {
            IProject[] iProjectArray2 = iProjectArray;
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Properties properties;
                String string;
                thread = iProjectArray2[n2];
                if (thread.isOpen() && thread.hasNature("com.unisys.tde.core.OS2200") && LoginAccount.getLoginAccount((String)(string = (properties = OS2200ProjectUpdate.getProperties((IProject)thread)).getProperty("hostID"))) == null) {
                    OS2200CorePlugin.logger.info((Object)("'" + thread.getName() + "' is not associated with any connection."));
                    thread.close(null);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
        }
        thread = new Thread(Messages.getString((String)"OS2200UIStartup_1")){

            @Override
            public void run() {
                OS2200UIStartup.updateProjecticon();
                OS2200UIStartup.downloadUnInitializedFile();
            }
        };
        thread.setPriority(1);
        thread.start();
        new OS2200CompareUtils().checkForMissingCompProps();
        ScheduleTask scheduleTask = new ScheduleTask();
        scheduleTask.schedule();
        t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                OS2200UIStartup.startHMVStatusThread();
            }
        }, "HMVStatusCheckUIStartUp");
        t1.setPriority(1);
        t1.start();
    }

    public static void startHMVStatusThread() {
        OS2200CorePlugin.logger.debug((Object)"");
        try {
            while (true) {
                String string;
                string = (string = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(OS2200ProjectUpdate.SCHEDULED_HMV_STS_CHECK)) == null ? String.valueOf(600000) : String.valueOf(60000 * Integer.parseInt(string));
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 600000;
                    OS2200CorePlugin.logger.debug((Object)("Exception occured while parsing, hence default value is set " + n));
                    OS2200CorePlugin.logger.info((Object)numberFormatException.getMessage(), (Throwable)numberFormatException);
                }
                OS2200CorePlugin.logger.debug((Object)("Frequency set to " + n));
                hostSet = ConnectionStatusChecker.getInstance().getHostStatus();
                HostManagerViewEventSource.getEventSource().handleHMVConStatusEvent(hostSet);
                Thread.sleep(n);
            }
        }
        catch (InterruptedException interruptedException) {
            OS2200CorePlugin.logger.error((Object)interruptedException.getMessage(), (Throwable)interruptedException);
            return;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    private void hookWorkbenchListener() {
        OS2200CorePlugin.logger.info((Object)"");
        try {
            final IWorkbenchWindow[] iWorkbenchWindowArray = OS2200CorePlugin.myWorkbench.getWorkbenchWindows();
            SaveablesList saveablesList = (SaveablesList)iWorkbenchWindowArray[0].getService(ISaveablesLifecycleListener.class);
            ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = iCommandService.getCommand(ActionFactory.SAVE.getCommandId());
            command.addExecutionListener(new IExecutionListener(){
                IProjectNature natureID = null;

                public void preExecute(String string, ExecutionEvent executionEvent) {
                    OS2200CorePlugin.logger.debug((Object)"");
                    String string2 = null;
                    IEditorPart iEditorPart = iWorkbenchWindowArray[0].getActivePage().getActiveEditor();
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (iEditorInput instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                        string2 = iFileEditorInput.getFile().getRawLocation().toOSString();
                        try {
                            this.natureID = iFileEditorInput.getFile().getProject().getNature("com.unisys.tde.core.OS2200");
                        }
                        catch (CoreException coreException) {
                            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                        }
                        OS2200CorePlugin.logger.debug((Object)(String.valueOf(string2) + " is added to the monitor "));
                        OS2200UIStartup.this.synchronizer.monitor(string2);
                    }
                }

                public void postExecuteSuccess(String string, Object object) {
                    OS2200CorePlugin.logger.debug((Object)"");
                    if (this.natureID == null) {
                        return;
                    }
                    IEditorPart iEditorPart = iWorkbenchWindowArray[0].getActivePage().getActiveEditor();
                    if (iEditorPart == null) {
                        return;
                    }
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    boolean bl = OS2200UIStartup.this.copyFile(iEditorInput);
                    IFile iFile = null;
                    if (iEditorInput instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                        iFile = iFileEditorInput.getFile();
                        OS2200UIStartup.setIconForElt(iFile, bl);
                        OS2200ArchitectureUtils.getProjectRefresh();
                    }
                    PDPCopyProc.getPDPCopyProcInstance().checkAndPerformPdp();
                }

                public void postExecuteFailure(String string, ExecutionException executionException) {
                    OS2200CorePlugin.logger.debug((Object)"");
                }

                public void notHandled(String string, NotHandledException notHandledException) {
                    OS2200CorePlugin.logger.debug((Object)"");
                }
            });
            Command command2 = iCommandService.getCommand(ActionFactory.SAVE_ALL.getCommandId());
            command2.addExecutionListener(new IExecutionListener(){
                HashSet<SyncInfoObject> out_Of_Sync_Element_Set = null;
                ArrayList<IFile> off_Line_Element_List = null;
                ArrayList<IFile> sync_Element_List = null;
                IFile inputFile = null;
                File dirtyEditorPath = null;
                IProject proj = null;

                public void preExecute(String string, ExecutionEvent executionEvent) {
                    OS2200CorePlugin.logger.debug((Object)"");
                    OS2200UIStartup.this.dirtyEditors = iWorkbenchWindowArray[0].getActivePage().getDirtyEditors();
                    this.out_Of_Sync_Element_Set = new HashSet();
                    this.off_Line_Element_List = new ArrayList();
                    this.sync_Element_List = new ArrayList();
                    IEditorPart[] iEditorPartArray = OS2200UIStartup.this.dirtyEditors;
                    int n = iEditorPartArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block12: {
                            IEditorPart iEditorPart = iEditorPartArray[n2];
                            if (iEditorPart != null) {
                                this.inputFile = ResourceUtil.getFile((IEditorInput)iEditorPart.getEditorInput());
                                if (this.inputFile != null) {
                                    block11: {
                                        try {
                                            if (this.inputFile.getProject().hasNature("com.unisys.tde.core.OS2200")) break block11;
                                            break block12;
                                        }
                                        catch (CoreException coreException) {
                                            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                                        }
                                    }
                                    OS2200CorePlugin.logger.debug((Object)(String.valueOf(this.inputFile.getName()) + " is dirty."));
                                    OS2200UIStartup.this.synchronizer.monitor(this.inputFile.getRawLocation().toOSString());
                                    this.dirtyEditorPath = this.inputFile.getLocation().toFile();
                                    this.proj = this.inputFile.getProject();
                                    try {
                                        long l = OS2200ProjectUpdate.connectOS2200((IProject)this.proj, (boolean)true);
                                        if (l != 0L) {
                                            OS2200CorePlugin.logger.debug((Object)" Connection was not successful ");
                                            this.off_Line_Element_List.add(this.inputFile);
                                            this.proj.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "False");
                                        } else if (TDECoreUtilities.isPhysicallyInSync((File)this.dirtyEditorPath)) {
                                            this.sync_Element_List.add(this.inputFile);
                                            this.proj.setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "True");
                                        } else {
                                            OS2200UIStartup.this.SyncInfoobj = new SyncInfoObject(this.inputFile, "conflict");
                                            this.out_Of_Sync_Element_Set.add(OS2200UIStartup.this.SyncInfoobj);
                                        }
                                    }
                                    catch (CoreException coreException) {
                                        OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                }

                public void postExecuteSuccess(String string, Object object) {
                    block19: {
                        OS2200CorePlugin.logger.debug((Object)"");
                        try {
                            try {
                                CacheConflictDialog cacheConflictDialog;
                                if (this.off_Line_Element_List != null && this.off_Line_Element_List.size() > 0) {
                                    StringBuffer object42 = new StringBuffer();
                                    int n = 0;
                                    object42.append(String.valueOf(Messages.getString((String)"OS2200UIStartup_2")) + this.off_Line_Element_List.size() + Messages.getString((String)"OS2200UIStartup_3") + "\n\n");
                                    OS2200CorePlugin.logger.info((Object)(String.valueOf(this.off_Line_Element_List.toString()) + " element(s) cannot be saved to the host because the network is not available."));
                                    for (IFile iFile : this.off_Line_Element_List) {
                                        if (n < 5) {
                                            object42.append("\t" + iFile.toString() + "\n");
                                        } else if (n == 5) {
                                            object42.append("\t\t" + (this.off_Line_Element_List.size() - 5) + Messages.getString((String)"OS2200UIStartup_4") + "\n");
                                        }
                                        ++n;
                                        OS2200UIStartup.setIconForElt(iFile, false);
                                    }
                                    MessageDialog.openInformation((Shell)new Shell(), (String)Messages.getString((String)"OS2200UIStartup_5"), (String)object42.toString());
                                }
                                if (this.sync_Element_List != null && this.sync_Element_List.size() > 0) {
                                    for (IFile iFile : this.sync_Element_List) {
                                        String string2 = TDECoreUtilities.getCIFSPathFromFilePath((String)iFile.getRawLocation().toOSString());
                                        if (string2 != null) {
                                            String string3 = OS2200UIStartup.this.synchronizer.copyToHost(iFile.getRawLocation().toFile(), new File(string2));
                                            if (string3.length() == 0) {
                                                OS2200UIStartup.setIconForElt(iFile, true);
                                                continue;
                                            }
                                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200UIStartUp.1"), (String)(String.valueOf(Messages.getString((String)"OS2200UIStartUp.2")) + string3 + Messages.getString((String)"OS2200UIStartUp.3")));
                                            OS2200UIStartup.setIconForElt(iFile, false);
                                            continue;
                                        }
                                        OS2200UIStartup.setIconForElt(iFile, false);
                                    }
                                }
                                if (this.out_Of_Sync_Element_Set.size() > 1 && (cacheConflictDialog = new CacheConflictDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.out_Of_Sync_Element_Set, null, null, null, "Sync with Local")).open() == 0) {
                                    List<IFile> list = cacheConflictDialog.getSelectedoutOfSyncEltList();
                                    List<IFile> list2 = cacheConflictDialog.getUnselectedoutOfSyncEltList();
                                    for (IFile iFile : list) {
                                        String string4 = TDECoreUtilities.getCIFSPathFromFilePath((String)iFile.getRawLocation().toOSString());
                                        String string5 = OS2200UIStartup.this.synchronizer.copyToHost(iFile.getRawLocation().toFile(), new File(string4));
                                        if (string5.length() == 0) {
                                            OS2200UIStartup.setIconForElt(iFile, true);
                                            continue;
                                        }
                                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200UIStartUp.1"), (String)(String.valueOf(Messages.getString((String)"OS2200UIStartUp.2")) + string5 + Messages.getString((String)"OS2200UIStartUp.3")));
                                        OS2200UIStartup.setIconForElt(iFile, false);
                                    }
                                    if (list2 != null) {
                                        for (IFile iFile : list2) {
                                            OS2200UIStartup.setIconForElt(iFile, false);
                                        }
                                    }
                                }
                                OS2200ArchitectureUtils.getProjectRefresh();
                            }
                            catch (Exception exception) {
                                OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                                this.out_Of_Sync_Element_Set = null;
                                this.off_Line_Element_List = null;
                                this.sync_Element_List = null;
                                this.inputFile = null;
                                this.dirtyEditorPath = null;
                                this.proj = null;
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            this.out_Of_Sync_Element_Set = null;
                            this.off_Line_Element_List = null;
                            this.sync_Element_List = null;
                            this.inputFile = null;
                            this.dirtyEditorPath = null;
                            this.proj = null;
                            throw throwable;
                        }
                        this.out_Of_Sync_Element_Set = null;
                        this.off_Line_Element_List = null;
                        this.sync_Element_List = null;
                        this.inputFile = null;
                        this.dirtyEditorPath = null;
                        this.proj = null;
                    }
                    OS2200ArchitectureUtils.getProjectRefresh();
                }

                public void postExecuteFailure(String string, ExecutionException executionException) {
                    OS2200CorePlugin.logger.debug((Object)"");
                }

                public void notHandled(String string, NotHandledException notHandledException) {
                    OS2200CorePlugin.logger.debug((Object)"");
                }
            });
            saveablesList.addModelLifecycleListener(new ISaveablesLifecycleListener(){

                public void handleLifecycleEvent(SaveablesLifecycleEvent saveablesLifecycleEvent) {
                    if (saveablesLifecycleEvent.getEventType() == 3) {
                        OS2200UIStartup.this.handleFileSync(saveablesLifecycleEvent.getSaveables());
                    }
                }
            });
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static void setIconForElt(IFile iFile, boolean bl) {
        OS2200CorePlugin.logger.debug((Object)"");
        try {
            if (!bl) {
                iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
            } else {
                iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
            }
            iFile.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
    }

    public void checkForGoodPerspective() {
        OS2200CorePlugin.logger.info((Object)"");
        IWorkbenchWindow[] iWorkbenchWindowArray = OS2200CorePlugin.myWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                this.checkOldPerspective(iWorkbenchPageArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void checkOldPerspective(final IWorkbenchPage iWorkbenchPage) {
        OS2200CorePlugin.logger.info((Object)"");
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart iViewPart;
                IPerspectiveDescriptor iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
                if (iPerspectiveDescriptor.getId().equals("com.unisys.tde.OS2200Perspective") && (iViewPart = iWorkbenchPage.findView("com.unisys.tde.ui.views.OS2200View")) == null) {
                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                        OS2200CorePlugin.logger.info((Object)"no 2200 view");
                    }
                    try {
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        final IWorkbenchPage iWorkbenchPage2 = iWorkbenchPage;
                        final IPerspectiveDescriptor iPerspectiveDescriptor2 = iPerspectiveDescriptor;
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                        OS2200CorePlugin.logger.info((Object)"closing and opening perspective");
                                    }
                                    iWorkbenchPage2.closePerspective(iPerspectiveDescriptor2, false, false);
                                    iWorkbenchPage2.setPerspective(iPerspectiveDescriptor2);
                                }
                                catch (Exception exception) {
                                    OS2200CorePlugin.logger.error((Object)"exception trying to change perspective", (Throwable)exception);
                                }
                                catch (Throwable throwable) {
                                    OS2200CorePlugin.logger.error((Object)"exception trying to change perspective", throwable);
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)"evil exception trying to run change perspective", (Throwable)exception);
                    }
                }
            }
        });
    }

    public boolean copyFile(IEditorInput iEditorInput) {
        OS2200CorePlugin.logger.debug((Object)"");
        boolean bl = false;
        IFileEditorInput iFileEditorInput = null;
        HashSet<SyncInfoObject> hashSet = new HashSet<SyncInfoObject>();
        try {
            try {
                if (iEditorInput instanceof IFileEditorInput) {
                    iFileEditorInput = (IFileEditorInput)iEditorInput;
                    IFile iFile = iFileEditorInput.getFile();
                    long l = OS2200ProjectUpdate.connectOS2200((IProject)iFile.getProject(), (boolean)true);
                    if (l == 0L) {
                        Object object;
                        OS2200CorePlugin.logger.debug((Object)" Connection successful ");
                        iFile.getProject().setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "True");
                        FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(iFile.getRawLocation().toOSString());
                        String string = iFile.getRawLocation().toOSString();
                        String string2 = TDECoreUtilities.getCIFSPathFromFilePath((String)string);
                        if (fileInfo != null) {
                            if (!new File(fileInfo.getRemoteFile()).exists()) {
                                this.SyncInfoobj = new SyncInfoObject(iFile, "element_deleted");
                                hashSet.add(this.SyncInfoobj);
                            } else if (fileInfo.remoteFileModified()) {
                                this.SyncInfoobj = new SyncInfoObject(iFile, "conflict");
                                hashSet.add(this.SyncInfoobj);
                            } else {
                                OS2200CorePlugin.logger.debug((Object)(" Copying  " + string + " to " + string2));
                                object = TDECoreUtilities.getInstance().copyToHost(new File(string), new File(string2), null);
                                if (object.length() == 0) {
                                    OS2200CorePlugin.logger.debug((Object)(" coping from " + string + " to " + string2 + " was successfull."));
                                    bl = true;
                                    OS2200UIStartup.setIconForElt(iFile, true);
                                } else {
                                    OS2200CorePlugin.logger.debug((Object)(" coping from " + string + " to " + string2 + " failed, because " + (String)object));
                                    ExclusiveFileLockChecker.HandleForExclusiveFileHold((String)object, (String)OS2200ProjectUpdate.getWorkFileForProj((IProject)iFile.getProject()), (String)object);
                                    OS2200UIStartup.setIconForElt(iFile, false);
                                    bl = false;
                                }
                            }
                        } else {
                            bl = false;
                        }
                        if (hashSet.size() == 1) {
                            object = new SaveConflictDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), iFile, "Sync with Local");
                            if (object.open() == 0) {
                                OS2200CorePlugin.logger.debug((Object)" Save Conflict Dialog Opened ");
                                String string3 = TDECoreUtilities.getInstance().copyToHost(new File(string), new File(string2), null);
                                if (string3.length() == 0) {
                                    OS2200CorePlugin.logger.debug((Object)(" coping from " + string + " to " + string2 + " was successfull."));
                                    bl = true;
                                    OS2200UIStartup.setIconForElt(iFile, true);
                                } else {
                                    OS2200CorePlugin.logger.debug((Object)(" coping from " + string + " to " + string2 + " failed, because " + string3));
                                    OS2200UIStartup.setIconForElt(iFile, false);
                                    bl = false;
                                }
                            } else {
                                OS2200CorePlugin.logger.debug((Object)" Save Conflict Dialog cancelled by the user. ");
                                OS2200UIStartup.setIconForElt(iFile, false);
                                bl = false;
                            }
                        } else if (hashSet.size() > 1) {
                            object = new CacheConflictDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), hashSet, null, null, null, "Sync with Local");
                            if (object.open() == 0) {
                                OS2200CorePlugin.logger.debug((Object)" Cache Conflict Dialog Opened ");
                                File file = new File(string);
                                File file2 = new File(string2);
                                String string4 = TDECoreUtilities.getInstance().copyToHost(file, file2);
                                if (string4.length() == 0) {
                                    OS2200UIStartup.setIconForElt(iFile, true);
                                    bl = true;
                                } else {
                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200UIStartUp.1"), (String)(String.valueOf(Messages.getString((String)"OS2200UIStartUp.2")) + string4 + Messages.getString((String)"OS2200UIStartUp.3")));
                                    OS2200UIStartup.setIconForElt(iFile, false);
                                    bl = false;
                                }
                            } else {
                                OS2200CorePlugin.logger.debug((Object)" Cache Conflict Dialog canceled ");
                                bl = false;
                            }
                        }
                    } else {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OpenFileAction.4"), (String)Messages.getString((String)"SaveAction.1"));
                        OS2200CorePlugin.logger.debug((Object)" Connection failed ");
                        iFile.getProject().setPersistentProperty(OS2200ArchitectureConstant.IS_CONNECTED, "False");
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
                iFileEditorInput = null;
                hashSet = null;
                return false;
            }
        }
        finally {
            iFileEditorInput = null;
            hashSet = null;
        }
        return bl;
    }

    private static OS2200View getViewObject() {
        IViewReference iViewReference;
        OS2200CorePlugin.logger.debug((Object)"");
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        if (iWorkbenchPage != null && (iViewReference = iWorkbenchPage.findViewReference("com.unisys.tde.ui.views.OS2200View")) != null) {
            OS2200View oS2200View = null;
            oS2200View = (OS2200View)iViewReference.getView(true);
            return oS2200View;
        }
        return null;
    }

    protected void handleFileSync(final Saveable[] saveableArray) {
        OS2200CorePlugin.logger.debug((Object)"");
        try {
            final HashSet<SyncInfoObject> hashSet = new HashSet<SyncInfoObject>();
            final ArrayList<IFile> arrayList = new ArrayList<IFile>(saveableArray.length);
            final HashMap<IProject, Long> hashMap = new HashMap<IProject, Long>(saveableArray.length);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IFile iFile = null;
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    Path path = null;
                    IProject iProject = null;
                    long l = -2L;
                    int n = 0;
                    while (n < saveableArray.length) {
                        block13: {
                            if (!saveableArray[n].getToolTipText().startsWith(" Comparing ") && !saveableArray[n].getToolTipText().contains("UNTITLED")) {
                                path = new Path(saveableArray[n].getToolTipText());
                                iFile = iWorkspaceRoot.getFile((IPath)path);
                                path = null;
                                if (iFile != null) {
                                    block12: {
                                        iProject = iFile.getProject();
                                        try {
                                            if (!iProject.exists() || !iProject.isOpen() || iProject.hasNature("com.unisys.tde.core.OS2200")) break block12;
                                            break block13;
                                        }
                                        catch (CoreException coreException) {
                                            OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
                                        }
                                    }
                                    if (!hashMap.containsKey(iProject)) {
                                        try {
                                            l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)false);
                                        }
                                        catch (CoreException coreException) {
                                            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                                        }
                                        hashMap.put(iProject, l);
                                    } else {
                                        l = (Long)hashMap.get(iProject);
                                    }
                                    OS2200UIStartup.this.processCloseOperation(l, iFile, hashSet, arrayList);
                                    try {
                                        iFile.refreshLocal(0, null);
                                        OS2200View oS2200View = OS2200ArchitectureUtils.getViewObject();
                                        if (oS2200View != null) {
                                            oS2200View.getViewer().refresh((Object)iFile, true);
                                        }
                                    }
                                    catch (CoreException coreException) {
                                        OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                                    }
                                }
                            }
                        }
                        ++n;
                    }
                }
            });
            this.processConflictStatus(hashSet, arrayList, hashMap);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void processCloseOperation(long l, IFile iFile, HashSet<SyncInfoObject> hashSet, List<IFile> list) {
        block9: {
            OS2200CorePlugin.logger.debug((Object)"");
            try {
                if (iFile.getRawLocation() == null) {
                    return;
                }
                String string = iFile.getRawLocation().toOSString();
                if (l == 0L) {
                    FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(string);
                    if (fileInfo != null) {
                        File file = new File(fileInfo.getRemoteFile());
                        if (!fileInfo.isFileModified()) break block9;
                        OS2200CorePlugin.logger.debug((Object)(String.valueOf(string) + " is modified "));
                        if (fileInfo.localFileModified() && fileInfo.remoteFileModified()) {
                            SyncInfoObject syncInfoObject = new SyncInfoObject(iFile, "conflict");
                            hashSet.add(syncInfoObject);
                            break block9;
                        }
                        if (!fileInfo.localFileModified()) break block9;
                        OS2200CorePlugin.logger.debug((Object)(String.valueOf(string) + " is locally modified "));
                        String string2 = this.synchronizer.copyToHost(new File(string), file);
                        try {
                            if (string2.length() == 0) {
                                OS2200CorePlugin.logger.info((Object)(String.valueOf(string) + " copied successfully to the host"));
                                iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                                break block9;
                            }
                            OS2200CorePlugin.logger.info((Object)("Did not copy " + string + " to the host"));
                            iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                            list.add(iFile);
                        }
                        catch (CoreException coreException) {
                            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                        }
                        break block9;
                    }
                    OS2200CorePlugin.logger.info((Object)"FileInfo returned null.");
                    iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                    list.add(iFile);
                    break block9;
                }
                OS2200CorePlugin.logger.info((Object)("Did not copy " + string + " to the host"));
                iFile.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                list.add(iFile);
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    private void processConflictStatus(HashSet<SyncInfoObject> hashSet, List<IFile> list, Map<IProject, Long> map) {
        OS2200CorePlugin.logger.debug((Object)"");
        try {
            if (hashSet.size() == 1) {
                SyncInfoObject syncInfoObject = hashSet.iterator().next();
                IFile iFile = syncInfoObject.getIfile();
                SaveConflictDialog saveConflictDialog = new SaveConflictDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), iFile, "Sync with Local");
                String string = iFile.getRawLocation().toOSString();
                String string2 = TDECoreUtilities.getCIFSPathFromFilePath((String)string);
                if (saveConflictDialog.open() == 0) {
                    OS2200CorePlugin.logger.debug((Object)"Save Conflict Dialog Opened ");
                    String string3 = "";
                    long l = map.get(iFile.getProject());
                    string3 = l == 0L ? TDECoreUtilities.getInstance().copyToHost(new File(string), new File(string2), null) : "Connection Unavailable";
                    if ((long)string3.length() == 0L) {
                        OS2200CorePlugin.logger.info((Object)("Coping from " + string + " to " + string2 + " is successful."));
                        OS2200UIStartup.setIconForElt(iFile, true);
                    } else {
                        OS2200CorePlugin.logger.info((Object)("Coping from " + string + " to " + string2 + " failed, because : " + string3));
                        OS2200UIStartup.setIconForElt(iFile, false);
                        list.add(iFile);
                    }
                } else {
                    OS2200CorePlugin.logger.debug((Object)"Save Conflict Dialog cancelled by the user. ");
                    OS2200UIStartup.setIconForElt(iFile, false);
                    list.add(iFile);
                }
            } else if (hashSet.size() > 1) {
                CacheConflictDialog cacheConflictDialog = new CacheConflictDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), hashSet, null, null, null, "Sync with Local");
                if (cacheConflictDialog.open() == 0) {
                    OS2200CorePlugin.logger.debug((Object)"Cache Conflict Dialog Opened ");
                    List<IFile> list2 = cacheConflictDialog.getSelectedoutOfSyncEltList();
                    List<IFile> list3 = cacheConflictDialog.getUnselectedoutOfSyncEltList();
                    for (IFile iFile : list2) {
                        String string = "";
                        long l = map.get(iFile.getProject());
                        String string4 = "";
                        if (l == 0L) {
                            string4 = TDECoreUtilities.getCIFSPathFromFilePath((String)iFile.getRawLocation().toOSString());
                            string = this.synchronizer.copyToHost(iFile.getRawLocation().toFile(), new File(string4));
                        } else {
                            string = "Connection Unavailable";
                        }
                        if (string.length() == 0) {
                            OS2200CorePlugin.logger.debug((Object)("Coping from " + iFile.getRawLocation().toFile() + " to " + string4 + " is successful."));
                            OS2200UIStartup.setIconForElt(iFile, true);
                            continue;
                        }
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200UIStartUp.1"), (String)(String.valueOf(Messages.getString((String)"OS2200UIStartUp.2")) + string + Messages.getString((String)"OS2200UIStartUp.3")));
                        OS2200CorePlugin.logger.debug((Object)("Coping from " + iFile.getRawLocation().toFile() + " to " + string4 + " failed, because : " + string));
                        OS2200UIStartup.setIconForElt(iFile, false);
                        list.add(iFile);
                    }
                    if (list3 != null) {
                        for (IFile iFile : list3) {
                            OS2200UIStartup.setIconForElt(iFile, false);
                        }
                    }
                } else {
                    OS2200CorePlugin.logger.debug((Object)"Cache Conflict Dialog canceled.");
                }
            }
            OS2200ArchitectureUtils.getProjectRefresh();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateProjecticon() {
        OS2200CorePlugin.logger.debug((Object)"enter update project icon method");
        try {
            IProject[] iProjectArray;
            IProject[] iProjectArray2 = iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (true) {
                block24: {
                    IProject iProject;
                    block23: {
                        if (n2 >= n) {
                            return;
                        }
                        iProject = iProjectArray2[n2];
                        if (iProject.isOpen()) break block23;
                        OS2200CorePlugin.logger.debug((Object)(String.valueOf(iProject.getName()) + " is closed."));
                        break block24;
                    }
                    long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)false);
                    IResource[] iResourceArray = iProject.members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (true) {
                        block22: {
                            FileInfo fileInfo;
                            File file;
                            IResource iResource;
                            block28: {
                                block29: {
                                    block26: {
                                        IPath iPath;
                                        block27: {
                                            block25: {
                                                block21: {
                                                    if (n4 >= n3) {
                                                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                OS2200View oS2200View = OS2200UIStartup.getViewObject();
                                                                if (oS2200View != null) {
                                                                    OS2200UIStartup.getViewObject().getViewer().refresh(true);
                                                                } else {
                                                                    OS2200CorePlugin.logger.warn((Object)"OS2200 View is null");
                                                                }
                                                            }
                                                        });
                                                        break;
                                                    }
                                                    iResource = iResourceArray[n4];
                                                    if (!(iResource instanceof IFile) || iResource.toString().toLowerCase().endsWith(".project") || iResource.toString().toLowerCase().endsWith(".settings")) break block22;
                                                    try {
                                                        if (((IFile)iResource).getProject().hasNature("com.unisys.tde.core.OS2200")) break block21;
                                                        break block22;
                                                    }
                                                    catch (CoreException coreException) {
                                                        OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                                                    }
                                                }
                                                if ((iPath = iResource.getRawLocation()) != null) break block25;
                                                iResource.delete(true, null);
                                                UtilLogger.getLogger().warn((Object)("'" + iResource.getName() + "' is not linked. Hence it will be removed from the project Tree."));
                                                break block22;
                                            }
                                            file = new File(iResource.getRawLocation().toOSString());
                                            fileInfo = TDECoreUtilities.getInstance().getFileInfo(file.toString());
                                            if (fileInfo != null) break block26;
                                            if (l == 0L) break block27;
                                            OS2200CorePlugin.logger.error((Object)("FileInfo getting null for : " + iPath.toOSString()));
                                            break block22;
                                        }
                                        String string = TDECoreUtilities.getCIFSPathFromFilePath((String)iPath.toOSString());
                                        if (string != null) {
                                            File file2 = new File(string);
                                            try {
                                                fileInfo = new FileInfo(file.getPath(), file2.getPath(), file.lastModified(), file2.lastModified());
                                                TDECoreUtilities.getInstance().addFileInfo(fileInfo);
                                            }
                                            catch (Exception exception) {
                                                OS2200CorePlugin.logger.warn((Object)exception.getMessage(), (Throwable)exception);
                                            }
                                        } else {
                                            OS2200CorePlugin.logger.error((Object)("Unable to get CIFS path from cache path: " + iPath.toOSString()));
                                        }
                                    }
                                    if (l != 0L) break block28;
                                    if (!TDECoreUtilities.isUnInitializedFile((IFile)((IFile)iResource))) break block29;
                                    iResource.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                                    break block22;
                                }
                                if (file.lastModified() == 1L) {
                                    file.setLastModified(0L);
                                    iResource.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                                    break block22;
                                } else if (TDECoreUtilities.isPhysicallyInSync((File)file)) {
                                    iResource.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                                    break block22;
                                } else {
                                    iResource.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                                }
                                break block22;
                            }
                            if (TDECoreUtilities.isUnInitializedFile((IFile)((IFile)iResource))) {
                                iResource.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                            } else if (file.lastModified() == 1L) {
                                file.setLastModified(0L);
                                iResource.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                            } else if (fileInfo.localFileModified()) {
                                iResource.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.warn((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
    }

    public static void downloadUnInitializedFile() {
        OS2200CorePlugin.logger.debug((Object)"");
        Thread thread = new Thread(Messages.getString((String)"OS2200UIStartup_6")){

            @Override
            public void run() {
                OS2200CorePlugin.logger.debug((Object)"Running a thread to download elements");
                try {
                    IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    final OS2200View oS2200View = OS2200UIStartup.getViewObject();
                    if (oS2200View != null) {
                        IProject[] iProjectArray2 = iProjectArray;
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject iProject = iProjectArray2[n2];
                            if (iProject.isOpen() && iProject.hasNature("com.unisys.tde.core.OS2200")) {
                                long l = OS2200ProjectUpdate.connectOS2200((IProject)iProject, (boolean)false);
                                if (l != 0L) {
                                    OS2200CorePlugin.logger.debug((Object)("Unable to download uninitialized files because '" + iProject.getName() + "' is not connected to the network."));
                                } else {
                                    OS2200ArchitectureUtils.startDownlodingElements(iProject.members());
                                }
                            }
                            ++n2;
                        }
                        OS2200UIStartup.checkStatusforUnInitializedFile();
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                oS2200View.getViewer().refresh();
                            }
                        });
                    }
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
                }
                OS2200CorePlugin.logger.debug((Object)"Finished running the thread to download elements.");
            }
        };
        thread.setPriority(1);
        thread.start();
        if (thread != null) {
            while (thread.isAlive()) {
                try {
                    OS2200CorePlugin.logger.info((Object)"Sleep for one min....");
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    OS2200CorePlugin.logger.error((Object)interruptedException.getLocalizedMessage(), (Throwable)interruptedException);
                    break;
                }
            }
            if (!thread.isAlive() && OS2200ArchitectureUtils.isZeroKBElement()) {
                OS2200UIStartup.downloadUnInitializedFile();
            }
        }
    }

    private static void checkStatusforUnInitializedFile() {
        OS2200CorePlugin.logger.debug((Object)"");
        try {
            IProject[] iProjectArray;
            boolean bl = false;
            IProject[] iProjectArray2 = iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray2[n2];
                if (iProject.isOpen()) {
                    IResource[] iResourceArray = iProject.members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource iResource = iResourceArray[n4];
                        if (iResource instanceof IFile && !iResource.toString().toLowerCase().endsWith(".project") && !iResource.toString().toLowerCase().endsWith(".settings")) {
                            File file = new File(iResource.getRawLocation().toOSString());
                            if (TDECoreUtilities.isUnInitializedFile((IFile)((IFile)iResource))) {
                                iResource.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                                bl = true;
                            } else if (file.lastModified() == 1L) {
                                iResource.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "True");
                            } else {
                                iResource.setPersistentProperty(OS2200ArchitectureConstant.ZEROKB_FILE, "False");
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            OS2200ArchitectureUtils.setZeroKBElement(bl);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
    }
}

