/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.IOS2200BuildPage;
import com.unisys.tde.ui.OS2200DebugSetup;
import com.unisys.tde.ui.OS2200ProjectBrkptList;
import com.unisys.tde.ui.OS2200ProjectBuildScript;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class OS2200ProjectProperties
extends PropertyPage
implements IWorkbenchPropertyPage,
IOS2200BuildPage {
    private Text projectNameField;
    private Text hostNameField;
    private Text workFileField;
    private Text buildType;
    private IProject theProject;
    private Properties projProps;
    private Label workFileLabel;
    private Button btnGenerate;
    private OS2200ProjectBuildScript projectBuildScript;
    private OS2200ProjectBrkptList projectBrkptList;
    private OS2200DebugSetup debugSetup;
    private static final String BREAKPOINT_COMMENT = "@. Set breakpoint-file in 'Brkpt Files' tab \n";
    private static final String LINK_COMMENT = "@. Clear (Delete & Catalog) the objfile before each build (Recommended) \n";
    private static final String DEBUG_COMM = "@. Create debugMsmElt \n";
    private static final String TAB_CHAR = "\t";
    private static final String SPACE_CHAR = " ";
    private static final String NEWLINE_CHAR = "\n";
    protected static final String OBJECT_FILE = "*objfile";
    protected static final String EMPTY_STRING = "";
    protected static final String DEBUG_OPTION = ",,,debug/full,no-optim";
    protected static final String DOT_PROJECT = ".project";
    protected static final String DOT_SETTINGS = ".settings";
    protected static final String DOT_COB = ".COB";
    protected static final String DOT_C = ".C";
    protected static final String DOT_FOR = ".FOR";
    protected static final String FWD_SLASH = "/";
    private static final String HOST_SHARE_PREFIX = "\\\\";
    private static final String CIFS_SHARES = "/.cifs_shares";
    private static final String CIFSUT = "@Cifsut \n";
    private static final String OS2200_FILE_SEPARATOR = "\\";
    protected static final String ASTERISK = "*";
    protected static final String PERIOD = ".";
    protected static final String AT_UCOB = "@ucob ";
    protected static final String AT_UC = "@uc ";
    protected static final String AT_UFTN = "@uftn ";
    protected static final String COPY_A = "@copy,a ";
    protected static final String MASM = "@MASM,JEVZ";
    private static final String HASH = "#";
    private final String SLASH = "/";
    private String ls2 = null;
    private boolean load = false;
    private static String bkptFile = "";
    private boolean performApply;
    public static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String LINKAGE = "linkage";
    private static final String SUBPROG = ",subprogram";
    private static final String COMMENT_START = "/*";
    private static final String COMMENT_END = "*/";
    private static final String MAIN_STR = "main";
    private static final String FUNCTION = "function";
    private static final String SUBROUTINE = "subroutine";
    private static final String BLOCK_DATA = "block data";
    private final String ERROR_STR = "ERR";
    private Text errMsg;
    private final int WIDTH_TEXT_FIELD = 20;
    private Button showFlexBuild;

    protected Control createContents(Composite composite) {
        String string;
        this.theProject = this.getInputProject();
        if (this.theProject == null) {
            return null;
        }
        try {
            this.projProps = OS2200ProjectUpdate.getProperties((IProject)this.theProject);
        }
        catch (Exception exception) {
            return null;
        }
        Composite composite2 = (Composite)this.getControl();
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "com.unisys.tde.ui.context_properties_for_my_project_screen_help");
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.errMsg = new Text(composite2, 0);
        this.errMsg.setLayoutData((Object)gridData);
        this.errMsg.setEditable(false);
        this.createProjectNameGroup(composite2);
        this.createOS2200Group(composite2);
        TabFolder tabFolder = new TabFolder(composite2, 0);
        tabFolder.setLayout((Layout)new TabLayout());
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState((Properties)this.projProps);
        TabItem tabItem = new TabItem(tabFolder, 0);
        this.projectBuildScript = new OS2200ProjectBuildScript(tabItem, this.projProps);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        this.projectBrkptList = new OS2200ProjectBrkptList(tabItem2, this.projProps);
        this.projectBrkptList.setShareState(this.projProps);
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        this.debugSetup = new OS2200DebugSetup(tabItem3, this.projProps, this.theProject, this);
        this.showFlexBuild = new Button(composite2, 32);
        this.showFlexBuild.setText(Messages.getString((String)"FlexibleBuildStream.12"));
        try {
            string = this.theProject.getPersistentProperty(OS2200ProjectUpdate.SHOW_FLEX_BUILD_STREAM_PROJECT_PROPERTIES);
            if (string != null) {
                this.showFlexBuild.setSelection(Boolean.parseBoolean(string));
            } else {
                this.showFlexBuild.setSelection(false);
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        this.showFlexBuild.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        string = new GridData(128);
        Button button = new Button(composite2, 16384);
        button.setLayoutData((Object)string);
        button.setText(Messages.getString((String)"OS2200ProjectProperties_0"));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200ProjectProperties.this.performBuildStream();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.projectNameField.setText(this.theProject.getName().toUpperCase());
        this.hostNameField.setText(this.projProps.getProperty("hostID").toUpperCase());
        this.workFileField.setText(this.projProps.getProperty("workFile").toUpperCase());
        if (share == OS2200ProjectUpdate.Share.nShare) {
            this.workFileLabel.setText(Messages.getString((String)"OS2200ProjectProperties.2a"));
            this.workFileField.setText(OS2200ProjectUpdate.getShareName((Properties)this.projProps));
        }
        this.projectBrkptList.setHostName(this.hostNameField);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private final void createProjectNameGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString((String)"OS2200ProjectProperties.0"));
        this.projectNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)gridData);
        this.projectNameField.setEditable(false);
    }

    private void createOS2200Group(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString((String)"OS2200ProjectProperties.6"));
        this.hostNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.hostNameField.setLayoutData((Object)gridData);
        this.hostNameField.setEditable(false);
        this.workFileLabel = new Label(composite2, 0);
        this.workFileLabel.setText(Messages.getString((String)"OS2200ProjectProperties.2"));
        this.workFileField = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        gridData.heightHint = 20;
        this.workFileField.setLayoutData((Object)gridData);
        this.workFileField.setEditable(false);
        this.buildType = new Text(composite2, 0);
        this.buildType.setLayoutData((Object)gridData);
        this.buildType.setEditable(false);
    }

    @Override
    public void setBuildType(int n) {
        if (n == 0) {
            Color color = this.buildType.getForeground();
            Color color2 = new Color(color.getDevice(), 0, 0, 0);
            this.buildType.setForeground(color2);
            this.buildType.setText(Messages.getString((String)"OS2200ProjectProperties_1"));
        } else {
            Color color = this.buildType.getForeground();
            Color color3 = new Color(color.getDevice(), 255, 0, 0);
            this.buildType.setForeground(color3);
            this.buildType.setText(Messages.getString((String)"OS2200ProjectProperties_2"));
        }
    }

    public void setErrMsg(boolean bl) {
        this.errMsg.setForeground(Display.getCurrent().getSystemColor(3));
        if (bl) {
            this.errMsg.setText(Messages.getString((String)"OS2200ProjectProperties_3"));
            if (this.getApplyButton() != null) {
                this.getApplyButton().setEnabled(false);
                this.setValid(false);
            }
        } else {
            this.errMsg.setText(EMPTY_STRING);
            if (this.getApplyButton() != null) {
                this.getApplyButton().setEnabled(true);
                this.setValid(true);
            }
        }
    }

    private IProject getInputProject() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IProject) {
            return (IProject)iAdaptable;
        }
        Object object = iAdaptable.getAdapter(IResource.class);
        if (object instanceof IProject) {
            return (IProject)object;
        }
        return null;
    }

    private boolean executeOK() {
        if (!this.checkProps()) {
            return false;
        }
        String string = this.projectBuildScript.getBuildScript().getText();
        string = string.replaceAll("\r", EMPTY_STRING);
        string = string.replaceAll(TAB_CHAR, SPACE_CHAR);
        String[] stringArray = string.split(NEWLINE_CHAR);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.trimSpacesAtEnd(stringArray[n]);
            if (stringArray[n].length() <= 80) {
                stringBuffer.append(String.valueOf(stringArray[n]) + NEWLINE_CHAR);
            } else {
                stringBuffer.append(String.valueOf(this.breakECL(stringArray[n])) + NEWLINE_CHAR);
            }
            ++n;
        }
        this.projProps.setProperty("buildStream", stringBuffer.toString());
        this.projProps.setProperty("breakpointFiles", this.projectBrkptList.getBrkptString());
        this.projProps.setProperty("ShareBreakpoints", Boolean.toString(this.projectBrkptList.getShareBreakpoint()));
        this.projProps.setProperty("BreakpointShare", this.projectBrkptList.getBreakpointShare());
        this.projProps = this.debugSetup.setProps(this.projProps);
        try {
            OS2200ProjectUpdate.setProperties((IProject)this.theProject, (Properties)this.projProps);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.debugSetup != null) {
            this.debugSetup.genDefaults();
        }
    }

    protected void performApply() {
        this.performApply = true;
        if (this.debugSetup != null && this.projProps != null) {
            this.load = this.debugSetup.reloadRequired() || !OS2200FileInterface.isMASMEltExists((Properties)this.projProps, (String)this.debugSetup.getStrMASMElt());
            this.setDebugbuildText();
            this.executeOK();
        }
    }

    public boolean performOk() {
        if (!this.performApply && this.debugSetup != null && this.projProps != null) {
            this.load = this.debugSetup.reloadRequired() || !OS2200FileInterface.isMASMEltExists((Properties)this.projProps, (String)this.debugSetup.getStrMASMElt());
            this.setDebugbuildText();
            this.executeOK();
        }
        this.setFlexbuildStream();
        super.performOk();
        if (this.load && this.debugSetup.getChkBuilddebug().getSelection()) {
            this.debugSetup.setProps();
            return this.debugSetup.makeAndDeployDebugElement();
        }
        return true;
    }

    private void setDebugbuildText() {
        String string = this.projProps.getProperty("workFile");
        int n = string.indexOf(HASH);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        String string2 = "@MASM,JEVZ  " + string + this.debugSetup.txtMASMEltName.getText() + "," + string + NEWLINE_CHAR;
        String string3 = this.debugSetup.txtDebugBuild.getText();
        if (!string3.contains(MASM)) {
            if (string3.length() > 0) {
                String[] stringArray = string3.split(NEWLINE_CHAR);
                StringBuffer stringBuffer = new StringBuffer(string2);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    stringBuffer.append(String.valueOf(stringArray[n2]) + NEWLINE_CHAR);
                    ++n2;
                }
                string2 = stringBuffer.toString();
            }
            this.debugSetup.txtDebugBuild.setText(string2);
        }
        this.debugSetup.setTxtLink();
    }

    private void performBuildStream() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                OS2200ProjectProperties.this.theProject = OS2200ProjectProperties.this.getInputProject();
                IResource[] iResourceArray = null;
                try {
                    iResourceArray = OS2200ProjectProperties.this.theProject.members();
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)(String.valueOf(coreException.getMessage()) + ": Couldn't get the proj-members"));
                    return;
                }
                OS2200ProjectUpdate.getShareName((IProject)OS2200ProjectProperties.this.theProject);
                Properties properties = null;
                try {
                    properties = OS2200ProjectUpdate.getProperties((IProject)OS2200ProjectProperties.this.theProject);
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getMessage());
                    return;
                }
                String string = properties.getProperty("hostID");
                LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
                HostAccount hostAccount = loginAccount.getHostAccount();
                hostAccount.getCifsHostId();
                String string2 = hostAccount.getCifsUserId();
                String string3 = String.valueOf(string2) + OS2200ProjectProperties.OBJECT_FILE;
                String string4 = OS2200ProjectProperties.EMPTY_STRING;
                String string5 = OS2200ProjectProperties.EMPTY_STRING;
                String string6 = OS2200ProjectProperties.EMPTY_STRING;
                String string7 = OS2200ProjectProperties.EMPTY_STRING;
                String string8 = OS2200ProjectProperties.EMPTY_STRING;
                String string9 = OS2200ProjectProperties.EMPTY_STRING;
                String string10 = this.getWorkfileFromProject();
                String[] stringArray = new String[iResourceArray.length];
                String[] stringArray2 = new String[iResourceArray.length];
                String string11 = OS2200ProjectProperties.EMPTY_STRING;
                String string12 = OS2200ProjectProperties.EMPTY_STRING;
                String string13 = OS2200ProjectProperties.EMPTY_STRING;
                String string14 = OS2200ProjectProperties.EMPTY_STRING;
                String string15 = OS2200ProjectProperties.EMPTY_STRING;
                String string16 = OS2200ProjectProperties.this.getTime();
                String string17 = OS2200ProjectProperties.EMPTY_STRING;
                OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState((Properties)properties);
                int n = 0;
                int n2 = 0;
                while (n2 < iResourceArray.length) {
                    string8 = iResourceArray[n2].toString().trim();
                    if (!string8.endsWith(OS2200ProjectProperties.DOT_PROJECT) && !string8.endsWith(OS2200ProjectProperties.DOT_SETTINGS) && (string8.endsWith(OS2200ProjectProperties.DOT_COB) || string8.endsWith(OS2200ProjectProperties.DOT_C) || string8.endsWith(OS2200ProjectProperties.DOT_FOR))) {
                        string6 = iResourceArray[n2].getRawLocation().lastSegment();
                        if (string6.contains(OS2200ProjectProperties.PERIOD)) {
                            string7 = string6.substring(0, string6.indexOf(OS2200ProjectProperties.PERIOD));
                            string9 = string6.substring(string6.indexOf(OS2200ProjectProperties.PERIOD) + 1);
                            stringArray[n] = OS2200FileInterface.legalOS2200EltName((String)string7) && OS2200FileInterface.legalOS2200EltName((String)string9) ? String.valueOf(string10) + string7 + OS2200ProjectProperties.FWD_SLASH + string9 : this.deriveFromLS2(string6);
                        } else {
                            string7 = string6;
                            stringArray[n] = OS2200FileInterface.legalOS2200EltName((String)string7) ? String.valueOf(string10) + string7 : this.deriveFromLS2(string7);
                        }
                        if (stringArray[n] != null) {
                            string4 = iResourceArray[n2].getRawLocation().toOSString();
                            string5 = OS2200FileInterface.getFileAsString((String)string4);
                            stringArray2[n] = string5 == null || string5.trim().length() == 0 ? OS2200ProjectProperties.EMPTY_STRING : OS2200ProjectProperties.this.getSubroutineDetails(string5, string8);
                            if (string8.endsWith(OS2200ProjectProperties.DOT_COB)) {
                                string12 = String.valueOf(string12) + OS2200ProjectProperties.AT_UCOB + stringArray[n] + ", " + stringArray[n].substring(0, stringArray[n].indexOf(OS2200ProjectProperties.PERIOD) + 1) + OS2200ProjectProperties.DEBUG_OPTION + stringArray2[n] + OS2200ProjectProperties.NEWLINE_CHAR;
                                string11 = stringArray2[n].trim().length() != 0 ? String.valueOf(string11) + OS2200ProjectProperties.AT_UCOB + stringArray[n] + ", " + stringArray[n].substring(0, stringArray[n].indexOf(OS2200ProjectProperties.PERIOD) + 1) + ",," + stringArray2[n] + OS2200ProjectProperties.NEWLINE_CHAR : String.valueOf(string11) + OS2200ProjectProperties.AT_UCOB + stringArray[n] + ", " + stringArray[n].substring(0, stringArray[n].indexOf(OS2200ProjectProperties.PERIOD) + 1) + OS2200ProjectProperties.NEWLINE_CHAR;
                            } else if (string8.endsWith(OS2200ProjectProperties.DOT_C)) {
                                string11 = String.valueOf(string11) + OS2200ProjectProperties.AT_UC + stringArray[n] + ", " + stringArray[n].substring(0, stringArray[n].indexOf(OS2200ProjectProperties.PERIOD) + 1) + OS2200ProjectProperties.NEWLINE_CHAR;
                                string12 = String.valueOf(string12) + OS2200ProjectProperties.AT_UC + stringArray[n] + ", " + stringArray[n].substring(0, stringArray[n].indexOf(OS2200ProjectProperties.PERIOD) + 1) + OS2200ProjectProperties.DEBUG_OPTION + OS2200ProjectProperties.NEWLINE_CHAR;
                            } else if (string8.endsWith(OS2200ProjectProperties.DOT_FOR)) {
                                string11 = String.valueOf(string11) + OS2200ProjectProperties.AT_UFTN + stringArray[n] + ", " + stringArray[n].substring(0, stringArray[n].indexOf(OS2200ProjectProperties.PERIOD) + 1) + OS2200ProjectProperties.NEWLINE_CHAR;
                                string12 = String.valueOf(string12) + OS2200ProjectProperties.AT_UFTN + stringArray[n] + ", " + stringArray[n].substring(0, stringArray[n].indexOf(OS2200ProjectProperties.PERIOD) + 1) + OS2200ProjectProperties.DEBUG_OPTION + OS2200ProjectProperties.NEWLINE_CHAR;
                            }
                            if (stringArray2[n].equals(OS2200ProjectProperties.EMPTY_STRING)) {
                                string11 = String.valueOf(string11) + OS2200ProjectProperties.COPY_A + stringArray[n] + ", " + string3 + ".\n";
                            }
                            ++n;
                        }
                    }
                    ++n2;
                }
                string13 = OS2200ProjectProperties.this.setFiles(string3, string2);
                string14 = OS2200ProjectProperties.this.setLinkStmt(string3, string16);
                string15 = OS2200ProjectProperties.this.setEnd(stringArray, stringArray2, string14, share, string10);
                string11 = String.valueOf(string13) + string11 + string15;
                ((OS2200ProjectProperties)OS2200ProjectProperties.this).projectBuildScript.buildScript.setText(string11.toUpperCase());
                string15 = OS2200ProjectProperties.this.setEnd(stringArray, stringArray2, String.valueOf(string14) + "D", share, string10);
                string17 = String.valueOf(OS2200ProjectProperties.this.debugSetup.getDebugBuildScript().getText()) + OS2200ProjectProperties.NEWLINE_CHAR;
                if (string17.startsWith(OS2200ProjectProperties.MASM)) {
                    string17 = string17.substring(0, string17.indexOf(OS2200ProjectProperties.NEWLINE_CHAR));
                    string12 = String.valueOf(string17) + " \n" + string13 + string12 + string15;
                } else {
                    string12 = OS2200ProjectProperties.DEBUG_COMM + string13 + string12 + string15;
                }
                OS2200ProjectProperties.this.debugSetup.getDebugBuildScript().setText(string12.toUpperCase());
                String string18 = String.valueOf(OS2200ProjectProperties.this.projectBrkptList.getBrkptString()) + "\r";
                String[] stringArray3 = string18.split("\r");
                boolean bl = false;
                if (stringArray3.length > 0) {
                    int n3 = 0;
                    while (n3 < stringArray3.length) {
                        if (stringArray3[n3].contains(",")) {
                            stringArray3[n3] = stringArray3[n3].substring(0, stringArray3[n3].indexOf(","));
                        }
                        if (bkptFile.equalsIgnoreCase(stringArray3[n3])) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        ((OS2200ProjectProperties)OS2200ProjectProperties.this).projectBrkptList.brkptList.add((String.valueOf(bkptFile) + ",View").toUpperCase());
                    }
                } else {
                    ((OS2200ProjectProperties)OS2200ProjectProperties.this).projectBrkptList.brkptList.add((String.valueOf(bkptFile) + ",View").toUpperCase());
                }
            }

            private String deriveFromLS2(String string) {
                if (OS2200ProjectProperties.this.ls2 == null) {
                    OS2200ProjectProperties.this.ls2 = OS2200ProjectProperties.this.getCIFSList(OS2200ProjectProperties.this.theProject);
                }
                return OS2200ProjectProperties.this.getQSFName(string);
            }

            private String getWorkfileFromProject() {
                String string = OS2200ProjectUpdate.getWorkFileForProj((IProject)OS2200ProjectProperties.this.theProject);
                if (string.contains(OS2200ProjectProperties.HASH)) {
                    string = string.substring(string.indexOf(OS2200ProjectProperties.HASH) + 1);
                }
                return string;
            }
        });
    }

    private String getQSFName(String string) {
        String string2 = null;
        string = string.toUpperCase();
        if (this.ls2 != null) {
            if (this.ls2.equalsIgnoreCase("ERR") || this.ls2.trim().length() <= 0) {
                OS2200CorePlugin.logger.error((Object)("An error was encountered while deriving the CIFS-list. The native name for the element " + string + " would not be derived."));
                return string2;
            }
        } else {
            return string2;
        }
        this.ls2 = this.ls2.toUpperCase();
        if (!this.ls2.contains(string = NEWLINE_CHAR + string + SPACE_CHAR) && string.contains("-")) {
            String string3 = string;
            string = EMPTY_STRING;
            while (string3.contains("-")) {
                string = String.valueOf(string) + string3.substring(0, string3.indexOf("-"));
                string3 = string3.substring(string3.indexOf("-") + 1);
            }
            string = String.valueOf(string) + PERIOD + string3;
        }
        if (!this.ls2.contains(string)) {
            return null;
        }
        string2 = this.ls2.substring(this.ls2.indexOf(string)).trim();
        string2 = string2.substring(0, string2.indexOf(NEWLINE_CHAR)).trim();
        if ((string2 = string2.substring(string2.indexOf(SPACE_CHAR)).trim()).contains(HASH)) {
            string2 = string2.substring(string2.indexOf(HASH) + 1);
        }
        return string2;
    }

    private String getSubroutineDetails(String string, String string2) {
        block12: {
            int n;
            int n2;
            boolean bl;
            block13: {
                String string3;
                block11: {
                    string3 = EMPTY_STRING;
                    bl = true;
                    n2 = 0;
                    n = 0;
                    if (!string2.endsWith(DOT_COB)) break block11;
                    while (bl) {
                        if (string.toLowerCase().contains(LINKAGE)) {
                            n = n2 = string.toLowerCase().indexOf(LINKAGE);
                            while (n > 0 && string.charAt(n) != '\n') {
                                --n;
                            }
                            string3 = string.substring(n + 1, n2);
                            string = string.substring(n2).trim();
                            if (string3.charAt(6) != '*') {
                                return SUBPROG;
                            }
                            string = string.substring(string.indexOf(NEWLINE_CHAR));
                            continue;
                        }
                        bl = false;
                    }
                    break block12;
                }
                if (!string2.endsWith(DOT_C)) break block13;
                int n3 = 0;
                int n4 = 0;
                while (bl) {
                    if (!string.toLowerCase().contains(MAIN_STR)) {
                        return SUBPROG;
                    }
                    n2 = string.toLowerCase().indexOf(MAIN_STR);
                    string3 = string.substring(0, n2);
                    n3 = this.countString(string3, COMMENT_START);
                    n4 = this.countString(string3, COMMENT_END);
                    string = string.substring(n2).trim();
                    if (n3 > n4) {
                        string = string.substring(string.indexOf(COMMENT_END) + 2);
                        continue;
                    }
                    bl = false;
                }
                break block12;
            }
            if (!string2.endsWith(DOT_FOR)) break block12;
            String[] stringArray = string.split(NEWLINE_CHAR);
            n2 = stringArray.length;
            while (bl) {
                if (n >= n2) continue;
                stringArray[n] = String.valueOf(stringArray[n]) + "       ";
                if (!(stringArray[n].trim().length() == 0 || stringArray[n].toLowerCase().startsWith("c") || stringArray[n].startsWith(ASTERISK) || stringArray[n].substring(6).trim().startsWith("!") || stringArray[n].substring(6).trim().startsWith("@"))) {
                    if (!stringArray[n].trim().toLowerCase().startsWith(BLOCK_DATA)) {
                        if (stringArray[n].trim().toLowerCase().startsWith(SUBROUTINE) || stringArray[n].trim().toLowerCase().startsWith(FUNCTION)) {
                            return SUBPROG;
                        }
                        bl = false;
                        continue;
                    }
                    string = string.substring(string.toLowerCase().indexOf("end") + 3);
                    n = 0;
                    stringArray = string.split(NEWLINE_CHAR);
                    n2 = stringArray.length;
                    continue;
                }
                ++n;
            }
        }
        return EMPTY_STRING;
    }

    private int countString(String string, String string2) {
        if (string.length() < string2.length()) {
            return 0;
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.startsWith(string2)) {
                ++n2;
                n3 += string2.length();
                string = string.substring(string2.length());
                continue;
            }
            ++n3;
            string = string.substring(1);
        }
        return n2;
    }

    private String getCIFSList(IProject iProject) {
        String string;
        block16: {
            String string2 = null;
            string = "ERR";
            String string3 = EMPTY_STRING;
            try {
                try {
                    Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                    String string4 = properties.getProperty("hostID");
                    LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string4);
                    HostAccount hostAccount = loginAccount.getHostAccount();
                    String string5 = hostAccount.getCifsHostId();
                    String string6 = OS2200FileInterface.getCIFSDir((Properties)properties);
                    String string7 = OS2200ProjectUpdate.getShareName((Properties)properties);
                    OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState((Properties)properties);
                    string2 = OS2200FileInterface.establishSession((Properties)properties);
                    if (string2 != null && string2.trim().length() == 0) {
                        String string8 = HOST_SHARE_PREFIX + string5 + OS2200_FILE_SEPARATOR + string7 + OS2200_FILE_SEPARATOR;
                        String string9 = EMPTY_STRING;
                        if (share == OS2200ProjectUpdate.Share.nShare) {
                            string9 = "/.cifs_shares/" + string7;
                        } else {
                            string3 = String.valueOf(string6.substring(string8.length()).replace(OS2200_FILE_SEPARATOR, ASTERISK)) + PERIOD;
                            string9 = FWD_SLASH + string7 + FWD_SLASH + OS2200FileInterface.getOS2200Path((String)string3);
                            if (share == OS2200ProjectUpdate.Share.cstShare) {
                                string9 = CIFS_SHARES + string9;
                            }
                        }
                        String string10 = OS2200FileInterface.executeCommand((String)CIFSUT);
                        if (string10.contains("CIFSUT")) {
                            String string11 = OS2200FileInterface.executeCommand((String)("cd " + string9 + NEWLINE_CHAR));
                            if (!string11.contains("ERROR")) {
                                string = OS2200FileInterface.executeCommand((String)"ls -2 \n");
                                if (string.trim().length() <= 0) {
                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200ProjectProperties.9"), (String)(String.valueOf(Messages.getString((String)"OS2200ProjectProperties.10")) + Messages.getString((String)"OS2200ProjectProperties.11", (String)string9)));
                                    string = "ERR";
                                }
                            } else {
                                OS2200CorePlugin.logger.error((Object)("cd command ended in error: " + string11));
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200ProjectProperties.9"), (String)(String.valueOf(Messages.getString((String)"OS2200ProjectProperties.10")) + Messages.getString((String)"OS2200ProjectProperties.12", (String)string7, (String)string3)));
                            }
                        } else {
                            OS2200CorePlugin.logger.error((Object)"Couldn't get into Cifsut");
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200ProjectProperties.9"), (String)(String.valueOf(Messages.getString((String)"OS2200ProjectProperties.10")) + Messages.getString((String)"OS2200ProjectProperties.13")));
                        }
                        break block16;
                    }
                    OS2200CorePlugin.logger.error((Object)("Error while establishing session: " + string2));
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200ProjectProperties.9"), (String)(String.valueOf(Messages.getString((String)"OS2200ProjectProperties.10")) + Messages.getString((String)"OS2200ProjectProperties.14", (String)string4)));
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getMessage());
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"OS2200ProjectProperties.9"), (String)(String.valueOf(Messages.getString((String)"OS2200ProjectProperties.10")) + Messages.getString((String)"OS2200ProjectProperties.15", (String)coreException.getMessage())));
                    if (string2 != null && string2.trim().length() == 0) {
                        OS2200FileInterface.sessionLogout();
                    }
                }
            }
            finally {
                if (string2 != null && string2.trim().length() == 0) {
                    OS2200FileInterface.sessionLogout();
                }
            }
        }
        return string;
    }

    private String setFiles(String string, String string2) {
        bkptFile = String.valueOf(string2) + "*bkpt.";
        return "@delete,c " + bkptFile + NEWLINE_CHAR + "@cat,p " + bkptFile + ",f///9999 \n" + BREAKPOINT_COMMENT + "@brkpt print$, " + bkptFile + NEWLINE_CHAR + LINK_COMMENT + "@delete,c " + string + ".\n" + "@cat,p " + string + ".,f///9999 \n" + "@cycle " + string + ".\n";
    }

    private String setLinkStmt(String string, String string2) {
        return "@link,e ," + string + PERIOD + string2;
    }

    private String setEnd(String[] stringArray, String[] stringArray2, String string, OS2200ProjectUpdate.Share share, String string2) {
        int n = 0;
        if (string.trim().endsWith("D")) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null) {
                    string = String.valueOf(string) + "\ninclude " + stringArray[n2];
                    ++n;
                }
                ++n2;
            }
            string = String.valueOf(string) + NEWLINE_CHAR + this.debugSetup.txtLinkLines.getText();
        } else {
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray2[n3] != null && stringArray2[n3].equals(SUBPROG) && stringArray[n3] != null) {
                    string = String.valueOf(string) + "\ninclude " + stringArray[n3];
                    ++n;
                }
                ++n3;
            }
            string = String.valueOf(string) + NEWLINE_CHAR;
        }
        if (share == OS2200ProjectUpdate.Share.nShare) {
            if (n > 0) {
                return String.valueOf(string) + "@eof \n@brkpt print$ \n@copy,i " + bkptFile + ", " + string2 + bkptFile.replace(PERIOD, EMPTY_STRING).replace(ASTERISK, FWD_SLASH) + NEWLINE_CHAR;
            }
            return "@brkpt print$ \n@copy,i " + bkptFile + ", " + string2 + bkptFile.replace(PERIOD, EMPTY_STRING).replace(ASTERISK, FWD_SLASH) + NEWLINE_CHAR;
        }
        if (n > 0) {
            return String.valueOf(string) + "@eof \n@brkpt print$ \n";
        }
        return "@brkpt print$ \n";
    }

    private String getTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return String.valueOf(Integer.toString(gregorianCalendar.get(5))) + Integer.toString(gregorianCalendar.get(2)) + Integer.toString(gregorianCalendar.get(11)) + Integer.toString(gregorianCalendar.get(12)) + Integer.toString(gregorianCalendar.get(13));
    }

    public String trimSpacesAtEnd(String string) {
        if (string.trim().length() == 0) {
            return EMPTY_STRING;
        }
        int n = 0;
        int n2 = string.length() - 1;
        char c = string.charAt(n2);
        while (' ' == c || '\t' == c || '\n' == c) {
            ++n;
            c = string.charAt(--n2);
        }
        return string.substring(0, string.length() - n);
    }

    public String breakECL(String string) {
        if (string.substring(0, string.indexOf(PERIOD)).trim().equals("@")) {
            return string;
        }
        int n = 0;
        String string2 = EMPTY_STRING;
        String[] stringArray = string.split(",");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = stringArray[n3].trim();
            if (n + stringArray[n3].length() >= 78) {
                n = stringArray[n3].length();
                string2 = String.valueOf(string2) + ";\n" + stringArray[n3];
            } else {
                n += stringArray[n3].length();
                string2 = String.valueOf(string2) + stringArray[n3];
            }
            if (n3 < n2 - 1) {
                string2 = String.valueOf(string2) + ",";
                ++n;
            }
            ++n3;
        }
        return string2;
    }

    boolean checkProps() {
        String string;
        this.setErrorMessage(null);
        OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState((Properties)this.projProps);
        if (share.equals((Object)OS2200ProjectUpdate.Share.nShare) && (string = this.projectBrkptList.getBrkptString()).trim().length() > 0) {
            String string2 = this.projectBrkptList.getBreakpointShare();
            if (string2.trim().length() > 0) {
                String string3 = this.projProps.getProperty("hostID");
                HostAccount hostAccount = LoginAccount.getLoginAccount((String)string3).getHostAccount();
                long l = OS2200FileInterface.connectCifs((HostAccount)hostAccount, (String)string2, (boolean)true);
                if (l != 0L) {
                    this.setErrorMessage(OS2200FileInterface.getConnectErrorMsg((long)l, (HostAccount)hostAccount, (String)string2));
                    return false;
                }
                return this.debugSetup.checkProps();
            }
            this.setErrorMessage(Messages.getString((String)"NewOS2200ProjectPageNext.4"));
            return false;
        }
        return true;
    }

    private void setFlexbuildStream() {
        OS2200CorePlugin.logger.info((Object)EMPTY_STRING);
        try {
            this.theProject.setPersistentProperty(OS2200ProjectUpdate.SHOW_FLEX_BUILD_STREAM_PROJECT_PROPERTIES, String.valueOf(this.showFlexBuild.getSelection()));
            this.theProject.setPersistentProperty(OS2200ProjectUpdate.DO_NOT_SHOW_FLEX_BUILD_STREAM, String.valueOf(!this.showFlexBuild.getSelection()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class TabLayout
    extends Layout {
        private TabLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Control[] controlArray = composite.getChildren();
            int n3 = controlArray.length;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                Control control = controlArray[n6];
                Point point = control.computeSize(-1, -1, bl);
                n4 = Math.max(n4, point.x);
                n5 = Math.max(n5, point.y);
                ++n6;
            }
            if (n != -1) {
                n4 = n;
            }
            if (n2 != -1) {
                n5 = n2;
            }
            return new Point(n4, n5);
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].setBounds(rectangle);
                ++n;
            }
        }
    }
}

