/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.ui;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.ElementSelectionObject;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.ui.IOS2200BuildPage;
import com.unisys.tde.ui.OS2200ProjectProperties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class OS2200DebugSetup {
    private String portNumber;
    private String debugID;
    private String projName;
    private String ipAddress;
    private IProject project;
    private Properties projProps;
    private TabItem ourTab;
    private String subType;
    private String debugBuild;
    private String buildType;
    private IOS2200BuildPage theBuildPage;
    private OS2200ProjectProperties projProperties = null;
    private String masmEltName;
    private String elt = null;
    private String ver = null;
    private String eltName = null;
    private String linkName = null;
    private boolean retDeploymentValue;
    private String strMASMElt;
    private String strLinkLines;
    private String lbName;
    private Label lblDebugID;
    private Text txtDebugID;
    private Text txtPortNumber;
    private Text txtLibName;
    private Text txtCallbackIPAddress;
    Text txtMASMEltName;
    public Text txtLinkLines;
    public Text txtDebugBuild;
    private String libAddress;
    private String codeString;
    private Button chkBuilddebug;
    public static final String PADS_LIB = "eclipse2200*pads$lib37.";
    private static final String DEFAULT_MASM_ELT_NAME = "DEBUGMSMELT";
    private Label txtLibHint;

    public OS2200DebugSetup(TabItem tabItem, Properties properties, IProject iProject, IOS2200BuildPage iOS2200BuildPage) {
        this.project = iProject;
        this.projName = iProject.getName();
        this.projProps = properties;
        this.ourTab = tabItem;
        this.theBuildPage = iOS2200BuildPage;
        this.projProperties = (OS2200ProjectProperties)iOS2200BuildPage;
        this.makeDebugSetup(tabItem, properties);
    }

    private void makeDebugSetup(TabItem tabItem, Properties properties) {
        Composite composite = new Composite((Composite)tabItem.getParent(), 2048);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData());
        tabItem.setText("OS 2200 Debug Setup");
        tabItem.setControl((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        this.chkBuilddebug = new Button(composite2, 32);
        this.chkBuilddebug.setText(Messages.getString((String)"OS2200DebugSetup_0"));
        gridData.horizontalSpan = 2;
        this.chkBuilddebug.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 131072);
        label.setAlignment(131072);
        label.setText(Messages.getString((String)"OS2200DebugSetup_1"));
        this.chkBuilddebug.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (OS2200DebugSetup.this.chkBuilddebug.getSelection()) {
                    OS2200DebugSetup.this.theBuildPage.setBuildType(1);
                } else {
                    OS2200DebugSetup.this.theBuildPage.setBuildType(0);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        GridData gridData2 = new GridData(130, 18);
        this.lblDebugID = new Label(composite2, 0);
        this.lblDebugID.setText(Messages.getString((String)"OS2200DebugSetup_2"));
        this.txtDebugID = new Text(composite2, 2048);
        this.txtDebugID.setLayoutData((Object)gridData2);
        Label label2 = new Label(composite2, 0);
        label2.setText(Messages.getString((String)"OS2200DebugSetup_3"));
        this.txtPortNumber = new Text(composite2, 2048);
        this.txtPortNumber.setLayoutData((Object)gridData2);
        Label label3 = new Label(composite2, 0);
        label3.setText(Messages.getString((String)"OS2200DebugSetup_4"));
        this.txtCallbackIPAddress = new Text(composite2, 2048);
        this.txtCallbackIPAddress.setLayoutData((Object)gridData2);
        Label label4 = new Label(composite2, 0);
        label4.setText(Messages.getString((String)"OS2200DebugSetup_5"));
        this.txtMASMEltName = new Text(composite2, 2048);
        this.txtMASMEltName.setLayoutData((Object)gridData2);
        this.txtMASMEltName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                OS2200DebugSetup.this.masmEltName = OS2200DebugSetup.this.txtMASMEltName.getText();
                if (OS2200DebugSetup.this.masmEltName.length() <= 0) {
                    OS2200DebugSetup.this.projProperties.setErrMsg(true);
                    return;
                }
                int n = OS2200DebugSetup.this.masmEltName.indexOf(47);
                if (n > 0) {
                    OS2200DebugSetup.this.elt = OS2200DebugSetup.this.masmEltName.substring(0, n);
                    OS2200DebugSetup.this.ver = OS2200DebugSetup.this.masmEltName.substring(n + 1);
                } else {
                    OS2200DebugSetup.this.elt = OS2200DebugSetup.this.masmEltName;
                    OS2200DebugSetup.this.ver = null;
                }
                if (OS2200DebugSetup.this.ver != null) {
                    if (OS2200DebugSetup.this.ver.length() == 0) {
                        OS2200DebugSetup.this.projProperties.setErrMsg(true);
                        return;
                    }
                    if (!OS2200FileInterface.legalOS2200EltName((String)OS2200DebugSetup.this.elt) || !OS2200FileInterface.legalOS2200EltName((String)OS2200DebugSetup.this.ver)) {
                        OS2200DebugSetup.this.projProperties.setErrMsg(true);
                        return;
                    }
                } else if (!OS2200FileInterface.legalOS2200EltName((String)OS2200DebugSetup.this.elt)) {
                    OS2200DebugSetup.this.projProperties.setErrMsg(true);
                    return;
                }
                OS2200DebugSetup.this.projProperties.setErrMsg(false);
            }
        });
        Label label5 = new Label(composite2, 0);
        label5.setText(Messages.getString((String)"OS2200DebugSetup_6"));
        this.txtLibName = new Text(composite2, 2048);
        this.txtLibName.setLayoutData((Object)gridData2);
        this.txtLibName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                OS2200DebugSetup.this.lbName = OS2200DebugSetup.this.gettxtLibName();
                if (!OS2200DebugSetup.this.lbName.contains("+") && OS2200FileInterface.legalOS2200FileName((String)OS2200DebugSetup.this.lbName)) {
                    OS2200DebugSetup.this.txtLibHint.setVisible(false);
                    OS2200DebugSetup.this.txtLibHint.setText("");
                    OS2200DebugSetup.this.libAddress = OS2200DebugSetup.this.gettxtLibName();
                    OS2200DebugSetup.this.setTxtLink();
                } else {
                    OS2200DebugSetup.this.txtLibHint.setVisible(true);
                    OS2200DebugSetup.this.txtLibHint.setToolTipText(Messages.getString((String)"OS2200DebugSetup_7"));
                    OS2200DebugSetup.this.txtLibHint.setText(Messages.getString((String)"OS2200DebugSetup_8"));
                }
            }
        });
        this.txtLibHint = new Label(composite2, 0);
        GridData gridData3 = new GridData(8);
        gridData3.horizontalSpan = 2;
        gridData3.horizontalAlignment = 4;
        this.txtLibHint.setLayoutData((Object)gridData3);
        this.txtLibHint.setVisible(false);
        this.txtLibHint.setText("");
        this.txtLibHint.setForeground(Display.getCurrent().getSystemColor(3));
        this.txtLinkLines = new Text(composite3, 2122);
        this.setDebugBuild(composite);
        this.initFields();
        this.setFields();
        this.txtDebugBuild.setFocus();
    }

    public boolean checkProps() {
        return true;
    }

    public Properties setProps(Properties properties) {
        properties.setProperty("DebugPortNumber", this.txtPortNumber.getText());
        properties.setProperty("DebugID", this.txtDebugID.getText());
        properties.setProperty("DebugLibFile", this.gettxtLibName());
        properties.setProperty("DebugIPCallback", this.txtCallbackIPAddress.getText());
        properties.setProperty("MASMElementName", this.txtMASMEltName.getText());
        String string = this.txtDebugBuild.getText();
        string = string.replaceAll("\r", "");
        string = string.replaceAll("\t", " ");
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.projProperties.trimSpacesAtEnd(stringArray[n]);
            if (stringArray[n].length() < 78) {
                stringBuffer.append(String.valueOf(stringArray[n]) + "\n");
            } else {
                stringBuffer.append(String.valueOf(this.projProperties.breakECL(stringArray[n])) + "\n");
            }
            ++n;
        }
        properties.setProperty("DebugBuildScript", stringBuffer.toString());
        if (this.chkBuilddebug.getSelection()) {
            properties.setProperty("BuildType", "Debug");
        } else {
            properties.setProperty("BuildType", "Standard");
        }
        return properties;
    }

    public void addLines() {
        String string = this.projProps.getProperty("workFile");
        int n = string.indexOf("#");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        String string2 = this.txtDebugBuild.getText().trim();
        String[] stringArray = string2.split("\n");
        String string3 = "@MASM,JEVZ  " + string + this.txtMASMEltName.getText() + "," + string;
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n2 = 1;
        while (n2 < stringArray.length) {
            stringBuffer.append("\n" + stringArray[n2]);
            ++n2;
        }
        this.txtDebugBuild.setText("");
        this.txtDebugBuild.setText(stringBuffer.toString().toUpperCase());
    }

    public boolean makeAndDeployDebugElement() {
        try {
            String string = this.readInTemplate("UDebugEltTemplate.txt");
            Object[] objectArray = new String[]{"'" + this.txtCallbackIPAddress.getText() + "'", "'" + this.txtPortNumber.getText() + "'", "'" + this.txtDebugID.getText() + "'", "'" + this.gettxtLibName() + "'", "'" + InetAddress.getByName(this.txtCallbackIPAddress.getText()).getHostName() + "'"};
            this.codeString = NLS.bind((String)string, (Object[])objectArray);
            this.eltName = this.txtMASMEltName.getText().trim();
            String string2 = null;
            string2 = this.eltName;
            if (this.eltName.contains("/") && !this.eltName.endsWith("/")) {
                this.eltName = this.eltName.replace('/', '.');
                string2 = string2.replace('/', '-');
            }
            this.linkName = String.valueOf(string2) + ".ELT";
            this.subType = "elt";
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    try {
                        try {
                            OS2200DebugSetup.this.doFinish(OS2200DebugSetup.this.eltName, OS2200DebugSetup.this.linkName, iProgressMonitor);
                            OS2200DebugSetup.this.retDeploymentValue = true;
                        }
                        catch (CoreException coreException) {
                            OS2200DebugSetup.this.retDeploymentValue = false;
                            throw new InvocationTargetException(coreException);
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, iRunnableWithProgress);
            }
            catch (InterruptedException interruptedException) {
                this.retDeploymentValue = false;
                MessageDialog.openError((Shell)this.ourTab.getParent().getShell(), (String)Messages.getString((String)"NewOS2200FileWizard.0"), (String)interruptedException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                this.retDeploymentValue = false;
                Throwable throwable = invocationTargetException.getTargetException();
                MessageDialog.openError((Shell)this.ourTab.getParent().getShell(), (String)Messages.getString((String)"NewOS2200FileWizard.0"), (String)throwable.getMessage());
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.retDeploymentValue = false;
            MessageDialog.openError((Shell)this.ourTab.getParent().getShell(), (String)Messages.getString((String)"OS2200DebugSetup_9"), (String)unknownHostException.getLocalizedMessage());
        }
        return this.retDeploymentValue;
    }

    void doFinish(String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        ElementSelectionObject elementSelectionObject = new ElementSelectionObject(string, string2, this.subType);
        ArrayList<ElementSelectionObject> arrayList = new ArrayList<ElementSelectionObject>();
        arrayList.add(elementSelectionObject);
        iProgressMonitor.beginTask(Messages.getString((String)"NewOS2200FileWizard.2", (String)Messages.getString((String)"OS2200DebugSetup_10"), (String)string2), 2);
        long l = OS2200FileInterface.createOS2200EltFromString((IProject)this.project, (Properties)this.projProps, (String)string, (String)this.codeString, (boolean)true);
        if (l == 0L) {
            OS2200ProjectUpdate.addLinks((IProject)this.project, arrayList, (IProgressMonitor)iProgressMonitor);
            iProgressMonitor.worked(1);
            iProgressMonitor.setTaskName(Messages.getString((String)"NewOS2200FileWizard.3"));
        } else {
            Display display = Display.getDefault();
            final long l2 = l;
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (l2 == -1005L) {
                        MessageDialog.openError((Shell)OS2200DebugSetup.this.ourTab.getParent().getShell(), (String)Messages.getString((String)"NewOS2200FileWizard.4"), (String)Messages.getString((String)"NewOS2200FileWizard.5"));
                    } else if (l2 == -1006L) {
                        MessageDialog.openInformation((Shell)OS2200DebugSetup.this.ourTab.getParent().getShell(), (String)Messages.getString((String)"NewOS2200FileWizard.4"), (String)Messages.getString((String)"NewOS2200FileWizard.8"));
                    } else {
                        MessageDialog.openError((Shell)OS2200DebugSetup.this.ourTab.getParent().getShell(), (String)Messages.getString((String)"NewOS2200FileWizard.4"), (String)(String.valueOf(Messages.getString((String)"NewOS2200FileWizard.5")) + "\n\n" + OS2200FileInterface.getConnectErrorMsg((long)l2, (IProject)OS2200DebugSetup.this.project)));
                    }
                }
            });
        }
        iProgressMonitor.worked(1);
    }

    void setTxtLink() {
        String string = this.projProps.getProperty("workFile");
        int n = string.indexOf("#");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        this.strLinkLines = "include " + string + this.txtMASMEltName.getText() + " \n" + "include " + this.libAddress + "debuginc \n" + "create reference RTS$PINIT  \n" + "resolve RTS$PINIT, TCA$$$ usi lcn  \n" + "change reference (pads$init) to pads$initec2 \n" + "res all refs usi local_defs,lcn  \n" + "conceal messages 108  \n";
        this.txtLinkLines.setText(this.strLinkLines.toUpperCase());
    }

    void setFields() {
        boolean bl = this.buildType.equals("Debug");
        this.chkBuilddebug.setSelection(bl);
        if (bl) {
            this.theBuildPage.setBuildType(1);
        } else {
            this.theBuildPage.setBuildType(0);
        }
        if (this.txtDebugID.getText().length() == 0) {
            this.txtDebugID.setText(this.debugID.toUpperCase());
        }
        this.txtDebugID.setText(this.debugID.toUpperCase());
        this.txtMASMEltName.setText(this.strMASMElt.toUpperCase());
        this.txtPortNumber.setText(this.portNumber.toUpperCase());
        this.txtCallbackIPAddress.setText(this.ipAddress.toUpperCase());
        this.txtLibName.setText(this.libAddress.toUpperCase());
        this.txtDebugID.setToolTipText(this.debugID);
        this.txtPortNumber.setToolTipText(this.portNumber);
        this.txtCallbackIPAddress.setToolTipText(this.ipAddress);
        this.txtMASMEltName.setToolTipText(this.strMASMElt.toUpperCase());
        this.txtLibName.setToolTipText(this.libAddress);
        this.setTxtLink();
    }

    public void genDefaults() {
        this.portNumber = "1023";
        this.debugID = this.genDebugID();
        this.libAddress = PADS_LIB;
        this.ipAddress = this.genIPCallback();
        this.buildType = "Standard";
        this.setFields();
    }

    String genDebugID() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        return String.valueOf(this.projName) + "." + Long.toString(date.getTime() & 0xFFFFFFL);
    }

    String genIPCallback() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return Messages.getString((String)"OS2200DebugSetup_11");
        }
    }

    void initFields() {
        this.debugID = this.projProps.getProperty("DebugID", this.genDebugID());
        if (this.debugID.trim().length() == 0) {
            this.debugID = this.genDebugID();
        }
        this.portNumber = this.projProps.getProperty("DebugPortNumber", "1023");
        if (this.portNumber.trim().length() == 0) {
            this.portNumber = "1023";
        }
        this.ipAddress = this.projProps.getProperty("DebugIPCallback", this.genIPCallback());
        if (this.ipAddress.trim().length() == 0) {
            this.ipAddress = this.genIPCallback();
        }
        this.strMASMElt = this.projProps.getProperty("MASMElementName", this.projName);
        if (this.strMASMElt.trim().length() == 0) {
            String string = this.projName;
            this.strMASMElt = (string = string.replaceAll("([^\\w$-])", "")).trim().length() <= 12 ? string : string.substring(0, 12);
            if (this.strMASMElt.trim().length() <= 0) {
                this.strMASMElt = DEFAULT_MASM_ELT_NAME;
            }
            this.setStrMASMElt(this.strMASMElt);
        }
        this.libAddress = this.projProps.getProperty("DebugLibFile", PADS_LIB);
        if (this.libAddress.trim().length() == 0) {
            this.libAddress = PADS_LIB;
        }
        this.buildType = this.projProps.getProperty("BuildType", "");
        if (this.buildType.trim().length() == 0) {
            this.buildType = "Standard";
        }
    }

    public void setDebugBuild(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.txtDebugBuild = new Text(composite2, 2818);
        GridData gridData2 = new GridData(1808);
        gridData2.widthHint = 250;
        gridData2.heightHint = 250;
        this.txtDebugBuild.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                verifyEvent.text = verifyEvent.text.toUpperCase();
            }
        });
        this.txtDebugBuild.setLayoutData((Object)gridData2);
        this.txtDebugBuild.setFont(composite.getParent().getFont());
        if (this.projProps == null) {
            this.txtDebugBuild.setText(Messages.getString((String)"OS2200ProjectBuildScript.1").toUpperCase());
        } else {
            this.txtDebugBuild.setText(this.projProps.getProperty("DebugBuildScript").toUpperCase());
        }
    }

    public Text getDebugBuildScript() {
        return this.txtDebugBuild;
    }

    public String readInTemplate(String string) {
        OS2200CorePlugin.logger.debug((Object)string);
        InputStream inputStream = null;
        try {
            String string2;
            inputStream = this.getClass().getResourceAsStream(string);
            int n = inputStream.available();
            byte[] byArray = new byte[n + 100];
            OS2200CorePlugin.logger.debug((Object)("count " + n + " " + byArray.length));
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n2 != -1) {
                n2 = inputStream.read(byArray, n3, byArray.length - n3);
                OS2200CorePlugin.logger.debug((Object)("cntIn " + n2));
                if (n2 == -1) continue;
                n4 += n2;
                n3 += n2;
            }
            OS2200CorePlugin.logger.debug((Object)("countin " + n4));
            String string3 = string2 = new String(byArray, 0, n4);
            return string3;
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)iOException);
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                inputStream = null;
            }
        }
    }

    public final String getStrLinkLines() {
        return this.strLinkLines;
    }

    public final void setStrLinkLines(String string) {
        this.strLinkLines = string;
    }

    boolean reloadRequired() {
        this.portNumber = this.txtPortNumber.getText();
        this.debugID = this.txtDebugID.getText();
        this.ipAddress = this.txtCallbackIPAddress.getText();
        this.strMASMElt = this.txtMASMEltName.getText();
        if (this.projProps != null) {
            if (this.portNumber.equalsIgnoreCase(this.projProps.getProperty("DebugPortNumber"))) {
                if (this.debugID.equalsIgnoreCase(this.projProps.getProperty("DebugID"))) {
                    if (this.ipAddress.equalsIgnoreCase(this.projProps.getProperty("DebugIPCallback"))) {
                        return !this.strMASMElt.equalsIgnoreCase(this.projProps.getProperty("MASMElementName"));
                    }
                    return true;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    public void setProps() {
        this.setProps(this.projProps);
    }

    public final void setStrMASMElt(String string) {
        this.strMASMElt = string;
    }

    public final String getStrMASMElt() {
        return this.strMASMElt;
    }

    public Button getChkBuilddebug() {
        return this.chkBuilddebug;
    }

    private String gettxtLibName() {
        this.lbName = this.txtLibName.getText().trim();
        if (this.lbName.length() > 0 && !this.lbName.endsWith(".")) {
            this.lbName = String.valueOf(this.lbName) + ".";
        }
        return this.lbName;
    }
}

