/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.internal.ui.editor.FortranKeywordRuleBasedScanner;

public class SalesScanKeywordRule
extends WordRule
implements IRule {
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected ISourceViewer fSourceViewer;
    protected Map<String, IToken> fWords = new HashMap<String, IToken>();
    protected Map<String, IToken> fIdentifiers = new HashMap<String, IToken>();
    private StringBuffer fBuffer = new StringBuffer();
    private StringBuffer fLineBuffer = new StringBuffer();
    private int fWordCol = 0;

    public SalesScanKeywordRule(IWordDetector detector, IToken defaultToken, ISourceViewer sourceViewer) {
        super(detector);
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)defaultToken);
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
        this.fSourceViewer = sourceViewer;
    }

    public void addWord(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        this.fWords.put(word.toLowerCase(), token);
    }

    public void addIdentifier(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        this.fIdentifiers.put(word.toLowerCase(), token);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (!(scanner instanceof FortranKeywordRuleBasedScanner)) {
            throw new IllegalStateException();
        }
        int c = scanner.read();
        if (c != -1 && this.fDetector.isWordStart((char)c)) {
            scanner.unread();
            this.populateBuffers(scanner);
            String buffer = this.fBuffer.toString().toLowerCase();
            IToken token = this.fWords.get(buffer);
            if (token != null) {
                return this.salesScan(token, this.fIdentifiers.get(buffer));
            }
            if (this.fDefaultToken.isUndefined()) {
                int i = this.fBuffer.length() - 1;
                while (i >= 0) {
                    scanner.unread();
                    --i;
                }
            }
            if (this.fIdentifiers.containsKey(buffer)) {
                return this.fIdentifiers.get(buffer);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private void populateBuffers(ICharacterScanner scanner) {
        this.fBuffer.setLength(0);
        this.fLineBuffer.setLength(0);
        this.readPrefix(scanner);
        this.readWord(scanner);
        this.readSuffix(scanner);
        this.fixLineBuffer();
    }

    /*
     * Unable to fully structure code
     */
    private void readPrefix(ICharacterScanner scanner) {
        block6: {
            this.fWordCol = scanner.getColumn();
            try {
                fscanner = (FortranKeywordRuleBasedScanner)scanner;
                tokenOffset = fscanner.getTokenOffset();
                i = partitionStart = this.fSourceViewer.getDocument().getPartition(tokenOffset).getOffset();
                while (i < tokenOffset) {
                    scanner.unread();
                    ++i;
                }
                i = partitionStart;
                while (i < tokenOffset) {
                    this.fLineBuffer.append((char)scanner.read());
                    ++i;
                }
                break block6;
            }
            catch (BadLocationException e) {
                FortranUIPlugin.log(e);
                i = 0;
                ** while (i < this.fWordCol)
            }
lbl-1000:
            // 1 sources

            {
                scanner.unread();
                ++i;
                continue;
            }
lbl24:
            // 1 sources

            i = 0;
            while (i < this.fWordCol) {
                this.fLineBuffer.append((char)scanner.read());
                ++i;
            }
        }
    }

    private void readWord(ICharacterScanner scanner) {
        int c = scanner.read();
        do {
            this.fBuffer.append((char)c);
            this.fLineBuffer.append((char)c);
        } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
        scanner.unread();
    }

    private void readSuffix(ICharacterScanner scanner) {
        int startCol = scanner.getColumn();
        int count = 1;
        int c = scanner.read();
        if (c == -1 || scanner.getColumn() < startCol) {
            return;
        }
        do {
            ++count;
            this.fLineBuffer.append((char)c);
        } while ((c = scanner.read()) != -1);
        int i = 0;
        while (i < count) {
            scanner.unread();
            ++i;
        }
    }

    private void fixLineBuffer() {
        this.removeStringLiterals();
        this.removeTrailingComment();
        this.removeLineContinuations();
        this.removeConcatenatedStatements();
    }

    private void removeStringLiterals() {
        boolean inString = false;
        int i = 0;
        int length = this.fLineBuffer.length();
        while (i < length) {
            char nextChar;
            char thisChar = this.fLineBuffer.charAt(i);
            char c = nextChar = i + 1 < length ? this.fLineBuffer.charAt(i + 1) : (char)'\u0000';
            if (!(thisChar != '\"' && thisChar != '\'' || inString)) {
                inString = true;
            } else if ((thisChar == '\"' || thisChar == '\'') && inString) {
                boolean bl = inString = nextChar == '\"';
            }
            if (inString || thisChar == '\"' || thisChar == '\'') {
                this.fLineBuffer.setCharAt(i, ' ');
            }
            ++i;
        }
    }

    private void removeTrailingComment() {
        int excl = this.fLineBuffer.lastIndexOf("!");
        if (excl >= 0) {
            int i = excl;
            int length = this.fLineBuffer.length();
            while (i < length) {
                this.fLineBuffer.setCharAt(i, ' ');
                ++i;
            }
        }
    }

    private void removeLineContinuations() {
        int i = 0;
        while (i < this.fLineBuffer.length()) {
            if (this.fLineBuffer.charAt(i) == '&') {
                this.fLineBuffer.setCharAt(i, ' ');
            }
            ++i;
        }
    }

    private void removeConcatenatedStatements() {
        int precedingSemicolon = this.fLineBuffer.indexOf(";");
        while (precedingSemicolon > 0 && precedingSemicolon < this.fWordCol) {
            int i = 0;
            while (i <= precedingSemicolon) {
                this.fLineBuffer.setCharAt(i, ' ');
                ++i;
            }
            precedingSemicolon = this.fLineBuffer.indexOf(";", precedingSemicolon + 1);
        }
        int followingSemicolon = this.fLineBuffer.indexOf(";", this.fWordCol);
        if (followingSemicolon > 0) {
            int i = followingSemicolon;
            int length = this.fLineBuffer.length();
            while (i < length) {
                this.fLineBuffer.setCharAt(i, ' ');
                ++i;
            }
        }
    }

    private IToken salesScan(IToken tokenIfKeyword, IToken tokenIfIdentifier) {
        try {
            SalesScanner salesScanner = new SalesScanner(this.fLineBuffer.toString(), this.fBuffer.toString());
            boolean retainAsKeyword = salesScanner.retainAsKeyword(this.fWordCol);
            if (retainAsKeyword) {
                return tokenIfKeyword;
            }
            if (tokenIfIdentifier == null) {
                return this.fDefaultToken;
            }
            return tokenIfIdentifier;
        }
        catch (Throwable e) {
            FortranUIPlugin.log(e);
            return this.fDefaultToken;
        }
    }

    private static class SalesScanner {
        private String line;
        private String keyword;
        private int length;
        private int pos;
        private boolean lineContainsColonColon;
        private boolean[] inParens;
        private boolean openContextComma;
        private boolean openContextEquals;
        private boolean letterFollowsParenthetical;
        private int firstTokenPos = -1;
        private int tokenFollowingParentheticalPos = -1;

        public SalesScanner(String line, String keyword) {
            this.line = line;
            this.keyword = keyword;
            this.length = line.length();
            this.pos = 0;
            this.inParens = new boolean[line.length()];
            this.firstTokenPos = this.findFirstToken();
            this.scan();
        }

        private int findFirstToken() {
            int pos;
            int start = 0;
            int cc = this.line.indexOf("::");
            boolean bl = this.lineContainsColonColon = cc > 0;
            if (this.lineContainsColonColon) {
                start = cc + 2;
            }
            if ((pos = this.skipWhitespace(start)) >= 0 && Character.isDigit(this.line.charAt(pos))) {
                pos = this.skipInteger(pos);
                pos = this.skipWhitespace(pos);
            }
            pos = this.skipConstructLabel(pos);
            pos = this.skipWhitespace(pos);
            return pos;
        }

        private int skipWhitespace(int start) {
            this.pos = start;
            while (this.pos < this.length) {
                if (!Character.isWhitespace(this.line.charAt(this.pos))) {
                    return this.pos;
                }
                ++this.pos;
            }
            return 0;
        }

        private int skipInteger(int start) {
            this.pos = start;
            while (this.pos < this.length) {
                if (!Character.isDigit(this.line.charAt(this.pos))) {
                    return this.pos;
                }
                ++this.pos;
            }
            return 0;
        }

        private int skipConstructLabel(int start) {
            this.pos = start;
            while (this.pos < this.length) {
                char ch = this.line.charAt(this.pos);
                if (!Character.isLetterOrDigit(ch) && ch != '_') {
                    if (ch == ':') {
                        return this.pos + 1;
                    }
                    return start;
                }
                ++this.pos;
            }
            return start;
        }

        private void scan() {
            this.openContextComma = false;
            this.openContextEquals = false;
            this.letterFollowsParenthetical = false;
            int currentParenDepth = 0;
            boolean justClosedParen = false;
            boolean firstParenthetical = true;
            boolean inArrayLiteral = false;
            boolean followingThen = false;
            this.pos = 0;
            while (this.pos < this.length) {
                if (currentParenDepth == 0) {
                    if (this.match("(/")) {
                        inArrayLiteral = true;
                    } else if (this.match("/)")) {
                        inArrayLiteral = false;
                    } else if (this.match("then")) {
                        followingThen = true;
                    }
                    if (!inArrayLiteral) {
                        if (this.match(",") && this.pos >= this.firstTokenPos) {
                            this.openContextComma = true;
                        } else if (this.match("=") && this.pos >= this.firstTokenPos && !followingThen) {
                            this.openContextEquals = true;
                        }
                        if (justClosedParen && firstParenthetical) {
                            firstParenthetical = false;
                            this.tokenFollowingParentheticalPos = this.nextPos();
                            this.letterFollowsParenthetical = this.letterIsNext();
                        }
                    }
                }
                justClosedParen = false;
                if (this.match("(")) {
                    ++currentParenDepth;
                } else if (this.match(")")) {
                    --currentParenDepth;
                    justClosedParen = true;
                }
                this.inParens[this.pos] = currentParenDepth > 0;
                ++this.pos;
            }
        }

        private boolean match(String pattern) {
            return this.match(pattern, this.pos);
        }

        private boolean match(String pattern, int matchAtPosition) {
            if (matchAtPosition < 0) {
                return false;
            }
            int patternLength = pattern.length();
            if (matchAtPosition + patternLength > this.length) {
                return false;
            }
            int i = 0;
            while (i < patternLength) {
                if (Character.toLowerCase(this.line.charAt(matchAtPosition + i)) != Character.toLowerCase(pattern.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean letterIsNext() {
            int i = this.pos;
            while (i < this.length) {
                if (!Character.isWhitespace(this.line.charAt(i))) {
                    return Character.isLetter(this.line.charAt(i));
                }
                ++i;
            }
            return false;
        }

        private int nextPos() {
            int i = this.pos;
            while (i < this.length) {
                if (!Character.isWhitespace(this.line.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return this.length - 1;
        }

        public boolean retainAsKeyword(int column) {
            return this.internalRetainAsKeyword(column, this.keyword);
        }

        private boolean internalRetainAsKeyword(int column, String keyword) {
            if (column < 0) {
                return false;
            }
            if (this.salesRetainAsKeyword(column)) {
                return true;
            }
            return this.applyKeywordRules(column, keyword);
        }

        private boolean applyKeywordRules(int column, String keyword) {
            if (keyword.equalsIgnoreCase("only")) {
                return this.openContextComma && this.match("use", this.firstTokenPos);
            }
            if (keyword.equalsIgnoreCase("result")) {
                return this.letterFollowsParenthetical;
            }
            if (keyword.equalsIgnoreCase("then")) {
                return !this.openContextEquals && !this.openContextComma && (this.match("if", this.firstTokenPos) || this.match("else", this.firstTokenPos) || this.match("forall", this.firstTokenPos));
            }
            if (keyword.equalsIgnoreCase("to")) {
                return !this.openContextEquals && !this.openContextComma && this.match("go", this.firstTokenPos);
            }
            if (keyword.equalsIgnoreCase("bind")) {
                return this.openContextComma && (this.match("enum", this.firstTokenPos) || this.match("type", this.firstTokenPos)) || this.match("function", this.firstTokenPos) || this.match("subroutine", this.firstTokenPos);
            }
            if (keyword.equalsIgnoreCase("procedure")) {
                return this.match("procedure", this.firstTokenPos) || this.match("module", this.firstTokenPos) || this.match("end", this.firstTokenPos);
            }
            if (keyword.equalsIgnoreCase("pointer")) {
                return this.openContextComma;
            }
            if (keyword.equalsIgnoreCase("operator") || keyword.equalsIgnoreCase("assignment") || keyword.equalsIgnoreCase("read") || keyword.equalsIgnoreCase("write")) {
                return this.lineContainsColonColon;
            }
            if (this.isType(keyword) && this.match("implicit", this.firstTokenPos)) {
                return true;
            }
            int precedingKeywordOffset = this.findPrecedingKeyword(column);
            if (precedingKeywordOffset == column) {
                return false;
            }
            String precedingKeyword = this.precedingKeywordAsString(column, precedingKeywordOffset);
            if (!this.internalRetainAsKeyword(precedingKeywordOffset, precedingKeyword)) {
                return false;
            }
            return this.applyPrecedingKeywordRules(keyword, precedingKeyword);
        }

        private boolean applyPrecedingKeywordRules(String keyword, String precedingKeyword) {
            if (keyword.equalsIgnoreCase("module")) {
                return this.isPrefixSpec(precedingKeyword) && !precedingKeyword.equalsIgnoreCase("module") || precedingKeyword.equalsIgnoreCase("end");
            }
            if (keyword.equalsIgnoreCase("complex") && precedingKeyword.equalsIgnoreCase("double")) {
                return true;
            }
            if (this.isType(keyword) && !keyword.equalsIgnoreCase("type")) {
                return this.isPrefixSpec(precedingKeyword) || precedingKeyword.equalsIgnoreCase("implicit");
            }
            if (this.isPrefixSpec(keyword)) {
                return this.isType(precedingKeyword);
            }
            if (keyword.equalsIgnoreCase("case")) {
                return precedingKeyword.equalsIgnoreCase("select");
            }
            if (keyword.equalsIgnoreCase("data")) {
                return precedingKeyword.equalsIgnoreCase("block");
            }
            if (keyword.equalsIgnoreCase("subroutine")) {
                return precedingKeyword.equalsIgnoreCase("end") || this.isPrefixSpec(precedingKeyword);
            }
            if (keyword.equalsIgnoreCase("function")) {
                return precedingKeyword.equalsIgnoreCase("end") || this.isType(precedingKeyword) || this.isPrefixSpec(precedingKeyword) || this.match("type", this.firstTokenPos);
            }
            if (keyword.equalsIgnoreCase("if")) {
                return precedingKeyword.equalsIgnoreCase("else") || precedingKeyword.equalsIgnoreCase("end");
            }
            if (keyword.equalsIgnoreCase("none")) {
                return precedingKeyword.equalsIgnoreCase("implicit");
            }
            if (keyword.equalsIgnoreCase("complex")) {
                return precedingKeyword.equalsIgnoreCase("double");
            }
            if (keyword.equalsIgnoreCase("precision")) {
                return precedingKeyword.equalsIgnoreCase("double");
            }
            if (keyword.equalsIgnoreCase("while")) {
                return precedingKeyword.equalsIgnoreCase("do");
            }
            if (keyword.equalsIgnoreCase("type")) {
                return this.isPrefixSpec(precedingKeyword) || precedingKeyword.equalsIgnoreCase("implicit") || precedingKeyword.equalsIgnoreCase("end") || precedingKeyword.equalsIgnoreCase("select");
            }
            if (keyword.equalsIgnoreCase("interface")) {
                return precedingKeyword.equalsIgnoreCase("abstract") || precedingKeyword.equalsIgnoreCase("end");
            }
            if (keyword.equalsIgnoreCase("is")) {
                return precedingKeyword.equalsIgnoreCase("type") || precedingKeyword.equalsIgnoreCase("class");
            }
            if (keyword.equalsIgnoreCase("default")) {
                return precedingKeyword.equalsIgnoreCase("case") || precedingKeyword.equalsIgnoreCase("class");
            }
            if (keyword.equalsIgnoreCase("stop")) {
                return precedingKeyword.equalsIgnoreCase("all");
            }
            if (keyword.equalsIgnoreCase("all") || keyword.equalsIgnoreCase("images") || keyword.equalsIgnoreCase("memory")) {
                return precedingKeyword.equalsIgnoreCase("sync");
            }
            if (keyword.equalsIgnoreCase("concurrent")) {
                return precedingKeyword.equalsIgnoreCase("do");
            }
            return precedingKeyword.equalsIgnoreCase("end");
        }

        private boolean salesRetainAsKeyword(int column) {
            if (column == this.firstTokenPos) {
                return this.retainFirstTokenAsKeyword();
            }
            if (column == this.tokenFollowingParentheticalPos) {
                return this.retainTokenFollowingParentheticalAsKeyword();
            }
            if (this.lineContainsColonColon) {
                return column < this.firstTokenPos && !this.inParens[column];
            }
            return false;
        }

        private boolean retainFirstTokenAsKeyword() {
            if (!this.openContextComma && !this.openContextEquals) {
                return !this.lineContainsColonColon;
            }
            if (this.openContextEquals && !this.openContextComma) {
                return !this.lineContainsColonColon && this.letterFollowsParenthetical && (this.match("if", this.firstTokenPos) || this.match("where", this.firstTokenPos) || this.match("forall", this.firstTokenPos));
            }
            if (this.openContextComma) {
                return true;
            }
            return this.letterFollowsParenthetical;
        }

        private boolean retainTokenFollowingParentheticalAsKeyword() {
            return this.letterFollowsParenthetical && (this.match("if", this.firstTokenPos) || this.match("forall", this.firstTokenPos)) && !this.openContextEquals;
        }

        private boolean isType(String kw) {
            return kw.equalsIgnoreCase("character") || kw.equalsIgnoreCase("complex") || kw.equalsIgnoreCase("double") || kw.equalsIgnoreCase("doublecomplex") || kw.equalsIgnoreCase("doubleprecision") || kw.equalsIgnoreCase("integer") || kw.equalsIgnoreCase("logical") || kw.equalsIgnoreCase("real") || kw.equalsIgnoreCase("type");
        }

        private boolean isPrefixSpec(String kw) {
            return kw.equalsIgnoreCase("recursive") || kw.equalsIgnoreCase("pure") || kw.equalsIgnoreCase("elemental") || kw.equalsIgnoreCase("impure") || kw.equalsIgnoreCase("module");
        }

        private int findPrecedingKeyword(int wordCol) {
            return this.backOverIdentifier(this.backOverSpaces(wordCol - 1)) + 1;
        }

        private int backOverSpaces(int offset) {
            while (offset >= 0 && Character.isWhitespace(this.line.charAt(offset))) {
                --offset;
            }
            return offset;
        }

        private int backOverIdentifier(int offset) {
            if (offset >= 0 && this.line.charAt(offset) == ')') {
                offset = this.backOverParens(offset);
            }
            while (offset >= 0 && Character.isJavaIdentifierPart(this.line.charAt(offset))) {
                --offset;
            }
            return offset;
        }

        private int backOverParens(int offset) {
            int depth = 0;
            while (offset >= 0) {
                if (this.line.charAt(offset) == ')') {
                    ++depth;
                } else if (this.line.charAt(offset) == '(') {
                    --depth;
                }
                --offset;
                if (depth == 0) break;
            }
            return offset;
        }

        private String precedingKeywordAsString(int column, int precedingKeywordOffset) {
            String precedingKeyword = this.line.substring(precedingKeywordOffset, column);
            if (precedingKeyword.indexOf("(") >= 0) {
                precedingKeyword = precedingKeyword.substring(0, precedingKeyword.indexOf("("));
            }
            precedingKeyword = precedingKeyword.trim();
            return precedingKeyword;
        }
    }
}

