/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.client.utils;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.telnet.client.utils.ConfigReader;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.net.telnet.TelnetClient;

public class TestTelnetConnection {
    private TelnetClient telnet = new TelnetClient();
    private InputStream inStream;
    private PrintStream outStream;
    private String machine;
    private String user;
    private String password;
    private int port;
    private String prompt;

    private boolean checkConnection() {
        String string;
        block3: {
            try {
                this.telnet.connect(this.machine, this.port);
                this.inStream = this.telnet.getInputStream();
                this.outStream = new PrintStream(this.telnet.getOutputStream());
                this.readFromSocket();
                this.writeToSocket(String.valueOf(this.user) + "/" + this.password);
                string = this.readFromSocket().trim();
                if (string.length() <= 0 || string.toLowerCase().contains(ConfigReader.TestTelnetConnection_InvalidLogin.toLowerCase()) || string.equals(this.prompt)) break block3;
                string = null;
                return true;
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
                return false;
            }
        }
        string = null;
        return false;
    }

    private String readFromSocket() {
        try {
            byte[] byArray = new byte[4096];
            this.inStream.read(byArray);
            String string = new String(byArray);
            return string.trim();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private void writeToSocket(String string) {
        try {
            this.outStream.println(string);
            this.outStream.flush();
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void disconnectAndClean() {
        try {
            try {
                this.machine = null;
                this.user = null;
                this.password = null;
                this.telnet.disconnect();
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
                try {
                    if (this.inStream != null) {
                        this.inStream.close();
                        this.inStream = null;
                    }
                    if (this.outStream != null) {
                        this.outStream = null;
                    }
                }
                catch (Exception exception2) {
                    OS2200CorePlugin.logger.info((Object)exception2.getMessage(), (Throwable)exception2);
                }
            }
        }
        finally {
            try {
                if (this.inStream != null) {
                    this.inStream.close();
                    this.inStream = null;
                }
                if (this.outStream != null) {
                    this.outStream = null;
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public boolean testConnection() {
        try {
            boolean bl = this.checkConnection();
            this.disconnectAndClean();
            return bl;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public void setMachine(String string) {
        this.machine = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }
}

