/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.client.ui.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.telnet.client.ui.ClientPlugin;
import com.unisys.telnet.client.ui.TelnetView;
import com.unisys.telnet.client.ui.wizards.TelnetWizardPage1;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class TelnetWizard
extends Wizard
implements INewWizard {
    private TelnetWizardPage1 page;
    private ISelection selection;
    private static String HOSTPROPERTY = "host";
    private static String PORTPROPERTY = "port";
    private static String LOGINPROPERTY = "login";
    private static String propertyprefix = "com.unisys.telnet.client.ui.wizards.TelnetWizard";

    public TelnetWizard() {
        OS2200CorePlugin.logger.debug((Object)"");
        this.setNeedsProgressMonitor(true);
        ImageDescriptor imageDescriptor = ClientPlugin.imageDescriptorFromPlugin((String)"com.unisys.telnet.client", (String)"icons/telnet2.gif");
        super.setDefaultPageImageDescriptor(imageDescriptor);
    }

    public void addPages() {
        super.setWindowTitle(Messages.getString((String)"Wizard.0"));
        OS2200CorePlugin.logger.debug((Object)"");
        this.page = new TelnetWizardPage1(this.selection);
        this.page.inithost = this.getProperty(HOSTPROPERTY);
        this.page.initport = this.getProperty(PORTPROPERTY);
        this.page.initcharCombo = this.getProperty("Property.CharSet");
        this.page.initSecureSSL = this.getProperty("Property.SecureSSL");
        if (this.page.initport.equals("")) {
            this.page.initport = "23";
            this.setProperty(PORTPROPERTY, "23");
        }
        this.page.initLoginAccount = this.getProperty(LOGINPROPERTY);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        OS2200CorePlugin.logger.debug((Object)"");
        new Properties();
        if (this.page.loginselection == 0) {
            String string = this.page.getHostid();
            String string2 = this.page.getPort();
            String string3 = this.page.getcharSetName();
            boolean bl = this.page.getSecure();
            this.setProperty(HOSTPROPERTY, string);
            this.setProperty(PORTPROPERTY, string2);
            this.setProperty("Property.CharSet", string3);
            this.setProperty(LOGINPROPERTY, "");
            this.setProperty("Property.SecureSSL", Boolean.toString(bl));
            TelnetView telnetView = ClientPlugin.getDefault().getView(string);
            telnetView.login(string, string2, string3, bl);
        } else {
            LoginAccount loginAccount = this.page.getLoginAccount();
            this.setProperty(HOSTPROPERTY, "");
            String string = this.page.getPort();
            boolean bl = this.page.getSecure();
            this.setProperty(PORTPROPERTY, string);
            String string4 = this.page.getcharSetName();
            this.setProperty("Property.CharSet", string4);
            this.setProperty(LOGINPROPERTY, loginAccount.getName());
            this.setProperty("Property.SecureSSL", Boolean.toString(bl));
            TelnetView telnetView = ClientPlugin.getDefault().getView(loginAccount.getName());
            telnetView.login(loginAccount);
        }
        return true;
    }

    private void setProperty(String string, String string2) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(new QualifiedName(propertyprefix, string), string2);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)exception);
        }
        OS2200CorePlugin.logger.debug((Object)("setproperty:" + string + "|" + string2 + "|"));
    }

    private String getProperty(String string) {
        String string2 = "";
        try {
            string2 = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(new QualifiedName(propertyprefix, string));
        }
        catch (Exception exception) {}
        if (string2 == null) {
            string2 = "";
        }
        OS2200CorePlugin.logger.debug((Object)("getproperty:" + string + "|" + string2 + "|"));
        return string2;
    }

    private InputStream openContentStream() {
        OS2200CorePlugin.logger.debug((Object)"");
        String string = "This is the initial file contents for *.mpe file that should be word-sorted in the Preview page of the multi-page editor";
        return new ByteArrayInputStream(string.getBytes());
    }

    private void throwCoreException(String string) throws CoreException {
        OS2200CorePlugin.logger.debug((Object)"");
        Status status = new Status(4, "com.unisys.telnet.client", 0, string, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        OS2200CorePlugin.logger.debug((Object)"");
        this.selection = iStructuredSelection;
    }
}

