/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.client.ui;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.telnet.client.ui.ClientPlugin;
import com.unisys.telnet.client.ui.RecentLines;
import com.unisys.telnet.client.ui.TelnetMacroMap;
import com.unisys.telnet.client.ui.TelnetMacroParamInputDlg;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.hostaccount.Protocol;
import com.unisys.telnet.lib.session.IOutputListener;
import com.unisys.telnet.lib.session.ISession;
import com.unisys.telnet.lib.session.Session;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.internal.console.ConsoleResourceBundleMessages;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class TelnetView
extends ViewPart
implements IOutputListener {
    private TextViewer viewer = null;
    private Document document = null;
    private StyledText textWidget = null;
    public ISession session = null;
    private Display mydisplay = Display.getDefault();
    private int outputMark = 0;
    private boolean autoscroll = true;
    private boolean madmouse = false;
    private String myKey = "";
    private MenuManager fMenuManager;
    private TextViewerAction fCopyAction;
    private TextViewerAction fPasteAction;
    private TextViewerAction fSelectAllAction;
    private HostAccount myHost;
    private LoginAccount myLogin;
    private boolean buffered = true;
    private RecentLines lineList;
    protected Map fGlobalActions = new HashMap();
    protected ArrayList fSelectionActions = new ArrayList();
    private IViewSite viewSite;
    private Properties telnetMacroProperties;
    private static final String NEW_LINE_CHAR = "\\n";
    private static final String EXTRA_SPACE_REG = "\\s+$";
    private static final String PARAM_CHAR = "[XXX]";
    private static final String PARAM_CHAR_REG = "\\[XXX\\]";
    static final String pwdCmd = "@PASSWD";
    private File telnetLogFile = null;
    int numberOfLines = 0;
    private FileWriter writer = null;
    private boolean appendLog = false;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            TelnetView.this.updateSelectionDependentActions();
        }
    };
    private ITextListener textListener = new ITextListener(){

        public void textChanged(TextEvent textEvent) {
            IUpdate iUpdate = (IUpdate)TelnetView.this.fGlobalActions.get(ActionFactory.FIND.getId());
            if (iUpdate != null) {
                iUpdate.update();
            }
        }
    };

    public TelnetView() {
        OS2200CorePlugin.logger.debug((Object)"");
        this.lineList = new RecentLines();
        this.telnetMacroProperties = OS2200FileInterface.loadTelnetMacroProperties();
        this.loadTelnetMacroToProperties();
    }

    public void dispose() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private void loadTelnetMacroToProperties() {
        if (this.telnetMacroProperties != null) {
            OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Loading telnet properties");
            for (Map.Entry<Object, Object> entry : this.telnetMacroProperties.entrySet()) {
                try {
                    TelnetMacroMap.getInstance().getConfiguredMacro().put(TelnetMacroMap.MacroKey.valueOf((String)entry.getKey()), (String)entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            OS2200CorePlugin.logger.debug((Object)("TelnetMacro : Count of properties : " + this.telnetMacroProperties.size()));
        } else {
            TelnetMacroMap.getInstance().getConfiguredMacro().clear();
        }
    }

    public void createPartControl(Composite composite) {
        OS2200CorePlugin.logger.debug((Object)"");
        this.viewer = new TextViewer(composite, 768);
        GridData gridData = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setEditable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "com.unisys.telnet.client.telnetview_context");
        this.document = new Document();
        this.viewer.setDocument((IDocument)this.document);
        this.setPartName(Messages.getString((String)"TelnetView.4"));
        TextViewer textViewer = this.viewer;
        this.textWidget = textViewer.getTextWidget();
        this.textWidget.setFont(JFaceResources.getTextFont());
        this.textWidget.forceFocus();
        this.fMenuManager = new MenuManager("TelnetView");
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                OS2200CorePlugin.logger.debug((Object)"");
                TelnetView.this.contextMenuAboutToShow(iMenuManager);
            }
        });
        Menu menu = this.fMenuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        IFindReplaceTargetExtension cfr_ignored_0 = (IFindReplaceTargetExtension)this.viewer.getFindReplaceTarget();
        this.createActions();
        this.viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.viewer.addTextListener(this.textListener);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        this.getViewSite().registerContextMenu(this.fMenuManager, this.getViewSite().getSelectionProvider());
        this.textWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                OS2200CorePlugin.logger.debug((Object)"");
                try {
                    ClientPlugin.removeKey(TelnetView.this.myKey);
                    TelnetView.this.session.Logout();
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.warn((Object)exception);
                }
            }
        });
        this.textWidget.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                Character c = new Character(verifyEvent.character);
                if (TelnetView.this.buffered) {
                    verifyEvent.doit = true;
                    if (TelnetView.this.textWidget.getCaretOffset() > TelnetView.this.outputMark) {
                        if (c.equals(Character.valueOf('\r'))) {
                            verifyEvent.doit = false;
                        }
                    } else if (TelnetView.this.textWidget.getCaretOffset() == TelnetView.this.outputMark && c.equals(Character.valueOf('\b'))) {
                        verifyEvent.doit = false;
                    }
                } else {
                    verifyEvent.doit = false;
                }
            }
        });
        this.textWidget.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                if (TelnetView.this.buffered) {
                    String string;
                    int n;
                    int n2;
                    int n3 = keyEvent.keyCode;
                    int n4 = keyEvent.stateMask;
                    if (n3 == 0x1000001 && n4 == 262144) {
                        n2 = TelnetView.this.textWidget.getCharCount();
                        n = n2 - TelnetView.this.outputMark;
                        string = TelnetView.this.lineList.getNext();
                        if (string != null) {
                            TelnetView.this.textWidget.replaceTextRange(TelnetView.this.outputMark, n, string);
                            TelnetView.this.textWidget.setCaretOffset(TelnetView.this.textWidget.getCharCount());
                        }
                    }
                    if (n3 == 0x1000002 && n4 == 262144) {
                        n2 = TelnetView.this.textWidget.getCharCount();
                        n = n2 - TelnetView.this.outputMark;
                        string = TelnetView.this.lineList.getPrevious();
                        if (string != null) {
                            TelnetView.this.textWidget.replaceTextRange(TelnetView.this.outputMark, n, string);
                            TelnetView.this.textWidget.setCaretOffset(TelnetView.this.textWidget.getCharCount());
                        }
                    }
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                Character c = new Character(keyEvent.character);
                int n = keyEvent.stateMask;
                keyEvent.doit = false;
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 100) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_d);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 103) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_g);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 106) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_j);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 107) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_k);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 108) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_l);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 111) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_o);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 112) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_p);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 114) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_r);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 47) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_FRWSLASH);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 116) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_t);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 0x100000C) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_F3);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 121) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_y);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 122) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_z);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 48) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_0);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 49) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_1);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 50) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_2);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 55) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_7);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 56) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_8);
                    return;
                }
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 57) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Ctrl_9);
                    return;
                }
                if (keyEvent.stateMask == 65536 && keyEvent.keyCode == 0x1000012) {
                    TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.Alt_F9);
                    return;
                }
                switch (keyEvent.keyCode) {
                    case 0x100000B: {
                        TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.F2);
                        break;
                    }
                    case 0x100000C: {
                        TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.F3);
                        break;
                    }
                    case 0x100000D: {
                        TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.F4);
                        break;
                    }
                    case 0x1000011: {
                        TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.F8);
                        break;
                    }
                    case 0x1000013: {
                        TelnetView.this.parsekeyPress(TelnetMacroMap.MacroKey.F10);
                        break;
                    }
                }
                if (keyEvent.character != '\u0000') {
                    if ((n & 0x10000) != 0 && (n & 0x20000) == 0 && (n & 0x40000) == 0) {
                        return;
                    }
                    if (TelnetView.this.session.active()) {
                        if (!TelnetView.this.buffered) {
                            TelnetView.this.session.SendCommandAsync(c.toString());
                        } else if (!TelnetView.this.session.getLocalEcho() && !c.equals(Character.valueOf('\r'))) {
                            keyEvent.doit = true;
                            int n2 = TelnetView.this.textWidget.getCharCount() - TelnetView.this.outputMark;
                            StyleRange styleRange = new StyleRange(TelnetView.this.outputMark, n2, TelnetView.this.textWidget.getBackground(), TelnetView.this.textWidget.getBackground());
                            TelnetView.this.textWidget.setStyleRange(styleRange);
                        } else {
                            keyEvent.doit = true;
                            if (c.equals(Character.valueOf('\r'))) {
                                keyEvent.doit = false;
                                TelnetView.this.textWidget.setCaretOffset(TelnetView.this.textWidget.getCharCount());
                                TelnetView.this.textWidget.insert("\r");
                                int n3 = TelnetView.this.textWidget.getCharCount() - TelnetView.this.outputMark;
                                String string = TelnetView.this.textWidget.getTextRange(TelnetView.this.outputMark, n3);
                                if (string.toUpperCase().contains(TelnetView.pwdCmd)) {
                                    TelnetView.this.writeToFile("@PASSWD\r");
                                } else {
                                    TelnetView.this.writeToFile(string);
                                }
                                TelnetView.this.outputMark = TelnetView.this.textWidget.getCharCount();
                                TelnetView.this.lineList.addLine(string);
                                TelnetView.this.session.SendCommandAsync(string);
                            }
                        }
                    } else {
                        TelnetView.this.login(TelnetView.this.myLogin);
                    }
                }
            }
        });
        this.textWidget.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                if (TelnetView.this.buffered) {
                    if (TelnetView.this.textWidget.getCaretOffset() < TelnetView.this.outputMark) {
                        verifyEvent.doit = false;
                    }
                    if (verifyEvent.text.equals("\r\n")) {
                        verifyEvent.doit = false;
                    }
                } else {
                    verifyEvent.doit = false;
                    TelnetView.this.session.SendCommandAsync(verifyEvent.text);
                }
            }
        });
        ScrollBar scrollBar = this.textWidget.getVerticalBar();
        scrollBar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TelnetView.this.viewer.getBottomIndexEndOffset() + 1000 < TelnetView.this.viewer.getVisibleRegion().getLength()) {
                    if (!TelnetView.this.madmouse) {
                        TelnetView.this.autoscroll = false;
                    } else {
                        TelnetView.this.madmouse = false;
                    }
                } else {
                    TelnetView.this.madmouse = true;
                    TelnetView.this.autoscroll = true;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    private int executeCmd(String string, boolean bl) {
        if (string.endsWith(NEW_LINE_CHAR)) {
            OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Command contains new line character.");
            string = string.substring(0, string.lastIndexOf(NEW_LINE_CHAR)).trim();
            string = String.valueOf(string) + '\n';
            bl = true;
        } else {
            OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Command don't have new line character.");
            string = string.trim();
            if (bl) {
                string = String.valueOf(string) + '\n';
            }
        }
        if (!this.buffered) {
            return this.session.SendCommandAsync(string);
        }
        this.textWidget.setCaretOffset(this.textWidget.getCharCount());
        this.textWidget.insert(string);
        this.textWidget.setCaretOffset(this.textWidget.getCharCount());
        OS2200CorePlugin.logger.debug((Object)"Command copied in telnet view");
        if (bl) {
            int n = this.textWidget.getCharCount() - this.outputMark;
            String string2 = this.textWidget.getTextRange(this.outputMark, n);
            if (string2.toUpperCase().contains(pwdCmd)) {
                this.writeToFile("@PASSWD\r");
            } else {
                this.writeToFile(string2);
            }
            this.outputMark = this.textWidget.getCharCount();
            this.lineList.addLine(string);
            OS2200CorePlugin.logger.debug((Object)"Command sent for execution.");
            return this.session.SendCommandAsync(string);
        }
        return -1;
    }

    void insertLine(String string) {
        this.textWidget.setCaretOffset(this.textWidget.getCharCount());
        this.textWidget.insert(string);
        this.textWidget.setCaretOffset(this.textWidget.getCharCount());
    }

    private void parsekeyPress(TelnetMacroMap.MacroKey macroKey) {
        String string = TelnetMacroMap.getInstance().getConfiguredMacro().get((Object)macroKey);
        if (string != null) {
            this.SendForExecution(string, false);
        }
    }

    public static int countSubStr(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n2)) != -1) {
            ++n2;
            ++n;
        }
        return n;
    }

    public void SendForExecution(String string, boolean bl) {
        if (string != null) {
            string = string.replaceAll(EXTRA_SPACE_REG, "");
            while (string.contains(PARAM_CHAR)) {
                OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Need input from user(parameter)");
                TelnetMacroParamInputDlg telnetMacroParamInputDlg = new TelnetMacroParamInputDlg(Display.getCurrent().getActiveShell(), string);
                int n = telnetMacroParamInputDlg.open();
                if (n == 0) {
                    String string2 = telnetMacroParamInputDlg.getValue();
                    string = string.replaceFirst(PARAM_CHAR_REG, string2);
                    continue;
                }
                return;
            }
            int n = this.executeCmd(string, bl);
            if (n == 0) {
                OS2200CorePlugin.logger.debug((Object)"Command executed");
            } else {
                OS2200CorePlugin.logger.debug((Object)"Command copied in telnet view");
            }
        }
    }

    public void toggleBuffered() {
        boolean bl = this.buffered = !this.buffered;
        if (this.buffered) {
            this.session.setLocalEcho(true);
            try {
                IRegion iRegion = this.document.getLineInformationOfOffset(this.outputMark);
                int n = iRegion.getLength();
                int n2 = 1;
                while (n2 < n) {
                    this.session.SendCommandAsync("\b");
                    --this.outputMark;
                    ++n2;
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.debug((Object)exception);
            }
        } else {
            int n = this.textWidget.getCharCount() - this.outputMark;
            String string = this.textWidget.getTextRange(this.outputMark, n);
            this.outputMark = this.textWidget.getCharCount();
            this.textWidget.setCaretOffset(this.textWidget.getCharCount());
            this.session.SendCommandAsync(string);
            this.session.setLocalEcho(false);
        }
    }

    public boolean getBuffered() {
        return this.buffered;
    }

    public void setImage(Image image) {
        this.setTitleImage(image);
    }

    public void login(LoginAccount loginAccount) {
        this.buffered = loginAccount.getHostAccount().getOS2200();
        this.myLogin = loginAccount;
        OS2200CorePlugin.logger.debug((Object)"");
        this.session = Session.New((LoginAccount)loginAccount);
        this.session.addOutputListener((IOutputListener)this);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = TelnetView.this.session.Login();
                if (string.length() == 0) {
                    OS2200CorePlugin.logger.debug((Object)("done with login: " + string));
                    OS2200CorePlugin.logger.debug((Object)"output message is set");
                    TelnetView.this.session.setLocalEcho(TelnetView.this.buffered);
                    OS2200CorePlugin.logger.debug((Object)"finished login run");
                } else {
                    final String string2 = string;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"TelnetView_0"), (String)string2);
                        }
                    });
                }
            }
        };
        new Thread(runnable).start();
    }

    public void login(String string, String string2, String string3, boolean bl) {
        OS2200CorePlugin.logger.debug((Object)"");
        this.buffered = false;
        if (bl) {
            this.buffered = true;
        }
        this.myHost = new HostAccount();
        this.myHost.setHostId(string);
        this.myLogin = new LoginAccount();
        this.myLogin.setHostAccount(this.myHost);
        Protocol protocol = new Protocol();
        protocol.setConnectionType("Telnet");
        protocol.setProperty("Property.Port", string2);
        protocol.setProperty("Property.CharSet", string3);
        protocol.setProperty("Property.SecureSSL", Boolean.toString(bl));
        this.myLogin.addProtocol(protocol);
        this.session = Session.New((LoginAccount)this.myLogin);
        this.session.addOutputListener((IOutputListener)this);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = TelnetView.this.session.Login();
                TelnetView.this.newOutput(string);
            }
        };
        new Thread(runnable).start();
    }

    public void newOutput(final String string) {
        this.mydisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String string4 = string;
                    if (string4 == null) {
                        return;
                    }
                    TelnetView.this.writeToFile(string4);
                    String string2 = new String("\r\n");
                    if (!string4.contains(string2)) {
                        string2 = new String("\n");
                    }
                    if (string4.length() > 3) {
                        int n;
                        int n2;
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, string2);
                        int n3 = TelnetView.this.textWidget.getLineCount();
                        int n4 = n3 + (n2 = stringTokenizer.countTokens());
                        if (n4 > (n = 10000)) {
                            StringBuffer stringBuffer = new StringBuffer();
                            int n5 = n4 - n;
                            if (n3 <= n5) {
                                if ((n4 -= n3) <= (n5 = n4 - n)) {
                                    stringBuffer.append(string4);
                                } else {
                                    int n6 = 0;
                                    int n7 = 0;
                                    while (n6 != n5) {
                                        n7 = string4.indexOf(string2, n7);
                                        n7 += string2.length();
                                        ++n6;
                                    }
                                    stringBuffer.append(string4.substring(n7, string4.length()));
                                }
                            } else {
                                stringBuffer = TelnetView.this.removeFromDocument(n5, string2);
                                stringBuffer.append(string4);
                            }
                            TelnetView.this.document.set(stringBuffer.toString());
                            TelnetView.this.outputMark = TelnetView.this.document.getLength();
                        } else {
                            TelnetView.this.document.replace(TelnetView.this.outputMark, 0, string4);
                            TelnetView telnetView = TelnetView.this;
                            telnetView.outputMark = telnetView.outputMark + string4.length();
                        }
                    } else {
                        Comparable<Character> comparable;
                        String string3 = "";
                        int n = 0;
                        while (n < string4.length()) {
                            comparable = Character.valueOf(string4.charAt(n));
                            int n8 = string4.codePointAt(n);
                            if (Character.isISOControl(n8)) {
                                if (n8 == 8) {
                                    IRegion iRegion = TelnetView.this.document.getLineInformationOfOffset(TelnetView.this.outputMark);
                                    if (iRegion.getLength() > 0) {
                                        if (string3.length() > 0) {
                                            TelnetView.this.document.replace(TelnetView.this.outputMark, 0, string3);
                                            TelnetView.this.outputMark = TelnetView.this.document.getLength();
                                            string3 = "";
                                        }
                                        TelnetView telnetView = TelnetView.this;
                                        telnetView.outputMark = telnetView.outputMark - 1;
                                        TelnetView.this.document.replace(TelnetView.this.outputMark, 1, "");
                                    }
                                } else if (n8 == 13 || n8 == 10) {
                                    string3 = String.valueOf(string3) + comparable;
                                } else if (n8 >= 32) {
                                    string3 = String.valueOf(string3) + comparable;
                                }
                            } else {
                                string3 = String.valueOf(string3) + comparable;
                            }
                            ++n;
                        }
                        if (string3.length() > 0) {
                            n = 1;
                            comparable = TelnetView.this.removeFromDocument(n, string2);
                            ((StringBuffer)comparable).append(string3);
                            TelnetView.this.document.replace(TelnetView.this.outputMark, 0, string3);
                            TelnetView.this.outputMark = TelnetView.this.document.getLength();
                            string3 = "";
                        }
                    }
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.debug((Object)"Exception in Newoutput", (Throwable)exception);
                }
                if (TelnetView.this.autoscroll) {
                    try {
                        if (!TelnetView.this.textWidget.isDisposed()) {
                            int n = TelnetView.this.textWidget.getLineCount();
                            TelnetView.this.textWidget.setTopIndex(n - 1);
                        }
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.debug((Object)"Exception in Newoutput", (Throwable)exception);
                    }
                }
                TelnetView.this.viewer.setSelectedRange(TelnetView.this.outputMark, 0);
            }
        });
    }

    public Document getDocument() {
        OS2200CorePlugin.logger.debug((Object)"");
        return this.document;
    }

    public void setName(String string) {
        OS2200CorePlugin.logger.debug((Object)string);
        this.myKey = string;
        this.setPartName(string);
    }

    public void setFocus() {
        OS2200CorePlugin.logger.debug((Object)"");
    }

    public ISession getSession() {
        OS2200CorePlugin.logger.debug((Object)"");
        return this.session;
    }

    private void createActions() {
        OS2200CorePlugin.logger.debug((Object)"");
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fCopyAction = new TextViewerAction((ITextViewer)this.viewer, 4);
        this.fCopyAction.configureAction(Messages.getString((String)"TelnetView.16"), Messages.getString((String)"TelnetView.16"), Messages.getString((String)"TelnetView.16"));
        this.fCopyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.fCopyAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        this.fPasteAction = new TextViewerAction((ITextViewer)this.viewer, 5);
        this.fPasteAction.configureAction(Messages.getString((String)"TelnetView.19"), Messages.getString((String)"TelnetView.19"), Messages.getString((String)"TelnetView.19"));
        this.fPasteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.fPasteAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
        this.fSelectAllAction = new TextViewerAction((ITextViewer)this.viewer, 7);
        this.fSelectAllAction.configureAction(Messages.getString((String)"TelnetView.22"), Messages.getString((String)"TelnetView.22"), Messages.getString((String)"TelnetView.22"));
        iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        ResourceBundle resourceBundle = ConsoleResourceBundleMessages.getBundle();
        FindReplaceAction findReplaceAction = new FindReplaceAction(resourceBundle, "find_replace_action_", (IWorkbenchPart)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)findReplaceAction, IConsoleHelpContextIds.CONSOLE_FIND_REPLACE_ACTION);
        this.setGlobalAction(iActionBars, ActionFactory.FIND.getId(), (IAction)findReplaceAction);
        iActionBars.updateActionBars();
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        OS2200CorePlugin.logger.debug((Object)"");
        iMenuManager.add((IAction)this.fCopyAction);
        iMenuManager.add((IAction)this.fPasteAction);
        iMenuManager.add((IAction)this.fSelectAllAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    protected void updateSelectionDependentActions() {
        this.fCopyAction.update();
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    public void saveState(IMemento iMemento) {
    }

    protected void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    protected void setGlobalAction(IActionBars iActionBars, String string, IAction iAction) {
        this.fGlobalActions.put(string, iAction);
        iActionBars.setGlobalActionHandler(string, iAction);
    }

    public Object getAdapter(Class clazz) {
        if (IFindReplaceTarget.class.equals((Object)clazz)) {
            return this.viewer.getFindReplaceTarget();
        }
        if (Widget.class.equals((Object)clazz)) {
            return this.viewer.getTextWidget();
        }
        return null;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.viewSite = iViewSite;
    }

    private void writeToFile(String string) {
        long l;
        block17: {
            l = System.currentTimeMillis();
            try {
                try {
                    if (this.writer == null) {
                        String string2 = String.valueOf(HostAccount.PrivateUserPath()) + "logs" + File.separatorChar + "Telnet-" + this.myKey + ".log";
                        File file = new File(string2);
                        File file2 = file.getParentFile();
                        if (!file2.exists() && !file2.mkdirs()) {
                            string2 = String.valueOf(HostAccount.PrivateUserPath()) + "logs" + File.separatorChar + "Telnet-" + this.myKey + ".log";
                        }
                        this.telnetLogFile = new File(string2);
                        OS2200CorePlugin.logger.info((Object)("Telnet log file is at " + this.telnetLogFile.toString()));
                        this.writer = new FileWriter(this.telnetLogFile, this.appendLog);
                        this.appendLog = true;
                    }
                    this.writer.write(string);
                    this.writer.flush();
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                    try {
                        if (this.writer != null) {
                            this.writer.close();
                        }
                    }
                    catch (IOException iOException2) {
                        OS2200CorePlugin.logger.info((Object)iOException2.getMessage(), (Throwable)iOException2);
                    }
                    this.writer = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.info((Object)iOException.getMessage(), (Throwable)iOException);
                }
                this.writer = null;
                throw throwable;
            }
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.info((Object)iOException.getMessage(), (Throwable)iOException);
            }
            this.writer = null;
        }
        long l2 = System.currentTimeMillis();
        if (OS2200CorePlugin.logger.isDebugEnabled()) {
            OS2200CorePlugin.logger.debug((Object)("Took " + (l2 - l) + " milli seconds to write to the " + this.telnetLogFile.toString() + " telnet log file."));
        }
    }

    public File getTelnetLogFile() {
        return this.telnetLogFile;
    }

    private StringBuffer removeFromDocument(int n, String string) {
        int n2 = this.textWidget.getLineCount();
        StringBuffer stringBuffer = new StringBuffer();
        while (n != n2) {
            stringBuffer.append(this.textWidget.getLine(n++)).append(string);
        }
        if (stringBuffer.substring(stringBuffer.length() - string.length(), stringBuffer.length()).equals(string)) {
            stringBuffer.delete(stringBuffer.length() - string.length(), stringBuffer.length());
        }
        return stringBuffer;
    }
}

