/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.client.ui;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.telnet.client.ui.AddTelnetMacroDialog;
import com.unisys.telnet.client.ui.ClientPlugin;
import com.unisys.telnet.client.ui.MacroTableContentProvider;
import com.unisys.telnet.client.ui.MacroTableLabelProvider;
import com.unisys.telnet.client.ui.TelnetMacroMap;
import com.unisys.telnet.client.ui.TelnetView;
import com.unisys.telnet.lib.session.ISession;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TelnetMacroDialog
extends TrayDialog {
    Composite parentComposite;
    private TableViewer tableViewer;
    private Table table;
    private TelnetMacroMap macroMap;
    private Button addBtn;
    private Button updateBtn;
    private Button removeBtn;
    private Button executeBtn;
    private static String telnetViewID = "com.unisys.telnet.client.ui.TelnetView";
    private static final String SPACE = "  ";
    private Properties telnetMacroProperties;
    private ImageDescriptor telnetMacroIcon;
    private Image telnetMacroImage;
    private static final String telnetMacroPath = "/icons/Telnet-Macro.png";
    ISession session = null;
    SelectionListener addSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Add Telnet Macro");
            AddTelnetMacroDialog addTelnetMacroDialog = new AddTelnetMacroDialog(TelnetMacroDialog.this.parentComposite.getShell());
            addTelnetMacroDialog.open();
            TelnetMacroDialog.this.updateMacroTable();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener updateSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)TelnetMacroDialog.this.tableViewer.getSelection();
            if (iStructuredSelection != null && iStructuredSelection.size() > 0) {
                OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Update Telnet Macro");
                TelnetMacroMap.MacroKey macroKey = (TelnetMacroMap.MacroKey)((Object)iStructuredSelection.getFirstElement());
                AddTelnetMacroDialog addTelnetMacroDialog = new AddTelnetMacroDialog(TelnetMacroDialog.this.parentComposite.getShell(), macroKey, TelnetMacroDialog.this.macroMap.getConfiguredMacro().get((Object)macroKey));
                addTelnetMacroDialog.open();
                TelnetMacroDialog.this.updateMacroTable();
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener removeSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Remove Telnet Macro");
            IStructuredSelection iStructuredSelection = (IStructuredSelection)TelnetMacroDialog.this.tableViewer.getSelection();
            if (iStructuredSelection != null && iStructuredSelection.size() > 0) {
                for (TelnetMacroMap.MacroKey macroKey : iStructuredSelection) {
                    TelnetMacroDialog.this.macroMap.removeFromConfiguredMacro(macroKey);
                    TelnetMacroDialog.this.updateMacroTable();
                }
                OS2200CorePlugin.logger.debug((Object)("TelnetMacro : No. of macro removed: " + iStructuredSelection.size()));
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    SelectionListener executeSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)TelnetMacroDialog.this.tableViewer.getSelection();
            if (iStructuredSelection != null && iStructuredSelection.size() > 0) {
                TelnetMacroMap.MacroKey macroKey = (TelnetMacroMap.MacroKey)((Object)iStructuredSelection.getFirstElement());
                String string = TelnetMacroDialog.this.macroMap.getConfiguredMacro().get((Object)macroKey);
                OS2200CorePlugin.logger.debug((Object)("TelnetMacro : Command To be executed : " + string));
                TelnetMacroDialog.this.executeCommand(string);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };

    public TelnetMacroDialog(Shell shell) {
        super(shell);
        this.macroMap = TelnetMacroMap.getInstance();
        this.telnetMacroIcon = ImageDescriptor.createFromURL((URL)ClientPlugin.getDefault().getBundle().getEntry(telnetMacroPath));
        this.telnetMacroImage = this.telnetMacroIcon.createImage();
        this.setShellStyle(67696);
        this.setBlockOnOpen(true);
        this.telnetMacroProperties = OS2200FileInterface.loadTelnetMacroProperties();
        this.loadTelnetMacroToProperties();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        composite.getShell().setImage(this.telnetMacroImage);
        return control;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.parentComposite = composite;
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.telnet.client.context_Telnet_Macro");
        composite.getShell().setText(Messages.getString((String)"TelnetMacroDialog.1"));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 190;
        gridData.widthHint = 400;
        composite3.setLayoutData((Object)gridData);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite3.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(composite3, 68354);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(1, 10, true));
        tableColumn.setText(Messages.getString((String)"TelnetMacroDialog.2"));
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumn2 = tableViewerColumn2.getColumn();
        tableColumnLayout.setColumnData((Widget)tableColumn2, (ColumnLayoutData)new ColumnWeightData(3, 20, true));
        tableColumn2.setText(Messages.getString((String)"TelnetMacroDialog.3"));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MacroTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MacroTableContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TelnetMacroDialog.this.tableViewer.getSelection();
                if (iStructuredSelection != null && iStructuredSelection.size() == 1) {
                    TelnetMacroDialog.this.updateBtn.setEnabled(true);
                    TelnetMacroDialog.this.removeBtn.setEnabled(true);
                    if (TelnetMacroDialog.this.isTelnetViewActive()) {
                        TelnetMacroDialog.this.executeBtn.setEnabled(true);
                    }
                } else if (iStructuredSelection != null && iStructuredSelection.size() > 1) {
                    TelnetMacroDialog.this.updateBtn.setEnabled(false);
                    TelnetMacroDialog.this.removeBtn.setEnabled(true);
                    TelnetMacroDialog.this.executeBtn.setEnabled(false);
                } else {
                    TelnetMacroDialog.this.updateBtn.setEnabled(false);
                    TelnetMacroDialog.this.removeBtn.setEnabled(false);
                    TelnetMacroDialog.this.executeBtn.setEnabled(false);
                }
            }
        });
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 10;
        gridLayout2.marginHeight = 10;
        gridLayout2.verticalSpacing = 20;
        composite4.setLayout((Layout)gridLayout2);
        GridData gridData2 = new GridData(768);
        this.addBtn = new Button(composite4, 0);
        this.addBtn.setText(SPACE + Messages.getString((String)"TelnetMacroDialog.4") + SPACE);
        this.addBtn.setLayoutData((Object)gridData2);
        this.addBtn.addSelectionListener(this.addSelectionListener);
        this.updateBtn = new Button(composite4, 0);
        this.updateBtn.setText(SPACE + Messages.getString((String)"TelnetMacroDialog.5") + SPACE);
        this.updateBtn.setLayoutData((Object)gridData2);
        this.updateBtn.addSelectionListener(this.updateSelectionListener);
        this.updateBtn.setEnabled(false);
        this.removeBtn = new Button(composite4, 0);
        this.removeBtn.setText(SPACE + Messages.getString((String)"TelnetMacroDialog.6") + SPACE);
        this.removeBtn.setLayoutData((Object)gridData2);
        this.removeBtn.addSelectionListener(this.removeSelectionListener);
        this.removeBtn.setEnabled(false);
        this.executeBtn = new Button(composite4, 0);
        this.executeBtn.setText(SPACE + Messages.getString((String)"TelnetMacroDialog.7") + SPACE);
        this.executeBtn.setLayoutData((Object)gridData2);
        this.executeBtn.addSelectionListener(this.executeSelectionListener);
        this.executeBtn.setEnabled(false);
        this.updateMacroTable();
        return composite;
    }

    private void updateMacroTable() {
        this.tableViewer.setInput(TelnetMacroDialog.sortByValues(this.macroMap.getConfiguredMacro()));
        if (this.addBtn != null) {
            if (TelnetMacroMap.getInstance().unusedShortcutKeys().size() != 0) {
                this.addBtn.setEnabled(true);
            } else {
                this.addBtn.setEnabled(false);
            }
        }
    }

    public static <K extends Comparable, V extends Comparable> HashMap<K, V> sortByValues(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> linkedList = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(linkedList, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                return ((Comparable)entry.getValue()).compareTo(entry2.getValue());
            }
        });
        HashMap<Comparable, Comparable> hashMap = new HashMap<Comparable, Comparable>();
        for (Map.Entry entry : linkedList) {
            hashMap.put((Comparable)entry.getKey(), (Comparable)entry.getValue());
        }
        return hashMap;
    }

    private void executeCommand(final String string) {
        final TelnetView telnetView = TelnetMacroDialog.getViewObject();
        if (telnetView != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    telnetView.SendForExecution(string, true);
                }
            });
            OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Command exceuted");
            this.close();
        }
    }

    private static TelnetView getViewObject() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        TelnetView telnetView = (TelnetView)iWorkbenchPage.getActivePart();
        String string = iWorkbenchPage.getActivePartReference().getId();
        IViewReference iViewReference = iWorkbenchPage.findViewReference(string);
        TelnetView telnetView2 = null;
        if (iViewReference != null && (telnetView2 = (TelnetView)iViewReference.getView(true)) == null) {
            try {
                telnetView2 = (TelnetView)iWorkbenchPage.showView(string);
            }
            catch (PartInitException partInitException) {
                OS2200CorePlugin.logger.error((Object)partInitException.getMessage());
            }
        }
        return telnetView;
    }

    private boolean isTelnetViewActive() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
        String string = iWorkbenchPage.getActivePartReference().getId();
        return string.equalsIgnoreCase(telnetViewID);
    }

    protected void okPressed() {
        this.close();
    }

    public boolean close() {
        this.saveToTelnetMacroProperties();
        return super.close();
    }

    private void saveToTelnetMacroProperties() {
        try {
            if (this.telnetMacroProperties == null) {
                OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Creating new telnet properties");
                this.telnetMacroProperties = new Properties();
            }
            this.telnetMacroProperties.clear();
            for (Map.Entry<TelnetMacroMap.MacroKey, String> entry : TelnetMacroMap.getInstance().getConfiguredMacro().entrySet()) {
                this.telnetMacroProperties.put(entry.getKey().name(), entry.getValue());
            }
            OS2200CorePlugin.logger.debug((Object)("TelnetMacro : Count of properties : " + TelnetMacroMap.getInstance().getConfiguredMacro().size()));
            OS2200FileInterface.saveTelnetMacroProperties((Properties)this.telnetMacroProperties);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage());
        }
    }

    private void loadTelnetMacroToProperties() {
        try {
            if (this.telnetMacroProperties != null) {
                OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Loading telnet properties");
                for (Map.Entry<Object, Object> entry : this.telnetMacroProperties.entrySet()) {
                    TelnetMacroMap.getInstance().getConfiguredMacro().put(TelnetMacroMap.MacroKey.valueOf((String)entry.getKey()), (String)entry.getValue());
                }
                OS2200CorePlugin.logger.debug((Object)("TelnetMacro : Count of properties : " + this.telnetMacroProperties.size()));
            } else {
                TelnetMacroMap.getInstance().getConfiguredMacro().clear();
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)exception.getMessage());
        }
    }
}

