/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.client.ui;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.telnet.client.ui.ClientPlugin;
import com.unisys.telnet.client.ui.TelnetMacroMap;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddTelnetMacroDialog
extends Dialog {
    private Composite parentComposite;
    private Combo keySelect;
    private Text commandText;
    private TelnetMacroMap.MacroKey orginalkey;
    private String orginalCommand;
    private boolean addMacro = false;
    private static final String NEW_LINE_CHAR = "\\n";
    private static final String ESCAPE_NEW_LINE_CHAR = "\\\\n";
    private ImageDescriptor telnetMacroIcon;
    private Image telnetMacroImage;
    private static final String telnetMacroPath = "/icons/Telnet-Macro.png";

    protected AddTelnetMacroDialog(Shell shell) {
        super(shell);
        this.setShellStyle(67696);
        this.setBlockOnOpen(true);
        this.telnetMacroIcon = ImageDescriptor.createFromURL((URL)ClientPlugin.getDefault().getBundle().getEntry(telnetMacroPath));
        this.telnetMacroImage = this.telnetMacroIcon.createImage();
        this.addMacro = true;
    }

    protected AddTelnetMacroDialog(Shell shell, TelnetMacroMap.MacroKey macroKey, String string) {
        super(shell);
        this.orginalkey = macroKey;
        this.orginalCommand = string;
        this.setShellStyle(67696);
        this.setBlockOnOpen(true);
        this.addMacro = false;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        composite.getShell().setImage(this.telnetMacroImage);
        if (this.commandText.getText().trim().length() > 0 && !this.keySelect.getText().isEmpty()) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        TelnetMacroMap.MacroKey macroKey2;
        this.parentComposite = composite;
        Composite composite2 = new Composite(composite, 0);
        if (this.addMacro) {
            composite.getShell().setText(Messages.getString((String)"AddTelnetMacroDialog.1"));
        } else {
            composite.getShell().setText(Messages.getString((String)"AddTelnetMacroDialog.2"));
        }
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 20;
        gridLayout.horizontalSpacing = 20;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString((String)"TelnetMacroDialog.2"));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.keySelect = new Combo(composite2, 2056);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 140;
        this.keySelect.setLayoutData((Object)gridData2);
        ArrayList<Object> arrayList = new ArrayList();
        arrayList = this.addMacro ? TelnetMacroMap.getInstance().unusedShortcutKeys() : TelnetMacroMap.getInstance().usedShortcutKeys();
        for (TelnetMacroMap.MacroKey macroKey2 : arrayList) {
            this.keySelect.add(macroKey2.toString());
            this.keySelect.setData(macroKey2.toString(), (Object)macroKey2);
        }
        if (!this.addMacro && this.orginalkey != null && this.keySelect.indexOf(this.orginalkey.toString()) >= 0) {
            this.keySelect.select(this.keySelect.indexOf(this.orginalkey.toString()));
            this.keySelect.setEnabled(false);
        }
        this.keySelect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AddTelnetMacroDialog.this.commandText.getText().trim().length() > 0 && !AddTelnetMacroDialog.this.keySelect.getText().isEmpty()) {
                    AddTelnetMacroDialog.this.getButton(0).setEnabled(true);
                } else {
                    AddTelnetMacroDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        macroKey2 = new Label(composite2, 0);
        macroKey2.setText(Messages.getString((String)"TelnetMacroDialog.3"));
        this.commandText = new Text(composite2, 2048);
        GridData gridData3 = new GridData(768);
        gridData3.widthHint = 300;
        this.commandText.setLayoutData((Object)gridData3);
        this.commandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (AddTelnetMacroDialog.this.getButton(0) != null) {
                    if (AddTelnetMacroDialog.this.commandText.getText().trim().length() > 0 && !AddTelnetMacroDialog.this.keySelect.getText().isEmpty()) {
                        AddTelnetMacroDialog.this.getButton(0).setEnabled(true);
                    } else {
                        AddTelnetMacroDialog.this.getButton(0).setEnabled(false);
                    }
                }
            }
        });
        if (this.orginalCommand != null) {
            this.commandText.setText(this.orginalCommand);
        }
        Label label2 = new Label(composite2, 0);
        label2.setText(Messages.getString((String)"AddTelnetMacroDialog.3"));
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData4);
        return composite;
    }

    protected void okPressed() {
        try {
            String string = this.commandText.getText().trim();
            String string2 = "";
            String string3 = null;
            string = string.trim();
            if (string.contains(NEW_LINE_CHAR)) {
                String[] stringArray = string.split(ESCAPE_NEW_LINE_CHAR);
                if (stringArray.length > 2) {
                    string3 = Messages.getString((String)"AddTelnetMacroDialog.4");
                }
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string4 = stringArray2[n2];
                    if (!(string4 = string4.trim()).isEmpty()) {
                        string2 = String.valueOf(string4) + NEW_LINE_CHAR;
                        break;
                    }
                    ++n2;
                }
                if (string2.isEmpty()) {
                    OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Command is empty");
                    MessageDialog.openInformation((Shell)this.parentComposite.getShell(), (String)Messages.getString((String)"TelnetMacroDialog.1"), (String)Messages.getString((String)"AddTelnetMacroDialog.5"));
                    this.getButton(0).setEnabled(false);
                    return;
                }
                string = string2;
                if (string3 != null) {
                    OS2200CorePlugin.logger.debug((Object)"TelnetMacro : Contains multiple command");
                    if (!MessageDialog.openConfirm((Shell)this.parentComposite.getShell(), (String)Messages.getString((String)"TelnetMacroDialog.1"), (String)string3)) {
                        return;
                    }
                }
            }
            TelnetMacroMap.getInstance().addToConfiguredMacro((TelnetMacroMap.MacroKey)((Object)this.keySelect.getData(this.keySelect.getText())), string);
        }
        finally {
            if (this.telnetMacroImage != null) {
                this.telnetMacroImage.dispose();
                this.telnetMacroImage = null;
            }
            this.close();
        }
    }
}

