/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.accounts.preferencepages;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboFieldEditor
extends FieldEditor {
    private Combo fCombo;
    private String fValue;
    private String[][] fEntryNamesAndValues;

    public ComboFieldEditor(String string, String string2, String[][] stringArray, Composite composite) {
        this.init(string, string2);
        Assert.isTrue((boolean)this.checkArray(stringArray));
        this.fEntryNamesAndValues = stringArray;
        this.createControl(composite);
    }

    private boolean checkArray(String[][] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2 == null || stringArray2.length != 2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void adjustForNumColumns(int n) {
        Label label = this.getLabelControl();
        if (label != null) {
            ((GridData)label.getLayoutData()).horizontalSpan = n;
        }
        ((GridData)this.fCombo.getLayoutData()).horizontalSpan = n;
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        Label label = this.getLabelControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        label = this.getComboBoxControl(composite);
        gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(Composite composite) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(composite, 8);
            int n = 0;
            while (n < this.fEntryNamesAndValues.length) {
                this.fCombo.add(this.fEntryNamesAndValues[n][0], n);
                ++n;
            }
            this.fCombo.setFont(composite.getFont());
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = ComboFieldEditor.this.fValue;
                    String string2 = ComboFieldEditor.this.fCombo.getText();
                    ComboFieldEditor.this.fValue = ComboFieldEditor.this.getValueForName(string2);
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fireValueChanged("field_editor_value", string, ComboFieldEditor.this.fValue);
                }
            });
        }
        return this.fCombo;
    }

    protected String getValueForName(String string) {
        int n = 0;
        while (n < this.fEntryNamesAndValues.length) {
            String[] stringArray = this.fEntryNamesAndValues[n];
            if (string.equals(stringArray[0])) {
                return stringArray[1];
            }
            ++n;
        }
        return this.fEntryNamesAndValues[0][0];
    }

    protected void updateComboForValue(String string) {
        this.fValue = string;
        int n = 0;
        while (n < this.fEntryNamesAndValues.length) {
            if (string.equals(this.fEntryNamesAndValues[n][1])) {
                this.fCombo.setText(this.fEntryNamesAndValues[n][0]);
                return;
            }
            ++n;
        }
        if (this.fEntryNamesAndValues.length > 0) {
            this.fValue = this.fEntryNamesAndValues[0][1];
            this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
        }
    }
}

