/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.accounts.preferencepages;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.telnet.accounts.preferences.HostAccountPropertyPage;
import com.unisys.telnet.accounts.preferences.TelnetLoginPage;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.listeners.TelnetEventSource;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class ClientConnectionUI {
    public Combo hostsCombo;
    public Combo connectionsCombo;
    protected Shell shell;
    static final String[] Blank = new String[]{""};
    private final int SHELL_MAX_WIDTH = 728;
    private final int SHELL_MAX_HEIGHT = 537;
    HostAccountPropertyPage hostAccountProp;
    TelnetLoginPage telnetLogin;
    private String telnetPassword;
    private String cifsPassword;
    private boolean unixButton;
    private String portnum;
    private String prompt;
    private String charCheckmod;
    private boolean checkSecureSSL;
    private Button ok;
    private String cifHostID;
    private ModifyListener passwordModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            ClientConnectionUI.this.setOKButton();
        }
    };
    private ModifyListener retypePasswordModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            ClientConnectionUI.this.setOKButton();
        }
    };
    private ModifyListener portnumModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            ClientConnectionUI.this.setOKButton();
        }
    };
    private ModifyListener promptModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            ClientConnectionUI.this.setOKButton();
        }
    };
    private Listener hostSelectionListner = new Listener(){

        public void handleEvent(Event event) {
            if (ClientConnectionUI.this.hostAccountProp.hostaccountsTab.getSelectionIndex() == ClientConnectionUI.this.hostAccountProp.telnetTabIndex) {
                if (ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getHostNameTextBox().getText().length() != 0) {
                    ClientConnectionUI.this.hostAccountProp.getInitState();
                    ClientConnectionUI.this.telnetLogin.setMyLoginAccount(null);
                    ClientConnectionUI.this.telnetLogin.getInitState();
                } else {
                    LoginAccount[] loginAccountArray = LoginAccount.getLoginAccounts();
                    int n = 0;
                    while (n < loginAccountArray.length) {
                        if (loginAccountArray[n].getHostAccount() != null && loginAccountArray[n].getHostAccount().getHostId().equals(ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getHostNameTextBox().getText())) {
                            ClientConnectionUI.this.hostAccountProp.updateTelnetTab(loginAccountArray[n].getHostAccount(), false);
                        }
                        ++n;
                    }
                }
            } else if (ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().getText().length() != 0) {
                ClientConnectionUI.this.hostAccountProp.getInitState();
                ClientConnectionUI.this.telnetLogin.setMyLoginAccount(null);
                ClientConnectionUI.this.telnetLogin.getInitState();
            } else {
                LoginAccount[] loginAccountArray = LoginAccount.getLoginAccounts();
                int n = 0;
                while (n < loginAccountArray.length) {
                    if (loginAccountArray[n].getHostAccount().getCifsHostId().equals(ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().getText())) {
                        ClientConnectionUI.this.hostAccountProp.updateCifsTab(loginAccountArray[n].getHostAccount(), false);
                    }
                    ++n;
                }
            }
        }
    };

    public ClientConnectionUI(int n) {
    }

    public abstract void clickDone();

    private void createTelnetLogin(HostAccount hostAccount, LoginAccount loginAccount) {
        this.telnetLogin = new TelnetLoginPage();
        this.hostAccountProp = new HostAccountPropertyPage(this.telnetLogin);
        this.createConnectionDialog();
        this.hostAccountProp.createHostAccount(hostAccount, null, null, (Composite)this.shell);
        this.hostAccountProp.getTelnetPropertyTab().getHostNameTextBox().addListener(13, this.hostSelectionListner);
        this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().addListener(13, this.hostSelectionListner);
        this.telnetLogin.setHostAccountPropertyPage(this.hostAccountProp);
        this.hostAccountProp.getTelnetPropertyTab().getHostNameTextBox().setFocus();
        this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().setFocus();
    }

    public void addConnection() {
        this.createTelnetLogin(null, null);
        this.telnetLogin.createLoginPage(null, null, null, null, (Composite)this.shell);
        Composite composite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        this.ok = new Button(composite, 8);
        this.ok.setText(Messages.getString((String)"LAccount.28"));
        this.ok.setLayoutData((Object)gridData2);
        this.ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().getText();
                String string2 = ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().getText();
                String string3 = ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().getText();
                String string4 = ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getRetypeTextBox().getText();
                if (!string.equals(string2)) {
                    MessageDialog.openError((Shell)ClientConnectionUI.this.shell, (String)Messages.getString((String)"HAccount.1"), (String)Messages.getString((String)"HAccount.13a"));
                    ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().setText("");
                    ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().setText("");
                    return;
                }
                if (!string3.equals(string4)) {
                    MessageDialog.openError((Shell)ClientConnectionUI.this.shell, (String)Messages.getString((String)"HAccount.1"), (String)Messages.getString((String)"HAccount.13b"));
                    ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().setText("");
                    ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getRetypeTextBox().setText("");
                    return;
                }
                HostAccount hostAccount = ClientConnectionUI.this.storeHostAccountData();
                if (hostAccount != null) {
                    ClientConnectionUI.this.hostAccountProp.setMyHostAccount(hostAccount);
                    ClientConnectionUI.this.telnetLogin.setMyHostAccount(hostAccount);
                    ClientConnectionUI.this.telnetLogin.setOS2200Flag();
                }
                boolean bl = false;
                ClientConnectionUI.this.telnetLogin.setHostAccountPropertyPage(ClientConnectionUI.this.hostAccountProp);
                bl = ClientConnectionUI.this.telnetLogin.clickOk();
                if (bl) {
                    try {
                        TelnetEventSource.getEventSource().handleEvent(hostAccount);
                    }
                    catch (Exception exception) {}
                } else {
                    ClientConnectionUI.this.telnetLogin.loginAccountError();
                    return;
                }
                ClientConnectionUI.this.clickDone();
            }
        });
        GridData gridData3 = new GridData();
        Button button = new Button(composite, 8);
        button.setText(Messages.getString((String)"LAccount.29"));
        button.setLayoutData((Object)gridData3);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClientConnectionUI.this.shell.dispose();
            }
        });
        this.hostAccountProp.getTelnetPropertyTab().getHostNameTextBox().setFocus();
        this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().setFocus();
        this.shell.pack();
        this.shell.open();
    }

    HostAccount storeHostAccountData() {
        HostAccount hostAccount = new HostAccount();
        hostAccount.setHostId(this.hostAccountProp.replaceAddr(this.hostAccountProp.getTelnetPropertyTab().getHostNameTextBox().getText()));
        hostAccount.setUserId(this.hostAccountProp.getTelnetPropertyTab().getUserIdTextBox().getText());
        hostAccount.setPassword(this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().getText());
        hostAccount.setSavePw(this.hostAccountProp.getTelnetPropertyTab().getSaveTextBox().getSelection());
        hostAccount.setOS2200(this.hostAccountProp.getTelnetPropertyTab().getOs2200Button().getSelection());
        hostAccount.setConnectionName(this.telnetLogin.getLoginname().getText());
        hostAccount.setCifsHostId(this.hostAccountProp.replaceAddr(this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().getText()));
        hostAccount.setCifsUserId(this.hostAccountProp.getCifsPropertyTab().getUserIdTextBox().getText());
        hostAccount.setCifsPassword(this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().getText());
        hostAccount.setCifsSavePw(this.hostAccountProp.getCifsPropertyTab().getSaveTextBox().getSelection());
        return hostAccount;
    }

    private void addListeners() {
        this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().addModifyListener(this.passwordModifyListener);
        this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().addModifyListener(this.retypePasswordModifyListener);
        this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().addModifyListener(this.passwordModifyListener);
        this.hostAccountProp.getCifsPropertyTab().getRetypeTextBox().addModifyListener(this.retypePasswordModifyListener);
        this.telnetLogin.getPortnum().addModifyListener(this.portnumModifyListener);
        this.telnetLogin.getPrompt().addModifyListener(this.promptModifyListener);
    }

    public void editConnection(HostAccount hostAccount, LoginAccount loginAccount) {
        this.createConnectionDialog();
        this.createTelnetLogin(hostAccount, loginAccount);
        this.telnetLogin.createLoginPage(hostAccount, loginAccount, null, null, (Composite)this.shell);
        this.telnetLogin.getLoginname().setText(hostAccount.getConnectionName());
        this.telnetLogin.getLoginname().setEnabled(false);
        this.shell.update();
        Composite composite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        this.ok = new Button(composite, 8);
        this.ok.setText(Messages.getString((String)"LAccount.28"));
        this.ok.setLayoutData((Object)gridData2);
        this.ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().getText();
                String string2 = ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().getText();
                String string3 = ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().getText();
                String string4 = ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getRetypeTextBox().getText();
                if (!string.equals(string2)) {
                    MessageDialog.openError((Shell)ClientConnectionUI.this.shell, (String)Messages.getString((String)"HAccount.1"), (String)Messages.getString((String)"HAccount.13a"));
                    ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().setText("");
                    ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().setText("");
                    return;
                }
                if (!string3.equals(string4)) {
                    MessageDialog.openError((Shell)ClientConnectionUI.this.shell, (String)Messages.getString((String)"HAccount.1"), (String)Messages.getString((String)"HAccount.13b"));
                    ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().setText("");
                    ClientConnectionUI.this.hostAccountProp.getCifsPropertyTab().getRetypeTextBox().setText("");
                    return;
                }
                if (!string.equals(string3)) {
                    ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().setText(string3);
                    ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().setText(string3);
                }
                if (ClientConnectionUI.this.hostActAttribChanged()) {
                    if (!ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().getText().equals(ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().getText())) {
                        MessageDialog.openError((Shell)ClientConnectionUI.this.shell, (String)Messages.getString((String)"HAccount.1"), (String)Messages.getString((String)"HAccount.13a"));
                        ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().setText("");
                        ClientConnectionUI.this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().setText("");
                        return;
                    }
                    ClientConnectionUI.this.saveHostAccountAttrib();
                }
                if (ClientConnectionUI.this.loginAcctAttribChanged() && !ClientConnectionUI.this.isPortNumValid()) {
                    MessageDialog.openError((Shell)ClientConnectionUI.this.shell, (String)Messages.getString((String)"HAccount.1"), (String)Messages.getString((String)"ClientConnectionUI_0"));
                    ClientConnectionUI.this.telnetLogin.getPortnum().setSelection(0, ClientConnectionUI.this.telnetLogin.getPortnum().getText().length());
                    ClientConnectionUI.this.telnetLogin.getPortnum().setFocus();
                    return;
                }
                if (!ClientConnectionUI.this.isPortNumValid()) {
                    MessageDialog.openError((Shell)ClientConnectionUI.this.shell, (String)Messages.getString((String)"HAccount.1"), (String)Messages.getString((String)"ClientConnectionUI_0"));
                    ClientConnectionUI.this.telnetLogin.getPortnum().setSelection(0, ClientConnectionUI.this.telnetLogin.getPortnum().getText().length());
                    ClientConnectionUI.this.telnetLogin.getPortnum().setFocus();
                    return;
                }
                boolean bl = false;
                ClientConnectionUI.this.telnetLogin.setHostAccountPropertyPage(ClientConnectionUI.this.hostAccountProp);
                bl = ClientConnectionUI.this.telnetLogin.clickOk();
                if (!bl) {
                    ClientConnectionUI.this.telnetLogin.loginAccountError();
                    return;
                }
                if (bl) {
                    ClientConnectionUI.this.clickDone();
                }
            }
        });
        GridData gridData3 = new GridData();
        Button button = new Button(composite, 8);
        button.setText(Messages.getString((String)"LAccount.29"));
        button.setLayoutData((Object)gridData3);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ClientConnectionUI.this.shell.dispose();
            }
        });
        this.saveScreenAttributes();
        this.addListeners();
        this.shell.pack();
        this.shell.setSize(537, 728);
        this.shell.open();
    }

    public boolean deleteConnection(HostAccount hostAccount) {
        boolean bl = MessageDialog.openConfirm((Shell)this.shell, (String)Messages.getString((String)"HAccount.1"), (String)Messages.getString((String)"HAccount.4", (String)hostAccount.getConnectionName()));
        if (!bl) {
            return false;
        }
        List list = OS2200ProjectUpdate.getProjListFromAssociatedHost((HostAccount)hostAccount);
        if (list != null && list.size() != 0) {
            String string = "";
            for (String string2 : list) {
                string = String.valueOf(string) + string2 + "\n";
            }
            string = String.valueOf(Messages.getString((String)"HManager.host", (String)hostAccount.getCifsHostId())) + "\n" + "\n" + string + "\n" + Messages.getString((String)"HManager.3");
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"DeleteElement.host"), (String)string);
            return false;
        }
        HostAccount.Remove((String)hostAccount.getHostId(), (String)hostAccount.getUserId(), (String)hostAccount.getConnectionName());
        OS2200FileInterface.fCifsConnMap.remove(hostAccount.getConnectionName());
        this.clickDone();
        return true;
    }

    private void createConnectionDialog() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65616);
        this.shell.setMinimumSize(400, 300);
        this.shell.setText(Messages.getString((String)"New0S2200Connection.2"));
        Monitor monitor = display.getPrimaryMonitor();
        Rectangle rectangle = monitor.getBounds();
        Rectangle rectangle2 = this.shell.getBounds();
        int n = rectangle.x + (rectangle.width - rectangle2.width) / 4;
        int n2 = rectangle.y + (rectangle.height - rectangle2.height) / 4;
        this.shell.setLocation(n, n2);
    }

    private void setOKButton() {
        if (this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().getText().length() == 0 || this.hostAccountProp.getTelnetPropertyTab().getRetypeTextBox().getText().length() == 0 || this.telnetLogin.getPortnum().getText().length() == 0 || this.telnetLogin.getPrompt().getText().length() == 0) {
            this.ok.setEnabled(false);
        } else {
            this.ok.setEnabled(true);
        }
    }

    private void saveScreenAttributes() {
        this.telnetPassword = this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().getText();
        this.cifsPassword = this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().getText();
        this.unixButton = this.hostAccountProp.getTelnetPropertyTab().getUnixButton().getSelection();
        this.cifHostID = this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().getText();
        this.portnum = this.telnetLogin.getPortnum().getText();
        this.prompt = this.telnetLogin.getPrompt().getText();
        this.charCheckmod = this.telnetLogin.getCharCheckmod().getText();
        this.checkSecureSSL = this.telnetLogin.getCheckSecureSSL().getSelection();
    }

    private boolean hostActAttribChanged() {
        return !this.telnetPassword.equalsIgnoreCase(this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().getText()) || !this.cifsPassword.equalsIgnoreCase(this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().getText()) || !this.cifHostID.equalsIgnoreCase(this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().getText()) || this.unixButton != this.hostAccountProp.getTelnetPropertyTab().getUnixButton().getSelection();
    }

    private boolean loginAcctAttribChanged() {
        return !this.portnum.equalsIgnoreCase(this.telnetLogin.getPortnum().getText()) || !this.prompt.equalsIgnoreCase(this.telnetLogin.getPrompt().getText()) || !this.charCheckmod.equalsIgnoreCase(this.telnetLogin.getCharCheckmod().getText()) || this.checkSecureSSL != this.telnetLogin.getCheckSecureSSL().getSelection();
    }

    private boolean compareHostAccountAttributes(HostAccount hostAccount) {
        String string = this.hostAccountProp.getCifsPropertyTab().getPasswordTextBox().getText();
        String string2 = this.hostAccountProp.getTelnetPropertyTab().getPasswordTextBox().getText();
        String string3 = this.hostAccountProp.getCifsPropertyTab().getHostNameTextBox().getText();
        boolean bl = this.hostAccountProp.getTelnetPropertyTab().getOs2200Button().getSelection();
        return hostAccount.getCifsPassword().equals(string) && hostAccount.getPassword().equals(string2) && hostAccount.getOS2200() == bl && hostAccount.getCifsHostId().equals(string3);
    }

    private void saveHostAccountAttrib() {
        String string = this.telnetLogin.getLoginname().getText();
        HostAccount hostAccount = HostAccount.getHostAccount((String)string);
        HostAccount hostAccount2 = this.storeHostAccountData();
        if (!this.compareHostAccountAttributes(hostAccount)) {
            HostAccount.update((HostAccount)hostAccount, (HostAccount)hostAccount2);
            TelnetEventSource.getEventSource().handleEvent(hostAccount2);
        }
    }

    private boolean isPortNumValid() {
        try {
            Integer.parseInt(this.telnetLogin.getPortnum().getText());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

