/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.model;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.model.OS2200DebugTarget;
import com.unisys.tde.debug.core.model.OS2200Variable;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IWatchpoint;

public class OS2200Watchpoint
extends Breakpoint
implements IWatchpoint {
    private boolean access;
    private boolean modification;
    public static final String VariableName = "VariableName";
    private String varName;
    private OS2200Variable variable;
    public static final String WatchPoint = "com.unisys.tde.debug.core.os2200WatchpointMarker";
    public static final String VarNameKey = "com.unisys.tde.debug.core.variableName";
    public static final String TrapNumKey = "com.unisys.tde.debug.core.trapNumber";
    public static final String OmElt = "com.unisys.tde.debug.core.omElt";
    public static final String OmPart = "com.unisys.tde.debug.core.omPart";
    public static final String BlockNum = "com.unisys.tde.debug.core.blockNum";
    private OS2200DebugTarget dbTarget;

    public OS2200Watchpoint(OS2200Variable oS2200Variable, final IResource iResource, final String string, final int n, final String string2, final String string3, final String string4, final Map map) throws DebugException {
        this.variable = oS2200Variable;
        this.dbTarget = (OS2200DebugTarget)oS2200Variable.getDebugTarget();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    OS2200Watchpoint.this.setMarker(iResource.createMarker(OS2200Watchpoint.WatchPoint));
                    map.put(OS2200Watchpoint.VarNameKey, string);
                    map.put(OS2200Watchpoint.TrapNumKey, Integer.toString(n));
                    map.put("org.eclipse.debug.core.id", OS2200Watchpoint.this.getModelIdentifier());
                    map.put(OS2200Watchpoint.OmElt, string2);
                    map.put(OS2200Watchpoint.OmPart, string3);
                    map.put(OS2200Watchpoint.BlockNum, string4);
                    map.put("org.eclipse.debug.core.persisted", new Boolean(true));
                    map.put("org.eclipse.debug.core.enabled", new Boolean(true));
                    OS2200Watchpoint.this.setEnabled(true);
                    OS2200Watchpoint.this.setPersisted(true);
                    OS2200Watchpoint.this.varName = string;
                    OS2200Watchpoint.this.setModification(true);
                    OS2200Watchpoint.this.setAccess(true);
                    try {
                        OS2200Watchpoint.this.ensureMarker().setAttributes(map);
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)"UnisysInternalError", (Throwable)exception);
                        OS2200CorePlugin.logger.error((Object)"Error creating Plus Breakpoint", (Throwable)exception);
                    }
                    OS2200Watchpoint.this.addToBreakpointManager();
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)"UnisysInternalError", (Throwable)coreException);
                    OS2200CorePlugin.logger.error((Object)"Error creating Plus Breakpoint", (Throwable)coreException);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)"UnisysInternalError", (Throwable)exception);
                    OS2200CorePlugin.logger.error((Object)"Error creating Plus Breakpoint", (Throwable)exception);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"UnisysInternalError", (Throwable)coreException);
            OS2200CorePlugin.logger.error((Object)"Error creating Plus Breakpoint", (Throwable)coreException);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"UnisysInternalError", (Throwable)exception);
            OS2200CorePlugin.logger.error((Object)"Error creating Plus Breakpoint", (Throwable)exception);
        }
    }

    public boolean isAccess() throws CoreException {
        return this.access;
    }

    public boolean isModification() throws CoreException {
        return this.modification;
    }

    public void setAccess(boolean bl) throws CoreException {
        this.access = bl;
    }

    public void setModification(boolean bl) throws CoreException {
        this.modification = bl;
    }

    public boolean supportsAccess() {
        return true;
    }

    public boolean supportsModification() {
        return true;
    }

    public String getModelIdentifier() {
        return "com.unisys.tde.debug.os2200";
    }

    public void setVariable(OS2200Variable oS2200Variable) {
        this.variable = oS2200Variable;
    }

    protected void addToBreakpointManager() throws CoreException {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null && debugPlugin.getBreakpointManager() != null) {
            debugPlugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        }
        this.dbTarget.getBreakpointListener().addToArray((IBreakpoint)this);
    }

    protected OS2200Variable getVariable() {
        return this.variable;
    }

    public void setVariableName(String string) {
        this.varName = string;
        try {
            this.setAttribute(VarNameKey, this.varName);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)coreException);
            OS2200CorePlugin.logger.info((Object)"Error setting variable breakpoint", (Throwable)coreException);
        }
    }

    public String getVariableName() {
        return this.varName;
    }
}

