/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.model;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.StopPoint;
import com.unisys.tde.debug.core.comm.VariableInfo;
import com.unisys.tde.debug.core.comm.WriterTo2200;
import com.unisys.tde.debug.core.model.OS2200DebugElement;
import com.unisys.tde.debug.core.model.OS2200DebugTarget;
import com.unisys.tde.debug.core.model.OS2200StackFrame;
import com.unisys.tde.debug.core.model.OS2200Value;
import com.unisys.tde.debug.core.model.OS2200Watchpoint;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OS2200Variable
extends OS2200DebugElement
implements IVariable {
    protected String fName;
    protected OS2200StackFrame fFrame;
    protected VariableInfo varInf;
    protected OS2200Value valueType;
    protected boolean valueChanged = false;
    protected boolean watchpointSet = false;
    protected OS2200DebugTarget dbTarget;
    protected int trapId;
    protected OS2200Variable parentVariable;

    public OS2200Variable(OS2200StackFrame oS2200StackFrame) {
        super((OS2200DebugTarget)oS2200StackFrame.getDebugTarget());
    }

    public OS2200Variable(OS2200StackFrame oS2200StackFrame, VariableInfo variableInfo) {
        super((OS2200DebugTarget)oS2200StackFrame.getDebugTarget());
        OS2200CorePlugin.logger.debug((Object)("new variable" + variableInfo.getVariableName()));
        try {
            this.varInf = variableInfo;
            this.fFrame = oS2200StackFrame;
            this.parentVariable = null;
            this.fName = this.varInf.getVariableName();
            if (this.fName == null || this.fName.trim().equals("")) {
                System.out.println("blank name");
            }
            this.valueType = new OS2200Value(oS2200StackFrame, this.varInf, this);
            this.dbTarget = (OS2200DebugTarget)oS2200StackFrame.getDebugTarget();
            this.checkIfBrkpt();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"internal Error", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"error initializing Variable", (Throwable)exception);
        }
    }

    public OS2200Variable(OS2200StackFrame oS2200StackFrame, String string, String string2, VariableInfo variableInfo) {
        super((OS2200DebugTarget)oS2200StackFrame.getDebugTarget());
        OS2200CorePlugin.logger.debug((Object)("new variable for Array member" + variableInfo.getVariableName()));
        try {
            this.varInf = variableInfo;
            this.fFrame = oS2200StackFrame;
            this.fName = string;
            this.parentVariable = null;
            this.valueType = new OS2200Value(oS2200StackFrame, string2, this.varInf, this);
            this.dbTarget = (OS2200DebugTarget)oS2200StackFrame.getDebugTarget();
            this.checkIfBrkpt();
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"internal Error", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"error initializing Variable", (Throwable)exception);
        }
    }

    public IValue getValue() throws DebugException {
        return this.valueType;
    }

    public String getName() throws DebugException {
        if (this.fName != null) {
            byte[] byArray = this.fName.getBytes();
            String string = "";
            try {
                string = new String(byArray, "LETSJ");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string;
        }
        return null;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.varInf.getVariableType();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String string) throws DebugException {
        String string2 = string;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        if (iDebugTarget instanceof OS2200DebugTarget) {
            OS2200DebugTarget oS2200DebugTarget = (OS2200DebugTarget)iDebugTarget;
            WriterTo2200 writerTo2200 = oS2200DebugTarget.getWriter();
            StopPoint stopPoint = this.fFrame.getStopPoint();
            writerTo2200.removeCycle(stopPoint.getOmElt());
            String string3 = this.varInf.getVariableType().toLowerCase();
            if (string3.indexOf("string") >= 0) {
                string2 = "'" + string2 + "'";
            }
            int n = stopPoint.getBlockNumber();
            try {
                writerTo2200.changeVariable(this.varInf.getSegmentedName(), string2, stopPoint.getOmElt(), stopPoint.getOmPart(), n);
                this.valueType.setStringValue(string2);
                this.fireChangeEvent();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.debug((Object)"IOError setting variable value", (Throwable)iOException);
                oS2200DebugTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200Variable_0")) + iOException.getLocalizedMessage());
                oS2200DebugTarget.precipitousTerminate();
            }
        }
    }

    protected void checkIfBrkpt() {
        IBreakpointManager iBreakpointManager = this.dbTarget.getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints();
        String string = this.varInf.getSegmentedName();
        IBreakpoint[] iBreakpointArray2 = iBreakpointArray;
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint iBreakpoint = iBreakpointArray2[n2];
            try {
                OS2200Watchpoint oS2200Watchpoint;
                String string2;
                if (iBreakpoint.isEnabled() && iBreakpoint instanceof OS2200Watchpoint && (string2 = (oS2200Watchpoint = (OS2200Watchpoint)iBreakpoint).getVariableName()).equals(string)) {
                    oS2200Watchpoint.setVariable(this);
                    this.setWatchpointToggle(true);
                    break;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
    }

    public String getFullName() {
        String string = this.fName;
        if (this.parentVariable != null) {
            string = this.fName != null && this.fName.length() != 0 && this.fName.indexOf(91) < 0 ? String.valueOf(this.parentVariable.getFullName()) + "." + this.fName : this.parentVariable.getFullName();
        }
        return string;
    }

    public String getFullNameJ() {
        String string = this.JForm(this.fName);
        if (this.parentVariable != null) {
            string = this.fName != null && this.fName.length() != 0 && this.fName.indexOf(91) < 0 ? String.valueOf(this.parentVariable.getFullNameJ()) + "." + string : this.parentVariable.getFullNameJ();
        }
        return string;
    }

    public String JForm(String string) {
        if (this.fName == null || this.fName.length() == 0 || this.fName.indexOf(91) >= 0) {
            return null;
        }
        byte[] byArray = this.fName.getBytes();
        byte cfr_ignored_0 = byArray[0];
        String string2 = Integer.toHexString(byArray[0]);
        string2 = string2.substring(string2.length() - 2);
        if (string2.equals("93")) {
            return this.makeCXVarForm(string);
        }
        return string;
    }

    public boolean hasJapanese() {
        if (this.fName == null || this.fName.length() == 0 || this.fName.indexOf(91) >= 0) {
            return false;
        }
        byte[] byArray = this.fName.getBytes();
        byte cfr_ignored_0 = byArray[0];
        String string = Integer.toHexString(byArray[0]);
        string = string.substring(string.length() - 2);
        if (string.equals("93")) {
            return true;
        }
        if (this.parentVariable != null) {
            return this.parentVariable.hasJapanese();
        }
        return false;
    }

    String makeCXVarForm(String string) {
        String string2 = "";
        byte[] byArray = string.getBytes();
        int n = 2;
        while (n < byArray.length - 2) {
            String string3 = Integer.toHexString(byArray[n]);
            string2 = String.valueOf(string2) + string3.substring(string3.length() - 2);
            ++n;
        }
        string2 = "CX(" + string2 + ")";
        return string2;
    }

    public boolean toggleWatchPoint() throws DebugException {
        if (this.watchpointSet) {
            this.unsetWatchPoint();
        } else {
            this.setWatchPoint();
        }
        this.fireChangeEvent();
        return this.watchpointSet;
    }

    public void setWatchPoint() throws DebugException {
        this.trapId = this.dbTarget.getNextTrapId();
        this.dbTarget.getWriter();
        int n = this.fFrame.getStopPoint().getBlockNumber();
        String string = this.fFrame.getStopPoint().getOmElt();
        String string2 = this.fFrame.getStopPoint().getOmPart();
        String string3 = this.varInf.getSegmentedName();
        HashMap hashMap = new HashMap(10);
        new OS2200Watchpoint(this, (IResource)this.dbTarget.getProject(), string3, this.trapId, string, string2, Integer.toString(n), hashMap);
        this.watchpointSet = true;
    }

    public Image getImage() {
        if (this.isLocal()) {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.debug.ui", (String)"icons/localdot.gif");
            Image image = imageDescriptor.createImage();
            return image;
        }
        if (this.watchpointSet) {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.debug.ui", (String)"icons/globaldotcheck.gif");
            Image image = imageDescriptor.createImage();
            return image;
        }
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.debug.ui", (String)"icons/globaldot.gif");
        Image image = imageDescriptor.createImage();
        return image;
    }

    public void unsetWatchPoint() {
        this.dbTarget.getWriter();
        IBreakpointManager iBreakpointManager = this.dbTarget.getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints();
        String string = this.varInf.getSegmentedName();
        int n = 0;
        while (n < iBreakpointArray.length) {
            OS2200Watchpoint oS2200Watchpoint;
            String string2;
            if (iBreakpointArray[n] instanceof OS2200Watchpoint && (string2 = (oS2200Watchpoint = (OS2200Watchpoint)iBreakpointArray[n]).getVariableName()).equals(string)) {
                try {
                    iBreakpointManager.removeBreakpoint((IBreakpoint)oS2200Watchpoint, true);
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)coreException);
                    OS2200CorePlugin.logger.info((Object)"Error removing variable breakpoint", (Throwable)coreException);
                }
            }
            ++n;
        }
        this.watchpointSet = false;
    }

    public void setValue(IValue iValue) throws DebugException {
        if (!iValue.hasVariables()) {
            String string = iValue.getValueString();
            IDebugTarget iDebugTarget = this.getDebugTarget();
            if (iDebugTarget instanceof OS2200DebugTarget) {
                OS2200DebugTarget oS2200DebugTarget = (OS2200DebugTarget)iDebugTarget;
                WriterTo2200 writerTo2200 = oS2200DebugTarget.getWriter();
                StopPoint stopPoint = this.fFrame.getStopPoint();
                writerTo2200.removeCycle(stopPoint.getOmElt());
                int n = stopPoint.getBlockNumber();
                String string2 = this.varInf.getVariableType().toLowerCase();
                if (string2.indexOf("string") >= 0) {
                    string = "'" + string + "'";
                }
                try {
                    writerTo2200.changeVariable(this.fName, string, stopPoint.getOmElt(), stopPoint.getOmPart(), n);
                    this.valueType.setStringValue(string);
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.debug((Object)"IOError setting variable value", (Throwable)iOException);
                    oS2200DebugTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200Variable_1")) + iOException.getLocalizedMessage());
                    oS2200DebugTarget.precipitousTerminate();
                }
            }
        }
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String string) throws DebugException {
        String string2 = this.varInf.getVariableType();
        if ((string2 = string2.toLowerCase()).indexOf("integer") >= 0) {
            try {
                Integer.decode(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public boolean verifyValue(IValue iValue) throws DebugException {
        String string = iValue.getValueString();
        return this.verifyValue(string);
    }

    protected OS2200StackFrame getStackFrame() {
        return this.fFrame;
    }

    public boolean isLocal() {
        return this.varInf.isLocal();
    }

    public void setWatchpointToggle(boolean bl) {
        this.watchpointSet = bl;
    }
}

