/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.model;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.OS2200DebugConnect;
import com.unisys.tde.debug.core.comm.TaskInfo;
import com.unisys.tde.debug.core.comm.WriterTo2200;
import com.unisys.tde.debug.core.model.OS2200DebugElement;
import com.unisys.tde.debug.core.model.OS2200DebugTarget;
import com.unisys.tde.debug.core.model.OS2200StackFrame;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class OS2200Thread
extends OS2200DebugElement
implements IThread {
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping = true;
    private boolean fSuspended = false;
    private IStackFrame[] fCurrentStackFrames;
    private boolean gotFrames = false;
    private boolean doingFrames = false;
    private TaskInfo tskInfo;
    private WriterTo2200 writer;
    private OS2200DebugConnect dbConn;

    public OS2200Thread(OS2200DebugTarget oS2200DebugTarget) {
        super(oS2200DebugTarget);
        this.tskInfo = null;
        this.gotFrames = false;
        this.writer = null;
    }

    public OS2200Thread(OS2200DebugTarget oS2200DebugTarget, TaskInfo taskInfo) {
        super(oS2200DebugTarget);
        this.tskInfo = taskInfo;
        this.gotFrames = false;
        this.doingFrames = false;
        this.dbConn = oS2200DebugTarget.getDebugConnect();
        this.writer = this.dbConn.get2200Writer(taskInfo.getTaskID());
        OS2200CorePlugin.logger.debug((Object)("Thread for Task " + taskInfo.getTaskID() + " created."));
    }

    public void suspended(int n) {
        OS2200CorePlugin.logger.debug((Object)("suspended called in task " + this.tskInfo.getTaskID()));
        TaskInfo.TaskState taskState = this.tskInfo.getTaskState();
        if (taskState == TaskInfo.TaskState.PadsCommand) {
            OS2200CorePlugin.logger.debug((Object)("Task " + this.tskInfo.getTaskID() + " Marked as suspended"));
            this.fSuspended = true;
            super.fireSuspendEvent(n);
        } else {
            this.fSuspended = false;
            OS2200CorePlugin.logger.debug((Object)("Task " + this.tskInfo.getTaskID() + " Marked as not suspended"));
        }
        this.dbConn.setTaskState(this.getTaskID(), this.fSuspended);
    }

    public void resumed(int n) {
        OS2200CorePlugin.logger.debug((Object)("resumed called in task " + this.tskInfo.getTaskID()));
        if (this.fSuspended) {
            super.fireResumeEvent(n);
            this.fSuspended = false;
        }
        this.dbConn.setTaskState(this.tskInfo.getTaskID(), this.fSuspended);
        if (this.fCurrentStackFrames != null) {
            IStackFrame[] iStackFrameArray = this.fCurrentStackFrames;
            int n2 = this.fCurrentStackFrames.length;
            int n3 = 0;
            while (n3 < n2) {
                IStackFrame iStackFrame = iStackFrameArray[n3];
                OS2200StackFrame oS2200StackFrame = (OS2200StackFrame)iStackFrame;
                oS2200StackFrame.setDead(true);
                oS2200StackFrame = null;
                ++n3;
            }
        }
        this.fCurrentStackFrames = null;
    }

    public String getTaskID() {
        return this.tskInfo.getTaskID();
    }

    public synchronized IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended() && this.isStarted()) {
            if (!this.gotFrames && !this.doingFrames) {
                this.doingFrames = true;
                OS2200CorePlugin.logger.debug((Object)("getting frames for thread " + this.tskInfo.getTaskID()));
                this.fCurrentStackFrames = ((OS2200DebugTarget)this.getDebugTarget()).getStackFrames(this);
                this.gotFrames = true;
            }
            return this.fCurrentStackFrames;
        }
        return new IStackFrame[0];
    }

    private void setTaskForPads() {
        WriterTo2200 writerTo2200 = ((OS2200DebugTarget)this.getDebugTarget()).getWriter();
        if (this.tskInfo.getTaskState() == TaskInfo.TaskState.Exectuing) {
            ((OS2200DebugTarget)this.getDebugTarget()).setInterrupting();
            writerTo2200.taskInterrupt(this.tskInfo.getTaskID());
        }
        writerTo2200.taskSelect(this.tskInfo.getTaskID());
    }

    public void setStackFrames(IStackFrame[] iStackFrameArray) {
        this.fCurrentStackFrames = (OS2200StackFrame[])iStackFrameArray;
    }

    public void setGotFrames(boolean bl) {
        this.gotFrames = bl;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] iStackFrameArray = null;
        iStackFrameArray = this.fCurrentStackFrames == null || !this.gotFrames ? this.getStackFrames() : this.fCurrentStackFrames;
        if (iStackFrameArray.length > 0) {
            return iStackFrameArray[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        if (this.tskInfo == null) {
            return "Main Activity";
        }
        return "Task " + this.tskInfo.getLinkingSystemID();
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] iBreakpointArray) {
        this.fBreakpoints = iBreakpointArray;
    }

    public boolean canResume() {
        return this.isSuspended() && !this.isTerminated();
    }

    public boolean canSuspend() {
        return !this.isSuspended() && !this.isTerminated();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public boolean isStarted() {
        return ((OS2200DebugTarget)this.getDebugTarget()).isStarted();
    }

    public void resume() throws DebugException {
        ((OS2200DebugTarget)this.getDebugTarget()).resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isStarted() && this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isStarted() && this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.fCurrentStackFrames != null && this.fCurrentStackFrames.length > 1 && !this.isTerminated() && this.isSuspended();
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        ((OS2200DebugTarget)this.getDebugTarget()).stepInto(this.writer);
    }

    public void stepOver() throws DebugException {
        ((OS2200DebugTarget)this.getDebugTarget()).stepOver(this.writer);
    }

    public void stepReturn() throws DebugException {
        ((OS2200DebugTarget)this.getDebugTarget()).stepReturn(this.writer);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setStepping(boolean bl) {
        this.fStepping = bl;
    }
}

