/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.model;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.debug.core.comm.AllVariables;
import com.unisys.tde.debug.core.comm.OS2200DebugConnect;
import com.unisys.tde.debug.core.comm.OS2200RegisterSets;
import com.unisys.tde.debug.core.comm.OneVarValue;
import com.unisys.tde.debug.core.comm.ProgramPoint;
import com.unisys.tde.debug.core.comm.StopPoint;
import com.unisys.tde.debug.core.comm.VariableInfo;
import com.unisys.tde.debug.core.comm.VariableSet;
import com.unisys.tde.debug.core.comm.WalkbackPoint;
import com.unisys.tde.debug.core.comm.WriterTo2200;
import com.unisys.tde.debug.core.model.OS2200DebugElement;
import com.unisys.tde.debug.core.model.OS2200DebugTarget;
import com.unisys.tde.debug.core.model.OS2200Register;
import com.unisys.tde.debug.core.model.OS2200RegisterGroup;
import com.unisys.tde.debug.core.model.OS2200Thread;
import com.unisys.tde.debug.core.model.OS2200Value;
import com.unisys.tde.debug.core.model.OS2200Variable;
import com.unisys.tde.debug.core.model.ValueMemory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class OS2200StackFrame
extends OS2200DebugElement
implements IStackFrame {
    private OS2200Thread fThread;
    private int fPC;
    private String lnAsString;
    private String fFileName;
    private String iFileName;
    private IFile stopFile;
    private int fId;
    private IVariable[] fVariables;
    private OS2200DebugTarget osTarget;
    private String progName;
    private Hashtable<String, String> omToSource;
    private StopPoint stpPt;
    private IRegisterGroup[] regGroups;
    private boolean hasRegs;
    private WriterTo2200 writer;
    private boolean fDead;
    private boolean hasSDD;
    private ValueMemory valList;
    private HashMap<String, OS2200Variable> varMap;

    public OS2200StackFrame(OS2200Thread oS2200Thread, StopPoint stopPoint, OS2200DebugTarget oS2200DebugTarget, int n) {
        super((OS2200DebugTarget)oS2200Thread.getDebugTarget());
        OS2200CorePlugin.logger.debug((Object)" ");
        this.fId = n;
        this.fThread = oS2200Thread;
        this.osTarget = oS2200DebugTarget;
        OS2200DebugConnect oS2200DebugConnect = this.osTarget.getDebugConnect();
        this.writer = oS2200DebugConnect.get2200Writer(this.fThread.getTaskID());
        this.fDead = false;
        this.stpPt = stopPoint;
        this.progName = stopPoint.getOmPart();
        this.varMap = new HashMap();
        this.init(stopPoint);
    }

    public boolean sameFrame(OS2200StackFrame oS2200StackFrame) {
        OS2200Thread oS2200Thread = (OS2200Thread)oS2200StackFrame.getThread();
        if (!this.fThread.getTaskID().equals(oS2200Thread.getTaskID())) {
            return false;
        }
        if (!this.stpPt.getOmElt().equals(oS2200StackFrame.getStopPoint().getOmElt())) {
            return false;
        }
        if (!this.stpPt.getOmPart().equals(oS2200StackFrame.getStopPoint().getOmPart())) {
            return false;
        }
        return this.stpPt.getBlockNumber() == oS2200StackFrame.getStopPoint().getBlockNumber();
    }

    private void init(StopPoint stopPoint) {
        OS2200RegisterSets oS2200RegisterSets;
        OS2200CorePlugin.logger.debug((Object)" ");
        this.omToSource = this.osTarget.getOMSourceTable();
        this.hasSDD = stopPoint.hasSDD();
        if (stopPoint.hasSDD()) {
            this.fFileName = this.omToSource.get(stopPoint.getOmPart());
            this.stopFile = this.osTarget.findIFileName(this.fFileName);
            this.iFileName = this.stopFile != null ? this.stopFile.getName() : this.fFileName;
        } else {
            this.iFileName = this.fFileName = stopPoint.getStartMod();
        }
        this.removeIPAnnotations();
        if (stopPoint.hasSDD()) {
            this.lnAsString = stopPoint.getStopLineNumber();
            if (this.lnAsString != null) {
                this.fPC = this.getCleanNumber(this.lnAsString);
            } else {
                this.lnAsString = "no Sdd line number, no debug option";
                this.fPC = 0;
            }
        } else {
            this.fPC = 0;
            this.lnAsString = "no Sdd line number, no debug option";
        }
        this.fVariables = null;
        this.regGroups = null;
        boolean bl = this.hasRegs = stopPoint instanceof WalkbackPoint && this.fThread.isSuspended();
        if (this.hasRegs && (oS2200RegisterSets = this.osTarget.getRegSets(this.writer)) != null) {
            this.fillRegisterSets(oS2200RegisterSets);
        }
        this.valList = this.osTarget.getValList(this);
    }

    public String displayText() {
        if (this.isSuspended()) {
            if (this.hasSDD) {
                return String.valueOf(this.stpPt.prefixText()) + this.fFileName + "<" + this.stpPt.getStopElement() + "> line: " + this.lnAsString;
            }
            return String.valueOf(this.stpPt.prefixText()) + this.fFileName + this.lnAsString;
        }
        return "Executing";
    }

    public boolean isDead() {
        return this.fDead;
    }

    public void setDead(boolean bl) {
        this.fDead = bl;
    }

    int getCleanNumber(String string) {
        String string2 = string;
        int n = string.indexOf(".");
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            OS2200CorePlugin.logger.info((Object)("bad string for line number " + string), (Throwable)numberFormatException);
        }
        return n2;
    }

    void fillVariables(AllVariables allVariables) {
        OS2200Variable oS2200Variable;
        VariableSet variableSet = allVariables.getLocalVariableSet();
        ArrayList arrayList = new ArrayList();
        if (variableSet != null) {
            arrayList = variableSet.getSubVariables();
        }
        VariableSet variableSet2 = allVariables.getGlobalVariableSet();
        ArrayList arrayList2 = new ArrayList();
        if (variableSet2 != null) {
            arrayList2 = variableSet2.getSubVariables();
        }
        this.fVariables = new IVariable[arrayList.size() + arrayList2.size()];
        int n = 0;
        for (VariableInfo variableInfo : arrayList2) {
            oS2200Variable = new OS2200Variable(this, variableInfo);
            this.fVariables[n++] = oS2200Variable;
            this.varMap.put(oS2200Variable.getFullName(), oS2200Variable);
        }
        for (VariableInfo variableInfo : arrayList) {
            oS2200Variable = new OS2200Variable(this, variableInfo);
            this.fVariables[n++] = oS2200Variable;
            this.varMap.put(oS2200Variable.getFullName(), oS2200Variable);
        }
        this.addRememberedValues();
    }

    public void addRememberedValue(String string) {
        this.valList.getVarList().add(string);
    }

    void addRememberedValues() {
        ArrayList<String> arrayList = this.valList.getVarList();
        for (String string : arrayList) {
            OS2200Variable oS2200Variable = this.varMap.get(string);
            if (oS2200Variable == null) continue;
            try {
                OS2200Value oS2200Value = (OS2200Value)oS2200Variable.getValue();
                oS2200Value.setGetValueFirst(true);
            }
            catch (DebugException debugException) {
                debugException.printStackTrace();
            }
        }
    }

    void fillRegisterSets(OS2200RegisterSets oS2200RegisterSets) {
        this.regGroups = new IRegisterGroup[3];
        this.regGroups[0] = new OS2200RegisterGroup("X Registers", oS2200RegisterSets.getXset(), this.osTarget);
        this.regGroups[1] = new OS2200RegisterGroup("A Registers", oS2200RegisterSets.getAset(), this.osTarget);
        this.regGroups[2] = new OS2200RegisterGroup("R Registers", oS2200RegisterSets.getRset(), this.osTarget);
    }

    public OS2200Register findRegister(String string) throws DebugException {
        int n;
        String string2 = string.toUpperCase();
        if (string2.startsWith("X")) {
            int n2 = this.getRegIndx(string);
            if (n2 > -1) {
                return (OS2200Register)this.regGroups[0].getRegisters()[n2];
            }
        } else if (string2.startsWith("A")) {
            int n3 = this.getRegIndx(string);
            if (n3 > -1) {
                return (OS2200Register)this.regGroups[1].getRegisters()[n3];
            }
        } else if (string2.startsWith("R") && (n = this.getRegIndx(string)) > -1) {
            return (OS2200Register)this.regGroups[2].getRegisters()[n];
        }
        return null;
    }

    int getRegIndx(String string) {
        String string2 = string.substring(1);
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public OS2200Variable findVariable(String string) throws DebugException {
        if (this.fVariables == null) {
            this.getVariables();
            if (this.fVariables == null) {
                return null;
            }
        }
        int n = 0;
        while (n < this.fVariables.length) {
            OS2200Variable oS2200Variable = (OS2200Variable)this.fVariables[n];
            if (string.equals(oS2200Variable.getName())) {
                return oS2200Variable;
            }
            if ((oS2200Variable = this.searchVariable(oS2200Variable, string)) != null) {
                return oS2200Variable;
            }
            ++n;
        }
        return null;
    }

    OS2200Variable searchVariable(OS2200Variable oS2200Variable, String string) throws DebugException {
        if (oS2200Variable.getValue().hasVariables()) {
            IVariable[] iVariableArray = oS2200Variable.getValue().getVariables();
            int n = 0;
            while (n < iVariableArray.length) {
                OS2200Variable oS2200Variable2;
                OS2200Variable oS2200Variable3 = (OS2200Variable)iVariableArray[n];
                if (oS2200Variable3.getName().equals(string)) {
                    oS2200Variable2 = oS2200Variable3;
                    return oS2200Variable2;
                }
                oS2200Variable2 = this.searchVariable(oS2200Variable3, string);
                if (oS2200Variable2 != null) {
                    return oS2200Variable2;
                }
                ++n;
            }
        }
        return null;
    }

    private void removeIPAnnotations() {
        OS2200CorePlugin.logger.debug((Object)" ");
        try {
            if (this.stopFile != null) {
                final IWorkbenchPage iWorkbenchPage = OS2200FileInterface.UIActivePage();
                FileEditorInput fileEditorInput = new FileEditorInput(this.stopFile);
                Display.getDefault().asyncExec(new Runnable((IEditorInput)fileEditorInput){
                    private final /* synthetic */ IEditorInput val$iep;
                    {
                        this.val$iep = iEditorInput;
                    }

                    @Override
                    public void run() {
                        try {
                            IEditorPart iEditorPart = iWorkbenchPage.findEditor(this.val$iep);
                            if (iEditorPart != null && iEditorPart instanceof AbstractTextEditor) {
                                AbstractTextEditor abstractTextEditor = (AbstractTextEditor)iEditorPart;
                                IDocumentProvider iDocumentProvider = abstractTextEditor.getDocumentProvider();
                                IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.val$iep);
                                Iterator iterator = iAnnotationModel.getAnnotationIterator();
                                while (iterator.hasNext()) {
                                    Annotation annotation;
                                    String string;
                                    Object e = iterator.next();
                                    if (!(e instanceof Annotation) || !(string = (annotation = (Annotation)e).getType()).equals("org.eclipse.debug.ui.currentIP") && !string.equals("org.eclipse.debug.ui.secondaryIP")) continue;
                                    iAnnotationModel.removeAnnotation(annotation);
                                }
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            OS2200CorePlugin.logger.error((Object)"error removing annotations", (Throwable)runtimeException);
                            OS2200CorePlugin.logger.info((Object)"error removing annotations", (Throwable)runtimeException);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)"error removing annotations", (Throwable)exception);
            OS2200CorePlugin.logger.error((Object)"error removing annotations", (Throwable)exception);
        }
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.hasSDD) {
            if (this.fThread.isSuspended()) {
                if (this.fVariables == null) {
                    AllVariables allVariables = this.osTarget.getVariableSet((ProgramPoint)this.stpPt, this.writer);
                    if (allVariables != null) {
                        this.fillVariables(allVariables);
                    } else {
                        this.fVariables = new IVariable[0];
                    }
                }
                return this.fVariables;
            }
            this.fVariables = new IVariable[0];
            return this.fVariables;
        }
        this.fVariables = new IVariable[0];
        return this.fVariables;
    }

    public OS2200Value getVariable(String string) {
        try {
            OneVarValue oneVarValue = this.osTarget.getWriter().getVariable(string, this.stpPt.getOmElt(), this.stpPt.getOmPart(), this.stpPt.getBlockNumber());
            if (oneVarValue != null) {
                VariableInfo variableInfo = new VariableInfo();
                variableInfo.setVariableName(oneVarValue.getVarName());
                variableInfo.setValue(oneVarValue.getVarValue());
                variableInfo.setVariableType("ASCII string");
                variableInfo.setComplete(true);
                variableInfo.setErrorMsgs(oneVarValue.getErrorMsgs());
                OS2200Value oS2200Value = new OS2200Value(this, variableInfo, null);
                return oS2200Value;
            }
            return null;
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)("IOError getting variable-" + string), (Throwable)iOException);
            this.osTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200StackFrame_0")) + iOException.getLocalizedMessage());
            this.osTarget.precipitousTerminate();
            return null;
        }
    }

    OneVarValue getLoneValue(String string) {
        OneVarValue oneVarValue = null;
        try {
            byte[] byArray = string.getBytes();
            byte cfr_ignored_0 = byArray[0];
            String string2 = Integer.toHexString(byArray[0]);
            string2 = string2.substring(string2.length() - 2);
            string.charAt(0);
            oneVarValue = string2.equals("93") ? this.osTarget.getWriter().getVariableJ(string, this.stpPt.getOmElt(), this.stpPt.getOmPart(), this.stpPt.getBlockNumber()) : this.osTarget.getWriter().getVariable(string, this.stpPt.getOmElt(), this.stpPt.getOmPart(), this.stpPt.getBlockNumber());
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)("IOError getting variable-" + string), (Throwable)iOException);
            this.osTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200StackFrame_1")) + iOException.getLocalizedMessage());
            this.osTarget.precipitousTerminate();
            return null;
        }
        return oneVarValue;
    }

    public OneVarValue getCString(String string, int n) {
        OneVarValue oneVarValue = null;
        try {
            oneVarValue = this.osTarget.getWriter().getVariable(string, this.stpPt.getOmElt(), this.stpPt.getOmPart(), this.stpPt.getBlockNumber());
            String string2 = "'" + oneVarValue.getVarValue() + "'";
            oneVarValue.setVarValue(string2);
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)("IOError getting variable-" + string), (Throwable)iOException);
            this.osTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200StackFrame_2")) + iOException.getLocalizedMessage());
            this.osTarget.precipitousTerminate();
            return null;
        }
        return oneVarValue;
    }

    public boolean hasVariables() throws DebugException {
        if (this.isSuspended()) {
            if (this.hasSDD) {
                if (this.fVariables == null) {
                    AllVariables allVariables = this.osTarget.getVariableSet((ProgramPoint)this.stpPt, this.writer);
                    this.fillVariables(allVariables);
                }
                return this.fVariables.length > 0;
            }
            return false;
        }
        return false;
    }

    public int getLineNumber() throws DebugException {
        return this.fPC;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.iFileName;
    }

    public String getProgName() {
        return this.progName;
    }

    public String getStopElement() {
        return this.stpPt.getStopElement();
    }

    public StopPoint getStopPoint() {
        return this.stpPt;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        if (this.regGroups == null) {
            OS2200RegisterSets oS2200RegisterSets = this.osTarget.getRegSets(this.writer);
            if (oS2200RegisterSets == null) {
                return null;
            }
            this.fillRegisterSets(oS2200RegisterSets);
        }
        return this.regGroups;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return this.hasRegs;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.iFileName;
    }

    public boolean equals(Object object) {
        if (object instanceof OS2200StackFrame) {
            OS2200StackFrame oS2200StackFrame = (OS2200StackFrame)((Object)object);
            try {
                return oS2200StackFrame.getSourceName().equals(this.getSourceName()) && oS2200StackFrame.getLineNumber() == this.getLineNumber() && oS2200StackFrame.fId == this.fId;
            }
            catch (DebugException debugException) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getSourceName().hashCode() + this.fId;
    }

    protected int getIdentifier() {
        return this.fId;
    }

    public OneVarValue getCString(String string) {
        return null;
    }

    public OneVarValue getFArray(String string, int n, int n2, int n3) {
        OneVarValue oneVarValue = null;
        try {
            oneVarValue = this.osTarget.getWriter().getArray(string, n, n2, this.stpPt.getOmElt(), this.stpPt.getOmPart(), this.stpPt.getBlockNumber(), n3);
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)("IOError getting variable-" + string), (Throwable)iOException);
            this.osTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200StackFrame_3")) + iOException.getLocalizedMessage());
            this.osTarget.precipitousTerminate();
            return null;
        }
        return oneVarValue;
    }

    public OneVarValue getFArrayJ(String string, int n, int n2, int n3) {
        OneVarValue oneVarValue = null;
        try {
            oneVarValue = this.osTarget.getWriter().getArrayJ(string, n, n2, this.stpPt.getOmElt(), this.stpPt.getOmPart(), this.stpPt.getBlockNumber(), n3);
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)("IOError getting variable-" + string), (Throwable)iOException);
            this.osTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200StackFrame_4")) + iOException.getLocalizedMessage());
            this.osTarget.precipitousTerminate();
            return null;
        }
        return oneVarValue;
    }
}

