/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.model;

import com.unisys.tde.debug.core.comm.MemoryDumpModule;
import com.unisys.tde.debug.core.model.MemoryLabelProvider;
import com.unisys.tde.debug.core.model.OS2200DebugElement;
import com.unisys.tde.debug.core.model.OS2200DebugTarget;
import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;

public class OS2200MemoryBlockExt
extends OS2200DebugElement
implements IMemoryBlockExtension {
    Object currentClient = null;
    OS2200DebugTarget targ;
    BigInteger startAdd;
    int lenDump;
    MemoryDumpModule memModule;
    long octalAddress;
    ArrayList<Object> clients;
    String expression;
    MemoryLabelProvider labelGiver = null;

    public OS2200MemoryBlockExt(MemoryDumpModule memoryDumpModule, OS2200DebugTarget oS2200DebugTarget, BigInteger bigInteger, int n, String string) {
        super(oS2200DebugTarget);
        this.memModule = memoryDumpModule;
        this.targ = oS2200DebugTarget;
        this.startAdd = bigInteger;
        this.lenDump = n;
        Long l = this.startAdd.longValue();
        this.octalAddress = l;
        this.clients = new ArrayList();
        this.expression = string;
    }

    public void connect(Object object) {
        if (this.clients == null) {
            this.clients = new ArrayList();
        }
        this.clients.add(object);
    }

    public void disconnect(Object object) {
        if (this.clients != null && object != null) {
            this.clients.remove(object);
        }
    }

    public void dispose() throws DebugException {
        this.clients = null;
    }

    public MemoryDumpModule getMemDump() {
        return this.memModule;
    }

    public long getLength() {
        return this.memModule.getLength();
    }

    public int getAddressSize() throws DebugException {
        return 5;
    }

    public int getAddressableSize() throws DebugException {
        return 5;
    }

    public BigInteger getBigBaseAddress() throws DebugException {
        return this.startAdd;
    }

    public BigInteger getBigLength() throws DebugException {
        return BigInteger.valueOf(this.lenDump);
    }

    public MemoryByte[] getBytesFromAddress(BigInteger bigInteger, long l) throws DebugException {
        Object object;
        bigInteger.longValue();
        int n = 0;
        int n2 = bigInteger.compareTo(this.startAdd);
        if (n2 == 1) {
            object = this.startAdd.subtract(bigInteger);
            n = ((BigInteger)object).intValue();
        }
        object = this.memModule.getThemInBytes();
        long l2 = l * (long)this.getAddressableSize();
        if (l2 > (long)(((Object)object).length - n)) {
            l2 = ((Object)object).length - n;
        }
        MemoryByte[] memoryByteArray = new MemoryByte[((Object)object).length];
        int n3 = n;
        while ((long)n3 < l2) {
            memoryByteArray[n3] = new MemoryByte((byte)object[n3], 34);
            ++n3;
        }
        return memoryByteArray;
    }

    public MemoryByte[] getBytesFromOffset(BigInteger bigInteger, long l) throws DebugException {
        int n = bigInteger.intValue();
        byte[] byArray = this.memModule.getThemInBytes();
        long l2 = l * (long)this.getAddressableSize();
        if (l2 > (long)(byArray.length - n)) {
            l2 = byArray.length - n;
        }
        MemoryByte[] memoryByteArray = new MemoryByte[byArray.length];
        int n2 = n;
        while ((long)n2 < l2) {
            memoryByteArray[n2] = new MemoryByte(byArray[n2], 34);
            ++n2;
        }
        return memoryByteArray;
    }

    public Object[] getConnections() {
        Object[] objectArray = new Object[this.clients.size()];
        objectArray = this.clients.toArray(objectArray);
        return objectArray;
    }

    public String getExpression() {
        return this.expression;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return BigInteger.valueOf(this.startAdd.longValue() + (long)this.lenDump);
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.targ;
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return this.startAdd;
    }

    public long getOctalStartAddress() {
        return this.octalAddress;
    }

    public void setBaseAddress(BigInteger bigInteger) throws DebugException {
    }

    public void setValue(BigInteger bigInteger, byte[] byArray) throws DebugException {
    }

    public boolean supportBaseAddressModification() throws DebugException {
        return false;
    }

    public boolean supportsChangeManagement() {
        return false;
    }

    public byte[] getBytes() throws DebugException {
        byte[] byArray = this.memModule.getThemInBytes();
        return byArray;
    }

    public long getStartAddress() {
        return this.startAdd.longValue();
    }

    public void setValue(long l, byte[] byArray) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this.targ;
    }

    @Override
    public ILaunch getLaunch() {
        return this.targ.getLaunch();
    }

    @Override
    public Object getAdapter(Class clazz) {
        String string = clazz.getCanonicalName();
        System.out.println("adapter sought " + string);
        if (clazz.getSimpleName().equals("IElementLabelProvider")) {
            if (this.labelGiver == null) {
                this.labelGiver = new MemoryLabelProvider(this);
            }
            return this.labelGiver;
        }
        if (clazz.equals(IMemoryBlockRetrieval.class)) {
            return this.targ;
        }
        if (clazz.equals(IResource.class) || clazz.equals(IProject.class)) {
            return this.targ.getProject();
        }
        if (clazz.equals(IMemoryBlockExtension.class)) {
            return this;
        }
        return null;
    }
}

