/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.model;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.ProjectProperties;
import com.unisys.tde.debug.core.DebugStop;
import com.unisys.tde.debug.core.OS2200DebugPlugin;
import com.unisys.tde.debug.core.comm.AllVariables;
import com.unisys.tde.debug.core.comm.DebugCallback;
import com.unisys.tde.debug.core.comm.DebugListener;
import com.unisys.tde.debug.core.comm.DebugSocketControl;
import com.unisys.tde.debug.core.comm.MemoryDumpModule;
import com.unisys.tde.debug.core.comm.MessageType;
import com.unisys.tde.debug.core.comm.OS2200DebugConnect;
import com.unisys.tde.debug.core.comm.OS2200RegisterSets;
import com.unisys.tde.debug.core.comm.ProcedureList;
import com.unisys.tde.debug.core.comm.ProgramContext;
import com.unisys.tde.debug.core.comm.ProgramInfo;
import com.unisys.tde.debug.core.comm.ProgramPoint;
import com.unisys.tde.debug.core.comm.StartLineInfo;
import com.unisys.tde.debug.core.comm.StopPoint;
import com.unisys.tde.debug.core.comm.TaskInfo;
import com.unisys.tde.debug.core.comm.WalkbackPoint;
import com.unisys.tde.debug.core.comm.WriterTo2200;
import com.unisys.tde.debug.core.model.OS2200BreakpointListener;
import com.unisys.tde.debug.core.model.OS2200DebugElement;
import com.unisys.tde.debug.core.model.OS2200MemoryBlock;
import com.unisys.tde.debug.core.model.OS2200MemoryBlockExt;
import com.unisys.tde.debug.core.model.OS2200OmDescriptor;
import com.unisys.tde.debug.core.model.OS2200Register;
import com.unisys.tde.debug.core.model.OS2200StackFrame;
import com.unisys.tde.debug.core.model.OS2200Thread;
import com.unisys.tde.debug.core.model.OS2200Variable;
import com.unisys.tde.debug.core.model.PadsLibVersionChecker;
import com.unisys.tde.debug.core.model.SingleOpQueue;
import com.unisys.tde.debug.core.model.StartingDebugMonitor;
import com.unisys.tde.debug.core.model.ValueMemory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;

public class OS2200DebugTarget
extends OS2200DebugElement
implements IDebugTarget,
IMemoryBlockRetrievalExtension {
    private ILaunch fLaunch;
    private IProject proj2200;
    private String dbPort;
    private String debugID;
    IBreakpointManager bkpMgr;
    private String fName;
    Hashtable<String, String> omToSource;
    Hashtable<String, OS2200OmDescriptor> srcToOm;
    OS2200DebugConnect debugConn;
    ProgramInfo inf;
    private String projectName;
    private boolean fSuspended = true;
    private boolean fWorking = false;
    private boolean fDisconnected = true;
    private Shell fShell = null;
    StopPoint stpPt;
    ProgramContext proCon;
    ProcedureList procList;
    private boolean fStarted = false;
    private String versionPads;
    private boolean fTerminated = false;
    private DebugListener dbListen;
    WriterTo2200 dbWriter = null;
    private IThread[] fThreads;
    private boolean fEnding = false;
    IStackFrame[] lastSF;
    private boolean fInterrupting = false;
    private String startMonitorMessage;
    private String retrieveMonitorMessage = "";
    private OS2200BreakpointListener bkpListener;
    private Vector<workfileAndProject> wnP;
    private DebugStop dbStop;
    private String pProcLvl;
    private int lastTrapId;
    private ConnectionMonitor connMonitor;
    private ArrayList<ValueMemory> valLists;
    private boolean fInitialized;
    private SingleOpQueue theSingleOPQueue;

    String getEltVer(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    void createThreads(ArrayList<TaskInfo> arrayList) throws DebugException {
        OS2200CorePlugin.logger.debug((Object)"creating Threads");
        if (arrayList != null) {
            this.fThreads = new IThread[arrayList.size()];
            int n = 0;
            for (TaskInfo taskInfo : arrayList) {
                OS2200Thread oS2200Thread = new OS2200Thread(this, taskInfo);
                if (taskInfo.getTaskState() == TaskInfo.TaskState.PadsCommand) {
                    oS2200Thread.getStackFrames();
                }
                this.fThreads[n++] = oS2200Thread;
            }
        }
    }

    void sendErrorMsg(String string) {
        Display display = Display.getDefault();
        final String string2 = string;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200DebugTarget_41"), (String)string2);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.info((Object)"error posting debug message", (Throwable)exception);
                }
            }
        });
    }

    void createInitThreads() {
        this.fThreads = new IThread[1];
        this.fThreads[0] = new OS2200Thread(this);
    }

    public void setInterrupting() {
        this.fInterrupting = true;
    }

    public boolean isInterrupting() {
        return this.fInterrupting;
    }

    public void resetInterrupting() {
        this.fInterrupting = false;
    }

    public WriterTo2200 getWriter() {
        return this.getAvailableWriter();
    }

    void endThreads() {
        this.fThreads = new IThread[0];
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Hashtable<String, String> getOMSourceTable() {
        return this.omToSource;
    }

    void waitASec() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void makeSrcToOMMap(IProject iProject, String string) {
        Set<String> set = this.omToSource.keySet();
        for (String string2 : set) {
            String string3 = this.omToSource.get(string2);
            OS2200OmDescriptor oS2200OmDescriptor = new OS2200OmDescriptor(iProject, string, string2);
            int n = string3.indexOf(".");
            String string4 = string3.substring(n + 1).toLowerCase();
            string4 = string4.replace('/', '.');
            this.srcToOm.put(string4, oS2200OmDescriptor);
        }
    }

    public Hashtable<String, OS2200OmDescriptor> gotSrcToOm() {
        return this.srcToOm;
    }

    public ProgramInfo getProgramInfo() {
        return this.inf;
    }

    public OS2200DebugTarget(ILaunch iLaunch, IProject iProject, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        super(null);
        this.fLaunch = iLaunch;
        this.projectName = iLaunchConfiguration.getAttribute("Project_Name", "");
        this.debugID = iLaunchConfiguration.getAttribute("OS2200_DEBUG_ID", "");
        this.dbPort = iLaunchConfiguration.getAttribute("OS2200_DEBUG_PORT_NUMBER", "");
        String string = iLaunchConfiguration.getAttribute("DebugFirstStop", DebugStop.firstLineNoBkpt.toString());
        this.dbStop = DebugStop.valueOf(string);
        this.fStarted = false;
        this.fSuspended = false;
        this.fTerminated = false;
        this.fWorking = false;
        this.fTarget = this;
        this.fInitialized = false;
        this.valLists = new ArrayList();
        this.fShell = OS2200DebugTarget.getShell();
        this.versionPads = null;
        this.proj2200 = iProject;
        this.debugConn = new OS2200DebugConnect(iProject);
        this.srcToOm = new Hashtable();
        this.projectName = iProject.getName();
        this.makeProjectTable();
        this.createInitThreads();
        this.showOtherViews();
        this.dbListen = new DebugListen();
        this.lastTrapId = 11;
        this.checkPerspective();
        this.pProcLvl = "";
        this.connMonitor = new ConnectionMonitor();
        this.theSingleOPQueue = new SingleOpQueue();
        this.connMonitor.start();
        this.debugConn.startDebug(Integer.parseInt(this.dbPort), this.debugID, this.dbListen);
    }

    public OS2200DebugConnect getDebugConnect() {
        return this.debugConn;
    }

    public SingleOpQueue getSingleOPQueue() {
        return this.theSingleOPQueue;
    }

    private static Shell getShell() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        Shell shell = new Shell(display.getActiveShell(), 0);
        return shell;
    }

    void callDebugListener(DebugCallback debugCallback) {
        final DebugCallback debugCallback2 = debugCallback;
        Thread thread = new Thread(){

            @Override
            public void run() {
                OS2200DebugTarget.this.dbListen.debugCall(debugCallback2);
            }
        };
        thread.start();
    }

    public void halt() {
        OS2200DebugConnect.InitState initState = this.debugConn.getInitState();
        DebugCallback debugCallback = null;
        switch (initState) {
            case preConnect: 
            case Connect: 
            case Validated: 
            case Rejected: {
                debugCallback = new DebugCallback(MessageType.tpPrecipitousTerminate, (Object)Messages.getString((String)"OS2200DebugTarget_42"));
                this.callDebugListener(debugCallback);
            }
        }
    }

    public IProcess getProcess() {
        return null;
    }

    boolean processThreads(WriterTo2200 writerTo2200) {
        OS2200CorePlugin.logger.debug((Object)"Processing Threads");
        ArrayList arrayList = null;
        try {
            arrayList = writerTo2200.getTaskList();
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.info((Object)"IOError on getting task List", (Throwable)iOException);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_43")) + iOException.getLocalizedMessage());
            this.precipitousTerminate();
        }
        if (arrayList != null) {
            try {
                if (this.procList == null) {
                    OS2200CorePlugin.logger.debug((Object)"procList is null");
                }
                this.createThreads(arrayList);
            }
            catch (DebugException debugException) {
                OS2200CorePlugin.logger.info((Object)"createThreads failed", (Throwable)debugException);
                this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_44")) + debugException.getLocalizedMessage() + Messages.getString((String)"OS2200DebugTarget_45"));
                this.precipitousTerminate();
                return false;
            }
            return true;
        }
        OS2200CorePlugin.logger.info((Object)"timeout getting task list");
        this.sendErrorMsg(Messages.getString((String)"OS2200DebugTarget_46"));
        this.precipitousTerminate();
        return false;
    }

    StartLineInfo processStartLine() {
        try {
            StartLineInfo startLineInfo = this.dbWriter.getStart();
            return startLineInfo;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    boolean processRun(WriterTo2200 writerTo2200) throws IOException {
        OS2200CorePlugin.logger.debug((Object)"doing process run");
        boolean bl = writerTo2200.run();
        return bl;
    }

    void waitABit(int n) {
        OS2200CorePlugin.logger.debug((Object)("waiting " + n));
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            OS2200CorePlugin.logger.debug((Object)("wait a bit interrupted" + n));
        }
    }

    ProcedureList processProcs(StopPoint stopPoint, ProcedureList procedureList, WriterTo2200 writerTo2200) throws IOException {
        OS2200CorePlugin.logger.debug((Object)("process procs " + stopPoint.getStopLineNumber()));
        ProcedureList procedureList2 = writerTo2200.getAllProcs(stopPoint, procedureList);
        if (procedureList2 != null) {
            return procedureList2;
        }
        return null;
    }

    void makeProjectTable() {
        try {
            this.wnP = new Vector();
            Properties properties = OS2200ProjectUpdate.getProperties((IProject)this.proj2200);
            String string = this.removeCycle(properties.getProperty("workFile"));
            this.wnP.add(new workfileAndProject(string.toUpperCase(), this.proj2200));
            IProject[] iProjectArray = this.proj2200.getReferencedProjects();
            int n = 0;
            while (n < iProjectArray.length) {
                IProject iProject = iProjectArray[n];
                properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                string = this.removeCycle(properties.getProperty("workFile"));
                this.wnP.add(new workfileAndProject(string.toUpperCase(), iProject));
                ++n;
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Unisys internal Error", (Throwable)coreException);
            OS2200CorePlugin.logger.info((Object)"Error setting project Table", (Throwable)coreException);
        }
    }

    public String removeCycle(String string) {
        int n;
        int n2 = string.indexOf("(");
        if (n2 > 0 && (n = string.indexOf(")", n2)) > 0) {
            String string2 = String.valueOf(string.substring(0, n2)) + string.substring(n + 1);
            return string2;
        }
        return string;
    }

    public void checkPerspective() {
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    OS2200CorePlugin.myWorkbench.showPerspective("org.eclipse.debug.ui.DebugPerspective", OS2200FileInterface.UIActiveWindow());
                }
                catch (WorkbenchException workbenchException) {
                    OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)workbenchException);
                    OS2200CorePlugin.logger.info((Object)"Error setting debug perspective", (Throwable)workbenchException);
                }
            }
        });
    }

    public IFile findIFileName(String string) {
        ProjectProperties projectProperties = new ProjectProperties();
        IFile iFile = null;
        try {
            Properties properties = OS2200ProjectUpdate.getProperties((IProject)this.proj2200);
            String string2 = this.removeCycle(properties.getProperty("workFile"));
            int n = string.indexOf(".");
            if (n < 0) {
                return iFile;
            }
            String string3 = string.substring(n + 1).replace('/', '.');
            for (workfileAndProject workfileAndProject2 : this.wnP) {
                if (!workfileAndProject2.workfile.equalsIgnoreCase(string2)) continue;
                IProject iProject = workfileAndProject2.proj;
                IResource[] iResourceArray = iProject.members();
                int n2 = 0;
                while (n2 < iResourceArray.length) {
                    IFile iFile2;
                    if (iResourceArray[n2] instanceof IFile && (iFile2 = (IFile)iResourceArray[n2]).isLinked()) {
                        String string4 = projectProperties.getPropertyFor(iResourceArray[n2], "NativeName");
                        if (string4 == null) {
                            IPath iPath = null;
                            if (iFile2.toString().contains(" ")) {
                                OS2200CorePlugin.logger.info((Object)"check for character conversion file");
                                String string5 = iFile2.toString().substring(iFile2.toString().lastIndexOf(" ") + 1, iFile2.toString().lastIndexOf("."));
                                String string6 = OS2200FileInterface.getCIFSDir((IProject)iProject);
                                string6 = String.valueOf(string6) + "\\" + string5;
                                iPath = new Path(string6);
                            } else {
                                iPath = iResourceArray[n2].getRawLocation();
                            }
                            string4 = iPath != null ? iPath.lastSegment() : "";
                        } else {
                            string4 = string4.replace('/', '.');
                        }
                        if (string4.equalsIgnoreCase(string3)) {
                            return (IFile)iResourceArray[n2];
                        }
                    }
                    ++n2;
                }
            }
            return iFile;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)coreException);
            OS2200CorePlugin.logger.info((Object)"Error finding File name", (Throwable)coreException);
            return iFile;
        }
    }

    public IThread[] getThreads() throws DebugException {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        if (this.fThreads != null) {
            return this.fThreads.length > 0;
        }
        return false;
    }

    public IProject getProject() {
        return this.proj2200;
    }

    void showOtherViews() {
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    OS2200FileInterface.UIActivePage().showView("org.eclipse.debug.ui.MemoryView");
                    OS2200FileInterface.UIActivePage().showView("org.eclipse.debug.ui.RegisterView");
                }
                catch (PartInitException partInitException) {
                    OS2200CorePlugin.logger.info((Object)"Can't open the regsiter view", (Throwable)partInitException);
                }
            }
        });
    }

    public IBreakpointManager getBreakpointManager() {
        return this.bkpMgr;
    }

    private void initBreakpoints() {
        this.bkpMgr = DebugPlugin.getDefault().getBreakpointManager();
        this.bkpListener = new OS2200BreakpointListener(this);
        this.bkpMgr.addBreakpointListener((IBreakpointListener)this.bkpListener);
        this.bkpMgr.addBreakpointManagerListener((IBreakpointManagerListener)this.bkpListener);
        this.bkpListener.initBrkptSet();
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = this.projectName;
        }
        return this.fName;
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        if (iBreakpoint.getModelIdentifier().equals("com.unisys.tde.debug.os2200")) {
            try {
                IMarker iMarker;
                String string = this.getLaunch().getLaunchConfiguration().getAttribute("com.unisys.tde.debug.os2200.ATTR_PDA_PROGRAM", null);
                if (string != null && (iMarker = iBreakpoint.getMarker()) != null) {
                    Path path = new Path(string);
                    return iMarker.getResource().getFullPath().equals((Object)path);
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        WriterTo2200 writerTo2200 = this.getAvailableWriter();
        if (writerTo2200 != null) {
            boolean bl = true;
            try {
                this.debugConn.writeStop();
                bl = writerTo2200.EndSession();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.info((Object)"IOError on EndSession", (Throwable)iOException);
                this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_47")) + iOException.getLocalizedMessage());
                this.precipitousTerminate();
            }
            if (!bl) {
                this.precipitousTerminate();
            }
        } else {
            this.precipitousTerminate();
        }
    }

    OS2200Thread findStoppedThread() {
        IThread[] iThreadArray = this.fThreads;
        int n = this.fThreads.length;
        int n2 = 0;
        while (n2 < n) {
            IThread iThread = iThreadArray[n2];
            OS2200Thread oS2200Thread = (OS2200Thread)iThread;
            if (oS2200Thread.isSuspended()) {
                OS2200CorePlugin.logger.debug((Object)("thread chosen for write " + oS2200Thread.getTaskID()));
                return oS2200Thread;
            }
            ++n2;
        }
        return null;
    }

    public WriterTo2200 getAvailableWriter() {
        OS2200Thread oS2200Thread = this.findStoppedThread();
        if (oS2200Thread != null) {
            String string = oS2200Thread.getTaskID();
            return this.debugConn.get2200Writer(string);
        }
        return this.debugConn.get2200Writer();
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.fSuspended && !this.fWorking;
    }

    public boolean isStarted() {
        return this.fStarted;
    }

    void startRun() {
    }

    public void setWorking(boolean bl) {
        this.fWorking = bl;
    }

    public boolean isWorking() {
        return this.fWorking;
    }

    public void resume() throws DebugException {
        if (this.isSuspended()) {
            WriterTo2200 writerTo2200 = this.getAvailableWriter();
            this.resumed();
            this.startRun();
            try {
                writerTo2200.run();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.info((Object)"IOError on Run", (Throwable)iOException);
                this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_48")) + iOException.getLocalizedMessage());
                this.precipitousTerminate();
            }
        }
    }

    private void suspended(int n) {
        OS2200CorePlugin.logger.debug((Object)"Target suspended call");
        this.fSuspended = true;
        int n2 = 0;
        while (n2 < this.fThreads.length) {
            OS2200Thread oS2200Thread = (OS2200Thread)this.fThreads[n2];
            if (oS2200Thread != null) {
                oS2200Thread.suspended(n);
            }
            ++n2;
        }
    }

    private void resumed() {
        OS2200CorePlugin.logger.debug((Object)"Target resumed call");
        this.fSuspended = false;
        int n = 0;
        while (n < this.fThreads.length) {
            OS2200Thread oS2200Thread = (OS2200Thread)this.fThreads[n];
            oS2200Thread.resumed(1);
            ++n;
        }
        this.fireResumeEvent(1);
    }

    public void suspend() throws DebugException {
        String string = "hit";
        string = String.valueOf(string);
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        if (this.supportsBreakpoint(iBreakpoint)) {
            try {
                iBreakpoint.isEnabled();
            }
            catch (CoreException coreException) {}
        }
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        this.supportsBreakpoint(iBreakpoint);
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (this.supportsBreakpoint(iBreakpoint)) {
            try {
                if (iBreakpoint.isEnabled()) {
                    this.breakpointAdded(iBreakpoint);
                } else {
                    this.breakpointRemoved(iBreakpoint, null);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return this.fDisconnected;
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        Long l3 = l;
        String string = Long.toHexString(l3);
        Long l4 = Long.parseLong(string, 8);
        Long l5 = l2;
        try {
            WriterTo2200 writerTo2200 = this.getAvailableWriter();
            MemoryDumpModule memoryDumpModule = writerTo2200.dumpMemory(l4.longValue(), l5.intValue());
            OS2200MemoryBlock oS2200MemoryBlock = new OS2200MemoryBlock(memoryDumpModule, this, l3);
            return oS2200MemoryBlock;
        }
        catch (IOException iOException) {
            OS2200DebugTarget oS2200DebugTarget = (OS2200DebugTarget)this.getDebugTarget();
            OS2200CorePlugin.logger.debug((Object)"IOError setting variable value", (Throwable)iOException);
            oS2200DebugTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_49")) + iOException.getLocalizedMessage());
            oS2200DebugTarget.precipitousTerminate();
            Status status = new Status(4, "com.unisys.tde.debug.core", 0, String.valueOf(Messages.getString((String)"OS2200DebugTarget_50")) + string + Messages.getString((String)"OS2200DebugTarget_51"), null);
            DebugException debugException = new DebugException((IStatus)status);
            throw debugException;
        }
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String string, Object object) throws DebugException {
        Long l;
        String string2 = this.getStartPart(string);
        Long l2 = l = this.getStartAddress(string2, object);
        int n = this.getLength(string);
        try {
            WriterTo2200 writerTo2200 = this.getAvailableWriter();
            MemoryDumpModule memoryDumpModule = writerTo2200.dumpMemory(l2.longValue(), n);
            OS2200MemoryBlockExt oS2200MemoryBlockExt = new OS2200MemoryBlockExt(memoryDumpModule, this, BigInteger.valueOf(l), n, string);
            return oS2200MemoryBlockExt;
        }
        catch (IOException iOException) {
            OS2200DebugTarget oS2200DebugTarget = (OS2200DebugTarget)this.getDebugTarget();
            OS2200CorePlugin.logger.debug((Object)"IOError setting variable value", (Throwable)iOException);
            oS2200DebugTarget.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_52")) + iOException.getLocalizedMessage());
            oS2200DebugTarget.precipitousTerminate();
            Status status = new Status(4, "com.unisys.tde.debug.core", 0, String.valueOf(Messages.getString((String)"OS2200DebugTarget_53")) + string + Messages.getString((String)"OS2200DebugTarget_54"), null);
            DebugException debugException = new DebugException((IStatus)status);
            throw debugException;
        }
    }

    Long getStartAddress(String string, Object object) throws DebugException {
        try {
            Long l = Long.parseLong(string, 8);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            OS2200StackFrame oS2200StackFrame = (OS2200StackFrame)((Object)object);
            OS2200Register oS2200Register = oS2200StackFrame.findRegister(string);
            if (oS2200Register != null) {
                return Long.parseLong(oS2200Register.getValue().getValueString(), 8);
            }
            OS2200Variable oS2200Variable = oS2200StackFrame.findVariable(string);
            if (oS2200Variable != null) {
                Long l;
                String string2 = oS2200Variable.getValue().getValueString();
                if (string2.indexOf("=>") > 0) {
                    string2 = OS2200DebugTarget.parsePadsAddress(string2);
                }
                try {
                    l = Long.parseLong(string2, 8);
                }
                catch (NumberFormatException numberFormatException2) {
                    Status status = new Status(4, "com.unisys.tde.debug.core", 0, String.valueOf(Messages.getString((String)"OS2200DebugTarget_55")) + string + Messages.getString((String)"OS2200DebugTarget_56") + string2 + Messages.getString((String)"OS2200DebugTarget_57"), null);
                    DebugException debugException = new DebugException((IStatus)status);
                    throw debugException;
                }
                return l;
            }
            Status status = new Status(4, "com.unisys.tde.debug.core", 0, String.valueOf(Messages.getString((String)"OS2200DebugTarget_58")) + string + Messages.getString((String)"OS2200DebugTarget_59"), null);
            DebugException debugException = new DebugException((IStatus)status);
            throw debugException;
        }
    }

    public static String parsePadsAddress(String string) {
        int n = string.indexOf("T");
        String string2 = string.substring(0, n);
        int n2 = string.indexOf("=>", n) + 2;
        int n3 = string.indexOf("T", n2);
        String string3 = string.substring(n2, n3);
        string3 = "00000" + string3;
        string3 = string3.substring(string3.length() - 6);
        String string4 = String.valueOf(string2) + string3;
        return string4;
    }

    String getStartPart(String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    int getLength(String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            int n2;
            try {
                n2 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                return 16;
            }
            return n2;
        }
        return 16;
    }

    public AllVariables getVariableSet(ProgramPoint programPoint, WriterTo2200 writerTo2200) {
        RetrieverMonitor retrieverMonitor = new RetrieverMonitor(Messages.getString((String)"OS2200DebugTarget_60"), Messages.getString((String)"OS2200DebugTarget_61"), writerTo2200);
        try {
            this.fWorking = true;
            retrieverMonitor.start();
            AllVariables allVariables = writerTo2200.getVariables(programPoint);
            this.fWorking = false;
            if (!retrieverMonitor.interrupted) {
                retrieverMonitor.setDone(true);
                retrieverMonitor.interrupt();
            }
            retrieverMonitor = null;
            return allVariables;
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)"IOError getting variables", (Throwable)iOException);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_62")) + iOException.getLocalizedMessage());
            this.precipitousTerminate();
            this.fWorking = false;
            retrieverMonitor.interrupt();
            return null;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)" Error getting variables", (Throwable)exception);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_63")) + exception.getLocalizedMessage());
            this.precipitousTerminate();
            this.fWorking = false;
            retrieverMonitor.interrupt();
            return null;
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.debug((Object)" Error getting variables", throwable);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_64")) + throwable.getLocalizedMessage());
            this.precipitousTerminate();
            this.fWorking = false;
            retrieverMonitor.interrupt();
            return null;
        }
    }

    public OS2200RegisterSets getRegSets(WriterTo2200 writerTo2200) {
        RetrieverMonitor retrieverMonitor = new RetrieverMonitor(Messages.getString((String)"OS2200DebugTarget_65"), Messages.getString((String)"OS2200DebugTarget_66"), writerTo2200);
        try {
            this.fWorking = true;
            retrieverMonitor.start();
            OS2200RegisterSets oS2200RegisterSets = writerTo2200.getRegisterSets();
            this.fWorking = false;
            retrieverMonitor.setDone(true);
            retrieverMonitor.interrupt();
            return oS2200RegisterSets;
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.debug((Object)"IOError getting register sets", (Throwable)iOException);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_67")) + iOException.getLocalizedMessage());
            this.fWorking = false;
            retrieverMonitor.interrupt();
            this.precipitousTerminate();
            return null;
        }
        catch (ClassCastException classCastException) {
            OS2200CorePlugin.logger.debug((Object)"IOError getting register sets", (Throwable)classCastException);
            this.sendErrorMsg(Messages.getString((String)"OS2200DebugTarget_68"));
            this.fWorking = false;
            retrieverMonitor.interrupt();
            return null;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.debug((Object)"Error getting register sets", (Throwable)exception);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_69")) + exception.getLocalizedMessage());
            this.fWorking = false;
            retrieverMonitor.interrupt();
            this.precipitousTerminate();
            return null;
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.debug((Object)"Error getting register sets", throwable);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_70")) + throwable.getLocalizedMessage());
            this.fWorking = false;
            retrieverMonitor.interrupt();
            this.precipitousTerminate();
            return null;
        }
    }

    void precipitousTerminate() {
        this.fStarted = false;
        this.fTerminated = true;
        this.endThreads();
        if (this.bkpMgr != null && this.bkpListener != null) {
            this.bkpMgr.removeBreakpointListener((IBreakpointListener)this.bkpListener);
            this.bkpMgr.removeBreakpointManagerListener((IBreakpointManagerListener)this.bkpListener);
            this.bkpListener.dispose();
        }
        if (this.debugConn != null) {
            this.debugConn.terminateIt();
        }
        this.fDisconnected = true;
        this.fireTerminateEvent();
    }

    protected synchronized OS2200StackFrame[] getStackFrames(OS2200Thread oS2200Thread) throws DebugException {
        int n = 0;
        if (this.fStarted && !this.fTerminated) {
            OS2200CorePlugin.logger.debug((Object)"Target getting stack frames");
            try {
                OS2200StackFrame[] oS2200StackFrameArray;
                WalkbackPoint walkbackPoint = this.dbWriter.getStack();
                ArrayList<OS2200StackFrame> arrayList = new ArrayList<OS2200StackFrame>();
                String string = this.stpPt.getStopElement();
                this.stpPt.setBlockNumber(this.procList.getBlock(string));
                OS2200StackFrame oS2200StackFrame = new OS2200StackFrame(oS2200Thread, this.stpPt, this, n++);
                arrayList.add(oS2200StackFrame);
                while (walkbackPoint.getNextWalkbackPoint() != null) {
                    oS2200StackFrameArray = walkbackPoint.getStopElement();
                    walkbackPoint.setBlockNumber(this.procList.getBlock((String)oS2200StackFrameArray));
                    OS2200StackFrame oS2200StackFrame2 = new OS2200StackFrame(oS2200Thread, (StopPoint)walkbackPoint, this, n++);
                    arrayList.add(oS2200StackFrame2);
                    walkbackPoint = walkbackPoint.getNextWalkbackPoint();
                }
                oS2200StackFrameArray = new OS2200StackFrame[arrayList.size()];
                oS2200StackFrameArray = arrayList.toArray(oS2200StackFrameArray);
                this.lastSF = oS2200StackFrameArray;
                return oS2200StackFrameArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.abort("Unable to retrieve stack frames", exception);
                return new OS2200StackFrame[0];
            }
        }
        return new OS2200StackFrame[0];
    }

    protected void step(WriterTo2200 writerTo2200) throws DebugException {
        OS2200CorePlugin.logger.debug((Object)"doing step");
        this.resumed();
        this.startRun();
        String string = "";
        try {
            string = writerTo2200.step();
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.info((Object)"IOError on step", (Throwable)iOException);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_71")) + iOException.getLocalizedMessage());
            this.precipitousTerminate();
        }
        if (!string.equals("")) {
            OS2200CorePlugin.logger.debug((Object)("Message doing step " + string));
            if (string.indexOf("REMOVE STEP") >= 0) {
                OS2200CorePlugin.logger.debug((Object)"doing a remove step");
                String string2 = writerTo2200.removeStep();
                if (string2.equals("")) {
                    try {
                        string = writerTo2200.step();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError on Step", (Throwable)iOException);
                        this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_72")) + iOException.getLocalizedMessage());
                        this.precipitousTerminate();
                    }
                    if (!string.equals("")) {
                        OS2200CorePlugin.logger.info((Object)("cannot do step \n" + string));
                    }
                } else {
                    MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200DebugTarget_73"), (String)string2);
                    OS2200CorePlugin.logger.info((Object)("cannot do remove Step \n" + string2));
                }
            }
        }
    }

    protected void stepOver(WriterTo2200 writerTo2200) throws DebugException {
        if (this.isSuspended()) {
            this.resumed();
            this.startRun();
            String string = "";
            try {
                string = writerTo2200.stepOver();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.info((Object)"IOError on StepOver", (Throwable)iOException);
                this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_74")) + iOException.getLocalizedMessage());
                this.precipitousTerminate();
                return;
            }
            if (!string.equals("")) {
                OS2200CorePlugin.logger.debug((Object)("Message doing stepOver " + string));
                if (string.indexOf("REMOVE STEP") >= 0) {
                    OS2200CorePlugin.logger.debug((Object)"doing a remove step");
                    String string2 = writerTo2200.removeStep();
                    if (string2.equals("")) {
                        try {
                            string = writerTo2200.stepOver();
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.info((Object)"IOError on StepOver", (Throwable)iOException);
                            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_75")) + iOException.getLocalizedMessage());
                            this.precipitousTerminate();
                            return;
                        }
                        if (!string.equals("")) {
                            MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200DebugTarget_76"), (String)string);
                            OS2200CorePlugin.logger.info((Object)("cannot do stepOver \n" + string));
                        }
                    } else {
                        MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200DebugTarget_77"), (String)string2);
                        OS2200CorePlugin.logger.info((Object)("cannot do remove Step \n" + string2));
                    }
                }
            }
        }
    }

    protected void stepInto(WriterTo2200 writerTo2200) throws DebugException {
        if (this.isSuspended()) {
            this.resumed();
            this.startRun();
            String string = "";
            try {
                string = writerTo2200.stepInto();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.info((Object)"IOError on StepInto", (Throwable)iOException);
                this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_78")) + iOException.getLocalizedMessage());
                this.precipitousTerminate();
            }
            if (!string.equals("")) {
                OS2200CorePlugin.logger.debug((Object)("Message doing stepInto " + string));
                if (string.indexOf("REMOVE STEP") >= 0) {
                    OS2200CorePlugin.logger.debug((Object)"doing a remove step");
                    String string2 = writerTo2200.removeStep();
                    if (string2.equals("")) {
                        try {
                            string = writerTo2200.stepInto();
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.info((Object)"IOError on StepInto", (Throwable)iOException);
                            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_79")) + iOException.getLocalizedMessage());
                            this.precipitousTerminate();
                        }
                        if (!string.equals("")) {
                            MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200DebugTarget_80"), (String)string);
                            OS2200CorePlugin.logger.info((Object)("cannot do stepInto \n" + string));
                        }
                    } else {
                        MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200DebugTarget_81"), (String)string2);
                        OS2200CorePlugin.logger.info((Object)("cannot do remove Step \n" + string2));
                    }
                }
            }
        }
    }

    public int getNextTrapId() {
        return ++this.lastTrapId;
    }

    protected void stepReturn(WriterTo2200 writerTo2200) throws DebugException {
        this.startRun();
        String string = "";
        try {
            string = writerTo2200.stepOut();
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.info((Object)"IOError on StepOut", (Throwable)iOException);
            this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_82")) + iOException.getLocalizedMessage());
            this.precipitousTerminate();
        }
        if (!string.equals("")) {
            OS2200CorePlugin.logger.debug((Object)("Message doing stepOut " + string));
            if (string.indexOf("REMOVE STEP") >= 0) {
                OS2200CorePlugin.logger.debug((Object)"doing a remove step");
                String string2 = writerTo2200.removeStep();
                if (string2.equals("")) {
                    try {
                        string = writerTo2200.stepOut();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError on StepOut", (Throwable)iOException);
                        this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_83")) + iOException.getLocalizedMessage());
                        this.precipitousTerminate();
                    }
                    if (!string.equals("")) {
                        MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200DebugTarget_84"), (String)string);
                        OS2200CorePlugin.logger.info((Object)("cannot do stepOut \n" + string));
                    }
                } else {
                    MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200DebugTarget_85"), (String)string2);
                    OS2200CorePlugin.logger.info((Object)("cannot do remove Step \n" + string2));
                }
            }
        }
    }

    public void setMonitorMessage(String string) {
        this.startMonitorMessage = string;
    }

    public OS2200BreakpointListener getBreakpointListener() {
        return this.bkpListener;
    }

    public void addValList(OS2200StackFrame oS2200StackFrame) {
        this.valLists.add(new ValueMemory(oS2200StackFrame));
    }

    public ValueMemory getValList(OS2200StackFrame oS2200StackFrame) {
        ValueMemory valueMemory2;
        for (ValueMemory valueMemory2 : this.valLists) {
            if (!valueMemory2.sameFrame(oS2200StackFrame)) continue;
            return valueMemory2;
        }
        valueMemory2 = new ValueMemory(oS2200StackFrame);
        this.valLists.add(valueMemory2);
        return valueMemory2;
    }

    class ConnectionMonitor
    extends Thread
    implements Runnable {
        boolean keepGoing;
        int waitTime = 500;
        boolean halting;
        private IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                OS2200CorePlugin.logger.debug((Object)"starting ");
                ConnectionMonitor.this.keepGoing = true;
                ConnectionMonitor.this.halting = false;
                iProgressMonitor.beginTask(Messages.getString((String)"OS2200DebugTarget_86"), 15);
                iProgressMonitor.subTask(Messages.getString((String)"OS2200DebugTarget_87"));
                while (ConnectionMonitor.this.keepGoing) {
                    try {
                        Thread.sleep(ConnectionMonitor.this.waitTime);
                        if (iProgressMonitor.isCanceled() && !ConnectionMonitor.this.halting) {
                            ConnectionMonitor.this.halting = true;
                            OS2200DebugTarget.this.halt();
                            return;
                        }
                        iProgressMonitor.subTask(OS2200DebugTarget.this.startMonitorMessage);
                    }
                    catch (InterruptedException interruptedException) {
                        OS2200CorePlugin.logger.debug((Object)"interrupted ");
                        return;
                    }
                }
            }
        };

        ConnectionMonitor() {
        }

        @Override
        public void interrupt() {
            this.keepGoing = false;
        }

        public boolean running() {
            return this.keepGoing && !this.halting;
        }

        @Override
        public void run() {
            Display display;
            IWorkbenchWindow iWorkbenchWindow = OS2200FileInterface.UIActiveWindow();
            Shell shell = null;
            if (iWorkbenchWindow != null) {
                shell = iWorkbenchWindow.getShell();
            }
            if ((display = Display.getCurrent()) == null) {
                display = Display.getDefault();
            }
            StartingDebugMonitor startingDebugMonitor = new StartingDebugMonitor(shell);
            display.syncExec(new Runnable((IRunnableContext)startingDebugMonitor){
                private final /* synthetic */ IRunnableContext val$context;
                {
                    this.val$context = iRunnableContext;
                }

                @Override
                public void run() {
                    try {
                        this.val$context.run(true, true, ConnectionMonitor.this.operation);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        OS2200CorePlugin.logger.warn((Object)"Exception from wait for connect", (Throwable)invocationTargetException);
                    }
                    catch (InterruptedException interruptedException) {
                        OS2200CorePlugin.logger.warn((Object)"Exception from wait for connect", (Throwable)interruptedException);
                        return;
                    }
                }
            });
        }
    }

    class DebugListen
    extends DebugListener {
        DebugListen() {
        }

        public void debugCall(DebugCallback debugCallback) {
            MessageType messageType = debugCallback.getCallType();
            switch (messageType) {
                case tpMonitorMessage: {
                    OS2200DebugTarget.this.startMonitorMessage = (String)debugCallback.getCallThing();
                    break;
                }
                case tpINITIAL: {
                    if (!OS2200DebugTarget.this.fInitialized) {
                        OS2200DebugTarget.this.fInitialized = true;
                        OS2200CorePlugin.logger.debug((Object)"Initial called in Debug");
                        OS2200DebugTarget.this.fDisconnected = false;
                        if (OS2200DebugTarget.this.versionPads == null) {
                            OS2200DebugTarget.this.versionPads = OS2200DebugTarget.this.debugConn.getPadsLibLevel();
                        }
                        if (OS2200DebugTarget.this.versionPads == null) {
                            String string = String.valueOf(Messages.getString((String)"OS2200DebugTarget_0")) + Messages.getString((String)"OS2200DebugTarget_1") + OS2200DebugPlugin.getDefault().readPadsLibVersion();
                            OS2200DebugTarget.this.sendErrorMsg(string);
                            OS2200DebugTarget.this.precipitousTerminate();
                            break;
                        }
                        OS2200DebugTarget.this.inf = (ProgramInfo)debugCallback.getCallThing();
                        DebugSocketControl debugSocketControl = debugCallback.getCallerControl();
                        OS2200DebugTarget.this.dbWriter = debugSocketControl.getWriter();
                        try {
                            OS2200DebugTarget.this.pProcLvl = OS2200DebugTarget.this.dbWriter.getPadsLibProcLevel();
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.info((Object)"IOError on Getting PadsLib Proc LEvel", (Throwable)iOException);
                            OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_2")) + iOException.getLocalizedMessage());
                            OS2200DebugTarget.this.precipitousTerminate();
                            break;
                        }
                        if (OS2200DebugTarget.this.pProcLvl.indexOf("Procedure PADSLBPRCLVL not found") > 0) {
                            String string = String.valueOf(Messages.getString((String)"OS2200DebugTarget_3")) + Messages.getString((String)"OS2200DebugTarget_4") + OS2200DebugPlugin.getDefault().readPadsLibVersion();
                            OS2200DebugTarget.this.sendErrorMsg(string);
                            OS2200DebugTarget.this.precipitousTerminate();
                            break;
                        }
                        PadsLibVersionChecker padsLibVersionChecker = new PadsLibVersionChecker(OS2200DebugTarget.this.pProcLvl);
                        if (!padsLibVersionChecker.isCompatible()) {
                            String string = String.valueOf(Messages.getString((String)"OS2200DebugTarget_5")) + OS2200DebugTarget.this.versionPads + Messages.getString((String)"OS2200DebugTarget_6") + Messages.getString((String)"OS2200DebugTarget_7") + padsLibVersionChecker.getPadsRange();
                            OS2200DebugTarget.this.sendErrorMsg(string);
                            OS2200DebugTarget.this.precipitousTerminate();
                            break;
                        }
                        String string = OS2200DebugTarget.this.inf.getOmElt();
                        OS2200DebugTarget.this.setMonitorMessage(Messages.getString((String)"OS2200DebugTarget_8"));
                        try {
                            OS2200DebugTarget.this.omToSource = OS2200DebugTarget.this.dbWriter.getOMSDD(string);
                        }
                        catch (IOException iOException) {
                            OS2200CorePlugin.logger.info((Object)"IOError on Getting OM list", (Throwable)iOException);
                            OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_9")) + iOException.getLocalizedMessage());
                            OS2200DebugTarget.this.precipitousTerminate();
                            break;
                        }
                        if (OS2200DebugTarget.this.omToSource == null) {
                            OS2200CorePlugin.logger.info((Object)"timeout on Getting OM list");
                            OS2200DebugTarget.this.sendErrorMsg(Messages.getString((String)"OS2200DebugTarget_10"));
                            OS2200DebugTarget.this.precipitousTerminate();
                            break;
                        }
                        OS2200CorePlugin.logger.debug((Object)"done with geting om SDDs");
                        OS2200DebugTarget.this.setMonitorMessage(Messages.getString((String)"OS2200DebugTarget_11"));
                        OS2200DebugTarget.this.makeSrcToOMMap(OS2200DebugTarget.this.proj2200, string);
                        if (!OS2200DebugTarget.this.processThreads(OS2200DebugTarget.this.dbWriter)) break;
                        OS2200DebugTarget.this.suspended(4);
                        OS2200DebugTarget.this.setMonitorMessage(Messages.getString((String)"OS2200DebugTarget_12"));
                        OS2200DebugTarget.this.initBreakpoints();
                        OS2200DebugTarget.this.fStarted = true;
                        OS2200DebugTarget.this.fSuspended = true;
                        OS2200DebugTarget.this.fireCreationEvent();
                        ArrayList<IBreakpoint> arrayList = OS2200DebugTarget.this.bkpListener.getBkptList();
                        switch (OS2200DebugTarget.this.dbStop) {
                            case firstLine: {
                                OS2200DebugTarget.this.setMonitorMessage(Messages.getString((String)"OS2200DebugTarget_13"));
                                StartLineInfo startLineInfo = OS2200DebugTarget.this.processStartLine();
                                if (startLineInfo != null && startLineInfo.getStartLineNumber() != -1) {
                                    try {
                                        OS2200DebugTarget.this.setMonitorMessage(Messages.getString((String)"OS2200DebugTarget_14"));
                                        OS2200DebugTarget.this.dbWriter.setBrkpt(string, OS2200DebugTarget.this.getEltVer(startLineInfo.getStartElemetn()), Integer.toString(startLineInfo.getStartLineNumber()));
                                    }
                                    catch (IOException iOException) {
                                        OS2200CorePlugin.logger.info((Object)"IOError on Setting Breakpoint", (Throwable)iOException);
                                        OS2200DebugTarget.this.connMonitor.interrupt();
                                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_15")) + iOException.getLocalizedMessage());
                                        OS2200DebugTarget.this.precipitousTerminate();
                                    }
                                    break;
                                }
                                if (startLineInfo != null) {
                                    OS2200DebugTarget.this.sendErrorMsg(startLineInfo.getErrorMessage());
                                } else {
                                    OS2200DebugTarget.this.sendErrorMsg(Messages.getString((String)"OS2200DebugTarget_16"));
                                }
                                try {
                                    OS2200DebugTarget.this.dbWriter.EndSession();
                                }
                                catch (IOException iOException) {
                                    OS2200DebugTarget.this.connMonitor.interrupt();
                                    OS2200CorePlugin.logger.info((Object)"IOError on EndSession", (Throwable)iOException);
                                    OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_17")) + iOException.getLocalizedMessage());
                                    OS2200DebugTarget.this.precipitousTerminate();
                                }
                                break;
                            }
                            case firstLineNoBkpt: {
                                if (arrayList != null && arrayList.size() != 0) break;
                                OS2200DebugTarget.this.setMonitorMessage(Messages.getString((String)"OS2200DebugTarget_18"));
                                StartLineInfo startLineInfo = OS2200DebugTarget.this.processStartLine();
                                if (startLineInfo != null && startLineInfo.getStartLineNumber() != -1) {
                                    try {
                                        OS2200DebugTarget.this.setMonitorMessage(Messages.getString((String)"OS2200DebugTarget_19"));
                                        OS2200DebugTarget.this.dbWriter.setBrkpt(string, OS2200DebugTarget.this.getEltVer(startLineInfo.getStartElemetn()), Integer.toString(startLineInfo.getStartLineNumber()));
                                    }
                                    catch (IOException iOException) {
                                        OS2200DebugTarget.this.connMonitor.interrupt();
                                        OS2200CorePlugin.logger.info((Object)"IOError on Setting Breakpoint", (Throwable)iOException);
                                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_20")) + iOException.getLocalizedMessage());
                                        OS2200DebugTarget.this.precipitousTerminate();
                                    }
                                    break;
                                }
                                if (startLineInfo != null) {
                                    OS2200DebugTarget.this.sendErrorMsg(startLineInfo.getErrorMessage());
                                } else {
                                    OS2200DebugTarget.this.sendErrorMsg(Messages.getString((String)"OS2200DebugTarget_21"));
                                }
                                try {
                                    OS2200DebugTarget.this.dbWriter.EndSession();
                                }
                                catch (IOException iOException) {
                                    OS2200DebugTarget.this.connMonitor.interrupt();
                                    OS2200CorePlugin.logger.info((Object)"IOError on EndSession", (Throwable)iOException);
                                    OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_22")) + iOException.getLocalizedMessage());
                                    OS2200DebugTarget.this.precipitousTerminate();
                                }
                                break;
                            }
                        }
                        try {
                            OS2200DebugTarget.this.setMonitorMessage(Messages.getString((String)"OS2200DebugTarget_23"));
                            if (!OS2200DebugTarget.this.processRun(OS2200DebugTarget.this.dbWriter)) {
                                OS2200DebugTarget.this.connMonitor.interrupt();
                                OS2200CorePlugin.logger.info((Object)"Failure to write first run");
                                OS2200DebugTarget.this.sendErrorMsg(Messages.getString((String)"OS2200DebugTarget_24"));
                                OS2200DebugTarget.this.precipitousTerminate();
                            }
                        }
                        catch (IOException iOException) {
                            OS2200DebugTarget.this.connMonitor.interrupt();
                            OS2200CorePlugin.logger.info((Object)"IOError on Run", (Throwable)iOException);
                            OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_25")) + iOException.getLocalizedMessage());
                            OS2200DebugTarget.this.precipitousTerminate();
                        }
                        OS2200DebugTarget.this.connMonitor.interrupt();
                        break;
                    }
                    OS2200CorePlugin.logger.debug((Object)"initialize called twice");
                    break;
                }
                case tpWrongID: {
                    String string = (String)debugCallback.getCallThing();
                    String string2 = String.valueOf(Messages.getString((String)"OS2200DebugTarget_26")) + "'" + OS2200DebugTarget.this.debugID + Messages.getString((String)"OS2200DebugTarget_27") + string + Messages.getString((String)"OS2200DebugTarget_28");
                    OS2200DebugTarget.this.sendErrorMsg(string2);
                    try {
                        debugCallback.getCallerControl().getWriter().EndSession();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError on EndSession", (Throwable)iOException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_29")) + iOException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                    }
                    break;
                }
                case tpPADSLIB_LEVEL: {
                    OS2200DebugTarget.this.versionPads = (String)debugCallback.getCallThing();
                    PadsLibVersionChecker padsLibVersionChecker = new PadsLibVersionChecker(OS2200DebugTarget.this.versionPads);
                    if (padsLibVersionChecker.isCompatible()) break;
                    String string = String.valueOf(Messages.getString((String)"OS2200DebugTarget_30")) + OS2200DebugTarget.this.versionPads + Messages.getString((String)"OS2200DebugTarget_31") + Messages.getString((String)"OS2200DebugTarget_32") + padsLibVersionChecker.getPadsRange();
                    OS2200DebugTarget.this.sendErrorMsg(string);
                    OS2200DebugTarget.this.precipitousTerminate();
                    break;
                }
                case tpSTEP: {
                    OS2200DebugTarget.this.fSuspended = false;
                    OS2200DebugTarget.this.stpPt = (StopPoint)debugCallback.getCallThing();
                    try {
                        OS2200DebugTarget.this.dbWriter = debugCallback.getCallerControl().getWriter();
                        OS2200DebugTarget.this.procList = OS2200DebugTarget.this.dbWriter.getAllProcs(OS2200DebugTarget.this.stpPt, OS2200DebugTarget.this.procList);
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError processing stop", (Throwable)iOException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_33")) + iOException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                        break;
                    }
                    OS2200DebugTarget.this.checkPerspective();
                    if (OS2200DebugTarget.this.processThreads(OS2200DebugTarget.this.dbWriter)) {
                        OS2200DebugTarget.this.suspended(8);
                        break;
                    }
                    OS2200DebugTarget.this.precipitousTerminate();
                    break;
                }
                case tpTRAP_EXECUTION: {
                    OS2200CorePlugin.logger.debug((Object)"trap execution");
                    OS2200DebugTarget.this.fSuspended = false;
                    OS2200DebugTarget.this.stpPt = (StopPoint)debugCallback.getCallThing();
                    try {
                        OS2200DebugTarget.this.dbWriter = debugCallback.getCallerControl().getWriter();
                        if (OS2200DebugTarget.this.dbWriter == null) {
                            OS2200CorePlugin.logger.info((Object)"bad writer");
                        }
                        OS2200DebugTarget.this.procList = OS2200DebugTarget.this.processProcs(OS2200DebugTarget.this.stpPt, OS2200DebugTarget.this.procList, OS2200DebugTarget.this.dbWriter);
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError processing stop", (Throwable)iOException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_34")) + iOException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                        break;
                    }
                    if (OS2200DebugTarget.this.procList == null) {
                        OS2200DebugTarget.this.precipitousTerminate();
                        break;
                    }
                    OS2200DebugTarget.this.checkPerspective();
                    if (OS2200DebugTarget.this.processThreads(OS2200DebugTarget.this.dbWriter)) {
                        OS2200DebugTarget.this.suspended(16);
                        break;
                    }
                    OS2200DebugTarget.this.precipitousTerminate();
                    break;
                }
                case tpTRAP_CHANGE: {
                    OS2200DebugTarget.this.fSuspended = false;
                    OS2200DebugTarget.this.stpPt = (StopPoint)debugCallback.getCallThing();
                    try {
                        OS2200DebugTarget.this.dbWriter = debugCallback.getCallerControl().getWriter();
                        OS2200DebugTarget.this.procList = OS2200DebugTarget.this.dbWriter.getAllProcs(OS2200DebugTarget.this.stpPt, OS2200DebugTarget.this.procList);
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError processing stop", (Throwable)iOException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_35")) + iOException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                        break;
                    }
                    OS2200DebugTarget.this.checkPerspective();
                    if (OS2200DebugTarget.this.processThreads(OS2200DebugTarget.this.dbWriter)) {
                        OS2200DebugTarget.this.suspended(8);
                        OS2200DebugTarget.this.suspended(16);
                        break;
                    }
                    OS2200DebugTarget.this.precipitousTerminate();
                    break;
                }
                case tpTASKTERMINATE: {
                    if (!OS2200DebugTarget.this.fEnding) {
                        OS2200DebugTarget.this.fEnding = true;
                        OS2200DebugTarget.this.endThreads();
                        if (OS2200DebugTarget.this.bkpMgr != null) {
                            OS2200DebugTarget.this.bkpMgr.removeBreakpointListener((IBreakpointListener)OS2200DebugTarget.this.bkpListener);
                        }
                        OS2200DebugTarget.this.bkpMgr.removeBreakpointManagerListener((IBreakpointManagerListener)OS2200DebugTarget.this.bkpListener);
                        if (OS2200DebugTarget.this.bkpListener != null) {
                            OS2200DebugTarget.this.bkpListener.dispose();
                        }
                        OS2200DebugTarget.this.debugConn.terminateIt();
                        OS2200DebugTarget.this.fireTerminateEvent();
                        break;
                    }
                    System.out.println("still ending");
                    break;
                }
                case tpERROR_CONDITION: {
                    OS2200CorePlugin.logger.debug((Object)"Error condition called");
                    OS2200DebugTarget.this.stpPt = (StopPoint)debugCallback.getCallThing();
                    try {
                        OS2200DebugTarget.this.dbWriter = debugCallback.getCallerControl().getWriter();
                        OS2200DebugTarget.this.procList = OS2200DebugTarget.this.dbWriter.getAllProcs(OS2200DebugTarget.this.stpPt, OS2200DebugTarget.this.procList);
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError processing stop", (Throwable)iOException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_36")) + iOException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                        break;
                    }
                    OS2200DebugTarget.this.checkPerspective();
                    if (OS2200DebugTarget.this.processThreads(OS2200DebugTarget.this.dbWriter)) {
                        OS2200DebugTarget.this.suspended(8);
                        OS2200DebugTarget.this.suspended(16);
                        break;
                    }
                    OS2200DebugTarget.this.precipitousTerminate();
                    break;
                }
                case tpTRAP_CONDITION: {
                    OS2200DebugTarget.this.stpPt = (StopPoint)debugCallback.getCallThing();
                    try {
                        OS2200DebugTarget.this.dbWriter = debugCallback.getCallerControl().getWriter();
                        OS2200DebugTarget.this.procList = OS2200DebugTarget.this.dbWriter.getAllProcs(OS2200DebugTarget.this.stpPt, OS2200DebugTarget.this.procList);
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError processing stop", (Throwable)iOException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_37")) + iOException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                        break;
                    }
                    OS2200DebugTarget.this.checkPerspective();
                    if (OS2200DebugTarget.this.processThreads(OS2200DebugTarget.this.dbWriter)) {
                        OS2200DebugTarget.this.suspended(8);
                        OS2200DebugTarget.this.suspended(16);
                        break;
                    }
                    OS2200DebugTarget.this.precipitousTerminate();
                    break;
                }
                case tpTaskInit: {
                    ArrayList arrayList = null;
                    try {
                        arrayList = OS2200DebugTarget.this.dbWriter.getTaskList();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError on getting task List", (Throwable)iOException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_38")) + iOException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                        break;
                    }
                    try {
                        OS2200DebugTarget.this.createThreads(arrayList);
                    }
                    catch (DebugException debugException) {
                        OS2200CorePlugin.logger.info((Object)"Debug Exception creating initial task list", (Throwable)debugException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_39")) + debugException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                        break;
                    }
                    try {
                        OS2200DebugTarget.this.dbWriter.run();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)"IOError on Run", (Throwable)iOException);
                        OS2200DebugTarget.this.sendErrorMsg(String.valueOf(Messages.getString((String)"OS2200DebugTarget_40")) + iOException.getLocalizedMessage());
                        OS2200DebugTarget.this.precipitousTerminate();
                    }
                    break;
                }
                case tpPrestartAbort: {
                    OS2200CorePlugin.logger.debug((Object)"PreStart Abort");
                    OS2200DebugTarget.this.fDisconnected = true;
                    OS2200DebugTarget.this.fireTerminateEvent();
                    if (OS2200DebugTarget.this.connMonitor == null || !OS2200DebugTarget.this.connMonitor.running()) break;
                    OS2200DebugTarget.this.connMonitor.interrupt();
                    break;
                }
                case tpPrecipitousTerminate: {
                    OS2200CorePlugin.logger.debug((Object)"PostStart Abort");
                    OS2200DebugTarget.this.fDisconnected = true;
                    OS2200DebugTarget.this.precipitousTerminate();
                    if (OS2200DebugTarget.this.connMonitor == null || !OS2200DebugTarget.this.connMonitor.running()) break;
                    OS2200DebugTarget.this.connMonitor.interrupt();
                    break;
                }
                case tpPROGRAM_EXIT: {
                    if (!OS2200DebugTarget.this.fEnding) {
                        OS2200CorePlugin.logger.debug((Object)"Program_Exit");
                        OS2200DebugTarget.this.fEnding = true;
                        OS2200DebugTarget.this.dbWriter.onWithPads();
                        OS2200DebugTarget.this.fStarted = false;
                        OS2200DebugTarget.this.fTerminated = true;
                        OS2200DebugTarget.this.endThreads();
                        OS2200DebugTarget.this.bkpMgr.removeBreakpointListener((IBreakpointListener)OS2200DebugTarget.this.bkpListener);
                        OS2200DebugTarget.this.bkpMgr.removeBreakpointManagerListener((IBreakpointManagerListener)OS2200DebugTarget.this.bkpListener);
                        OS2200DebugTarget.this.bkpListener.dispose();
                        OS2200DebugTarget.this.debugConn.terminateIt();
                        OS2200DebugTarget.this.fDisconnected = true;
                        OS2200DebugTarget.this.fireTerminateEvent();
                        break;
                    }
                    System.out.println("still ending");
                    break;
                }
                case tpSimpleExit: {
                    if (!OS2200DebugTarget.this.fEnding) {
                        OS2200CorePlugin.logger.debug((Object)"Program_Exit");
                        OS2200DebugTarget.this.fEnding = true;
                        OS2200DebugTarget.this.fStarted = false;
                        OS2200DebugTarget.this.fTerminated = true;
                        OS2200DebugTarget.this.endThreads();
                        OS2200DebugTarget.this.bkpMgr.removeBreakpointListener((IBreakpointListener)OS2200DebugTarget.this.bkpListener);
                        OS2200DebugTarget.this.bkpMgr.removeBreakpointManagerListener((IBreakpointManagerListener)OS2200DebugTarget.this.bkpListener);
                        OS2200DebugTarget.this.bkpListener.dispose();
                        OS2200DebugTarget.this.debugConn.terminateIt();
                        OS2200DebugTarget.this.fDisconnected = true;
                        OS2200DebugTarget.this.fireTerminateEvent();
                        break;
                    }
                    System.out.println("still ending");
                }
            }
        }
    }

    class RetrieverMonitor
    extends Thread
    implements Runnable {
        boolean keepGoing;
        int waitTime = 500;
        boolean started;
        boolean done;
        boolean interrupted;
        String mainHeading;
        String firstTask;
        WriterTo2200 write2200;
        private IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                OS2200CorePlugin.logger.debug((Object)"starting retriever dialog");
                RetrieverMonitor.this.done = false;
                iProgressMonitor.beginTask(RetrieverMonitor.this.mainHeading, 15);
                iProgressMonitor.subTask(RetrieverMonitor.this.firstTask);
                while (RetrieverMonitor.this.keepGoing && !RetrieverMonitor.this.interrupted) {
                    try {
                        Thread.sleep(RetrieverMonitor.this.waitTime);
                        if (iProgressMonitor.isCanceled()) {
                            OS2200CorePlugin.logger.debug((Object)"retrieval cancelled");
                            RetrieverMonitor.this.keepGoing = false;
                            RetrieverMonitor.this.interrupted = true;
                        }
                        iProgressMonitor.subTask(OS2200DebugTarget.this.retrieveMonitorMessage);
                    }
                    catch (InterruptedException interruptedException) {
                        OS2200CorePlugin.logger.debug((Object)"interrupted ");
                        return;
                    }
                }
            }
        };

        public RetrieverMonitor(String string, String string2, WriterTo2200 writerTo2200) {
            this.mainHeading = string;
            this.firstTask = string2;
            OS2200DebugTarget.this.retrieveMonitorMessage = string2;
            this.keepGoing = false;
            this.interrupted = false;
            this.done = false;
            this.write2200 = writerTo2200;
        }

        @Override
        public void interrupt() {
            OS2200CorePlugin.logger.debug((Object)"interrupting retriever dialog");
            this.keepGoing = false;
            this.interrupted = true;
        }

        public boolean running() {
            return this.keepGoing;
        }

        @Override
        public void run() {
            Display display;
            IWorkbenchWindow iWorkbenchWindow = OS2200FileInterface.UIActiveWindow();
            Shell shell = null;
            if (iWorkbenchWindow != null) {
                shell = iWorkbenchWindow.getShell();
            }
            if (shell == null) {
                OS2200CorePlugin.logger.debug((Object)"shell is null");
            }
            if ((display = Display.getCurrent()) == null) {
                display = Display.getDefault();
            }
            StartingDebugMonitor startingDebugMonitor = new StartingDebugMonitor(shell);
            display.syncExec(new Runnable((IRunnableContext)startingDebugMonitor){
                private final /* synthetic */ IRunnableContext val$context;
                {
                    this.val$context = iRunnableContext;
                }

                @Override
                public void run() {
                    try {
                        RetrieverMonitor.this.keepGoing = true;
                        this.val$context.run(true, true, RetrieverMonitor.this.operation);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        OS2200CorePlugin.logger.warn((Object)"Exception from wait for connect", (Throwable)invocationTargetException);
                    }
                    catch (InterruptedException interruptedException) {
                        OS2200CorePlugin.logger.warn((Object)"Exception from wait for connect", (Throwable)interruptedException);
                        return;
                    }
                }
            });
        }

        public void setDone(boolean bl) {
            this.done = bl;
        }
    }

    class workfileAndProject {
        String workfile;
        IProject proj;

        workfileAndProject(String string, IProject iProject) {
            this.workfile = string;
            this.proj = iProject;
        }
    }
}

