/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.model;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.ProjectProperties;
import com.unisys.tde.debug.core.comm.OS2200DebugConnect;
import com.unisys.tde.debug.core.comm.WriterTo2200;
import com.unisys.tde.debug.core.model.OS2200DebugTarget;
import com.unisys.tde.debug.core.model.OS2200OmDescriptor;
import com.unisys.tde.debug.core.model.OS2200Variable;
import com.unisys.tde.debug.core.model.OS2200Watchpoint;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.services.IDisposable;

public class OS2200BreakpointListener
implements IBreakpointListener,
IBreakpointManagerListener,
IDisposable {
    OS2200DebugTarget uTarget;
    IBreakpointManager bkpMgr;
    OS2200DebugConnect osConn;
    private ArrayList<IBreakpoint> bkpList;
    Hashtable<String, OS2200OmDescriptor> srcTbl;
    boolean bkpMgrEnabled;
    static final String CSource = "org.eclipse.cdt.debug.core.sourceHandle";
    static final String CBLSource = "org.eclipse.cobol.core.debug.sourceName";
    static final String CDbCore = "org.eclipse.cdt.debug.core";
    static final String CBLDb = "org.eclipse.cobol.debug";
    static final String OS2200Model = "com.unisys.tde.debug.os2200";
    static final String dbCoreId = "org.eclipse.debug.core.id";
    static final String dbEnabled = "org.eclipse.debug.core.enabled";
    static final String dbLineNum = "lineNumber";
    static final String osLineNum = "com.unisys.os2200.actual.line";
    static final String dbMessage = "message";
    static final String alreadySet = "*E5302";

    public OS2200BreakpointListener(OS2200DebugTarget oS2200DebugTarget) {
        this.uTarget = oS2200DebugTarget;
        this.bkpMgr = this.uTarget.getBreakpointManager();
        this.srcTbl = this.uTarget.gotSrcToOm();
        this.osConn = this.uTarget.debugConn;
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        if (!this.bkpList.contains(iBreakpoint)) {
            this.setOSBkpt(iBreakpoint);
        }
    }

    public ArrayList<IBreakpoint> getBkptList() {
        return this.bkpList;
    }

    private void setOSBkpt(IBreakpoint iBreakpoint) {
        OS2200CorePlugin.logger.debug((Object)"Setting Brkpt");
        try {
            Shell shell = OS2200FileInterface.UIActiveWindow().getShell();
            iBreakpoint.isEnabled();
            IMarker iMarker = iBreakpoint.getMarker();
            Boolean bl = iMarker.getAttribute(dbEnabled, false);
            if (bl.booleanValue()) {
                if (iBreakpoint instanceof OS2200Watchpoint) {
                    this.setWatchpoint(iBreakpoint, iMarker, shell);
                } else {
                    this.setLineBreakpoint(iBreakpoint, iMarker, shell);
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Internal Error", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"error handling brkpt list", (Throwable)exception);
        }
    }

    String getLookupName(IFile iFile) {
        ProjectProperties projectProperties = new ProjectProperties();
        String string = projectProperties.getPropertyFor((IResource)iFile, "NativeName");
        if (string == null) {
            IPath iPath = iFile.getRawLocation();
            string = iPath.lastSegment();
        } else {
            string = string.replace('/', '.');
        }
        return string.toLowerCase();
    }

    void setLineBreakpoint(IBreakpoint iBreakpoint, IMarker iMarker, Shell shell) throws Exception {
        IFile iFile;
        String string;
        OS2200OmDescriptor oS2200OmDescriptor;
        String string2 = (String)iMarker.getAttribute(dbCoreId);
        if (string2 != null && (oS2200OmDescriptor = this.srcTbl.get(string = this.getLookupName(iFile = (IFile)iMarker.getResource()))) != null) {
            String string3 = Integer.toString(iMarker.getAttribute(dbLineNum, 0));
            this.osConn.setLastErrorMessage("");
            WriterTo2200 writerTo2200 = this.uTarget.getAvailableWriter();
            String string4 = writerTo2200.setBrkpt(oS2200OmDescriptor.getOmEltDesc(), oS2200OmDescriptor.getOmName(), string3);
            if (!string4.equals("")) {
                int n = string4.indexOf(string3);
                if (n > 0) {
                    int n2 = string4.indexOf(" ", n);
                    if (n2 > 0) {
                        this.osConn.setLastErrorMessage("");
                        String string5 = string4.substring(n, n2).trim();
                        String string6 = writerTo2200.setBrkpt(oS2200OmDescriptor.getOmEltDesc(), oS2200OmDescriptor.getOmName(), string5);
                        if (!string6.equals("") && string6.indexOf(alreadySet) < 0) {
                            OS2200CorePlugin.logger.debug((Object)("error altering brkpt " + string6));
                            this.bkpMgr.removeBreakpoint(iBreakpoint, true);
                            if (shell != null) {
                                MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200BreakpointListener_0"), (String)(String.valueOf(Messages.getString((String)"OS2200BreakpointListener_1")) + this.removeMsgHead(string6)));
                            }
                        } else {
                            iMarker.setAttribute(osLineNum, (Object)string5);
                            this.bkpList.add(iBreakpoint);
                        }
                    } else {
                        OS2200CorePlugin.logger.debug((Object)("error adding brkpt " + string4));
                        this.bkpMgr.removeBreakpoint(iBreakpoint, true);
                        if (shell != null) {
                            MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200BreakpointListener_2"), (String)(String.valueOf(Messages.getString((String)"OS2200BreakpointListener_3")) + this.removeMsgHead(string4)));
                        }
                    }
                } else if (string4.indexOf("Specified location is already the subject of a breakpoint") >= 0) {
                    iMarker.setAttribute(osLineNum, (Object)string3);
                    this.bkpList.add(iBreakpoint);
                } else {
                    this.bkpMgr.removeBreakpoint(iBreakpoint, true);
                    if (shell != null) {
                        MessageDialog.openError((Shell)OS2200FileInterface.UIActiveWindow().getShell(), (String)Messages.getString((String)"OS2200BreakpointListener_4"), (String)(String.valueOf(Messages.getString((String)"OS2200BreakpointListener_5")) + this.removeMsgHead(string4)));
                    }
                }
            } else {
                iMarker.setAttribute(osLineNum, (Object)string3);
                this.bkpList.add(iBreakpoint);
            }
        }
    }

    void setWatchpoint(IBreakpoint iBreakpoint, IMarker iMarker, Shell shell) throws Exception {
        IProject iProject;
        IResource iResource;
        String string = iMarker.getAttribute(dbCoreId, "generic");
        if (string.equals(OS2200Model) && iBreakpoint instanceof OS2200Watchpoint && (iResource = iMarker.getResource()) instanceof IProject && (iProject = (IProject)iResource).getName().equals(this.uTarget.getProject().getName())) {
            String string2 = (String)iMarker.getAttribute("com.unisys.tde.debug.core.variableName");
            String string3 = (String)iMarker.getAttribute("com.unisys.tde.debug.core.omElt");
            String string4 = (String)iMarker.getAttribute("com.unisys.tde.debug.core.omPart");
            int n = this.uTarget.getNextTrapId();
            String string5 = Integer.toString(n);
            iMarker.setAttribute("com.unisys.tde.debug.core.trapNumber", (Object)string5);
            String string6 = (String)iMarker.getAttribute("com.unisys.tde.debug.core.blockNum");
            int n2 = Integer.parseInt(string6);
            WriterTo2200 writerTo2200 = this.uTarget.getAvailableWriter();
            writerTo2200.setVariableTrap(string2, n, string3, string4, n2);
            OS2200Watchpoint oS2200Watchpoint = (OS2200Watchpoint)iBreakpoint;
            OS2200Variable oS2200Variable = oS2200Watchpoint.getVariable();
            if (oS2200Variable != null) {
                oS2200Variable.setWatchpointToggle(true);
            }
            this.bkpList.add(iBreakpoint);
        }
    }

    void removeWatchPoint(OS2200Watchpoint oS2200Watchpoint, IMarker iMarker) throws Exception {
        IProject iProject;
        IResource iResource;
        String string = iMarker.getAttribute(dbCoreId, "generic");
        if (string.equals(OS2200Model) && (iResource = iMarker.getResource()) instanceof IProject && (iProject = (IProject)iResource).getName().equals(this.uTarget.getProject().getName())) {
            String string2 = (String)iMarker.getAttribute("com.unisys.tde.debug.core.trapNumber");
            int n = Integer.parseInt(string2);
            WriterTo2200 writerTo2200 = this.uTarget.getAvailableWriter();
            writerTo2200.removeTrapChange(n);
            if (this.bkpList.contains((Object)oS2200Watchpoint)) {
                this.bkpList.remove((Object)oS2200Watchpoint);
            }
            OS2200Watchpoint oS2200Watchpoint2 = oS2200Watchpoint;
            OS2200Variable oS2200Variable = oS2200Watchpoint2.getVariable();
            oS2200Variable.setWatchpointToggle(false);
        }
    }

    public void addToArray(IBreakpoint iBreakpoint) {
        for (IBreakpoint iBreakpoint2 : this.bkpList) {
            if (!iBreakpoint2.equals(iBreakpoint)) continue;
            return;
        }
        this.bkpList.add(iBreakpoint);
    }

    String removeMsgHead(String string) {
        int n = string.indexOf("21 ");
        if (n >= 0) {
            return string.substring(n + 3);
        }
        return string;
    }

    public void dispose() {
        this.uTarget = null;
        this.bkpMgr = null;
        this.bkpList = null;
    }

    private void removeOSBkpt(IBreakpoint iBreakpoint) {
        OS2200CorePlugin.logger.debug((Object)"Removing Brkpt");
        try {
            IMarker iMarker = iBreakpoint.getMarker();
            Boolean cfr_ignored_0 = (Boolean)iMarker.getAttribute(dbEnabled);
            String string = (String)iMarker.getAttribute(dbCoreId);
            if (string != null) {
                OS2200CorePlugin.logger.debug((Object)("Breakpoint type removing breakpoint " + string));
                if (iBreakpoint instanceof OS2200Watchpoint) {
                    this.removeWatchPoint((OS2200Watchpoint)iBreakpoint, iMarker);
                } else {
                    Object object;
                    IFile iFile = (IFile)iMarker.getResource();
                    String string2 = this.getLookupName(iFile);
                    OS2200OmDescriptor oS2200OmDescriptor = this.srcTbl.get(string2);
                    String string3 = (String)iMarker.getAttribute(osLineNum);
                    if (string3 == null) {
                        object = (Integer)iMarker.getAttribute(dbLineNum);
                        string3 = ((Integer)object).toString();
                    }
                    object = this.uTarget.getAvailableWriter();
                    object.removeBrkpt(oS2200OmDescriptor.getOmEltDesc(), oS2200OmDescriptor.getOmName(), string3);
                    if (this.bkpList.contains(iBreakpoint)) {
                        this.bkpList.remove(iBreakpoint);
                    }
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Internal Error", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"error handling brkpt list", (Throwable)exception);
        }
    }

    public void initBrkptSet() {
        OS2200CorePlugin.logger.debug((Object)"Initializing Brkpts");
        try {
            this.bkpMgrEnabled = this.bkpMgr.isEnabled();
            if (this.bkpMgrEnabled) {
                this.bkpList = new ArrayList();
                IBreakpoint[] iBreakpointArray = this.bkpMgr.getBreakpoints();
                OS2200CorePlugin.logger.debug((Object)("bkArray length" + iBreakpointArray.length));
                IBreakpoint[] iBreakpointArray2 = iBreakpointArray;
                int n = iBreakpointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint iBreakpoint = iBreakpointArray2[n2];
                    this.bkpMgr.getTypeName(iBreakpoint);
                    this.setOSBkpt(iBreakpoint);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Internal Error", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"error handling brkpt list", (Throwable)exception);
        }
    }

    void setAllBrkpts() {
        OS2200CorePlugin.logger.debug((Object)"setting all brkpts");
        try {
            this.bkpList = new ArrayList();
            IBreakpoint[] iBreakpointArray = this.bkpMgr.getBreakpoints();
            OS2200CorePlugin.logger.debug((Object)("set all bkpts bkArray length" + iBreakpointArray.length));
            IBreakpoint[] iBreakpointArray2 = iBreakpointArray;
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint iBreakpoint = iBreakpointArray2[n2];
                this.bkpMgr.getTypeName(iBreakpoint);
                this.setOSBkpt(iBreakpoint);
                ++n2;
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Internal Error", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"error handling brkpt list", (Throwable)exception);
        }
    }

    void removeAllBrkpts() {
        OS2200CorePlugin.logger.debug((Object)"setting all brkpts");
        try {
            this.bkpList = new ArrayList();
            IBreakpoint[] iBreakpointArray = this.bkpMgr.getBreakpoints();
            OS2200CorePlugin.logger.debug((Object)("remove all bkpts bkArray length" + iBreakpointArray.length));
            IBreakpoint[] iBreakpointArray2 = iBreakpointArray;
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint iBreakpoint = iBreakpointArray2[n2];
                this.bkpMgr.getTypeName(iBreakpoint);
                this.removeOSBkpt(iBreakpoint);
                ++n2;
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Internal Error", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"error handling brkpt list", (Throwable)exception);
        }
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        try {
            boolean bl = iBreakpoint.isEnabled();
            boolean bl2 = this.bkpMgr.isEnabled();
            if (bl2) {
                if (this.bkpList.contains(iBreakpoint) && !bl) {
                    this.removeOSBkpt(iBreakpoint);
                }
                if (!this.bkpList.contains(iBreakpoint) && bl) {
                    this.setOSBkpt(iBreakpoint);
                }
            } else if (this.bkpList.contains(iBreakpoint)) {
                this.removeOSBkpt(iBreakpoint);
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Error handling breakpoint change", (Throwable)coreException);
            OS2200CorePlugin.logger.info((Object)"Error handling breakpoint change", (Throwable)coreException);
        }
    }

    public void breakpointManagerEnablementChanged(boolean bl) {
        if (bl) {
            this.setAllBrkpts();
        } else {
            this.removeAllBrkpts();
        }
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (this.bkpList.contains(iBreakpoint)) {
            this.removeOSBkpt(iBreakpoint);
        }
    }
}

