/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.core.model;

import com.unisys.tde.debug.core.comm.StopPoint;
import com.unisys.tde.debug.core.model.OS2200StackFrame;
import com.unisys.tde.debug.core.model.OS2200Thread;

public class FrameID {
    private int blockNumber;
    private String omElt;
    private String omPart;
    private String taskID;

    public FrameID(String string, String string2, int n, String string3) {
        this.omElt = string;
        this.omPart = string2;
        this.blockNumber = n;
        this.taskID = string3;
    }

    public FrameID(OS2200StackFrame oS2200StackFrame) {
        OS2200Thread oS2200Thread = (OS2200Thread)oS2200StackFrame.getThread();
        this.omElt = oS2200StackFrame.getStopPoint().getOmElt();
        this.omPart = oS2200StackFrame.getStopPoint().getOmPart();
        this.blockNumber = oS2200StackFrame.getStopPoint().getBlockNumber();
        this.taskID = oS2200Thread.getTaskID();
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public String getOmElt() {
        return this.omElt;
    }

    public String getOmPart() {
        return this.omPart;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public void setBlockNumber(int n) {
        this.blockNumber = n;
    }

    public void setOmElt(String string) {
        this.omElt = string;
    }

    public void setOmPart(String string) {
        this.omPart = string;
    }

    public void setTaskID(String string) {
        this.taskID = string;
    }

    public boolean equals(FrameID frameID) {
        if (!this.omElt.equals(frameID.getOmElt())) {
            return false;
        }
        if (!this.omPart.equals(frameID.getOmPart())) {
            return false;
        }
        if (!this.taskID.equals(frameID.getTaskID())) {
            return false;
        }
        return this.blockNumber == frameID.getBlockNumber();
    }

    public boolean sameFrame(OS2200StackFrame oS2200StackFrame) {
        OS2200Thread oS2200Thread = (OS2200Thread)oS2200StackFrame.getThread();
        StopPoint stopPoint = oS2200StackFrame.getStopPoint();
        if (!this.omElt.equals(stopPoint.getOmElt())) {
            return false;
        }
        if (!this.omPart.equals(stopPoint.getOmPart())) {
            return false;
        }
        if (!this.taskID.equals(oS2200Thread.getTaskID())) {
            return false;
        }
        return this.blockNumber == stopPoint.getBlockNumber();
    }
}

