/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.views;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.BuildOutput;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.views.EndLineDialog;
import com.unisys.tde.core.views.EndListContentProvider;
import com.unisys.tde.core.views.EndListLabelProvider;
import com.unisys.tde.core.views.EndViewEntry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class OS2200EndSummaryView
extends ViewPart {
    private FilteredTree endList;
    private TreeColumn mainCol;
    private TreeColumn projCol;
    private TreeColumn procCol;
    private TreeColumn lineCol;
    private List<EndViewEntry> endLister;
    private ArrayList<BuildOutput> outputList;
    private EndListContentProvider contentProvider;
    public static final String EndSummaryId = "com.unisys.tde.core.views.OS2200EndSummaryView";
    private PatternFilter patFilt;
    private EndListLabelProvider labelProvider;
    private IDoubleClickListener dblClick = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            TreeSelection treeSelection = (TreeSelection)doubleClickEvent.getSelection();
            if (!treeSelection.isEmpty()) {
                EndViewEntry endViewEntry = (EndViewEntry)((Object)treeSelection.getFirstElement());
                EndLineDialog endLineDialog = endViewEntry.getMyDialog();
                if (endLineDialog == null) {
                    String[] stringArray = endViewEntry.getRelevantLines();
                    String string = endViewEntry.getDisplayName();
                    Shell shell = OS2200EndSummaryView.this.endList.getDisplay().getActiveShell();
                    endLineDialog = new EndLineDialog(stringArray, string, shell);
                    endViewEntry.setMyDialog(endLineDialog);
                }
                endLineDialog.show();
            }
        }
    };

    public OS2200EndSummaryView() {
        this.outputList = new ArrayList();
    }

    public void dispose() {
        if (this.endLister.size() > 0) {
            int n = this.endLister.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                EndViewEntry endViewEntry = this.endLister.get(n2);
                endViewEntry.clearMyDialog();
                this.endLister.remove(n2);
                --n2;
            }
        }
    }

    public void createPartControl(Composite composite) {
        this.patFilt = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object object) {
                OS2200CorePlugin.logger.debug((Object)("viewer" + viewer.getClass().getName()));
                OS2200CorePlugin.logger.debug((Object)("obejct" + object.getClass().getName()));
                return true;
            }
        };
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.endLister = new ArrayList<EndViewEntry>();
        this.setUpView(composite2);
    }

    public void setFocus() {
    }

    public void clear(String string) {
        if (this.endLister.size() > 0) {
            int n = this.endLister.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                EndViewEntry endViewEntry = this.endLister.get(n2);
                if (endViewEntry.getProjectName().equals(string)) {
                    try {
                        endViewEntry.clearMyDialog();
                    }
                    catch (Throwable throwable) {
                        OS2200CorePlugin.logger.debug((Object)"error clearing dialog", throwable);
                    }
                    this.endLister.remove(n2);
                }
                --n2;
            }
            this.endList.getViewer().setInput((Object)this);
        }
    }

    public void addOutput(BuildOutput buildOutput) {
        this.readOutput(buildOutput);
        this.endList.getViewer().refresh();
        this.endList.getViewer().setInput((Object)this);
    }

    public void setUpView(Composite composite) {
        this.endList = new FilteredTree(composite, 65536, this.patFilt, true);
        this.endList.setBackground(composite.getDisplay().getSystemColor(25));
        Tree tree = this.endList.getViewer().getTree();
        this.mainCol = new TreeColumn(tree, 0x2000000);
        this.mainCol.setText(Messages.getString((String)"OS2200EndSummaryView_0"));
        this.mainCol.setWidth(300);
        this.projCol = new TreeColumn(tree, 0x2000000);
        this.projCol.setText(Messages.getString((String)"OS2200EndSummaryView_1"));
        this.projCol.setWidth(100);
        this.procCol = new TreeColumn(tree, 0x2000000);
        this.procCol.setText(Messages.getString((String)"OS2200EndSummaryView_2"));
        this.procCol.setWidth(100);
        this.lineCol = new TreeColumn(tree, 131072);
        this.lineCol.setText(Messages.getString((String)"OS2200EndSummaryView_3"));
        this.lineCol.setWidth(100);
        tree.setHeaderVisible(true);
        tree.setVisible(true);
        this.contentProvider = new EndListContentProvider(this.endList, this);
        this.endList.getViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new EndListLabelProvider(tree);
        this.endList.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.endList.getViewer().addDoubleClickListener(this.dblClick);
    }

    public List<EndViewEntry> getList() {
        return this.endLister;
    }

    private void readOutput(BuildOutput buildOutput) {
        String[] stringArray = buildOutput.getOutputArray();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toUpperCase();
            if (string.startsWith("END ") && !string.startsWith("END OF ")) {
                this.endLister.add(new EndViewEntry(buildOutput, n));
            }
            ++n;
        }
    }
}

