/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.views;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.session.ISession;
import com.unisys.telnet.lib.session.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IUpdate;

public class OS2200ConsoleView
extends ViewPart {
    public static final String actSet = "viewActions";
    private TextViewer viewer = null;
    private Document document = null;
    private String prefix = null;
    private boolean titleSet = false;
    private IMemento mem;
    private String fileName = null;
    private LoginAccount ll = null;
    private IViewSite viewSite;
    private boolean printNSave = false;
    private boolean deleteFile = false;
    protected Map fGlobalActions = new HashMap();
    protected ArrayList fSelectionActions = new ArrayList();
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private MenuManager fMenuManager;
    public static final String CONSOLE_ID = "com.unisys.tde.core.views.OS2200ConsoleView";
    public static final String BRKPT_CONSOLE_ID = "com.unisys.tde.core.views.OS2200BreakpointConsoleView";
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            OS2200ConsoleView.this.updateSelectionDependentActions();
        }
    };
    private ITextListener textListener = new ITextListener(){

        public void textChanged(TextEvent textEvent) {
            IUpdate iUpdate = (IUpdate)OS2200ConsoleView.this.fGlobalActions.get(ActionFactory.FIND.getId());
            if (iUpdate != null) {
                iUpdate.update();
            }
        }
    };

    public void createPartControl(Composite composite) {
        this.viewer = new TextViewer(composite, 768);
        GridData gridData = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setEditable(false);
        StyledText styledText = this.viewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        this.document = new Document();
        this.viewer.setDocument((IDocument)this.document);
        this.setTabTitle(this.prefix);
        IFindReplaceTargetExtension cfr_ignored_0 = (IFindReplaceTargetExtension)this.viewer.getFindReplaceTarget();
        this.createActions();
        this.viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.viewer.addTextListener(this.textListener);
        this.fMenuManager = new MenuManager("ConsoleViewMenu");
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                OS2200ConsoleView.this.contextMenuAboutToShow(iMenuManager);
            }
        });
        Menu menu = this.fMenuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        OS2200CorePlugin.logger.debug((Object)"");
        iMenuManager.add((IAction)this.copyAction);
        iMenuManager.add((IAction)this.selectAllAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    protected void updateSelectionDependentActions() {
        this.copyAction.update();
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void createActions() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
        this.copyAction = new TextViewerAction((ITextViewer)this.viewer, 4);
        this.copyAction.configureAction(Messages.getString((String)"TelnetView.16"), Messages.getString((String)"TelnetView.16"), Messages.getString((String)"TelnetView.16"));
        this.copyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.selectAllAction = new TextViewerAction((ITextViewer)this.viewer, 7);
        this.selectAllAction.configureAction(Messages.getString((String)"TelnetView.22"), Messages.getString((String)"TelnetView.22"), Messages.getString((String)"TelnetView.22"));
    }

    protected void setGlobalAction(IActionBars iActionBars, String string, IAction iAction) {
        this.fGlobalActions.put(string, iAction);
        iActionBars.setGlobalActionHandler(string, iAction);
    }

    public Object getAdapter(Class clazz) {
        if (IFindReplaceTarget.class.equals((Object)clazz)) {
            return this.viewer.getFindReplaceTarget();
        }
        if (Widget.class.equals((Object)clazz)) {
            return this.viewer.getTextWidget();
        }
        return null;
    }

    protected IConsole getConsole() {
        return (IConsole)this;
    }

    protected void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    public void setRawFile(String string, LoginAccount loginAccount, boolean bl) {
        this.fileName = string;
        this.ll = loginAccount;
        this.deleteFile = bl;
    }

    public void disableActions() {
        IContributionItem[] iContributionItemArray = this.getViewSite().getActionBars().getToolBarManager().getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            String string = iContributionItemArray[n].getId();
            if (string.equals("com.unisys.tde.core.SavePrint") || string.equals("com.unisys.tde.core.PrintConsole")) {
                iContributionItemArray[n].setVisible(false);
            }
            ++n;
        }
    }

    public boolean checkView() {
        if (this.fileName == null) {
            return false;
        }
        return this.ll != null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void dispose() {
        if (this.deleteFile && this.fileName != null) {
            if (this.ll != null) {
                ISession iSession = Session.New((LoginAccount)this.ll);
                if (iSession != null) {
                    String string = iSession.Login();
                    if (string.length() == 0) {
                        iSession.SendCommand("@Delete,c " + this.fileName + "\n");
                        String string2 = iSession.getOutput();
                        OS2200CorePlugin.logger.debug((Object)string2);
                        iSession.SendCommand("@fin \n");
                        string2 = iSession.getOutput();
                        OS2200CorePlugin.logger.debug((Object)string2);
                        iSession.Logout();
                    } else {
                        OS2200CorePlugin.logger.error((Object)("Could not login to delete " + this.fileName));
                    }
                } else {
                    OS2200CorePlugin.logger.error((Object)("Could not create a session to delete " + this.fileName));
                }
            } else {
                OS2200CorePlugin.logger.error((Object)("Login Account is null.  Cannot delete " + this.fileName));
            }
        }
    }

    public void setOutputText(String string) {
        String string2 = this.document.get();
        string2 = String.valueOf(string2) + string;
        this.document.set(string2);
        OS2200CorePlugin.logger.debug((Object)"Console view set");
    }

    public void setDeleteInfo(String string, LoginAccount loginAccount) {
        this.fileName = string;
        this.ll = loginAccount;
    }

    public void clearOutputText() {
        this.document.set("");
    }

    public String getOutputText() {
        return this.document.get();
    }

    public void setTabTitle(String string) {
        if (!this.titleSet) {
            String string2 = this.getTitle();
            String string3 = null;
            string3 = string != null ? String.valueOf(string) + "-" + string2 : string2;
            this.setPartName(string3);
            this.titleSet = true;
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.viewSite = iViewSite;
        this.prefix = iViewSite.getSecondaryId();
        if (this.prefix != null) {
            if (this.prefix.indexOf("/") > 0) {
                this.printNSave = true;
            }
            this.mem = iMemento;
        }
    }

    public boolean getPrintNSave() {
        return this.printNSave;
    }

    public String getFileName() {
        return this.fileName;
    }

    public LoginAccount getLogin() {
        return this.ll;
    }

    public void saveState(IMemento iMemento) {
        iMemento.putTextData("Dying");
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

