/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.utils;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.ExclusiveFileLockChecker;
import com.unisys.os2200.util.FileInfo;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200NonExistingFileEditorInput;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.session.ISession;
import com.unisys.telnet.lib.session.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class EditorRelatedUtils {
    private static final String ON = " ON ";
    private static final String STAR = "*";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static String tooltip = null;
    private static final long LIMITED_FILE_SIZE = 0x500000L;
    private static boolean activate;
    private static IWorkbenchPage page;
    private static final String EditorID = "com.unisys.os2200.editor.UDTEditor";
    protected static final String EMPTY_STR = "";
    private static final String SINGLE_SPACE = " ";
    private static final String ERROR_CONDITION = "*ERROR";
    private static final String CIFSUT_SIZE = "SIZE ";
    private static final String TERMINATE_CIFSUT = "@";
    private static final String FIN_COMMAND = "@FIN";
    private static final String FILE_PARAM = "<FILE>";
    private static final String[] CIFSUT_SIZE_COMMANDS;

    static {
        CIFSUT_SIZE_COMMANDS = new String[]{"@CIFSUT\n", "SIZE <FILE> 34359738367\n", "@\n", "@FIN\n"};
    }

    public static String getPathIn2200Format(IEditorInput iEditorInput, StringBuffer stringBuffer) {
        IPath iPath = null;
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            iPath = iFileEditorInput.getFile().getRawLocation();
            tooltip = TDECoreUtilities.getOS2200FormatfromCachePath((IPath)iPath);
            if (stringBuffer != null) {
                stringBuffer.append(iPath.toOSString());
            }
            iPath = null;
            return tooltip.toUpperCase();
        }
        if (iEditorInput instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
            OS2200ProjectUpdate.Share share = oS2200FileEditorInput.getFileShare();
            iPath = new Path(oS2200FileEditorInput.getfFile().toURI().getPath());
            if (iPath.toOSString().contains(":\\")) {
                tooltip = iPath.toOSString();
                tooltip = tooltip.substring(0, tooltip.length());
                if (stringBuffer != null) {
                    stringBuffer.append(tooltip);
                }
            } else {
                tooltip = EditorRelatedUtils.parseShare(null, share, iPath, stringBuffer);
            }
            iPath = null;
            return tooltip.toUpperCase();
        }
        if (iEditorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)iEditorInput;
            tooltip = fileStoreEditorInput.getURI().getRawPath();
            if (!tooltip.startsWith("//") && !tooltip.startsWith("\\\\")) {
                tooltip = tooltip.substring(1, tooltip.length());
            }
            if (tooltip.contains(SLASH)) {
                tooltip = tooltip.replaceAll(SLASH, "\\\\");
            }
            try {
                tooltip = URLDecoder.decode(tooltip, ResourcesPlugin.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                OS2200CorePlugin.logger.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            }
            if (stringBuffer != null) {
                stringBuffer.append(tooltip);
            }
            return tooltip.toUpperCase();
        }
        return iEditorInput.getToolTipText();
    }

    private static String parseShare(String string, OS2200ProjectUpdate.Share share, IPath iPath, StringBuffer stringBuffer) {
        block13: {
            OS2200CorePlugin.logger.info((Object)EMPTY_STR);
            String string2 = null;
            try {
                if (share != null && share.equals((Object)OS2200ProjectUpdate.Share.nShare)) {
                    try {
                        string2 = iPath.lastSegment();
                        int n = iPath.segmentCount();
                        if (n >= 5) {
                            tooltip = iPath.toOSString();
                        } else {
                            if (string2.contains(DOT)) {
                                string2 = string2.replace(DOT, SLASH);
                            }
                            if (stringBuffer != null) {
                                stringBuffer.append(iPath.toOSString().toUpperCase());
                            }
                            tooltip = string != null ? String.valueOf(string) + string2 + ON + iPath.segment(0) : String.valueOf(iPath.segment(1)) + DOT + string2 + ON + iPath.segment(0);
                        }
                        return tooltip;
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                        break block13;
                    }
                }
                int n = iPath.segmentCount();
                if (n > 5) {
                    tooltip = iPath.toOSString();
                } else {
                    string2 = iPath.lastSegment();
                    if (string2.contains(DOT)) {
                        string2 = string2.replace(DOT, SLASH);
                    }
                    tooltip = n == 4 ? String.valueOf(iPath.segment(2)) + STAR + iPath.segment(3) + DOT + ON + iPath.segment(0) : String.valueOf(iPath.segment(2)) + STAR + iPath.segment(3) + DOT + string2 + ON + iPath.segment(0);
                    if (stringBuffer != null) {
                        stringBuffer.append(iPath.toOSString().toUpperCase());
                    }
                }
                return tooltip;
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return iPath.toOSString();
    }

    public static void reloadEditor() {
        try {
            OS2200CorePlugin.logger.info((Object)EMPTY_STR);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
                        if (iEditorPart != null) {
                            boolean bl;
                            Object object;
                            IEditorInput iEditorInput = iEditorPart.getEditorInput();
                            if (iEditorInput instanceof CompareEditorInput || iEditorInput instanceof OS2200NonExistingFileEditorInput) {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"EditorReload.1"), (String)Messages.getString((String)"EditorReload.8"));
                                return;
                            }
                            try {
                                Object object2;
                                if (iEditorInput instanceof IFileEditorInput) {
                                    object2 = (IFileEditorInput)iEditorInput;
                                    if (object2 != null) {
                                        object = object2.getFile();
                                        boolean bl2 = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"EditorReload.1"), (String)Messages.getString((String)"EditorReload.9"));
                                        if (!bl2) {
                                            return;
                                        }
                                        FileInfo fileInfo = TDECoreUtilities.getInstance().getFileInfo(object.getRawLocation().toOSString());
                                        if (fileInfo != null) {
                                            String string = TDECoreUtilities.getInstance().copyToLocal(new File(fileInfo.getRemoteFile()), new File(fileInfo.getLocalFile()));
                                            if (string.trim().length() > 0) {
                                                OS2200CorePlugin.logger.info((Object)string);
                                                ExclusiveFileLockChecker.HandleForExclusiveFileHold((String)string, (String)OS2200ProjectUpdate.getWorkFileForProj(object.getProject()), (String)string);
                                                object.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "False");
                                                string = null;
                                                return;
                                            }
                                            OS2200CorePlugin.logger.debug((Object)("Copied successfully from the OS 2200 system." + fileInfo.toString()));
                                            object.setPersistentProperty(OS2200ArchitectureConstant.SYNC_FILE, "True");
                                            string = null;
                                        }
                                    }
                                } else if (iEditorInput instanceof OS2200FileEditorInput ? (object2 = (OS2200FileEditorInput)iEditorInput) != null && !EditorRelatedUtils.verifyAccessibility(((OS2200FileEditorInput)((Object)object2)).getFileLocation()) : iEditorInput instanceof FileStoreEditorInput && (object2 = (FileStoreEditorInput)iEditorInput) != null && !EditorRelatedUtils.verifyAccessibility((String)(object = object2.getURI().getPath()))) {
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                                return;
                            }
                            if (iEditorPart.isDirty() && !(bl = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"EditorReload.1"), (String)Messages.getString((String)"EditorReload.2")))) {
                                return;
                            }
                            iWorkbenchPage.closeEditor(iWorkbenchPage.findEditor(iEditorInput), false);
                            if (iEditorInput instanceof IFileEditorInput) {
                                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                                if (iFileEditorInput != null) {
                                    object = iFileEditorInput.getFile();
                                    if (OS2200CorePlugin.logger.isDebugEnabled()) {
                                        OS2200CorePlugin.logger.debug((Object)(String.valueOf(object.getRawLocation().toOSString()) + " is a Project file."));
                                    }
                                    EditorRelatedUtils.openInternal(object);
                                }
                            } else if (iEditorInput instanceof OS2200FileEditorInput) {
                                OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
                                object = EditorRelatedUtils.EMPTY_STR;
                                if (oS2200FileEditorInput != null && oS2200FileEditorInput.isDataFile()) {
                                    object = EditorRelatedUtils.executeCIFSUTSizeCommand(oS2200FileEditorInput.getFile().getAbsolutePath(), oS2200FileEditorInput.getHostAcc());
                                }
                                if (OS2200CorePlugin.logger.isDebugEnabled()) {
                                    OS2200CorePlugin.logger.debug((Object)(String.valueOf(oS2200FileEditorInput.getFile().getAbsolutePath()) + " is a OFCS file."));
                                }
                                OS2200FileInterface.openFileInEditor(oS2200FileEditorInput.getFile(), oS2200FileEditorInput);
                                if (object.length() > 0) {
                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"EditorReload.1"), (String)object);
                                }
                            } else if (iEditorInput instanceof FileStoreEditorInput) {
                                IFileStore iFileStore;
                                FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)iEditorInput;
                                object = fileStoreEditorInput.getURI().getPath();
                                if (OS2200CorePlugin.logger.isDebugEnabled()) {
                                    OS2200CorePlugin.logger.debug((Object)(String.valueOf(object) + " is a Local File system file."));
                                }
                                if (!(iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path((String)object))).fetchInfo().isDirectory() && iFileStore.fetchInfo().exists()) {
                                    try {
                                        IDE.openEditorOnFileStore((IWorkbenchPage)iWorkbenchPage, (IFileStore)iFileStore);
                                    }
                                    catch (PartInitException partInitException) {
                                        OS2200CorePlugin.logger.error((Object)partInitException.getMessage(), (Throwable)partInitException);
                                    }
                                }
                            }
                        } else {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"EditorReload.1"), (String)Messages.getString((String)"EditorReload.10"));
                            return;
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public static String executeCIFSUTSizeCommand(String string, LoginAccount loginAccount) {
        if (string == null || string.trim().length() <= 0) {
            OS2200CorePlugin.logger.warn((Object)"CIFS has read the 'remembered' size of the data file as CIFSUT Size command could not be executed.\n\nReason:\nThe file-path is empty or NULL.");
            return String.valueOf(Messages.getString((String)"CIFSUTSizeCmd.commonError")) + Messages.getString((String)"CIFSUTSizeCmd.reason") + Messages.getString((String)"CIFSUTSizeCmd.invalidFilePath");
        }
        string = string.trim();
        if (loginAccount == null) {
            OS2200CorePlugin.logger.warn((Object)"CIFS has read the 'remembered' size of the data file as CIFSUT Size command could not be executed.\n\nReason:\nThe loginAccount is NULL.");
            return String.valueOf(Messages.getString((String)"CIFSUTSizeCmd.commonError")) + Messages.getString((String)"CIFSUTSizeCmd.reason") + Messages.getString((String)"CIFSUTSizeCmd.sessionNotEstablished");
        }
        long l = System.currentTimeMillis();
        String string2 = EMPTY_STR;
        ISession iSession = null;
        try {
            try {
                iSession = Session.New((LoginAccount)loginAccount);
                if (iSession != null) {
                    String string3 = iSession.Login();
                    if (string3.length() == 0) {
                        String string4 = EMPTY_STR;
                        string = EditorRelatedUtils.removeHOSTIDFromPath(string);
                        int n = 0;
                        String string5 = EMPTY_STR;
                        int n2 = 0;
                        while (n2 < CIFSUT_SIZE_COMMANDS.length) {
                            if (!string5.startsWith(ERROR_CONDITION)) {
                                string4 = CIFSUT_SIZE_COMMANDS[n2];
                                if (string4.startsWith(CIFSUT_SIZE)) {
                                    string4 = string4.replace(FILE_PARAM, string);
                                }
                                if ((n = iSession.SendCommand_ProtocolSpecific(string4, false)) == 0) {
                                    string5 = iSession.getOutput();
                                } else if ((string4 = string4.trim()) != TERMINATE_CIFSUT && string4 != FIN_COMMAND) {
                                    OS2200CorePlugin.logger.warn((Object)("CIFS has read the 'remembered' size of the data file as CIFSUT Size command could not be executed.\n\nReason:\nThe following command could not be executed:\n" + string4));
                                    string2 = String.valueOf(Messages.getString((String)"CIFSUTSizeCmd.commonError")) + Messages.getString((String)"CIFSUTSizeCmd.reason") + Messages.getString((String)"CIFSUTSizeCmd.commandNotExecuted", (String)string4);
                                }
                            } else {
                                OS2200CorePlugin.logger.warn((Object)("CIFS has read the 'remembered' size of the data file as CIFSUT Size command could not be executed.\n\nReason:\nThe following command ended up in error:\n" + string4 + "\n" + string5));
                                string2 = String.valueOf(Messages.getString((String)"CIFSUTSizeCmd.commonError")) + Messages.getString((String)"CIFSUTSizeCmd.reason") + Messages.getString((String)"CIFSUTSizeCmd.commandErred", (String)string4, (String)string5);
                            }
                            ++n2;
                        }
                    } else {
                        OS2200CorePlugin.logger.warn((Object)("CIFS has read the 'remembered' size of the data file as CIFSUT Size command could not be executed.\n\nReason:\nCould not login to the telnet session.\n" + string3));
                        string2 = String.valueOf(Messages.getString((String)"CIFSUTSizeCmd.commonError")) + Messages.getString((String)"CIFSUTSizeCmd.reason") + Messages.getString((String)"CIFSUTSizeCmd.loginFailed", (String)string3);
                    }
                } else {
                    OS2200CorePlugin.logger.warn((Object)("CIFS has read the 'remembered' size of the data file as CIFSUT Size command could not be executed.\n\nReason:\nThe telnet session could not be established for the following host:\n" + loginAccount.getName()));
                    string2 = String.valueOf(Messages.getString((String)"CIFSUTSizeCmd.commonError")) + Messages.getString((String)"CIFSUTSizeCmd.reason") + Messages.getString((String)"CIFSUTSizeCmd.sessionNotEstablished", (String)loginAccount.getName());
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.warn((Object)("CIFS has read the 'remembered' size of the data file as CIFSUT Size command could not be executed.\n\nReason:\n" + exception.getMessage()), (Throwable)exception);
                string2 = String.valueOf(Messages.getString((String)"CIFSUTSizeCmd.commonError")) + Messages.getString((String)"CIFSUTSizeCmd.reason") + exception.getMessage();
                if (iSession != null) {
                    iSession.Logout();
                }
                long l2 = System.currentTimeMillis();
                OS2200CorePlugin.logger.debug((Object)("Time taken to establish Telnet session and execute CIFSUT Size command for file" + string + " on host " + loginAccount.getName().trim() + ": " + (l2 - l) / 1000L + " seconds."));
            }
        }
        finally {
            if (iSession != null) {
                iSession.Logout();
            }
            long l3 = System.currentTimeMillis();
            OS2200CorePlugin.logger.debug((Object)("Time taken to establish Telnet session and execute CIFSUT Size command for file" + string + " on host " + loginAccount.getName().trim() + ": " + (l3 - l) / 1000L + " seconds."));
        }
        return string2;
    }

    private static String removeHOSTIDFromPath(String string) {
        String[] stringArray = null;
        String string2 = EMPTY_STR;
        if (string.contains(File.separator)) {
            stringArray = string.replaceAll(" +", EMPTY_STR).replace(File.separator, SINGLE_SPACE).trim().split(SINGLE_SPACE);
            int n = 1;
            while (n < stringArray.length) {
                string2 = String.valueOf(string2) + File.separator + stringArray[n];
                ++n;
            }
            if (string2.length() <= 0) {
                string2 = string;
            }
        }
        return string2;
    }

    private static void openInternal(IFile iFile) {
        OS2200CorePlugin.logger.info((Object)EMPTY_STR);
        try {
            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
        }
        try {
            String string = iFile.getFileExtension();
            if (string.equalsIgnoreCase("ELT") || string.equalsIgnoreCase("C") || string.equalsIgnoreCase("H") || string.equalsIgnoreCase("ASM") || string.equalsIgnoreCase("FOR")) {
                EditorRelatedUtils.popUpEditor(iFile);
            } else {
                InputStream inputStream = iFile.getContents();
                FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
                long l = fileChannel.size();
                fileChannel.close();
                fileChannel = null;
                inputStream.close();
                inputStream = null;
                OS2200CorePlugin.logger.debug((Object)("Opening file : " + iFile.getName() + " of size " + l + "bytes"));
                if (l >= 0x500000L) {
                    boolean bl = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"EditorReload.6"), (String)Messages.getString((String)"EditorReload.7"));
                    if (!bl) {
                        OS2200CorePlugin.logger.debug((Object)("User cancelled to open " + iFile.getName() + " with Text Editor."));
                        return;
                    }
                    EditorRelatedUtils.openEditor(iFile);
                } else {
                    EditorRelatedUtils.popUpEditor(iFile);
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private static void popUpEditor(final IFile iFile) {
        OS2200CorePlugin.logger.debug((Object)EMPTY_STR);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    activate = OpenStrategy.activateOnOpen();
                    page = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)iFile, (boolean)activate);
                }
                catch (PartInitException partInitException) {
                    DialogUtil.openError((Shell)page.getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenFileAction_openFileShellTitle, (String)partInitException.getMessage(), (PartInitException)partInitException);
                    OS2200CorePlugin.logger.error((Object)partInitException.getMessage(), (Throwable)partInitException);
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
                }
            }
        });
    }

    private static void openEditor(IFile iFile) {
        OS2200CorePlugin.logger.debug((Object)EMPTY_STR);
        try {
            activate = OpenStrategy.activateOnOpen();
            page = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)iFile, (String)EditorID);
        }
        catch (PartInitException partInitException) {
            OS2200CorePlugin.logger.error((Object)partInitException.getMessage(), (Throwable)partInitException);
            ErrorDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)"Open External File With ...", (String)partInitException.getMessage(), (IStatus)partInitException.getStatus());
        }
    }

    private static boolean verifyAccessibility(String string) {
        FileInputStream fileInputStream = null;
        try {
            try {
                File file = new File(string);
                fileInputStream = new FileInputStream(file);
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"EditorReload.11"), (String)(String.valueOf(Messages.getString((String)"EditorReload.12")) + exception.getMessage()));
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                }
                catch (Exception exception2) {
                    OS2200CorePlugin.logger.info((Object)exception2.getMessage(), (Throwable)exception2);
                }
                return false;
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.info((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return true;
    }
}

