/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.dialog;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.dialog.FindReplaceDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class TextActionHandler {
    private Listener textControlListener = new TextControlListener();
    private Text activeTextControl;
    private CutActionHandler textCutAction = new CutActionHandler();
    private CopyActionHandler textCopyAction = new CopyActionHandler();
    private PasteActionHandler textPasteAction = new PasteActionHandler();
    private SelectAllActionHandler textSelectAllAction = new SelectAllActionHandler();
    private FindNReplaceActionHandler textFindReplaceAction = new FindNReplaceActionHandler();
    private KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            TextActionHandler.this.updateActionsEnableState();
        }
    };
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseUp(MouseEvent mouseEvent) {
            TextActionHandler.this.updateActionsEnableState();
        }
    };

    public TextActionHandler(Text text) {
        this.addText(text);
    }

    public TextActionHandler() {
    }

    public void addText(Text text) {
        OS2200CorePlugin.logger.info((Object)"");
        if (text == null) {
            return;
        }
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
            }
        });
        text.addListener(26, this.textControlListener);
        text.addListener(27, this.textControlListener);
        text.addKeyListener((KeyListener)this.keyAdapter);
        text.addMouseListener((MouseListener)this.mouseAdapter);
        this.activeTextControl = text;
        this.updateActionsEnableState();
    }

    public void hookContextMenu() {
        OS2200CorePlugin.logger.info((Object)"");
        final MenuManager menuManager = new MenuManager("#PMPopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                TextActionHandler.this.addContextMenuOptions(menuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.activeTextControl);
        this.activeTextControl.setMenu(menu);
    }

    private void addContextMenuOptions(MenuManager menuManager) {
        OS2200CorePlugin.logger.info((Object)"");
        menuManager.removeAll();
        menuManager.add((IAction)this.textCutAction);
        menuManager.add((IAction)this.textCopyAction);
        menuManager.add((IAction)this.textPasteAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.textSelectAllAction);
        menuManager.add((IAction)this.textFindReplaceAction);
    }

    private void updateActionsEnableState() {
        OS2200CorePlugin.logger.info((Object)"");
        this.textCutAction.updateEnabledState();
        this.textCopyAction.updateEnabledState();
        this.textPasteAction.updateEnabledState();
        this.textSelectAllAction.updateEnabledState();
    }

    public final Text getActiveTextControl() {
        return this.activeTextControl;
    }

    public final void setActiveTextControl(Text text) {
        this.activeTextControl = text;
    }

    private final class CopyActionHandler
    extends Action {
        private CopyActionHandler() {
            this.setText(Messages.getString((String)"FlexibleBuildStream.8"));
            this.setId("org.eclipse.ui.edit.copy");
            this.setImageDescriptor(this.getImageDescriptor());
        }

        public void runWithEvent(Event event) {
            OS2200CorePlugin.logger.info((Object)"");
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                TextActionHandler.this.activeTextControl.copy();
                TextActionHandler.this.updateActionsEnableState();
            }
        }

        public boolean isEnabled() {
            OS2200CorePlugin.logger.info((Object)"");
            return TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed() && TextActionHandler.this.activeTextControl.getEditable() && TextActionHandler.this.activeTextControl.getSelectionCount() > 0;
        }

        public void updateEnabledState() {
            OS2200CorePlugin.logger.info((Object)"");
            this.setEnabled(this.isEnabled());
        }
    }

    private final class CutActionHandler
    extends Action {
        private CutActionHandler() {
            this.setText(Messages.getString((String)"FlexibleBuildStream.7"));
            this.setId("org.eclipse.ui.edit.cut");
            this.setImageDescriptor(this.getImageDescriptor());
        }

        public void runWithEvent(Event event) {
            OS2200CorePlugin.logger.info((Object)"");
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                TextActionHandler.this.activeTextControl.cut();
                TextActionHandler.this.updateActionsEnableState();
            }
        }

        public boolean isEnabled() {
            OS2200CorePlugin.logger.info((Object)"");
            return TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed() && TextActionHandler.this.activeTextControl.getEditable() && TextActionHandler.this.activeTextControl.getSelectionCount() > 0;
        }

        public void updateEnabledState() {
            OS2200CorePlugin.logger.info((Object)"");
            this.setEnabled(this.isEnabled());
        }
    }

    private final class FindNReplaceActionHandler
    extends Action {
        private FindNReplaceActionHandler() {
            this.setText(Messages.getString((String)"FlexibleBuildStream.11"));
            this.setId("org.eclipse.ui.edit.findReplace");
            this.setImageDescriptor(this.getImageDescriptor());
            this.setEnabled(true);
        }

        public void runWithEvent(Event event) {
            OS2200CorePlugin.logger.info((Object)"");
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                FindReplaceDialog findReplaceDialog = new FindReplaceDialog(new Shell());
                findReplaceDialog.setParentShell(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                findReplaceDialog.setTargetText(TextActionHandler.this.activeTextControl);
                if (findReplaceDialog.open() == 1) {
                    OS2200CorePlugin.logger.info((Object)"Find/Replace dialog disposed.");
                    return;
                }
                TextActionHandler.this.updateActionsEnableState();
            }
        }

        public boolean isEnabled() {
            OS2200CorePlugin.logger.info((Object)"");
            return true;
        }
    }

    private final class PasteActionHandler
    extends Action {
        private PasteActionHandler() {
            this.setText(Messages.getString((String)"FlexibleBuildStream.9"));
            this.setId("org.eclipse.ui.edit.paste");
            this.setImageDescriptor(this.getImageDescriptor());
        }

        public void runWithEvent(Event event) {
            OS2200CorePlugin.logger.info((Object)"");
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                TextActionHandler.this.activeTextControl.paste();
                TextActionHandler.this.updateActionsEnableState();
            }
        }

        public boolean isEnabled() {
            OS2200CorePlugin.logger.info((Object)"");
            Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            String string = (String)clipboard.getContents((Transfer)textTransfer);
            return string != null && string.trim().length() > 0;
        }

        public void updateEnabledState() {
            OS2200CorePlugin.logger.info((Object)"");
            this.setEnabled(this.isEnabled());
        }
    }

    private final class SelectAllActionHandler
    extends Action {
        private SelectAllActionHandler() {
            this.setText(Messages.getString((String)"FlexibleBuildStream.10"));
            this.setId("org.eclipse.ui.edit.paste");
            this.setImageDescriptor(this.getImageDescriptor());
        }

        public void runWithEvent(Event event) {
            OS2200CorePlugin.logger.info((Object)"");
            if (TextActionHandler.this.activeTextControl != null && !TextActionHandler.this.activeTextControl.isDisposed()) {
                TextActionHandler.this.activeTextControl.selectAll();
                TextActionHandler.this.updateActionsEnableState();
            }
        }

        public boolean isEnabled() {
            OS2200CorePlugin.logger.info((Object)"");
            return TextActionHandler.this.activeTextControl != null && TextActionHandler.this.activeTextControl.getText().length() > 0;
        }

        public void updateEnabledState() {
            OS2200CorePlugin.logger.info((Object)"");
            this.setEnabled(this.isEnabled());
        }
    }

    private class TextControlListener
    implements Listener {
        private TextControlListener() {
        }

        public void handleEvent(Event event) {
            OS2200CorePlugin.logger.info((Object)"");
            switch (event.type) {
                case 26: {
                    TextActionHandler.this.activeTextControl = (Text)event.widget;
                    TextActionHandler.this.updateActionsEnableState();
                    break;
                }
                case 27: {
                    TextActionHandler.this.activeTextControl = null;
                    TextActionHandler.this.updateActionsEnableState();
                    break;
                }
            }
        }
    }
}

