/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.dialog;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.dialog.TextActionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class OS2200BuildStreamDialog
extends TrayDialog {
    private Text textArea;
    private Button ldBldStream;
    private IProject project;
    private boolean isFileSystem;
    private boolean isProjectProperties;
    private String selectedFile = "";
    private Label spaceLabel;
    private String contents;
    private Button doNotShowBldStreamDlg;
    private Button saveBtn;
    private final String[] FILTER_EXTENSION = new String[]{"*.txt;*.elt;*.log"};

    public OS2200BuildStreamDialog(Shell shell) {
        super(shell);
    }

    public OS2200BuildStreamDialog(IShellProvider iShellProvider) {
        super(iShellProvider);
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    protected Control createDialogArea(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.getShell().setText(String.valueOf(Messages.getString((String)"FlexibleBuildStream.1")) + " - " + this.project.getName());
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.Flexible_Build_Stream");
        GridLayout gridLayout = new GridLayout(3, false);
        composite2.setLayout((Layout)gridLayout);
        this.createComponents(composite2);
        return composite2;
    }

    private void createComponents(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        gridData.heightHint = 20;
        gridData.horizontalSpan = 1;
        final GridData gridData2 = new GridData();
        gridData2.widthHint = 300;
        gridData2.heightHint = 20;
        gridData2.horizontalSpan = 2;
        GridData gridData3 = new GridData();
        gridData3.widthHint = 60;
        gridData3.heightHint = 25;
        gridData3.horizontalSpan = 1;
        GridData gridData4 = new GridData();
        gridData4.widthHint = 125;
        gridData4.heightHint = 25;
        gridData4.horizontalAlignment = 0x1000000;
        gridData4.horizontalSpan = 1;
        this.textArea = new Text(composite, 2880);
        TextActionHandler textActionHandler = new TextActionHandler();
        textActionHandler.setActiveTextControl(this.textArea);
        textActionHandler.addText(this.textArea);
        textActionHandler.hookContextMenu();
        GridData gridData5 = new GridData();
        gridData5.widthHint = 420;
        gridData5.heightHint = 300;
        gridData5.horizontalSpan = 3;
        this.textArea.setLayoutData((Object)gridData5);
        this.textArea.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                OS2200BuildStreamDialog.this.saveBtn.setEnabled(true);
                if (OS2200BuildStreamDialog.this.getButton(0) != null) {
                    OS2200BuildStreamDialog.this.getButton(0).setEnabled(true);
                }
                verifyEvent.text = verifyEvent.text.toUpperCase();
            }
        });
        Button button = new Button(composite, 0);
        button.setText(Messages.getString((String)"FlexibleBuildStream.2"));
        button.setLayoutData((Object)gridData3);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200BuildStreamDialog.this.clearTextArea();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label = new Label(composite, 0);
        label.setText("");
        label.setLayoutData((Object)gridData);
        this.saveBtn = new Button(composite, 0);
        this.saveBtn.setText(Messages.getString((String)"FlexibleBuildStream.3"));
        this.saveBtn.setLayoutData((Object)gridData4);
        this.saveBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200BuildStreamDialog.this.save();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.ldBldStream = new Button(composite, 0);
        this.ldBldStream.setText(Messages.getString((String)"FlexibleBuildStream.4"));
        this.ldBldStream.setLayoutData((Object)gridData);
        this.ldBldStream.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(OS2200BuildStreamDialog.this.getParentShell());
                fileDialog.setText(Messages.getString((String)"FlexibleBuildStream.5"));
                fileDialog.setFilterExtensions(OS2200BuildStreamDialog.this.FILTER_EXTENSION);
                File file = null;
                boolean bl = true;
                do {
                    OS2200BuildStreamDialog.this.selectedFile = fileDialog.open();
                    if (OS2200BuildStreamDialog.this.selectedFile != null) {
                        file = new File(OS2200BuildStreamDialog.this.selectedFile);
                        bl = file.exists();
                        if (bl) continue;
                        MessageDialog.openError((Shell)OS2200BuildStreamDialog.this.getParentShell(), (String)Messages.getString((String)"FlexibleBuildStream.24"), (String)Messages.getString((String)"FlexibleBuildStream.25", (String)file.getName()));
                        OS2200CorePlugin.logger.info((Object)("The file " + file.getAbsolutePath() + " could not be found."));
                        continue;
                    }
                    OS2200CorePlugin.logger.info((Object)"Cancel Pressed.");
                    return;
                } while (!bl);
                if (OS2200BuildStreamDialog.this.selectedFile != null) {
                    String string = "";
                    if (OS2200BuildStreamDialog.this.selectedFile != null && OS2200BuildStreamDialog.this.selectedFile.trim().length() > 0) {
                        OS2200BuildStreamDialog.this.setTxtAreaValue(OS2200BuildStreamDialog.this.selectedFile);
                        string = OS2200BuildStreamDialog.this.selectedFile.substring(OS2200BuildStreamDialog.this.selectedFile.lastIndexOf(File.separator) + 1, OS2200BuildStreamDialog.this.selectedFile.length());
                    } else {
                        string = Messages.getString((String)"FlexibleBuildStream.26");
                    }
                    OS2200BuildStreamDialog.this.isFileSystem = true;
                    OS2200BuildStreamDialog.this.spaceLabel.setText(string.toUpperCase());
                    OS2200BuildStreamDialog.this.spaceLabel.setToolTipText(OS2200BuildStreamDialog.this.selectedFile.toUpperCase());
                    OS2200BuildStreamDialog.this.spaceLabel.setLayoutData((Object)gridData2);
                } else {
                    OS2200CorePlugin.logger.info((Object)(String.valueOf(OS2200BuildStreamDialog.this.selectedFile) + Messages.getString((String)"FlexibleBuildStream.25")));
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.spaceLabel = new Label(composite, 0);
        String string = this.selectedFile != null && this.selectedFile.trim().length() > 0 ? this.selectedFile : Messages.getString((String)"FlexibleBuildStream.26");
        this.spaceLabel.setText(string);
        this.spaceLabel.setToolTipText(string);
        this.spaceLabel.setLayoutData((Object)gridData2);
        this.doNotShowBldStreamDlg = new Button(composite, 32);
        this.doNotShowBldStreamDlg.setText(Messages.getString((String)"FlexibleBuildStream.6"));
        this.doNotShowBldStreamDlg.setLayoutData((Object)gridData2);
        try {
            String string2 = this.project.getPersistentProperty(OS2200ProjectUpdate.DO_NOT_SHOW_FLEX_BUILD_STREAM);
            if (string2 != null) {
                this.doNotShowBldStreamDlg.setSelection(Boolean.parseBoolean(string2));
            } else {
                this.doNotShowBldStreamDlg.setSelection(false);
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        this.doNotShowBldStreamDlg.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.setTxtAreaValue(null);
    }

    protected void save() {
        block20: {
            OS2200CorePlugin.logger.info((Object)"");
            File file = null;
            FileOutputStream fileOutputStream = null;
            String string = this.textArea.getText();
            try {
                try {
                    Object object;
                    if (this.isFileSystem && this.selectedFile != null) {
                        file = new File(this.selectedFile);
                        fileOutputStream = new FileOutputStream(file);
                        object = string.getBytes();
                        fileOutputStream.write((byte[])object);
                        fileOutputStream.flush();
                        object = null;
                    }
                    if (!this.isProjectProperties || this.project == null) break block20;
                    try {
                        object = OS2200ProjectUpdate.getProperties(this.project);
                        String string2 = ((Properties)object).getProperty("BuildType");
                        boolean bl = string2.equals("Debug");
                        if (bl) {
                            ((Properties)object).setProperty("DebugBuildScript", string);
                        } else {
                            ((Properties)object).setProperty("buildStream", string);
                        }
                        try {
                            OS2200ProjectUpdate.setProperties(this.project, (Properties)object);
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                        }
                    }
                    catch (CoreException coreException) {
                        OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
                    }
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                            fileOutputStream = null;
                        }
                        file = null;
                    }
                    catch (Exception exception2) {
                        OS2200CorePlugin.logger.error((Object)exception2.getMessage(), (Throwable)exception2);
                    }
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    file = null;
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    private void setTxtAreaValue(String string) {
        OS2200CorePlugin.logger.info((Object)"");
        if (string == null) {
            if (this.project != null) {
                try {
                    Properties properties = OS2200ProjectUpdate.getProperties(this.project);
                    String string2 = "";
                    String string3 = properties.getProperty("BuildType");
                    boolean bl = string3.equals("Debug");
                    if (bl) {
                        OS2200CorePlugin.logger.debug((Object)"Debug build stream is called.");
                        string2 = properties.getProperty("DebugBuildScript");
                    } else {
                        OS2200CorePlugin.logger.debug((Object)"Build stream is called.");
                        string2 = properties.getProperty("buildStream");
                    }
                    this.textArea.setText(string2.toUpperCase());
                    this.isProjectProperties = true;
                    string2 = null;
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
                }
            }
        } else {
            File file = null;
            FileInputStream fileInputStream = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            ByteBuffer byteBuffer = null;
            try {
                try {
                    file = new File(string);
                    fileInputStream = new FileInputStream(file);
                    abstractInterruptibleChannel = fileInputStream.getChannel();
                    byteBuffer = ByteBuffer.allocate((int)((FileChannel)abstractInterruptibleChannel).size());
                    ((FileChannel)abstractInterruptibleChannel).read(byteBuffer);
                    this.textArea.setText("");
                    this.textArea.setText(new String(byteBuffer.array()));
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    try {
                        if (byteBuffer != null) {
                            byteBuffer = null;
                        }
                        if (abstractInterruptibleChannel != null) {
                            abstractInterruptibleChannel.close();
                            abstractInterruptibleChannel = null;
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                        file = null;
                    }
                    catch (Exception exception2) {
                        OS2200CorePlugin.logger.error((Object)exception2.getMessage(), (Throwable)exception2);
                    }
                }
            }
            finally {
                try {
                    if (byteBuffer != null) {
                        byteBuffer = null;
                    }
                    if (abstractInterruptibleChannel != null) {
                        abstractInterruptibleChannel.close();
                        abstractInterruptibleChannel = null;
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    file = null;
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    private void clearTextArea() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.textArea != null) {
            this.textArea.setText("");
            this.textArea.setFocus();
            this.spaceLabel.setText("");
        }
        if (this.saveBtn != null) {
            this.saveBtn.setEnabled(false);
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        OS2200CorePlugin.logger.info((Object)"");
        this.contents = this.textArea.getText().trim();
        this.showBuildStream();
        super.okPressed();
        this.isFileSystem = false;
        this.selectedFile = null;
    }

    protected void cancelPressed() {
        OS2200CorePlugin.logger.info((Object)"");
        this.contents = this.textArea.getText().trim();
        super.cancelPressed();
        this.isFileSystem = false;
        this.selectedFile = null;
    }

    public boolean close() {
        OS2200CorePlugin.logger.info((Object)"");
        this.contents = this.textArea.getText().trim();
        this.isFileSystem = false;
        this.selectedFile = null;
        return super.close();
    }

    public String getFileContents() {
        return this.contents;
    }

    private void showBuildStream() {
        OS2200CorePlugin.logger.info((Object)"");
        try {
            this.project.setPersistentProperty(OS2200ProjectUpdate.DO_NOT_SHOW_FLEX_BUILD_STREAM, String.valueOf(this.doNotShowBldStreamDlg.getSelection()));
            this.project.setPersistentProperty(OS2200ProjectUpdate.SHOW_FLEX_BUILD_STREAM_PROJECT_PROPERTIES, String.valueOf(!this.doNotShowBldStreamDlg.getSelection()));
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }
}

