/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.dialog;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.texteditor.SWTUtil;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.IEditorStatusLine;

class FindReplaceDialog
extends Dialog {
    private static final int HISTORY_SIZE = 5;
    private Point fIncrementalBaseLocation;
    private boolean fWrapInit = false;
    private boolean fCaseInit = false;
    private boolean fWholeWordInit = false;
    private boolean fForwardInit = true;
    private boolean fGlobalInit = true;
    private boolean fIncrementalInit = false;
    private boolean fNeedsInitialFindBeforeReplace;
    boolean fIsRegExInit = false;
    private List fFindHistory;
    private List fReplaceHistory;
    private IRegion fOldScope;
    private boolean fIsTargetEditable;
    private Text fTarget = null;
    private Shell fParentShell = null;
    private Shell fActiveShell;
    private final ActivationListener fActivationListener = new ActivationListener();
    private Label fReplaceLabel;
    private Label fStatusLabel;
    private Button fForwardRadioButton;
    private Button fIsRegExCheckBox;
    private Button fReplaceSelectionButton;
    private Button fFindNextButton;
    private Button fReplaceAllButton;
    private Combo fFindField;
    private Combo fReplaceField;
    private Rectangle fDialogPositionInit = null;
    private boolean fIsTargetSupportingRegEx;
    private boolean fUseSelectedLines;
    private boolean fGiveFocusToFindField = true;
    private HashMap fMnemonicButtonMap = new HashMap();
    private IDialogSettings fDialogSettings;

    public FindReplaceDialog(Shell shell) {
        super(shell);
        this.fFindHistory = new ArrayList(4);
        this.fReplaceHistory = new ArrayList(4);
        this.readConfiguration();
        this.setShellStyle(this.getShellStyle() | 0x10000);
        this.setBlockOnOpen(false);
    }

    protected boolean isResizable() {
        return false;
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private boolean okToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public void create() {
        OS2200CorePlugin.logger.info((Object)"");
        super.create();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.find_replace_dialog_context");
        this.updateCombo(this.fFindField, this.fFindHistory);
        this.updateCombo(this.fReplaceField, this.fReplaceHistory);
        this.initFindStringFromSelection();
        if (this.fDialogPositionInit != null) {
            shell.setBounds(this.fDialogPositionInit);
        }
        shell.setText(Messages.getString((String)"FlexibleBuildStream.11"));
    }

    private Composite createButtonSection(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = -2;
        composite2.setLayout((Layout)gridLayout);
        this.fReplaceAllButton = this.makeButton(composite2, Messages.getString((String)"FlexibleBuildStream.15"), 105, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200CorePlugin.logger.info((Object)"");
                FindReplaceDialog.this.performReplaceAll();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
            }
        });
        this.setGridData((Control)this.fReplaceAllButton, 4, true, 4, false);
        this.fReplaceAllButton.setEnabled(this.fTarget.getText().trim().length() > 0);
        return composite2;
    }

    private Composite createConfigPanel(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = this.createDirectionGroup(composite2);
        this.setGridData((Control)composite3, 4, true, 4, false);
        return composite2;
    }

    protected Control createContents(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = this.createInputPanel(composite2);
        this.setGridData((Control)composite3, 4, true, 128, false);
        Composite composite4 = this.createConfigPanel(composite2);
        this.setGridData((Control)composite4, 4, true, 128, true);
        Composite composite5 = this.createButtonSection(composite2);
        this.setGridData((Control)composite5, 131072, true, 1024, false);
        Composite composite6 = this.createStatusAndCloseButton(composite2);
        this.setGridData((Control)composite6, 4, true, 1024, false);
        composite2.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                OS2200CorePlugin.logger.info((Object)"");
                if (traverseEvent.detail == 4) {
                    Event event;
                    if (!Util.isMac() && (event = FindReplaceDialog.this.getShell().getDisplay().getFocusControl()) != null && (event.getStyle() & 8) == 8) {
                        return;
                    }
                    event = new Event();
                    event.type = 13;
                    event.stateMask = traverseEvent.stateMask;
                    FindReplaceDialog.this.fFindNextButton.notifyListeners(13, event);
                    traverseEvent.doit = false;
                } else if (traverseEvent.detail == 128) {
                    Character c = new Character(Character.toLowerCase(traverseEvent.character));
                    if (FindReplaceDialog.this.fMnemonicButtonMap.containsKey(c)) {
                        Button button = (Button)FindReplaceDialog.this.fMnemonicButtonMap.get(c);
                        if ((FindReplaceDialog.this.fFindField.isFocusControl() || FindReplaceDialog.this.fReplaceField.isFocusControl() || (button.getStyle() & 8) != 0) && button.isEnabled()) {
                            Event event = new Event();
                            event.type = 13;
                            event.stateMask = traverseEvent.stateMask;
                            if ((button.getStyle() & 0x10) != 0) {
                                Composite composite = button.getParent();
                                if (composite != null) {
                                    Control[] controlArray = composite.getChildren();
                                    int n = 0;
                                    while (n < controlArray.length) {
                                        ((Button)controlArray[n]).setSelection(false);
                                        ++n;
                                    }
                                }
                                button.setSelection(true);
                            } else {
                                button.setSelection(!button.getSelection());
                            }
                            button.notifyListeners(13, event);
                            traverseEvent.detail = 0;
                            traverseEvent.doit = true;
                        }
                    }
                }
            }
        });
        this.updateButtonState();
        FindReplaceDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private Composite createDirectionGroup(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 16);
        group.setText(Messages.getString((String)"FlexibleBuildStream.19"));
        GridLayout gridLayout2 = new GridLayout();
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)new GridData(256, 256, true, true));
        Group group2 = new Group(composite2, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = -2;
        group2.setLayout((Layout)gridLayout3);
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200CorePlugin.logger.info((Object)"");
                if (FindReplaceDialog.this.isIncrementalSearch() && !FindReplaceDialog.this.isRegExSearchAvailableAndChecked()) {
                    FindReplaceDialog.this.initIncrementalBaseLocation();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        this.fForwardRadioButton = new Button((Composite)group, 16400);
        this.fForwardRadioButton.setText(Messages.getString((String)"FlexibleBuildStream.20"));
        this.setGridData((Control)this.fForwardRadioButton, 16384, false, 0x1000000, false);
        this.fForwardRadioButton.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(this.fForwardRadioButton);
        Button button = new Button((Composite)group, 16400);
        button.setText(Messages.getString((String)"FlexibleBuildStream.21"));
        this.setGridData((Control)button, 16384, false, 0x1000000, false);
        button.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(button);
        button.setSelection(!this.fForwardInit);
        this.fForwardRadioButton.setSelection(this.fForwardInit);
        this.fFindNextButton = this.makeButton((Composite)group2, Messages.getString((String)"FlexibleBuildStream.13"), 102, true, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200CorePlugin.logger.info((Object)"");
                if (FindReplaceDialog.this.isIncrementalSearch() && !FindReplaceDialog.this.isRegExSearchAvailableAndChecked()) {
                    FindReplaceDialog.this.initIncrementalBaseLocation();
                }
                FindReplaceDialog.this.fNeedsInitialFindBeforeReplace = false;
                FindReplaceDialog.this.performSearch(selectionEvent.stateMask == 131072 ^ FindReplaceDialog.this.isForwardSearch());
                FindReplaceDialog.this.updateFindHistory();
            }
        });
        this.setGridData((Control)this.fFindNextButton, 4, true, 4, false);
        this.fReplaceSelectionButton = this.makeButton((Composite)group2, Messages.getString((String)"FlexibleBuildStream.14"), 104, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200CorePlugin.logger.info((Object)"");
                if (FindReplaceDialog.this.fNeedsInitialFindBeforeReplace) {
                    FindReplaceDialog.this.performSearch();
                }
                FindReplaceDialog.this.performReplaceSelection();
                FindReplaceDialog.this.updateButtonState();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
            }
        });
        this.setGridData((Control)this.fReplaceSelectionButton, 4, false, 4, false);
        Button button2 = this.makeButton((Composite)group2, "", 106, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        this.setGridData((Control)button2, 4, true, 4, false);
        button2.setVisible(false);
        this.fReplaceAllButton = this.makeButton((Composite)group2, Messages.getString((String)"FlexibleBuildStream.15"), 105, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OS2200CorePlugin.logger.info((Object)"");
                FindReplaceDialog.this.performReplaceAll();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
            }
        });
        this.setGridData((Control)this.fReplaceAllButton, 4, true, 4, false);
        this.fReplaceAllButton.setEnabled(this.fTarget.getText().trim().length() > 0);
        return composite2;
    }

    private Composite createScopeGroup(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    private void useSelectedLines(boolean bl) {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked()) {
            this.initIncrementalBaseLocation();
        }
        if (this.fTarget == null || !(this.fTarget instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension iFindReplaceTargetExtension = (IFindReplaceTargetExtension)this.fTarget;
        if (bl) {
            IRegion iRegion;
            if (this.fOldScope == null) {
                Point point = iFindReplaceTargetExtension.getLineSelection();
                iRegion = new Region(point.x, point.y);
            } else {
                iRegion = this.fOldScope;
                this.fOldScope = null;
            }
            int n = this.isForwardSearch() ? iRegion.getOffset() : iRegion.getOffset() + iRegion.getLength();
            iFindReplaceTargetExtension.setSelection(n, 0);
            iFindReplaceTargetExtension.setScope(iRegion);
        } else {
            this.fOldScope = iFindReplaceTargetExtension.getScope();
            iFindReplaceTargetExtension.setScope(null);
        }
    }

    private Composite createInputPanel(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                OS2200CorePlugin.logger.info((Object)"");
                FindReplaceDialog.this.updateButtonState();
            }
        };
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(Messages.getString((String)"FlexibleBuildStream.22"));
        this.setGridData((Control)label, 16384, false, 0x1000000, false);
        this.fFindField = new Combo(composite2, 2052);
        this.setGridData((Control)this.fFindField, 4, true, 0x1000000, false);
        this.fFindField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                FindReplaceDialog.this.fFindNextButton.setEnabled(FindReplaceDialog.this.fFindField != null && FindReplaceDialog.this.fFindField.getText().trim().length() > 0);
                FindReplaceDialog.this.fReplaceAllButton.setEnabled(FindReplaceDialog.this.fFindField != null && FindReplaceDialog.this.fFindField.getText().trim().length() > 0);
            }
        });
        this.fReplaceLabel = new Label(composite2, 16384);
        this.fReplaceLabel.setText(Messages.getString((String)"FlexibleBuildStream.23"));
        this.setGridData((Control)this.fReplaceLabel, 16384, false, 0x1000000, false);
        this.fReplaceField = new Combo(composite2, 2052);
        this.setGridData((Control)this.fReplaceField, 4, true, 0x1000000, false);
        this.fReplaceField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                FindReplaceDialog.this.fReplaceSelectionButton.setEnabled(FindReplaceDialog.this.fReplaceField != null && FindReplaceDialog.this.fReplaceField.getText().trim().length() > 0);
                FindReplaceDialog.this.fReplaceAllButton.setEnabled(FindReplaceDialog.this.fFindField != null && FindReplaceDialog.this.fFindField.getText().trim().length() > 0);
            }
        });
        return composite2;
    }

    private Composite createStatusAndCloseButton(Composite composite) {
        OS2200CorePlugin.logger.info((Object)"");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fStatusLabel = new Label(composite2, 16384);
        this.setGridData((Control)this.fStatusLabel, 4, true, 0x1000000, false);
        String string = Messages.getString((String)"FlexibleBuildStream.16");
        Button button = this.createButton(composite2, 101, string, false);
        this.setGridData((Control)button, 131072, false, 1024, false);
        return composite2;
    }

    protected void buttonPressed(int n) {
        OS2200CorePlugin.logger.info((Object)"");
        if (n == 101) {
            this.close();
        }
    }

    private int findIndex(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        int n2;
        OS2200CorePlugin.logger.info((Object)"");
        if (bl) {
            int n3 = this.findAndSelect(n, string, true, bl2, bl4, bl5);
            if (n3 == -1 && bl6 && this.okToUse((Control)this.getShell())) {
                this.getShell().getDisplay().beep();
            }
            return n3;
        }
        int n4 = n2 = n == 0 ? -1 : this.findAndSelect(n - 1, string, false, bl2, bl4, bl5);
        if (n2 == -1 && bl6 && this.okToUse((Control)this.getShell())) {
            this.getShell().getDisplay().beep();
        }
        return n2;
    }

    private int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        OS2200CorePlugin.logger.info((Object)"");
        String string2 = this.fTarget.getText().trim().toUpperCase();
        string = string.toUpperCase();
        int n2 = this.fTarget.getCaretPosition() + this.fTarget.getSelectionText().length();
        int n3 = 0;
        if (bl) {
            n3 = n2 <= string2.indexOf(string) ? string2.indexOf(string, this.fTarget.getCaretPosition()) : string2.indexOf(string, this.fTarget.getCaretPosition() + string.length());
            if (n3 >= 0) {
                this.fTarget.setSelection(n3, n3 + string.length());
            }
        } else {
            n3 = string2.lastIndexOf(string, this.fTarget.getCaretPosition() - string.length());
            if (n3 >= 0) {
                this.fTarget.setSelection(n3 + string.length(), n3);
            }
        }
        return n3;
    }

    Point replaceSelection(String string, boolean bl) {
        OS2200CorePlugin.logger.info((Object)"");
        String string2 = this.getFindString();
        String string3 = this.fTarget.getText().trim().toUpperCase();
        StringBuilder stringBuilder = new StringBuilder(string3);
        int n = this.fTarget.getCaretPosition();
        int n2 = string3.indexOf(string2.toUpperCase(), n);
        if (n2 >= 0) {
            stringBuilder.replace(n2, n2 + string2.length(), string.toUpperCase());
        } else {
            this.statusError("No Match Found");
        }
        this.fTarget.setText(stringBuilder.toString());
        this.fTarget.setSelection(n + string.length());
        return this.fTarget.getSelection();
    }

    public void setTargetText(Text text) {
        this.fTarget = text;
    }

    private boolean findNext(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.fTarget == null) {
            return false;
        }
        Point point = null;
        point = this.fTarget.getSelection();
        int n = point.x;
        if (bl && !this.fNeedsInitialFindBeforeReplace || !bl && this.fNeedsInitialFindBeforeReplace) {
            n += point.y;
        }
        this.fNeedsInitialFindBeforeReplace = false;
        int n2 = this.findIndex(string, n, bl, bl2, bl3, bl4, bl6, bl7);
        if (n2 == -1) {
            this.statusMessage(Messages.getString((String)"FlexibleBuildStream.27"));
            return false;
        }
        this.statusMessage("");
        return true;
    }

    protected Point getInitialSize() {
        OS2200CorePlugin.logger.info((Object)"");
        Point point = super.getInitialSize();
        Point point2 = this.getShell().computeSize(-1, -1);
        if (point.x < point2.x) {
            return point2;
        }
        return point;
    }

    private String getFindString() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.okToUse((Control)this.fFindField)) {
            return this.fFindField.getText();
        }
        return "";
    }

    private String getReplaceString() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.okToUse((Control)this.fReplaceField)) {
            return this.fReplaceField.getText();
        }
        return "";
    }

    private String getFirstLine(String string) {
        OS2200CorePlugin.logger.info((Object)"");
        if (string.length() > 0) {
            int[] nArray = TextUtilities.indexOf((String[])TextUtilities.DELIMITERS, (String)string, (int)0);
            if (nArray[0] > 0) {
                return string.substring(0, nArray[0]);
            }
            if (nArray[0] == -1) {
                return string;
            }
        }
        return "";
    }

    public boolean close() {
        OS2200CorePlugin.logger.info((Object)"");
        this.handleDialogClose();
        return super.close();
    }

    private void handleDialogClose() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.fParentShell != null) {
            this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            this.fParentShell = null;
        }
        this.getShell().removeShellListener((ShellListener)this.fActivationListener);
        this.storeSettings();
        this.fActiveShell = null;
        this.fTarget = null;
    }

    private void initFindStringFromSelection() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.fTarget != null && this.okToUse((Control)this.fFindField)) {
            String string = this.fTarget.getSelectionText();
            boolean bl = this.isRegExSearchAvailableAndChecked();
            if (string.length() > 0) {
                String string2 = this.getFirstLine(string);
                if (bl) {
                    FindReplaceDocumentAdapter.escapeForRegExPattern((String)string);
                }
                this.fFindField.setText(string);
                if (!string2.equals(string)) {
                    this.useSelectedLines(true);
                    this.fUseSelectedLines = true;
                }
            } else if ("".equals(this.fFindField.getText())) {
                if (this.fFindHistory.size() > 0) {
                    this.fFindField.setText((String)this.fFindHistory.get(0));
                } else {
                    this.fFindField.setText("");
                }
            }
            this.fFindField.setSelection(new Point(0, this.fFindField.getText().length()));
        }
    }

    private void initIncrementalBaseLocation() {
        OS2200CorePlugin.logger.info((Object)"");
        this.fIncrementalBaseLocation = this.fTarget != null && this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked() ? this.fTarget.getSelection() : new Point(0, 0);
    }

    private boolean isCaseSensitiveSearch() {
        return false;
    }

    private boolean isRegExSearch() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isRegExSearchAvailableAndChecked() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsTargetSupportingRegEx && this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isForwardSearch() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.okToUse((Control)this.fForwardRadioButton)) {
            return this.fForwardRadioButton.getSelection();
        }
        return this.fForwardInit;
    }

    private boolean isWholeWordSetting() {
        return true;
    }

    private boolean isWholeWordSearch() {
        return true;
    }

    private boolean isWrapSearch() {
        return false;
    }

    private boolean isIncrementalSearch() {
        return true;
    }

    private Button makeButton(Composite composite, String string, int n, boolean bl, SelectionListener selectionListener) {
        OS2200CorePlugin.logger.info((Object)"");
        Button button = this.createButton(composite, n, string, bl);
        button.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(button);
        return button;
    }

    private void storeButtonWithMnemonicInMap(Button button) {
        OS2200CorePlugin.logger.info((Object)"");
        char c = LegacyActionTools.extractMnemonic((String)button.getText());
        if (c != '\u0000') {
            this.fMnemonicButtonMap.put(new Character(Character.toLowerCase(c)), button);
        }
    }

    private IEditorStatusLine getStatusLineManager() {
        OS2200CorePlugin.logger.info((Object)"");
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null) {
            return null;
        }
        return (IEditorStatusLine)iEditorPart.getAdapter(IEditorStatusLine.class);
    }

    private void statusMessage(boolean bl, String string) {
        OS2200CorePlugin.logger.info((Object)"");
        this.fStatusLabel.setText(string);
        this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        IEditorStatusLine iEditorStatusLine = this.getStatusLineManager();
        if (iEditorStatusLine != null) {
            iEditorStatusLine.setMessage(bl, string, null);
        }
        if (bl) {
            this.getShell().getDisplay().beep();
        }
    }

    private void statusError(String string) {
        this.statusMessage(true, string);
    }

    private void statusMessage(String string) {
        this.statusMessage(false, string);
    }

    private void performReplaceAll() {
        OS2200CorePlugin.logger.info((Object)"");
        int n = 0;
        String string = this.getReplaceString();
        String string2 = this.getFindString();
        if (string2 != null && string2.length() > 0) {
            try {
                class ReplaceAllRunnable
                implements Runnable {
                    public int numberOfOccurrences;
                    private final /* synthetic */ String val$findString;
                    private final /* synthetic */ String val$replaceString;

                    ReplaceAllRunnable(String string, String string2) {
                        this.val$findString = string;
                        this.val$replaceString = string2;
                    }

                    @Override
                    public void run() {
                        this.numberOfOccurrences = FindReplaceDialog.this.replaceAll(this.val$findString, this.val$replaceString == null ? "" : this.val$replaceString, FindReplaceDialog.this.isForwardSearch(), FindReplaceDialog.this.isCaseSensitiveSearch(), FindReplaceDialog.this.isWholeWordSearch(), FindReplaceDialog.this.isRegExSearchAvailableAndChecked());
                    }
                }
                ReplaceAllRunnable replaceAllRunnable = new ReplaceAllRunnable(string2, string);
                BusyIndicator.showWhile((Display)this.fActiveShell.getDisplay(), (Runnable)replaceAllRunnable);
                n = replaceAllRunnable.numberOfOccurrences;
                if (n == 0) {
                    this.statusMessage(Messages.getString((String)"FlexibleBuildStream.17"));
                } else {
                    this.statusMessage(Messages.getString((String)"FlexibleBuildStream.18"));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.statusError(patternSyntaxException.getLocalizedMessage());
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.updateButtonState();
    }

    private boolean validateTargetState() {
        return this.isEditable();
    }

    private boolean performReplaceSelection() {
        boolean bl;
        OS2200CorePlugin.logger.info((Object)"");
        if (!this.validateTargetState()) {
            return false;
        }
        String string = this.getReplaceString();
        if (string == null) {
            string = "";
        }
        try {
            this.replaceSelection(string, this.isRegExSearchAvailableAndChecked());
            bl = true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.statusError(patternSyntaxException.getLocalizedMessage());
            bl = false;
        }
        catch (IllegalStateException illegalStateException) {
            bl = false;
        }
        return bl;
    }

    private void performSearch() {
        this.performSearch(this.isForwardSearch());
    }

    private void performSearch(boolean bl) {
        this.performSearch(this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked(), true, bl);
    }

    private void performSearch(boolean bl, boolean bl2, boolean bl3) {
        OS2200CorePlugin.logger.info((Object)"");
        if (bl) {
            this.initIncrementalBaseLocation();
        }
        String string = this.getFindString();
        boolean bl4 = false;
        if (string != null && string.length() > 0) {
            try {
                bl4 = this.findNext(string, bl3, this.isCaseSensitiveSearch(), this.isWrapSearch(), this.isWholeWordSearch(), this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked(), this.isRegExSearchAvailableAndChecked(), bl2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.statusError(patternSyntaxException.getLocalizedMessage());
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.updateButtonState(!bl4);
    }

    private int replaceAll(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        OS2200CorePlugin.logger.info((Object)"");
        int n = 0;
        String string3 = this.fTarget.getText().trim().toUpperCase();
        int n2 = this.fTarget.getCaretPosition();
        if (string3.indexOf(string.toUpperCase()) > 0) {
            string3 = string3.replace(string.toUpperCase(), string2.toUpperCase());
            this.fTarget.setText(string3.toUpperCase());
            this.fTarget.setSelection(n2);
            n = 1;
        } else {
            n = 0;
        }
        return n;
    }

    private void setGridData(Control control, int n, boolean bl, int n2, boolean bl2) {
        GridData gridData;
        OS2200CorePlugin.logger.info((Object)"");
        if (control instanceof Button && (((Button)control).getStyle() & 8) != 0) {
            SWTUtil.setButtonDimensionHint((Button)((Button)control));
            gridData = (GridData)control.getLayoutData();
        } else {
            gridData = new GridData();
            control.setLayoutData((Object)gridData);
            gridData.horizontalAlignment = n;
            gridData.grabExcessHorizontalSpace = bl;
        }
        gridData.verticalAlignment = n2;
        gridData.grabExcessVerticalSpace = bl2;
    }

    private void addDecorationMargin(Control control) {
        OS2200CorePlugin.logger.info((Object)"");
        Object object = control.getLayoutData();
        if (!(object instanceof GridData)) {
            return;
        }
        GridData cfr_ignored_0 = (GridData)object;
    }

    private void updateButtonState() {
        this.updateButtonState(false);
    }

    private void updateButtonState(boolean bl) {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.okToUse((Control)this.getShell()) && this.okToUse((Control)this.fFindNextButton)) {
            String string;
            boolean bl2 = false;
            if (this.fTarget != null) {
                bl2 = this.fTarget.getSelectionText().length() > 0;
            }
            boolean bl3 = (string = this.getFindString()) != null && string.length() > 0;
            this.fFindNextButton.setEnabled(this.fFindField != null && this.fFindField.getText().trim().length() > 0);
            this.fReplaceSelectionButton.setEnabled(!bl && this.isEditable() && bl2 && (!this.fNeedsInitialFindBeforeReplace || !this.isRegExSearchAvailableAndChecked()));
            this.fReplaceAllButton.setEnabled(this.isEditable() && bl3);
        }
    }

    private boolean isWord(String string) {
        OS2200CorePlugin.logger.info((Object)"");
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void updateCombo(Combo combo, List list) {
        OS2200CorePlugin.logger.info((Object)"");
        if (combo != null) {
            combo.removeAll();
        }
        int n = 0;
        while (n < list.size()) {
            combo.add(list.get(n).toString());
            ++n;
        }
    }

    private void updateFindAndReplaceHistory() {
        OS2200CorePlugin.logger.info((Object)"");
        this.updateFindHistory();
        if (this.okToUse((Control)this.fReplaceField)) {
            this.updateHistory(this.fReplaceField, this.fReplaceHistory);
        }
    }

    private void updateFindHistory() {
        OS2200CorePlugin.logger.info((Object)"");
        if (this.okToUse((Control)this.fFindField)) {
            this.updateHistory(this.fFindField, this.fFindHistory);
        }
    }

    private void updateHistory(Combo combo, List list) {
        OS2200CorePlugin.logger.info((Object)"");
        String string = combo.getText();
        int n = list.indexOf(string);
        if (n != 0) {
            if (n != -1) {
                list.remove(n);
            }
            list.add(0, string);
            Point point = combo.getSelection();
            this.updateCombo(combo, list);
            combo.setText(string);
            combo.setSelection(point);
        }
    }

    private boolean isEditable() {
        OS2200CorePlugin.logger.info((Object)"");
        boolean bl = this.fTarget == null ? false : this.fTarget.isEnabled();
        return bl;
    }

    public void updateTarget(IFindReplaceTarget iFindReplaceTarget, boolean bl, boolean bl2) {
        OS2200CorePlugin.logger.info((Object)"");
        this.fIsTargetEditable = bl;
        this.fNeedsInitialFindBeforeReplace = true;
        if (iFindReplaceTarget != this.fTarget) {
            this.fTarget = null;
            if (this.fTarget != null) {
                this.fIsTargetSupportingRegEx = this.fTarget instanceof IFindReplaceTargetExtension3;
            }
            if (this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).beginSession();
            }
        }
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            this.fIsRegExCheckBox.setEnabled(this.fIsTargetSupportingRegEx);
        }
        if (this.okToUse((Control)this.fReplaceLabel)) {
            this.fReplaceLabel.setEnabled(this.isEditable());
            this.fReplaceField.setEnabled(this.isEditable());
            if (bl2) {
                this.initFindStringFromSelection();
                this.fGiveFocusToFindField = true;
            }
            this.initIncrementalBaseLocation();
            this.updateButtonState();
        }
    }

    public void setParentShell(Shell shell) {
        OS2200CorePlugin.logger.info((Object)"");
        if (shell != this.fParentShell) {
            if (this.fParentShell != null) {
                this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fParentShell = shell;
            this.fParentShell.addShellListener((ShellListener)this.fActivationListener);
        }
        this.fActiveShell = shell;
    }

    private void readConfiguration() {
        String[] stringArray;
        IDialogSettings iDialogSettings = this.getDialogSettings();
        this.fWrapInit = iDialogSettings.get("wrap") == null || iDialogSettings.getBoolean("wrap");
        this.fCaseInit = iDialogSettings.getBoolean("casesensitive");
        this.fWholeWordInit = iDialogSettings.getBoolean("wholeword");
        this.fIncrementalInit = iDialogSettings.getBoolean("incremental");
        this.fIsRegExInit = iDialogSettings.getBoolean("isRegEx");
        String[] stringArray2 = iDialogSettings.getArray("findhistory");
        if (stringArray2 != null) {
            stringArray = this.getFindHistory();
            stringArray.clear();
            int n = 0;
            while (n < stringArray2.length) {
                stringArray.add(stringArray2[n]);
                ++n;
            }
        }
        if ((stringArray = iDialogSettings.getArray("replacehistory")) != null) {
            List list = this.getReplaceHistory();
            list.clear();
            int n = 0;
            while (n < stringArray.length) {
                list.add(stringArray[n]);
                ++n;
            }
        }
    }

    private void writeConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        iDialogSettings.put("wrap", this.fWrapInit);
        iDialogSettings.put("casesensitive", this.fCaseInit);
        iDialogSettings.put("wholeword", this.fWholeWordInit);
        iDialogSettings.put("incremental", this.fIncrementalInit);
        iDialogSettings.put("isRegEx", this.fIsRegExInit);
        List list = this.getFindHistory();
        String string = this.getFindString();
        if (string.length() > 0) {
            list.add(0, string);
        }
        this.writeHistory(list, iDialogSettings, "findhistory");
        list = this.getReplaceHistory();
        String string2 = this.getReplaceString();
        if (string2.length() > 0) {
            list.add(0, string2);
        }
        this.writeHistory(list, iDialogSettings, "replacehistory");
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = TextEditorPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = iDialogSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = iDialogSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    private List getFindHistory() {
        return this.fFindHistory;
    }

    private List getReplaceHistory() {
        return this.fReplaceHistory;
    }

    private void writeHistory(List list, IDialogSettings iDialogSettings, String string) {
        int n = list.size();
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)list.get(n2);
            if (hashSet.contains(string2)) {
                list.remove(n2--);
                --n;
            } else {
                hashSet.add(string2);
            }
            ++n2;
        }
        while (list.size() > 8) {
            list.remove(8);
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        iDialogSettings.put(string, stringArray);
    }

    private void storeSettings() {
        this.fDialogPositionInit = this.getDialogBoundaries();
        this.fWrapInit = this.isWrapSearch();
        this.fWholeWordInit = this.isWholeWordSetting();
        this.fCaseInit = this.isCaseSensitiveSearch();
        this.fIsRegExInit = this.isRegExSearch();
        this.fIncrementalInit = this.isIncrementalSearch();
        this.fForwardInit = this.isForwardSearch();
        this.writeConfiguration();
    }

    private Rectangle getDialogBoundaries() {
        if (this.okToUse((Control)this.getShell())) {
            return this.getShell().getBounds();
        }
        return this.fDialogPositionInit;
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent shellEvent) {
            OS2200CorePlugin.logger.info((Object)"");
            FindReplaceDialog.this.fActiveShell = (Shell)shellEvent.widget;
            FindReplaceDialog.this.updateButtonState();
            if (FindReplaceDialog.this.fGiveFocusToFindField && FindReplaceDialog.this.getShell() == FindReplaceDialog.this.fActiveShell && FindReplaceDialog.this.okToUse((Control)FindReplaceDialog.this.fFindField)) {
                FindReplaceDialog.this.fFindField.setFocus();
            }
        }

        public void shellDeactivated(ShellEvent shellEvent) {
            OS2200CorePlugin.logger.info((Object)"");
            FindReplaceDialog.this.fGiveFocusToFindField = false;
            FindReplaceDialog.this.fUseSelectedLines = false;
            FindReplaceDialog.this.fOldScope = null;
            FindReplaceDialog.this.fActiveShell = null;
            FindReplaceDialog.this.updateButtonState();
        }
    }
}

