/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.tde.core.OS2200TimerTask;
import java.util.Arrays;

class TaskQueue {
    private OS2200TimerTask[] queue = new OS2200TimerTask[128];
    private int size = 0;

    TaskQueue() {
    }

    int size() {
        return this.size;
    }

    void add(OS2200TimerTask oS2200TimerTask) {
        if (this.size + 1 == this.queue.length) {
            this.queue = Arrays.copyOf(this.queue, 2 * this.queue.length);
        }
        this.queue[++this.size] = oS2200TimerTask;
        this.fixUp(this.size);
    }

    OS2200TimerTask getMin() {
        return this.queue[1];
    }

    OS2200TimerTask get(int n) {
        return this.queue[n];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void quickRemove(int n) {
        assert (n <= this.size);
        this.queue[n] = this.queue[this.size];
        this.queue[this.size--] = null;
    }

    void rescheduleMin(long l) {
        this.queue[1].nextExecutionTime = l;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        int n = 1;
        while (n <= this.size) {
            this.queue[n] = null;
            ++n;
        }
        this.size = 0;
    }

    private void fixUp(int n) {
        while (n > 1) {
            int n2 = n >> 1;
            if (this.queue[n2].nextExecutionTime <= this.queue[n].nextExecutionTime) break;
            OS2200TimerTask oS2200TimerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = oS2200TimerTask;
            n = n2;
        }
    }

    private void fixDown(int n) {
        int n2;
        while ((n2 = n << 1) <= this.size && n2 > 0) {
            if (n2 < this.size && this.queue[n2].nextExecutionTime > this.queue[n2 + 1].nextExecutionTime) {
                ++n2;
            }
            if (this.queue[n].nextExecutionTime <= this.queue[n2].nextExecutionTime) break;
            OS2200TimerTask oS2200TimerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = oS2200TimerTask;
            n = n2;
        }
    }

    void heapify() {
        int n = this.size / 2;
        while (n >= 1) {
            this.fixDown(n);
            --n;
        }
    }
}

