/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.tde.core.OS2200CorePlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;

public class RuntimeExec {
    private static RuntimeExec runTimeObj = null;
    private static Runtime rt = null;
    private static RuntimeExec rte = null;
    private String err = null;
    private String out = null;
    private StreamWrapper error = null;
    private StreamWrapper output = null;

    public String getErr() {
        return this.err;
    }

    public String getOut() {
        return this.out;
    }

    public static RuntimeExec getRuntimeExecInst() {
        if (runTimeObj == null) {
            runTimeObj = new RuntimeExec();
            rt = Runtime.getRuntime();
            rte = new RuntimeExec();
        }
        return runTimeObj;
    }

    public StreamWrapper getStreamWrapper(InputStream inputStream) {
        return new StreamWrapper(inputStream);
    }

    public void executeCMD(String string) {
        Process process = null;
        RuntimeExec.getRuntimeExecInst();
        try {
            OS2200CorePlugin.logger.info((Object)("string to be executed in command prompt := " + string));
            process = rt.exec(string);
            this.error = rte.getStreamWrapper(process.getErrorStream());
            this.output = rte.getStreamWrapper(process.getInputStream());
            this.error.start();
            this.output.start();
            try {
                this.error.join(3000L);
                this.output.join(3000L);
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                OS2200CorePlugin.logger.warn((Object)interruptedException.getMessage(), (Throwable)interruptedException);
            }
            this.err = this.error.message;
            this.out = this.output.message;
            OS2200CorePlugin.logger.info((Object)("Error: " + this.err));
            OS2200CorePlugin.logger.info((Object)("Output: " + this.out));
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public int doMappedDrive(String string, String string2, String string3) {
        String string4 = "net use " + string + " " + string3 + " /USER:" + string2;
        this.executeCMD(string4);
        if (this.err.length() == 0 && this.out.equalsIgnoreCase("The command completed successfully.")) {
            return 0;
        }
        return -1;
    }

    public long disconnectCIFS(String string) {
        String string2;
        String string3 = "net use " + string + " /delete";
        this.executeCMD(string3);
        if (this.err.length() == 0) {
            return 0L;
        }
        int n = this.err.lastIndexOf(".");
        int n2 = this.err.lastIndexOf(" ");
        int n3 = -1;
        if (n2 >= 0 && n > 0 && n2 < n && StringUtils.isNumeric((String)(string2 = this.err.substring(n2, n).trim()))) {
            n3 = Integer.parseInt(string2);
        }
        return n3;
    }

    public boolean disConnectMapDrive(String string) {
        if (!(string = string.trim()).contains(" ")) {
            String string2 = "NET USE " + string + " /DELETE";
            this.executeCMD(string2);
            return this.err.length() == 0;
        }
        return true;
    }

    public String getconnectCifsMsg(long l) {
        String string = "net helpmsg " + l;
        this.executeCMD(string);
        if (this.err != null && this.err.length() > 0) {
            OS2200CorePlugin.logger.debug((Object)(String.valueOf(string) + " : " + this.err));
        }
        return this.out;
    }

    private class StreamWrapper
    extends Thread {
        InputStream is = null;
        String message = null;

        StreamWrapper(InputStream inputStream) {
            this.is = inputStream;
        }

        @Override
        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
                StringBuffer stringBuffer = new StringBuffer();
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                }
                this.message = stringBuffer.toString();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }
}

