/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.TelnetCall;
import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDPCopyProc {
    private final String EIGHTY_SPACES = "                                                                                ";
    private final String COMMENT_CHAR = "*";
    private final String PERIOD = ".";
    private final String SLASH = "/";
    private final String EMPTY_STR = "";
    private final String PROC = " PROC";
    private final String HASH = "#";
    private String EditorContent;
    private IDocument doc;
    private static PDPCopyProc instance = null;
    private boolean returnValue = false;

    private PDPCopyProc() {
    }

    public static PDPCopyProc getPDPCopyProcInstance() {
        if (instance == null) {
            instance = new PDPCopyProc();
        }
        return instance;
    }

    public boolean checkAndPerformPdp() {
        this.returnValue = false;
        OS2200CorePlugin.logger.debug((Object)"Performing PDP checks and operations");
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        if (iPreferenceStore.getBoolean("Check for PDP Copy Proc after save") && PDPCopyProc.getPDPCopyProcInstance().isProcedure(false)) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean bl = PDPCopyProc.getPDPCopyProcInstance().performPDPCopyProc();
                    if (bl) {
                        OS2200CorePlugin.logger.info((Object)"PDP Copy Proc performed");
                        PDPCopyProc.this.returnValue = true;
                    }
                }
            });
            return this.returnValue;
        }
        OS2200CorePlugin.logger.info((Object)"PDP Copy Proc not performed");
        return false;
    }

    public boolean performPDPCopyProc() {
        OS2200CorePlugin.logger.debug((Object)"Entered perfromPDPCopyProc method");
        PDPCopyProcDialog pDPCopyProcDialog = new PDPCopyProcDialog(Display.getDefault().getActiveShell());
        pDPCopyProcDialog.open();
        return true;
    }

    public boolean isValidEditor(boolean bl) {
        OS2200CorePlugin.logger.debug((Object)"Entered isValid method");
        if (!bl) {
            this.readCurrentEditorCurrent();
        }
        if (this.EditorContent != null) {
            return true;
        }
        OS2200CorePlugin.logger.debug((Object)"is not a valid editor");
        return false;
    }

    public boolean isProcedure(boolean bl) {
        OS2200CorePlugin.logger.debug((Object)"Entered isProcedure method");
        if (!bl) {
            this.readCurrentEditorCurrent();
        }
        if (this.EditorContent == null) {
            OS2200CorePlugin.logger.debug((Object)"Editorcontent is null");
            return false;
        }
        if (this.EditorContent.contains(" PROC") && this.EditorContent.contains(" END")) {
            OS2200CorePlugin.logger.debug((Object)"editor needs to be validated further for COBOL procedure");
            int n = this.doc.getNumberOfLines();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                try {
                    int n4 = 0;
                    n4 = this.doc.getLineLength(n3);
                    String string = this.doc.get(n2, n4);
                    n2 += n4;
                    if (!(String.valueOf(string) + "                                                                                ").substring(6, 72).startsWith("*") && (string = string.trim()).length() > 0) {
                        if (string.endsWith(".")) {
                            string = string.replace(".", "");
                        }
                        return (string = string.toUpperCase()).endsWith(" PROC");
                    }
                }
                catch (BadLocationException badLocationException) {
                    OS2200CorePlugin.logger.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                }
                ++n3;
            }
        }
        return false;
    }

    protected void readCurrentEditorCurrent() {
        OS2200CorePlugin.logger.debug((Object)"Entered readCurrrentEditorContent method");
        this.EditorContent = null;
        try {
            IEditorPart iEditorPart = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getActiveEditor();
            if (iEditorPart != null && iEditorPart instanceof ITextEditor && (iEditorPart.getSite().getId().equalsIgnoreCase("org.eclipse.ui.DefaultTextEditor") || iEditorPart.getSite().getId().equalsIgnoreCase("com.unisys.os2200.editor.UDTEditor"))) {
                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                this.doc = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
                this.EditorContent = this.doc.get().toUpperCase();
                OS2200CorePlugin.logger.debug((Object)"Editor contents are copied to EditorContent");
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private String getInitialPdpPath(String string) {
        OS2200CorePlugin.logger.debug((Object)"Entered getInitialPdpPath");
        String string2 = OS2200FileInterface.getPath(string, 1);
        if (string2.contains("#")) {
            string2 = string2.substring(string2.indexOf("#") + "#".length());
        }
        return string2;
    }

    class PDPCopyProcDialog
    extends SelectionStatusDialog {
        private Text PDPcopyProcText;
        private Listener pdpTextBoxModifyListener;

        protected PDPCopyProcDialog(Shell shell) {
            super(shell);
            this.pdpTextBoxModifyListener = new Listener(){

                public void handleEvent(Event event) {
                    String string = PDPCopyProcDialog.this.PDPcopyProcText.getText().trim();
                    PDPCopyProcDialog.this.getButton(0).setEnabled(string != null && string.length() > 0);
                }
            };
        }

        protected Control createDialogArea(Composite composite) {
            OS2200CorePlugin.logger.debug((Object)"Entered creatDialogArea method of PDPCopyProcDialog class");
            String string = "@PDP,UC ";
            String string2 = this.getInitialValuesforPdp();
            if (string2 != null) {
                string2 = string2.toUpperCase();
                string = String.valueOf(string) + string2;
            }
            this.setHelpAvailable(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.tde.ui.PDP_Copy_Proc");
            composite.getShell().setText(Messages.getString((String)"PDPCopyProcDialog.title"));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite.setLayout((Layout)gridLayout);
            Label label = new Label(composite, 0);
            label.setText(Messages.getString((String)"PDPCopyProcDialog.label"));
            GridData gridData = new GridData();
            gridData = new GridData();
            gridData.verticalAlignment = 128;
            label.setLayoutData((Object)gridData);
            this.PDPcopyProcText = new Text(composite, 2048);
            this.PDPcopyProcText.setTextLimit(250);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.PDPcopyProcText.setLayoutData((Object)gridData);
            this.PDPcopyProcText.setText(string);
            this.PDPcopyProcText.addListener(24, this.pdpTextBoxModifyListener);
            return composite;
        }

        protected void okPressed() {
            OS2200CorePlugin.logger.debug((Object)"");
            final String string = this.PDPcopyProcText.getText().trim();
            super.okPressed();
            final TelnetCall telnetCall = new TelnetCall();
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    telnetCall.executeCommand(string);
                }
            });
        }

        protected void computeResult() {
        }

        private String getInitialValuesforPdp() {
            OS2200CorePlugin.logger.debug((Object)"Entered getIntialValuesforPdp method");
            String string = "";
            String string2 = "";
            IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (iEditorPart != null) {
                if (iEditorPart.getEditorInput() instanceof OS2200FileEditorInput && ((OS2200FileEditorInput)iEditorPart.getEditorInput()).isOS2200File()) {
                    if (!((OS2200FileEditorInput)iEditorPart.getEditorInput()).getFileShare().equals((Object)OS2200ProjectUpdate.Share.nShare)) {
                        string = ((OS2200FileEditorInput)iEditorPart.getEditorInput()).getPath().toOSString();
                    }
                    if (!string.isEmpty()) {
                        string2 = PDPCopyProc.this.getInitialPdpPath(string);
                    }
                    return string2;
                }
                if (iEditorPart.getEditorInput() instanceof IFileEditorInput) {
                    try {
                        IFile iFile = ((IFileEditorInput)iEditorPart.getEditorInput()).getFile();
                        Properties properties = OS2200ProjectUpdate.getProperties(iFile.getProject());
                        String string3 = properties.getProperty("workFile");
                        if (string3.contains("#")) {
                            string3 = string3.substring(string3.indexOf("#") + "#".length());
                        }
                        string = iFile.getLocation().toOSString();
                        if ((string = string.substring(string.lastIndexOf(File.separator) + 1)).contains(".")) {
                            string = string.replace(".", "/");
                        }
                        string2 = String.valueOf(string3) + string;
                        return string2;
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                        return string2;
                    }
                }
            }
            return string2;
        }
    }
}

