/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.tde.core.OS2200TimerTask;
import com.unisys.tde.core.TaskQueue;
import com.unisys.tde.core.TimerThread;
import java.util.Date;

public class OS2200Timer {
    private TaskQueue queue = new TaskQueue();
    private TimerThread thread = new TimerThread(this.queue);
    private Object threadReaper = new Object(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            TaskQueue taskQueue = OS2200Timer.this.queue;
            synchronized (taskQueue) {
                ((OS2200Timer)OS2200Timer.this).thread.newTasksMayBeScheduled = false;
                OS2200Timer.this.queue.notify();
            }
        }
    };
    private static int nextSerialNumber = 0;

    private static synchronized int serialNumber() {
        return nextSerialNumber++;
    }

    public OS2200Timer() {
        this("Timer-" + OS2200Timer.serialNumber());
    }

    public OS2200Timer(boolean bl) {
        this("Timer-" + OS2200Timer.serialNumber(), bl);
    }

    public OS2200Timer(String string) {
        this.thread.setName(string);
        this.thread.start();
    }

    public OS2200Timer(String string, boolean bl) {
        this.thread.setName(string);
        this.thread.setDaemon(bl);
        this.thread.start();
    }

    public void schedule(OS2200TimerTask oS2200TimerTask, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(oS2200TimerTask, System.currentTimeMillis() + l, 0L);
    }

    public void schedule(OS2200TimerTask oS2200TimerTask, Date date) {
        this.sched(oS2200TimerTask, date.getTime(), 0L);
    }

    public void schedule(OS2200TimerTask oS2200TimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(oS2200TimerTask, System.currentTimeMillis() + l, -l2);
    }

    public void schedule(OS2200TimerTask oS2200TimerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(oS2200TimerTask, date.getTime(), -l);
    }

    public void scheduleAtFixedRate(OS2200TimerTask oS2200TimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(oS2200TimerTask, System.currentTimeMillis() + l, l2);
    }

    public void scheduleAtFixedRate(OS2200TimerTask oS2200TimerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(oS2200TimerTask, date.getTime(), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(OS2200TimerTask oS2200TimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = oS2200TimerTask.lock;
            synchronized (object) {
                if (oS2200TimerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                oS2200TimerTask.nextExecutionTime = l;
                oS2200TimerTask.period = l2;
                oS2200TimerTask.state = 1;
            }
            this.queue.add(oS2200TimerTask);
            if (this.queue.getMin() == oS2200TimerTask) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.thread.newTasksMayBeScheduled = false;
            this.thread.interrupt();
            this.queue.clear();
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int n = 0;
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            int n2 = this.queue.size();
            while (n2 > 0) {
                if (this.queue.get((int)n2).state == 3) {
                    this.queue.quickRemove(n2);
                    ++n;
                }
                --n2;
            }
            if (n != 0) {
                this.queue.heapify();
            }
        }
        return n;
    }
}

