/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.MemChecker;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200GeneralEditListener;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.OS2200StartupWorkerThread;
import com.unisys.tde.license.LicensePlugin;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.markers.ProblemsView;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class OS2200Startup
implements IStartup {
    private static final String PLUGIN_ID = "com.unisys.tde.core.characterset";
    static AbstractTextEditor ate = null;
    private IProject[] projects = null;
    private Thread loadCharSet = null;
    private IWorkbenchPage page = null;
    private static List<IProject> toCloseProject = null;
    private static List<IEditorReference> toCloseEditors = new ArrayList<IEditorReference>(50);
    private List<IEditorReference> editorsOpened = null;
    private StringBuffer sbf = null;
    static ProblemsView hView = null;
    private TDECoreUtilities fileSynchronizer = TDECoreUtilities.getInstance();

    public void earlyStartup() {
        IWorkbenchWindow iWorkbenchWindow;
        IWorkbench iWorkbench;
        if (OS2200CorePlugin.logger.isInfoEnabled()) {
            OS2200CorePlugin.logger.info((Object)"Entering EarlyStartup");
        }
        if ((iWorkbench = PlatformUI.getWorkbench()) != null && (iWorkbenchWindow = iWorkbench.getWorkbenchWindows()[0]) != null) {
            this.page = iWorkbenchWindow.getActivePage();
            if (this.page != null) {
                IEditorReference[] iEditorReferenceArray = this.page.getEditorReferences();
                this.editorsOpened = new ArrayList<IEditorReference>(Arrays.asList(iEditorReferenceArray));
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                try {
                    progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            try {
                                iProgressMonitor.beginTask(Messages.getString((String)"OS2200Startup_5"), 4);
                                iProgressMonitor.subTask(Messages.getString((String)"OS2200Startup_6"));
                                if (!LicensePlugin.checkLicense()) {
                                    iProgressMonitor.done();
                                    return;
                                }
                                try {
                                    iProgressMonitor.worked(1);
                                    iProgressMonitor.subTask(Messages.getString((String)"OS2200Startup_7"));
                                    long l = System.currentTimeMillis();
                                    OS2200Startup.this.checkOpenProjects(iProgressMonitor);
                                    long l2 = System.currentTimeMillis();
                                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                        OS2200CorePlugin.logger.info((Object)(" Checking for Open Project completed in " + (l2 - l) + " milliseconds."));
                                    }
                                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200Startup_8")) + (l2 - l) + Messages.getString((String)"OS2200Startup_10"));
                                    iProgressMonitor.worked(1);
                                    iProgressMonitor.subTask(Messages.getString((String)"OS2200Startup_11"));
                                    long l3 = System.currentTimeMillis();
                                    OS2200Startup.checkForConvertedEditors(iProgressMonitor);
                                    long l4 = System.currentTimeMillis();
                                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                        OS2200CorePlugin.logger.info((Object)(" Converted Editors verification completd in " + (l4 - l3) + " milliseconds."));
                                    }
                                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200Startup_12")) + (l4 - l3) + Messages.getString((String)"OS2200Startup_13"));
                                    iProgressMonitor.worked(1);
                                    iProgressMonitor.subTask(Messages.getString((String)"OS2200Startup_14"));
                                    long l5 = System.currentTimeMillis();
                                    OS2200Startup.this.removeForOS2200Consoles();
                                    long l6 = System.currentTimeMillis();
                                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                        OS2200CorePlugin.logger.info((Object)(" Removing the OS2200 Console in " + (l6 - l5) + " milliseconds."));
                                    }
                                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200Startup_15")) + (l6 - l5) + Messages.getString((String)"OS2200Startup_16"));
                                    iProgressMonitor.worked(1);
                                    PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                                        public boolean preShutdown(IWorkbench iWorkbench, boolean bl) {
                                            MemChecker.getInstance().closeAllWindows();
                                            return true;
                                        }

                                        public void postShutdown(IWorkbench iWorkbench) {
                                        }
                                    });
                                }
                                catch (Exception exception) {
                                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                                }
                            }
                            finally {
                                iProgressMonitor.done();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        });
        TDECoreUtilities.getInstance();
        TDECoreUtilities.addDoubleClickListenerOnProblemsView();
    }

    private void listOpenEditorsAssociatedToProject(IProject iProject) {
        if (OS2200CorePlugin.logger.isInfoEnabled()) {
            OS2200CorePlugin.logger.info((Object)("Fetching a list of all the opened editors related to project " + iProject.getName()));
        }
        try {
            if (this.page != null) {
                Iterator<IEditorReference> iterator = this.editorsOpened.iterator();
                IEditorReference iEditorReference = null;
                IEditorInput iEditorInput = null;
                while (iterator.hasNext()) {
                    IFileEditorInput iFileEditorInput;
                    iEditorReference = iterator.next();
                    iEditorInput = iEditorReference.getEditorInput();
                    if (!(iEditorInput instanceof IFileEditorInput) || !(iFileEditorInput = (IFileEditorInput)iEditorInput).getFile().getProject().equals((Object)iProject)) continue;
                    toCloseEditors.add(iEditorReference);
                    iterator.remove();
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void checkOpenProjects(IProgressMonitor iProgressMonitor) {
        try {
            this.projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            if (this.projects == null || this.projects.length == 0) {
                if (OS2200CorePlugin.logger.isInfoEnabled()) {
                    OS2200CorePlugin.logger.info((Object)"No Projects in the workspace ");
                }
                return;
            }
            if (OS2200ProjectUpdate.isUiPluginExecuted()) {
                int n = 0;
                while (n < this.projects.length) {
                    if (this.projects[n].isOpen() && this.projects[n].hasNature("com.unisys.tde.core.OS2200")) {
                        System.currentTimeMillis();
                        IProject iProject = this.projects[n];
                        IResource[] iResourceArray = iProject.members();
                        String string = null;
                        int n2 = 0;
                        while (n2 < iResourceArray.length) {
                            IPath iPath = iResourceArray[n2].getLocation();
                            File file = iPath.toFile();
                            if (file.getName().compareToIgnoreCase(".settings") != 0 && file.getName().compareToIgnoreCase(".project") != 0) {
                                string = iPath.toFile().getParent();
                                break;
                            }
                            ++n2;
                        }
                        if (string != null) {
                            this.fileSynchronizer.monitor(string);
                        }
                    }
                    ++n;
                }
                return;
            }
            if (OS2200CorePlugin.logger.isInfoEnabled()) {
                OS2200CorePlugin.logger.info((Object)("Projects in workspace :" + this.projects.length));
            }
            this.validateHosts(iProgressMonitor);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void validateHosts(IProgressMonitor iProgressMonitor) {
        try {
            OS2200ProjectUpdate.setUiPluginExecuted(false);
            this.projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            if (this.projects == null || this.projects.length == 0) {
                return;
            }
            if (OS2200CorePlugin.logger.isInfoEnabled()) {
                OS2200CorePlugin.logger.info((Object)("Projects in workspace :" + this.projects.length));
            }
            iProgressMonitor.subTask(String.valueOf(this.projects.length) + Messages.getString((String)"OS2200Startup_17"));
            ExecutorService executorService = Executors.newFixedThreadPool(this.projects.length);
            int n = 0;
            while (n < this.projects.length) {
                if (this.projects[n] != null && this.projects[n].isOpen()) {
                    OS2200StartupWorkerThread oS2200StartupWorkerThread = new OS2200StartupWorkerThread(this.projects[n]);
                    executorService.execute(oS2200StartupWorkerThread);
                    Thread.sleep(300L);
                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200Startup_18")) + this.projects[n].getName() + Messages.getString((String)"OS2200Startup_19"));
                }
                ++n;
            }
            executorService.shutdown();
            n = 40;
            while (!executorService.isTerminated()) {
                try {
                    iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200Startup_20")) + n + Messages.getString((String)"OS2200Startup_21"));
                    Thread.sleep(1000L);
                    if (n > 0) {
                        --n;
                        continue;
                    }
                    n = 10;
                }
                catch (InterruptedException interruptedException) {
                    OS2200CorePlugin.logger.info((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                }
            }
            OS2200ProjectUpdate.setUiPluginExecuted(true);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void removeForOS2200Consoles() {
        OS2200CorePlugin.logger.debug((Object)"");
        Display display = OS2200CorePlugin.myWorkbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewReference[] iViewReferenceArray;
                    IWorkbench iWorkbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindowArray[0].getActivePage();
                    IViewReference[] iViewReferenceArray2 = iViewReferenceArray = iWorkbenchPage.getViewReferences();
                    int n = iViewReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IViewPart iViewPart;
                        IViewReference iViewReference = iViewReferenceArray2[n2];
                        String string = iViewReference.getId();
                        if ((string.equals("com.unisys.tde.core.views.OS2200ConsoleView") || string.equals("com.unisys.tde.core.views.OS2200BreakpointConsoleView")) && (iViewPart = iViewReference.getView(true)) != null) {
                            iWorkbenchPage.hideView(iViewPart);
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    OS2200CorePlugin.logger.error((Object)("Exception deleting console views" + throwable.getMessage()), throwable);
                }
            }
        });
    }

    private void checkForAlteredLinks(IProject iProject, IProgressMonitor iProgressMonitor) {
        try {
            IResource[] iResourceArray = iProject.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IFile iFile;
                if (iResourceArray[n] instanceof IFile && (iFile = (IFile)iResourceArray[n]).isLinked() && OS2200ProjectUpdate.isConverted(iFile)) {
                    iProgressMonitor.subTask(String.valueOf(iFile.getName()) + Messages.getString((String)"OS2200Startup_22"));
                    String string = iFile.getPersistentProperty(OS2200ArchitectureConstant.ORIGINAL_RAW);
                    String string2 = iFile.getPersistentProperty(OS2200ArchitectureConstant.ORIGINAL_LINK);
                    String string3 = iFile.getPersistentProperty(OS2200ArchitectureConstant.CHAR_SET);
                    File file = new File(iFile.getRawLocation().toOSString());
                    this.fileSynchronizer.monitor(file.getParent());
                    if (string != null && string2 != null) {
                        iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200Startup_23")) + iFile.getName());
                        iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        IFile iFile2 = iProject.getWorkspace().getRoot().getFile((IPath)new Path(string2));
                        iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"OS2200Startup_24")) + iFile.getName());
                        iFile2.createLink((IPath)new Path(string), 16, (IProgressMonitor)new NullProgressMonitor());
                        if (string3 == null) {
                            string3 = "";
                        }
                        iFile2.setCharset(string3, (IProgressMonitor)new NullProgressMonitor());
                    } else if (OS2200CorePlugin.logger.isInfoEnabled()) {
                        OS2200CorePlugin.logger.info((Object)("Original Raw path and link to the file, " + iFile.getName() + " returned null."));
                    }
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)("Unisys Internal Error " + (Object)((Object)coreException)), (Throwable)coreException);
        }
    }

    public static void checkForConvertedEditors(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.subTask(Messages.getString((String)"OS2200Startup_25"));
        try {
            Display display = OS2200CorePlugin.myWorkbench.getDisplay();
            IWorkbench iWorkbench = OS2200CorePlugin.myWorkbench;
            IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[iWorkbenchWindowArray.length - 1];
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
            OS2200CorePlugin.addListeners();
            int n = 0;
            while (n < iWorkbenchPageArray.length) {
                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n];
                IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                iProgressMonitor.subTask(String.valueOf(iEditorReferenceArray.length) + Messages.getString((String)"OS2200Startup_26"));
                int n2 = 0;
                while (n2 < iEditorReferenceArray.length) {
                    FileEditorInput fileEditorInput;
                    IFile iFile;
                    IEditorInput iEditorInput = iEditorReferenceArray[n2].getEditorInput();
                    if (iEditorInput instanceof FileEditorInput && (iFile = (fileEditorInput = (FileEditorInput)iEditorInput).getFile()) != null) {
                        IProject iProject = iFile.getProject();
                        try {
                            String string;
                            if (iProject != null && iProject.hasNature("com.unisys.tde.core.OS2200") && (string = fileEditorInput.getName()).startsWith(" ")) {
                                String string2 = string.substring(1);
                                IFile iFile2 = (IFile)iProject.findMember(string2);
                                String string3 = iEditorReferenceArray[n2].getId();
                                final IEditorReference iEditorReference = iEditorReferenceArray[n2];
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ate = (AbstractTextEditor)iEditorReference.getEditor(true);
                                    }
                                });
                                IFile iFile3 = OS2200GeneralEditListener.substituteLink(iFile2, iProject, ate, true);
                                OS2200GeneralEditListener.openNewEditor(iFile3, string3);
                            }
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (PartInitException partInitException) {
            OS2200CorePlugin.logger.error((Object)("Restoring OS 2200 Project " + partInitException.getMessage()), (Throwable)partInitException);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)("Restoring OS 2200 Project " + coreException.getMessage()), (Throwable)coreException);
        }
    }

    public static void setProjectsToClose(IProject iProject) {
        try {
            if (iProject != null) {
                if (toCloseProject == null) {
                    toCloseProject = new ArrayList<IProject>();
                }
                toCloseProject.add(iProject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

