/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.FileInfo;
import com.unisys.os2200.util.MemChecker;
import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.ElementSelectionObject;
import com.unisys.tde.core.InfoPack;
import com.unisys.tde.core.MyComparator;
import com.unisys.tde.core.OS2200AuthInterface;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.RuntimeExec;
import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import com.unisys.tde.core.events.TDECoreEventSource;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.session.ISession;
import com.unisys.telnet.lib.session.Session;
import com.unisys.telnet.ui.UserPrompt;
import com.unisys.telnet.ui.UserPromptData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class OS2200FileInterface {
    private static String legalEltChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-$";
    private static String legalFullFileChars = String.valueOf(legalEltChars) + ".*#(+)";
    public static final long CONNECTIONSUCCESSFUL = 0L;
    public static IWorkbenchWindow iww = null;
    public static IWorkbenchPage iwp = null;
    public static final String noCIFS = "NoCIFS";
    public static final String ls2Com = "ls -2";
    public static final String ERRMSG = "*ERROR";
    public static final String DEFAULT_SHARE = "os2200";
    public static final String FACSTAT = "FAC STATUS: 4";
    public static final long ERROR_INVALID_PASSWORD = 86L;
    public static final long ERROR_NETWORK_NAME_NOT_FOUND = 67L;
    public static final long USER_CANCELED = -1L;
    public static final long CONNECTION_INVALID = -1001L;
    public static final long HOST_INVALID = -1002L;
    public static final long DELETE_ACCESS_FAILURE = -1003L;
    public static final long DELETE_EXISTS_FAILURE = -1004L;
    public static final long ELEMENT_CREATION_OK = 0L;
    public static final long ELEMENT_CREATION_FAILED = -1005L;
    public static final long ELEMENT_EXISTS = -1006L;
    public static final long ELEMENT_CREATION_FAILED_DUE_TO_EXCLUISVE_USE = -1007L;
    public static final long DELETE_DIRECTORY_FAILURE = -1008L;
    public static final long CONNECTION_TIMEOUT = -1111L;
    public static final long UNKNOWN_ERROR = -111L;
    public static final long OUTOFFSYNC_ERROR = -2L;
    public static final long CONNECTION_LOST = -1009L;
    public static final long FILE_ACCESS_DENIED = -1010L;
    private static final String HOST_SHARE_PREFIX = "\\\\";
    private static final String CIFS_SHARES = "/.cifs_shares/";
    private static final String OS2200_FILE_SEPARATOR = "\\";
    private static final String OS2200_PATH_SEPARATOR = "/";
    private static final String CIFSUT = "@Cifsut \n";
    private static final String GET_CIFS_SHARES = "cd /.cifs_shares \n";
    private static final String ALL_VERSIONS = "/************";
    private static final String DELETE_V = "@delete,aorv ";
    public static ISession sesso = null;
    public static String QSF = "";
    public static boolean forceRestart = false;
    public static ISession session = null;
    private static final String COBOL_EDITOR_ID = "org.eclipse.cobol.ui.editor.COBOLEditor";
    public static int error1219 = -3;
    public static boolean isOutlookConfigured = false;
    private static final String SSG = "@SSG,MN";
    private static final String SKEL = "SKEL";
    private static final String STAT = "*DISPLAY '[SYSTEM$,1,1,2] (HOST [SYSTEM$,1,4,2]) MHFS STATUS IS [SYSTEM$,1,4,1]'";
    private static final String CAT_ERROR = "E:244433 file is already catalogued.";
    public static Map<String, Boolean> fCifsConnMap = new HashMap<String, Boolean>();
    private static Map<String, String> fHostUserIDMap = new HashMap<String, String>();
    public static HashMap<String, String> elementNameMap = new HashMap();
    public static HashMap<String, HashMap<String, ArrayList<String>>> Connectiob_CopyProc_Map = new HashMap();
    public static String copyProcDir = "\\Local Settings\\Application Data\\Unisys\\os2200\\dd\\";
    public static String userHome = System.getProperty("user.home");
    public static Map connDisConnMap = new HashMap();
    protected static final String COBOL = "COB";
    protected static final String ELT = "ELT";
    protected static final String C = "C";
    protected static final String JAVA = "JAVA";
    protected static final String PLS = "PLS";
    protected static final String FOR = "FOR";
    protected static final String ASM = "ASM";
    protected static final String MSM = "MSM";
    protected static final String H = "H";
    protected static final String C_EDITOR_ID = "org.eclipse.cdt.ui.editor.CEditor";
    protected static final String JAVA_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    protected static final String DEFAULT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    protected static final String ASM_EDITOR_EDITOR = "org.eclipse.cdt.ui.editor.asm.AsmEditor";
    protected static final String PLUS_EDITOR_ID = "com.unisys.tde.plus.editor.PlusEditor";
    public static final String UDT_EDITOR_ID = "com.unisys.os2200.editor.UDTEditor";
    private static final long LIMITED_FILE_SIZE = 0x500000L;
    private static String editorID;
    private static String fileNameStr;
    private static String CBSEltName;
    public static Properties telnetMacroProperties;
    public static Type fileType;
    private static final int stdShare = 0;
    private static final int cstShare = 1;
    private static final int nShare = 2;
    private static final String FILE_SEPARATOR = "\\";
    private static final String SPLIT_ON_SEPARATOR = ":?\\\\";
    private static final String ASTERISK = "*";
    private static final String PERIOD = ".";
    private static final String COLON = ":";
    private static final String SLASH = "/";
    private static final String EMPTY_STR = "";
    private static final String SINGLE_SPACE = " ";
    private static final String CRLF = "\r\n";
    static boolean returnstat;

    public static InfoPack getInfo(IProject iProject, String string, String string2) {
        try {
            Properties properties = OS2200ProjectUpdate.getProperties(iProject);
            OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState(iProject);
            String string3 = DEFAULT_SHARE;
            switch (share) {
                case stdShare: {
                    break;
                }
                case cstShare: {
                    string3 = properties.getProperty("OS2200Share");
                    break;
                }
                case nShare: {
                    string3 = properties.getProperty("ProjectShare");
                }
            }
            return OS2200FileInterface.getInfo(iProject, string, string2, string3, share);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"UnisysInternal"), (Throwable)coreException);
            return null;
        }
    }

    public static InfoPack getInfo(IProject iProject, String string, String string2, String string3, OS2200ProjectUpdate.Share share) {
        OS2200CorePlugin.logger.debug((Object)"entering getInfo");
        InfoPack infoPack = new InfoPack();
        ArrayList arrayList = new ArrayList();
        try {
            infoPack = OS2200FileInterface.getNamesWithSubTypes(iProject, string, string2, string3, share);
            arrayList = infoPack.getInfoList();
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200ProjectUpdate.21"), (Throwable)coreException);
        }
        if (iProject != null && arrayList != null) {
            try {
                if (iProject.exists()) {
                    IResource[] iResourceArray = iProject.members();
                    int n = 0;
                    while (n < iResourceArray.length) {
                        if (iResourceArray[n] instanceof IFile && iResourceArray[n].isLinked()) {
                            String string4;
                            boolean bl = OS2200ProjectUpdate.isConverted((IFile)iResourceArray[n]);
                            IPath iPath = null;
                            if (bl) {
                                string4 = OS2200ProjectUpdate.getRawLoc((IFile)iResourceArray[n]);
                                iPath = new Path(string4);
                            } else {
                                iPath = iResourceArray[n].getRawLocation();
                            }
                            if (iPath != null) {
                                string4 = iPath.lastSegment();
                                ElementSelectionObject elementSelectionObject = OS2200FileInterface.findbyeltname(arrayList, string4);
                                if (elementSelectionObject == null) {
                                    elementSelectionObject = new ElementSelectionObject(String.valueOf(OS2200ProjectUpdate.DeletedFlag) + SINGLE_SPACE + string4, iResourceArray[n].getName(), OS2200ProjectUpdate.DeletedFlag);
                                    OS2200FileInterface.addSortedItem(arrayList, elementSelectionObject);
                                } else {
                                    elementSelectionObject.linkName = iResourceArray[n].getName();
                                }
                                elementSelectionObject.ConvName = bl || OS2200ProjectUpdate.hasCharConversion((IFile)iResourceArray[n]) ? OS2200ProjectUpdate.getCharConversion((IFile)iResourceArray[n]) : null;
                                elementSelectionObject.editOpen = OS2200FileInterface.isEditOpen(iProject, elementSelectionObject.linkName);
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {
                OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200Startup.9"), (Throwable)coreException);
            }
            infoPack.setInfoList(arrayList);
        }
        return infoPack;
    }

    public static boolean isEditOpen(IProject iProject, String string) {
        final IResource iResource = iProject.findMember(string);
        if (iResource != null && iResource instanceof IFile) {
            Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    returnstat = false;
                    try {
                        IFile iFile = (IFile)iResource;
                        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
                        IWorkbenchPage iWorkbenchPage = OS2200FileInterface.UIActivePage();
                        if (iWorkbenchPage == null) {
                            return;
                        }
                        IEditorPart iEditorPart = iWorkbenchPage.findEditor((IEditorInput)fileEditorInput);
                        if (iEditorPart != null) {
                            returnstat = true;
                            return;
                        }
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.debug((Object)("isEditOpen " + exception));
                    }
                }
            });
        }
        return returnstat;
    }

    public static String getQSFName(String string, String string2) {
        ISession iSession;
        String string3;
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
        if (loginAccount != null && (string3 = (iSession = Session.New((LoginAccount)loginAccount)).Login()).length() == 0) {
            iSession.SendCommand("@cifsut \n");
            String string4 = OS2200FileInterface.getQSFfromCIFS(iSession, string2);
            iSession.SendCommand("@fin \n");
            String string5 = iSession.getOutput();
            OS2200CorePlugin.logger.debug((Object)string5);
            iSession.Logout();
            return string4;
        }
        return null;
    }

    public static void grantFullAccessToAllUsers(File file) {
        file.setWritable(true, false);
        file.setReadable(true, false);
        file.setExecutable(true, false);
    }

    public static InfoPack getNamesWithSubTypes(IProject iProject, String string, String string2, String string3, OS2200ProjectUpdate.Share share) throws CoreException {
        InfoPack infoPack;
        block15: {
            OS2200CorePlugin.logger.debug((Object)"entering getNamesWithSubTypes");
            OS2200FileInterface.UIActiveWindow();
            infoPack = new InfoPack();
            String string4 = string2;
            infoPack.setQSFName(string4);
            ArrayList arrayList = null;
            LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
            if (loginAccount != null) {
                ISession iSession = Session.New((LoginAccount)loginAccount);
                String string5 = CIFS_SHARES + string3 + "/" + OS2200FileInterface.getOS2200Path(string4);
                if (share == OS2200ProjectUpdate.Share.nShare) {
                    string5 = CIFS_SHARES + string3;
                }
                try {
                    String string6 = iSession.Login();
                    if (string6.length() == 0) {
                        iSession.SendCommand("@CIFSUT \n");
                        String string7 = iSession.getOutput();
                        OS2200CorePlugin.logger.debug((Object)("response-to-CIFSUT: " + string7));
                        iSession.SendCommand("pwd \n");
                        String string8 = iSession.getOutput();
                        OS2200CorePlugin.logger.debug((Object)("response-to-CIFSUT: " + string8));
                        if (share == OS2200ProjectUpdate.Share.nShare) {
                            string4 = OS2200FileInterface.getQSFfromCIFS(iSession, string3);
                            infoPack.setQSFName(string4);
                        }
                        iSession.SendCommand("cd " + string5 + "\n");
                        String string9 = iSession.getOutput();
                        OS2200CorePlugin.logger.debug((Object)("response-to-cd: " + string9));
                        iSession.SendCommand("ls -2 \n");
                        String string10 = iSession.getOutput();
                        OS2200CorePlugin.logger.debug((Object)("response-to-ls2: " + string10));
                        int n = -1;
                        if (string10.contains(" STD#")) {
                            n = string10.indexOf(" STD#");
                        } else if (string10.contains(" SHARED#")) {
                            n = string10.indexOf(" SHARED#");
                        }
                        if (n < 0) {
                            iSession.SendCommand("ls -2 \n");
                            string10 = iSession.getOutput();
                            OS2200CorePlugin.logger.debug((Object)("response-to-ls2-A: " + string10));
                        }
                        iSession.SendCommand("@use $$ECLIPSEIDE," + string4 + "\n");
                        iSession.SendCommand("@PRT,TL $$ECLIPSEIDE.\n");
                        String string11 = iSession.getOutput();
                        if (string11.indexOf("NEXT AVAILABLE LOCATION-") < 0) {
                            iSession.SendCommand("@PRT,TL $$ECLIPSEIDE.\n");
                            string11 = iSession.getOutput();
                            OS2200CorePlugin.logger.debug((Object)("second prttl: " + string11));
                        }
                        if (string9.indexOf(ERRMSG) > -1 || string11.indexOf(FACSTAT) > -1) {
                            String string12 = loginAccount.getHostAccount().getHostId();
                            Throwable throwable = new Throwable(string9);
                            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200FileInterface.13", (String)string4, (String)string12), throwable);
                        } else {
                            Hashtable hashtable = OS2200FileInterface.parseLS2(string10, string4);
                            arrayList = OS2200FileInterface.PastTOC(string11, hashtable);
                            infoPack.setInfoList(arrayList);
                            iSession.SendCommand("@fin \n");
                            String string13 = iSession.getOutput();
                            OS2200CorePlugin.logger.debug((Object)string13);
                            iSession.Logout();
                        }
                        break block15;
                    }
                    String string14 = loginAccount.getHostAccount().getHostId();
                    MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.7"), (String)Messages.getString((String)"OS2200FileInterface.8", (String)string14));
                }
                catch (Throwable throwable) {
                    String string15 = Messages.getString((String)"OS2200FileInterface.9");
                    if (iProject != null) {
                        string15 = Messages.getString((String)"OS2200FileInterface.10", (String)iProject.getName());
                    }
                    MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.11"), (String)Messages.getString((String)"OS2200FileInterface.12"));
                    OS2200CorePlugin.logger.error((Object)string15, throwable);
                }
            } else {
                MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.7"), (String)Messages.getString((String)"OS2200CorePlugin.13", (String)string));
            }
        }
        return infoPack;
    }

    public static String getQSFfromCIFS(ISession iSession, String string) {
        iSession.SendCommand("ls -2a /.cifs_shares \n");
        String string2 = iSession.getOutput();
        if (string2.contains("DATA IGNORED - IN CONTROL MODE")) {
            iSession.SendCommand("@cifsut \n");
            iSession.SendCommand("ls -2a /.cifs_shares \n");
            string2 = iSession.getOutput();
        }
        int n = -1;
        if (string2.contains(" STD#")) {
            n = string2.indexOf(" STD#");
        } else if (string2.contains(" SHARED#")) {
            n = string2.indexOf(" SHARED#");
        }
        if (n < 0) {
            iSession.SendCommand("ls -2 /.cifs_shares \n");
            string2 = iSession.getOutput();
            OS2200CorePlugin.logger.debug((Object)"second-slist taken");
        }
        OS2200CorePlugin.logger.debug((Object)("response-to-sList: " + string2));
        String[] stringArray = string2.split("\n");
        int n2 = string.length();
        String string3 = null;
        String string4 = null;
        OS2200CorePlugin.logger.debug((Object)("searching for share " + n2 + SINGLE_SPACE + string));
        int n3 = 0;
        int n4 = stringArray.length;
        while (n3 < n4) {
            String string5 = stringArray[n3];
            OS2200CorePlugin.logger.debug((Object)("share search line: " + string5));
            if (string5.length() > n2 + 3 && string5.substring(0, n2).toUpperCase().equals(string.toUpperCase())) {
                string3 = string5.substring(n2 + 1);
                break;
            }
            ++n3;
        }
        if (string3 != null) {
            if (string3.length() > 0) {
                n3 = -1;
                if (string3.contains(" STD#")) {
                    n3 = string3.indexOf(" STD#");
                } else if (string3.contains(" SHARED#")) {
                    n3 = string3.indexOf(" SHARED#");
                }
                if (n3 > -1) {
                    string4 = String.valueOf(string3.trim()) + PERIOD;
                    OS2200CorePlugin.logger.debug((Object)("Qf found in cifsshares: " + string4));
                }
            } else {
                OS2200CorePlugin.logger.debug((Object)("sline found in cifsshares corrupt " + string3));
                string4 = Messages.getString((String)"OS2200FileInterface.60");
            }
        } else {
            OS2200CorePlugin.logger.debug((Object)"qf not found in cifsshares c");
            string4 = Messages.getString((String)"OS2200FileInterface.61");
        }
        return string4;
    }

    public static Hashtable parseLS2(String string, String string2) {
        return OS2200FileInterface.parseLS2(string, string2, true);
    }

    public static Hashtable parseLS2(String string, String string2, boolean bl) {
        OS2200CorePlugin.logger.debug((Object)"entering parseLS2");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = string2;
        int n = string3.indexOf("(");
        if (n > -1) {
            string3 = String.valueOf(string3.substring(0, n)) + PERIOD;
        }
        String[] stringArray = string.split("\n");
        int n2 = 0;
        while (n2 < stringArray.length) {
            block14: {
                String string4;
                int n3;
                String string5;
                int n4;
                String string6;
                int n5;
                int n6;
                String string7;
                block15: {
                    string7 = stringArray[n2].trim();
                    if (string7 == null || string7.length() == 0 || string7.length() < 10 || string7.equals(ls2Com)) break block14;
                    if (string7.length() == 132 && n2 + 1 < stringArray.length && (string7.indexOf(ASTERISK) == -1 && stringArray[n2 + 1].indexOf(ASTERISK) != -1 || string7.indexOf(ASTERISK) != -1 && stringArray[n2 + 1].indexOf(ASTERISK) == -1)) {
                        string7 = String.valueOf(string7) + stringArray[n2 + 1];
                        ++n2;
                    }
                    string7 = string7.replace("\r", EMPTY_STR);
                    string7 = string7.trim();
                    n6 = -1;
                    n5 = 0;
                    string6 = EMPTY_STR;
                    if (string7.contains(" STD#")) {
                        n6 = string7.indexOf(" STD#");
                        n5 = 5;
                        string6 = "STD#";
                    } else if (string7.contains(" SHARED#")) {
                        n6 = string7.indexOf(" SHARED#");
                        n5 = 8;
                        string6 = "SHARED#";
                    }
                    if (n6 < 0 || (n4 = string7.lastIndexOf(PERIOD)) < 1 || n4 < n6) break block14;
                    String string8 = string7.substring(n4 - 1, n4);
                    string5 = string7.substring(n6 + n5, n4 + 1);
                    if (!string8.equals(")")) break block15;
                    n3 = string7.lastIndexOf("(");
                    if (n3 == -1) break block14;
                    string4 = string7.substring(n3, n4);
                    string5 = string5.replace(string4, EMPTY_STR);
                }
                if (string5.equalsIgnoreCase(string3) || (String.valueOf(string6) + string5).equalsIgnoreCase(string3)) {
                    String string9;
                    n3 = OS2200FileInterface.findSpaceBefore(string7, n6 + n5);
                    string4 = string7.substring(0, n3).trim();
                    byte[] byArray = string4.getBytes();
                    if (byArray[0] == 63) {
                        string4 = string4.substring(1);
                    }
                    if (string4.indexOf("..") <= -1 && !string4.endsWith(".rel") && !string4.endsWith(".abs") && (string9 = string7.substring(n4 + 1).toUpperCase()).length() != 0) {
                        if (bl) {
                            hashtable.put(string9, string4);
                        } else {
                            hashtable.put(string4, string9);
                        }
                    }
                }
            }
            ++n2;
        }
        return hashtable;
    }

    static int findSpaceBefore(String string, int n) {
        int n2 = n;
        while (!string.substring(n2, n2 + 1).equals(SINGLE_SPACE) && n2 > 0) {
            --n2;
        }
        return n2;
    }

    private static ArrayList PastTOC(String string, Hashtable hashtable) {
        OS2200CorePlugin.logger.debug((Object)"entering PastTOC");
        ArrayList arrayList = new ArrayList();
        String[] stringArray = string.split("\n");
        OS2200CorePlugin.logger.debug((Object)(" lines to parse " + stringArray.length));
        int n = 0;
        boolean bl = true;
        while (bl) {
            String string2;
            if (stringArray[n].length() != 0 && (string2 = stringArray[n].substring(0, 1)).trim().equals("D")) {
                bl = false;
            }
            if (++n <= stringArray.length - 1) continue;
            return arrayList;
        }
        int n2 = n;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            OS2200CorePlugin.logger.debug((Object)(String.valueOf(n2) + SINGLE_SPACE + string3));
            if (string3.substring(0, 4).trim().equals("NEXT")) break;
            if (!string3.substring(0, 1).trim().equals(ASTERISK) && string3.length() > 42) {
                String string4 = string3.substring(3, 15).trim();
                String string5 = string3.substring(17, 29).trim();
                String string6 = string3.substring(31, 40).trim();
                String string7 = string3.substring(40, 42).trim();
                if (string6.indexOf("SYMB") >= 0 || string7 == "-Q" || string6.indexOf(COBOL) >= 0) {
                    String string8 = string4;
                    if (string5.length() != 0) {
                        string8 = String.valueOf(string8) + "/" + string5;
                    }
                    string8 = string8.toUpperCase();
                    String string9 = (String)hashtable.get(string8);
                    ElementSelectionObject elementSelectionObject = null;
                    if (string9 != null) {
                        OS2200CorePlugin.logger.debug((Object)(" PastTOC osName, cfsName, subtype " + string8 + "," + string9 + "," + string6));
                        elementSelectionObject = OS2200FileInterface.SetType(string9, string6, string7);
                        elementSelectionObject.nativeName = string8;
                    } else {
                        elementSelectionObject = OS2200FileInterface.SetType(String.valueOf(string8) + Messages.getString((String)"OS2200FileInterface.78"), noCIFS, EMPTY_STR);
                        elementSelectionObject.elementType = noCIFS;
                    }
                    OS2200FileInterface.addSortedItem(arrayList, elementSelectionObject);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private static ElementSelectionObject SetType(String string, String string2, String string3) {
        String string4 = string;
        String string5 = EMPTY_STR;
        if (string2.equals("PLS  SYMB")) {
            string5 = PLS;
        }
        if (string2.equals("C    SYMB")) {
            string5 = C;
        }
        if (string2.equals("COB  SYMB")) {
            string5 = COBOL;
        }
        if (string2.equals("COB PROC")) {
            string5 = COBOL;
        }
        if (string2.equals("FOR  SYMB")) {
            string5 = FOR;
        }
        if (string5.equals(ELT)) {
            string5 = OS2200FileInterface.checkForTypeMatch(string);
        }
        ElementSelectionObject elementSelectionObject = new ElementSelectionObject(string4, EMPTY_STR, string5);
        return elementSelectionObject;
    }

    public static String checkForTypeMatch(String string) {
        String string2;
        String string3 = ELT;
        int n = string.indexOf(PERIOD);
        if (n != 0 && n + 1 < string.length() && (string2 = string.substring(n + 1)).length() > 0) {
            int n2 = 0;
            while (n2 < OS2200ProjectUpdate.eltTypes.length) {
                if (string2.toUpperCase().equals(OS2200ProjectUpdate.eltTypes[n2])) {
                    string3 = string2;
                    break;
                }
                ++n2;
            }
        }
        return string3;
    }

    public static ArrayList getElementNames(String string) {
        OS2200CorePlugin.logger.debug((Object)"entering getElementNames");
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        if (!file.isDirectory()) {
            return arrayList;
        }
        stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            file = new File(stringArray[n]);
            if (!file.isDirectory()) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public static ArrayList getLinkNames(IProject iProject) {
        OS2200CorePlugin.logger.debug((Object)"entering getLinkNames");
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Properties properties = OS2200ProjectUpdate.getProperties(iProject);
            String string = properties.getProperty("hostID");
            LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
            HostAccount hostAccount = loginAccount.getHostAccount();
            String string2 = hostAccount.getHostId();
            IResource[] iResourceArray = iProject.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IPath iPath;
                int n2;
                IFile iFile;
                if (iResourceArray[n] instanceof IFile && (iFile = (IFile)iResourceArray[n]).isLinked() && (n2 = (iPath = iFile.getLocation()).toString().indexOf("//" + string2)) == 0) {
                    arrayList.add(iResourceArray[n].getName());
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200Startup.9"), (Throwable)coreException);
        }
        return arrayList;
    }

    public static String getRawShare(String string, String string2) {
        return HOST_SHARE_PREFIX + string + "\\" + string2;
    }

    public static String getCIFSFromQualFile(String string, String string2, String string3) {
        OS2200CorePlugin.logger.debug((Object)EMPTY_STR);
        String string4 = EMPTY_STR;
        int n = string2.indexOf(42);
        if (n > 0) {
            String string5 = string2.substring(0, n);
            String string6 = string2.substring(n + 1);
            int n2 = string6.indexOf(46);
            if (n2 >= 0) {
                string6 = string6.substring(0, n2);
            }
            String string7 = HOST_SHARE_PREFIX + string + "\\" + string3 + "\\" + string5 + "\\" + string6;
            string4 = new Path(string7).toOSString();
        }
        return string4;
    }

    public static String getSharedBKFile(String string, String string2, String string3) {
        OS2200CorePlugin.logger.debug((Object)EMPTY_STR);
        String string4 = EMPTY_STR;
        int n = string2.indexOf(42);
        if (n > 0) {
            String string5 = string2.substring(0, n);
            String string6 = string2.substring(n + 1);
            int n2 = string6.indexOf(46);
            if (n2 >= 0) {
                string6 = string6.substring(0, n2);
            }
            String string7 = HOST_SHARE_PREFIX + string + "\\" + string3 + "\\" + string5 + PERIOD + string6;
            string4 = new Path(string7).toOSString();
        }
        return string4;
    }

    public static String getCIFSDir(IProject iProject) {
        OS2200CorePlugin.logger.debug((Object)" get CIFS directory by project");
        try {
            Properties properties = OS2200ProjectUpdate.getProperties(iProject);
            return OS2200FileInterface.getCIFSDir(properties);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200FileInterface.93"));
            OS2200CorePlugin.logger.info((Object)Messages.getString((String)"OS2200FileInterface.94"), (Throwable)coreException);
            return null;
        }
    }

    public static String getCIFSDir(Properties properties) {
        OS2200CorePlugin.logger.debug((Object)" get CIFS directory by properties ");
        OS2200ProjectUpdate.Share share = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        LoginAccount loginAccount = null;
        HostAccount hostAccount = null;
        String string4 = null;
        if (properties != null) {
            share = OS2200ProjectUpdate.getShareState(properties);
            switch (share) {
                case stdShare: {
                    string = properties.getProperty("OS2200Share");
                    break;
                }
                case cstShare: {
                    string = properties.getProperty("OS2200Share");
                    break;
                }
                case nShare: {
                    string = properties.getProperty("ProjectShare");
                }
            }
            string2 = properties.getProperty("workFile");
            string3 = properties.getProperty("hostID");
        }
        if (string3 != null) {
            loginAccount = LoginAccount.getLoginAccount(string3);
        }
        if (loginAccount != null) {
            hostAccount = loginAccount.getHostAccount();
        }
        if (hostAccount != null) {
            string4 = hostAccount.getCifsHostId();
        }
        return OS2200FileInterface.getCIFSDir(string4, string2, string, share);
    }

    public static String getCIFSDir(String string, String string2, String string3, OS2200ProjectUpdate.Share share) {
        String string4 = EMPTY_STR;
        if (share.equals((Object)OS2200ProjectUpdate.Share.nShare)) {
            String string5 = HOST_SHARE_PREFIX + string + "\\" + string3;
            string4 = new Path(string5).toOSString();
        } else {
            string4 = OS2200FileInterface.getCIFSFromQualFile(string, string2, string3);
        }
        return string4;
    }

    public static String getOS2200Path(String string) {
        OS2200CorePlugin.logger.debug((Object)"entering getOS2200Path");
        int n = string.indexOf(42);
        if (n < 0) {
            return EMPTY_STR;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n2 = string3.indexOf(46);
        if (n2 >= 0) {
            string3 = string3.substring(0, n2);
        }
        String string4 = String.valueOf(string2) + "/" + string3;
        OS2200CorePlugin.logger.debug((Object)("returning from getOS2200Path " + string4));
        return string4;
    }

    public static String getOS2200ElementPath(String string) {
        OS2200CorePlugin.logger.debug((Object)"entering getOS2200Path");
        int n = string.indexOf(42);
        if (n < 0) {
            return EMPTY_STR;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = EMPTY_STR;
        int n2 = string3.indexOf(46);
        if (n2 >= 0) {
            if (n2 < string3.length() && (string4 = string3.substring(n2 + 1)).contains("/")) {
                string4 = string4.replaceFirst("/", PERIOD);
            }
            string3 = string3.substring(0, n2);
        }
        String string5 = EMPTY_STR;
        string5 = string4.isEmpty() ? String.valueOf(string2) + "\\" + string3 : String.valueOf(string2) + "\\" + string3 + "\\" + string4;
        OS2200CorePlugin.logger.debug((Object)("returning from getOS2200Path " + string5));
        return string5;
    }

    public static long connectCifs(HostAccount hostAccount, String string, boolean bl) {
        boolean bl2 = false;
        OS2200CorePlugin.logger.debug((Object)"Entering connectCIFS");
        long l = -1L;
        if (hostAccount != null) {
            Object object;
            Object object2;
            String string2 = hostAccount.getCifsHostId();
            String string3 = hostAccount.getCifsUserId();
            String string4 = hostAccount.getCifsPassword();
            if (string4.length() == 0) {
                object2 = new UserPrompt();
                object = new UserPromptData();
                ((UserPromptData)object).echo = false;
                ((UserPromptData)object).Title = Messages.getString((String)"OS2200FileInterface.14", (String)string2);
                ((UserPromptData)object).Prompt = com.unisys.telnet.lib.Messages.getString((String)"Session.29", (String)string3);
                if (object2.show((UserPromptData)object)) {
                    bl2 = true;
                    hostAccount.setCifsPassword(((UserPromptData)object).Reply);
                    string4 = ((UserPromptData)object).Reply;
                    OS2200CorePlugin.logger.debug((Object)" =========> got password from prompt");
                } else {
                    OS2200CorePlugin.logger.info((Object)com.unisys.telnet.lib.Messages.getString((String)"Session.19"));
                    OS2200CorePlugin.logger.debug((Object)"=========> password prompt cancelled");
                    return -1L;
                }
            }
            object2 = HOST_SHARE_PREFIX + string2 + "\\" + string;
            object = String.valueOf(string2) + "\\" + string3.replace(ASTERISK, EMPTY_STR);
            OS2200CorePlugin.logger.debug((Object)("About to connect with " + (String)object2 + SINGLE_SPACE + (String)object));
            boolean bl3 = false;
            String string5 = null;
            block7: do {
                connDisConnMap.put(hostAccount, object2);
                long l2 = System.currentTimeMillis();
                OS2200AuthInterface oS2200AuthInterface = new OS2200AuthInterface();
                oS2200AuthInterface.executeAuth(string2, (String)object2, (String)object, string4);
                l = oS2200AuthInterface.getConnectObj().getId();
                long l3 = System.currentTimeMillis();
                OS2200CorePlugin.logger.debug((Object)(" *** Time consumed to connect to host " + string2 + " took " + (l3 - l2) + " milliseconds *** with status := " + l));
                if (l == -1111L && bl) {
                    MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.timeout"), (String)Messages.getString((String)"OS2200FileInterface.timeoutError", (String)string2));
                    return -1111L;
                }
                if (l == -111L) {
                    MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.unknownError"), (String)Messages.getString((String)"OS2200FileInterface.unknownErrorMsg", (String)string2));
                    return -111L;
                }
                string5 = oS2200AuthInterface.getConnectObj().getMessage();
                int n = (int)l;
                switch (n) {
                    case 0: {
                        OS2200FileInterface.setCifsConnMap(hostAccount.getConnectionName(), true);
                        fHostUserIDMap.put(string2, String.valueOf(object) + "/" + string4);
                        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
                        iPreferenceStore.setValue(string2, (String)object2);
                        iPreferenceStore.putValue(string2, (String)object2);
                        if (iPreferenceStore.needsSaving()) {
                            try {
                                ((IPersistentPreferenceStore)iPreferenceStore).save();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        TDECoreEventSource.getEventSource().handleHostConStatusEvent(hostAccount, true);
                        OS2200CorePlugin.logger.debug((Object)string5);
                        bl3 = false;
                        break;
                    }
                    case 86: 
                    case 1326: {
                        string4 = OS2200FileInterface.promtForPassword(hostAccount);
                        if (string4 == null) {
                            OS2200CorePlugin.logger.debug((Object)" password change Cancelled ");
                            return -1L;
                        }
                        bl3 = true;
                        break;
                    }
                    case 1219: {
                        OS2200CorePlugin.logger.error((Object)("Error 1219 occured for user-id " + (String)object));
                        String string6 = fHostUserIDMap.get(string2);
                        if (string6 != null && string6.trim().length() > 0) {
                            String[] stringArray = string6.split("/");
                            if (stringArray != null && stringArray.length == 2) {
                                if (((String)object).equalsIgnoreCase(stringArray[0])) {
                                    if (string4.equalsIgnoreCase(stringArray[1])) {
                                        MessageDialog.openInformation((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface_0"), (String)Messages.getString((String)"OS2200FileInterface_1"));
                                        bl3 = false;
                                        break;
                                    }
                                    OS2200FileInterface.handle1219(hostAccount);
                                    return -1L;
                                }
                                MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface_2"), (String)(String.valueOf(Messages.getString((String)"OS2200FileInterface_3")) + string2 + Messages.getString((String)"OS2200FileInterface_4")));
                                error1219 = 1;
                                bl3 = false;
                                break;
                            }
                            OS2200CorePlugin.logger.error((Object)("Error connecting to " + string2));
                            MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface_5"), (String)(String.valueOf(Messages.getString((String)"OS2200FileInterface_6")) + string2));
                            bl3 = false;
                            break;
                        }
                        OS2200CorePlugin.logger.info((Object)(String.valueOf(object2) + " was not disconnected. Please delete the mapped drive manually and restart eclipse."));
                        bl3 = false;
                        if (!bl) continue block7;
                        MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface_2"), (String)(String.valueOf(Messages.getString((String)"OS2200FileInterface_3")) + string2 + Messages.getString((String)"OS2200FileInterface_7")));
                        error1219 = 1;
                        break;
                    }
                    default: {
                        if ((long)n != -1111L && bl) {
                            if (string5 == null || string5.length() == 0) {
                                string5 = String.valueOf(Messages.getString((String)"OS2200FileInterface_8")) + string2;
                            }
                            MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)(String.valueOf(Messages.getString((String)"OS2200FileInterface_9")) + string2), (String)string5);
                        }
                        OS2200CorePlugin.logger.debug((Object)string5);
                        bl3 = false;
                    }
                }
            } while (bl3);
            if (bl2 && l != 0L) {
                hostAccount.setCifsPassword(EMPTY_STR);
                OS2200CorePlugin.logger.debug((Object)"=========> password nulled");
            }
        } else {
            l = -1002L;
            OS2200CorePlugin.logger.debug((Object)"null hostaccount!");
        }
        return l;
    }

    private static int handle1219(HostAccount hostAccount) {
        OS2200CorePlugin.logger.debug((Object)EMPTY_STR);
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)hostAccount.getConnectionName());
        if (loginAccount != null) {
            ISession iSession = Session.New((LoginAccount)loginAccount);
            String string = iSession.Login();
            if (string.length() == 0) {
                RuntimeExec runtimeExec = RuntimeExec.getRuntimeExecInst();
                IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
                String string2 = iPreferenceStore.getString(hostAccount.getCifsHostId());
                if (!MessageDialog.openConfirm((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface_10"), (String)(String.valueOf(Messages.getString((String)"OS2200FileInterface_11")) + hostAccount.getCifsHostId() + Messages.getString((String)"OS2200FileInterface_12")))) {
                    return -1;
                }
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                iWorkbenchPage.saveAllEditors(true);
                if (string2.length() == 0) {
                    string2 = (String)connDisConnMap.get(hostAccount);
                }
                if (runtimeExec.disConnectMapDrive(string2)) {
                    OS2200CorePlugin.logger.info((Object)(String.valueOf(string2) + " disconnected successfully."));
                    forceRestart = true;
                    Workbench.getInstance().restart();
                    return -1;
                }
                error1219 = 1;
                OS2200CorePlugin.logger.debug((Object)(String.valueOf(string2) + " was not disconnected. Please delete the mapped drive manually and restart eclipse."));
                MessageDialog.openWarning((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface_13"), (String)Messages.getString((String)"OS2200FileInterface_14"));
                return 0;
            }
            MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface_15"), (String)Messages.getString((String)"OS2200FileInterface_16"));
            return -1;
        }
        return -1;
    }

    public static String getConnectErrorMsg(long l, IProject iProject) {
        Properties properties = null;
        LoginAccount loginAccount = null;
        try {
            properties = OS2200ProjectUpdate.getProperties(iProject);
            String string = properties.getProperty("hostID");
            loginAccount = LoginAccount.getLoginAccount((String)string);
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException);
            return OS2200FileInterface.getConnectErrorMsg(l, null, DEFAULT_SHARE);
        }
        return OS2200FileInterface.getConnectErrorMsg(l, loginAccount);
    }

    public static String getConnectErrorMsg(long l, LoginAccount loginAccount) {
        HostAccount hostAccount = null;
        if (loginAccount != null) {
            hostAccount = loginAccount.getHostAccount();
        }
        return OS2200FileInterface.getConnectErrorMsg(l, hostAccount, DEFAULT_SHARE);
    }

    public static String getConnectErrorMsg(long l, LoginAccount loginAccount, IFile iFile) {
        HostAccount hostAccount = null;
        if (loginAccount != null) {
            hostAccount = loginAccount.getHostAccount();
        }
        String string = null;
        if (iFile != null) {
            string = OS2200ProjectUpdate.getShareName(iFile.getProject());
        }
        return OS2200FileInterface.getConnectErrorMsg(l, hostAccount, string);
    }

    public static String getConnectErrorMsg(long l, HostAccount hostAccount, String string) {
        String string2 = EMPTY_STR;
        OS2200CorePlugin.logger.debug((Object)("Error Message status: " + l));
        if (l > 0L) {
            if (l == 86L && hostAccount != null) {
                string2 = Messages.getString((String)"OS2200FileInterface.57", (String)(String.valueOf(hostAccount.getCifsHostId()) + "/" + hostAccount.getCifsUserId()));
            } else {
                string2 = OS2200FileInterface.getErrorMessage(l);
                if (l == 67L && hostAccount != null) {
                    string2 = String.valueOf(string2) + Messages.getString((String)"OS2200FileInterface.58", (String)hostAccount.getCifsHostId(), (String)string);
                }
            }
        } else if (l < 0L) {
            if (l == -1001L) {
                string2 = Messages.getString((String)"OS2200FileInterface.54");
            } else if (l == -1002L) {
                string2 = Messages.getString((String)"OS2200FileInterface.59");
            } else if (l == -1L) {
                string2 = Messages.getString((String)"OS2200FileInterface.56");
            } else if (l == -1004L) {
                string2 = Messages.getString((String)"OS2200FileInterface.60", (String)hostAccount.getCifsHostId());
            } else if (l == -1003L) {
                string2 = Messages.getString((String)"OS2200FileInterface.61", (String)string);
            } else if (l == -1008L) {
                string2 = Messages.getString((String)"OS2200FileInterface.95");
            } else if (l == -1111L) {
                string2 = String.valueOf(Messages.getString((String)"OS2200FileInterface_17")) + hostAccount.getCifsHostId();
            } else if (l == -111L) {
                string2 = String.valueOf(Messages.getString((String)"OS2200FileInterface_18")) + hostAccount.getCifsHostId();
            } else if (l == -1009L) {
                string2 = Messages.getString((String)"OS2200FileInterface.62");
            } else if (l == -1010L) {
                string2 = Messages.getString((String)"OS2200FileInterface.63");
            } else {
                string2 = Messages.getString((String)"OS2200FileInterface.55", (String)String.valueOf(l));
                OS2200CorePlugin.logger.error((Object)string2);
            }
        }
        return string2;
    }

    public static long disconnectCifs(HostAccount hostAccount, String string) {
        String string2 = hostAccount.getCifsHostId();
        OS2200CorePlugin.logger.debug((Object)string2);
        String string3 = HOST_SHARE_PREFIX + string2 + "\\" + string;
        boolean bl = false;
        List<String> list = OS2200ProjectUpdate.getProjListFromAssociatedHost(hostAccount);
        RuntimeExec runtimeExec = new RuntimeExec();
        if (list != null) {
            if (list.size() != 0) {
                String string4 = EMPTY_STR;
                for (String string5 : list) {
                    string4 = String.valueOf(string4) + string5 + "\n";
                }
                string4 = String.valueOf(Messages.getString((String)"OS2200FileInterface_19")) + hostAccount.getCifsHostId() + "\n" + "\n" + string4 + "\n" + Messages.getString((String)"OS2200FileInterface_20");
                bl = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OS2200FileInterface_21"), (String)string4);
                if (bl) {
                    long l = runtimeExec.disconnectCIFS(string3);
                    OS2200FileInterface.removeHostFromMap(l, hostAccount);
                    return l;
                }
                return -1L;
            }
            long l = runtimeExec.disconnectCIFS(string3);
            OS2200FileInterface.removeHostFromMap(l, hostAccount);
            return l;
        }
        long l = runtimeExec.disconnectCIFS(string3);
        OS2200FileInterface.removeHostFromMap(l, hostAccount);
        return l;
    }

    private static void removeHostFromMap(long l, HostAccount hostAccount) {
        if (l == 2250L || l == 0L) {
            if (fCifsConnMap.containsKey(hostAccount.getConnectionName())) {
                fCifsConnMap.remove(hostAccount.getConnectionName()).booleanValue();
            }
            OS2200FileInterface.setCifsConnMap(String.valueOf(hostAccount.getCifsHostId()) + "#" + hostAccount.getCifsUserId(), false);
            OS2200CorePlugin.logger.debug((Object)"==========> Successfully disconnected");
        } else {
            OS2200CorePlugin.logger.debug((Object)("==========> Failed to disconnect" + l));
        }
    }

    public static String getErrorMessage(long l) {
        RuntimeExec runtimeExec = new RuntimeExec();
        String string = runtimeExec.getconnectCifsMsg(l);
        char c = string.charAt(string.length() - 1);
        if (c == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        return String.valueOf(string) + Messages.getString((String)"OS2200FileInterface_err") + l;
    }

    public static ElementSelectionObject findbyeltname(List list, String string) {
        OS2200CorePlugin.logger.debug((Object)"Entering findeltbyname");
        int n = 0;
        while (n < list.size()) {
            ElementSelectionObject elementSelectionObject = (ElementSelectionObject)list.get(n);
            if (elementSelectionObject.elementName.equalsIgnoreCase(string)) {
                return elementSelectionObject;
            }
            ++n;
        }
        return null;
    }

    public static ElementSelectionObject findbyLinkname(ArrayList arrayList, String string) {
        int n = 0;
        while (n < arrayList.size()) {
            ElementSelectionObject elementSelectionObject = (ElementSelectionObject)arrayList.get(n);
            if (elementSelectionObject.linkName.equalsIgnoreCase(string)) {
                return elementSelectionObject;
            }
            ++n;
        }
        return null;
    }

    public static boolean legalOS2200EltName(String string) {
        if (string == null || string.length() > 12) {
            return false;
        }
        String string2 = string.toUpperCase();
        int n = 0;
        while (n < string2.length()) {
            if (legalEltChars.indexOf(string2.charAt(n)) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isValidOS2200FileName(String string) {
        if (string == null || string.indexOf(ASTERISK) < 0) {
            return false;
        }
        String[] stringArray = string.split("\\*");
        if (stringArray.length > 2) {
            return false;
        }
        if (!OS2200FileInterface.legalQual(stringArray[0])) {
            return false;
        }
        return OS2200FileInterface.legalFile(stringArray[1]);
    }

    public static boolean legalOS2200FileName(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toUpperCase();
        int n = 0;
        while (n < string2.length()) {
            if (legalFullFileChars.indexOf(string2.charAt(n)) < 0) {
                return false;
            }
            ++n;
        }
        if (!string.endsWith(PERIOD)) {
            return false;
        }
        if (string.indexOf(PERIOD) < string.length() - 1) {
            return false;
        }
        if (string.indexOf("#") >= 0) {
            String[] stringArray = string.split("#");
            if (stringArray.length > 2) {
                return false;
            }
            if (!OS2200FileInterface.legalOS2200DirName(stringArray[0])) {
                return false;
            }
            string = stringArray[1];
        }
        if (string.indexOf(ASTERISK) < 0) {
            return false;
        }
        String[] stringArray = string.split("\\*");
        if (stringArray.length > 2) {
            return false;
        }
        if (!OS2200FileInterface.legalQual(stringArray[0])) {
            return false;
        }
        return OS2200FileInterface.legalFile(stringArray[1]);
    }

    private static boolean legalOS2200DirName(String string) {
        return string.compareToIgnoreCase("STD") == 0 || string.compareToIgnoreCase("SHARED") == 0;
    }

    public static boolean legalQual(String string) {
        if (string.length() < 1) {
            return false;
        }
        return OS2200FileInterface.legalOS2200EltName(string);
    }

    public static boolean legalFile(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!string.endsWith(PERIOD) || string.length() < 2) {
            return false;
        }
        n = (string = string.substring(0, string.lastIndexOf(PERIOD))).indexOf("(");
        if (n > 0) {
            if (string.lastIndexOf("(") != n) {
                return false;
            }
            n3 = string.indexOf(")");
            if (string.lastIndexOf(")") != n3) {
                return false;
            }
            if (n3 <= n || n3 < string.length() - 1) {
                return false;
            }
            n2 = string.charAt(n + 1) == '+' ? n + 2 : n + 1;
            try {
                n4 = n3 == n + 1 ? 0 : Integer.parseInt(string.substring(n2, n3));
                if (n4 > 999 || n4 < -31) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            string = string.substring(0, n);
        }
        return OS2200FileInterface.legalOS2200EltName(string);
    }

    public static long createOS2200Elt(Properties properties, String string) {
        OS2200CorePlugin.logger.debug((Object)"Entering createOS2200Elt");
        long l = 0L;
        String string2 = properties.getProperty("hostID");
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string2);
        HostAccount hostAccount = loginAccount.getHostAccount();
        String string3 = OS2200ProjectUpdate.getShareName(properties);
        String string4 = OS2200FileInterface.getCIFSDir(properties);
        l = OS2200FileInterface.connectCifs(hostAccount, string3, true);
        if (l == 0L) {
            File file = new File(String.valueOf(string4) + "/" + string);
            if (file.exists()) {
                l = -1006L;
            } else {
                try {
                    if (!file.createNewFile()) {
                        l = -1005L;
                    } else {
                        file.setReadable(true, false);
                        file.setExecutable(true, false);
                        file.setWritable(true, false);
                    }
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    l = exception.getMessage().contains("being used by another process") ? -1007L : -1005L;
                }
            }
        }
        return l;
    }

    public static String readFile(String string) throws IOException {
        try (AbstractInterruptibleChannel abstractInterruptibleChannel = null;){
            abstractInterruptibleChannel = new FileInputStream(new File(string)).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)((FileChannel)abstractInterruptibleChannel).size());
            ((FileChannel)abstractInterruptibleChannel).read(byteBuffer);
            String string2 = new String(byteBuffer.array());
            return string2;
        }
    }

    public static Type determineType(String string, int n) {
        int n2 = 0;
        File file = null;
        fileType = Type.NONE;
        if (string != null && n <= 2 && n >= 0 && (file = new File(string)).exists()) {
            n2 = string.replaceAll(" +", EMPTY_STR).replace("\\", SINGLE_SPACE).trim().split(SINGLE_SPACE).length;
            switch (n) {
                case 0: 
                case 1: {
                    if (n2 == 4) {
                        if (file.isDirectory()) {
                            fileType = Type.PROGRAM;
                            break;
                        }
                        fileType = Type.DATA;
                        break;
                    }
                    if (n2 != 5 || file.isDirectory()) break;
                    fileType = Type.ELEMENT;
                    break;
                }
                case 2: {
                    if (n2 == 2) {
                        fileType = Type.PROGRAM;
                        break;
                    }
                    if (n2 != 3) break;
                    fileType = Type.ELEMENT;
                }
            }
        }
        return fileType;
    }

    public static String getPath(String string, int n) {
        String[] stringArray = null;
        String string2 = EMPTY_STR;
        Type type = null;
        int n2 = 0;
        stringArray = string.split(SPLIT_ON_SEPARATOR);
        n2 = stringArray.length;
        string2 = string;
        type = OS2200FileInterface.determineType(string, n);
        switch (n) {
            case 0: 
            case 1: {
                if (type.equals((Object)Type.DATA) || type.equals((Object)Type.PROGRAM)) {
                    if (n2 < 2) break;
                    string2 = String.valueOf(stringArray[n2 - 2]) + ASTERISK + stringArray[n2 - 1] + PERIOD;
                    break;
                }
                if (!type.equals((Object)Type.ELEMENT) || n2 < 3) break;
                string2 = String.valueOf(stringArray[n2 - 3]) + ASTERISK + stringArray[n2 - 2] + PERIOD + stringArray[n2 - 1].replace(PERIOD, "/");
                break;
            }
        }
        return string2;
    }

    public static String getOS2200Path(String string, int n) {
        String[] stringArray = null;
        String string2 = EMPTY_STR;
        Type type = null;
        int n2 = 0;
        stringArray = string.split(SPLIT_ON_SEPARATOR);
        n2 = stringArray.length;
        string2 = string;
        type = OS2200FileInterface.determineType(string, n);
        switch (n) {
            case 0: 
            case 1: {
                if (type.equals((Object)Type.DATA) || type.equals((Object)Type.PROGRAM)) {
                    if (n2 < 2) break;
                    string2 = String.valueOf(stringArray[n2 - 2]) + ASTERISK + stringArray[n2 - 1] + PERIOD;
                    break;
                }
                if (!type.equals((Object)Type.ELEMENT) || n2 < 3) break;
                string2 = String.valueOf(stringArray[n2 - 3]) + ASTERISK + stringArray[n2 - 2] + PERIOD + stringArray[n2 - 1].replace(PERIOD, "/");
            }
        }
        return string2;
    }

    public static String getPathForsaveAs(String string, int n) {
        String[] stringArray = null;
        String string2 = EMPTY_STR;
        Type type = null;
        int n2 = 0;
        stringArray = string.split(SPLIT_ON_SEPARATOR);
        n2 = stringArray.length;
        string2 = string;
        type = OS2200FileInterface.determineType(string, n);
        switch (n) {
            case 0: 
            case 1: {
                if (type.equals((Object)Type.DATA) || type.equals((Object)Type.PROGRAM)) {
                    if (n2 < 2) break;
                    string2 = String.valueOf(stringArray[n2 - 2]) + ASTERISK + stringArray[n2 - 1] + PERIOD;
                    break;
                }
                if (type.equals((Object)Type.ELEMENT)) {
                    if (n2 < 3) break;
                    string2 = String.valueOf(stringArray[n2 - 3]) + ASTERISK + stringArray[n2 - 2] + PERIOD + stringArray[n2 - 1].replace(PERIOD, "/");
                    break;
                }
                Path path = new Path(string);
                string2 = path.removeFirstSegments(2).toString();
                break;
            }
            case 2: {
                if (type.equals((Object)Type.ELEMENT)) {
                    File file = new File(string);
                    string2 = file.getName();
                    break;
                }
                Path path = new Path(string);
                string2 = path.removeFirstSegments(2).toString();
            }
        }
        return string2;
    }

    public static long createOS2200EltFromString(IProject iProject, Properties properties, String string, String string2, boolean bl) {
        OS2200CorePlugin.logger.debug((Object)"Entering createOS2200Elt");
        long l = 0L;
        String string3 = properties.getProperty("hostID");
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string3);
        HostAccount hostAccount = loginAccount.getHostAccount();
        String string4 = OS2200ProjectUpdate.getShareName(properties);
        String string5 = OS2200FileInterface.getCIFSDir(properties);
        l = OS2200FileInterface.connectCifs(hostAccount, string4, true);
        if (l == 0L) {
            Object object;
            File file = new File(String.valueOf(string5) + File.separator + string);
            if (file.exists()) {
                try {
                    file.delete();
                    object = iProject.getFile(string);
                    object.delete(true, null);
                    iProject.refreshLocal(0, null);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            try {
                if (!file.createNewFile()) {
                    l = -1005L;
                    bl = false;
                } else {
                    object = new FileOutputStream(file);
                    ((FileOutputStream)object).write(string2.getBytes());
                    ((FileOutputStream)object).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
        return l;
    }

    public static long renameOS2200Elt(Properties properties, String string, String string2, IResource iResource) {
        long l;
        block12: {
            l = 0L;
            if (!string.equals(string2)) {
                OS2200CorePlugin.logger.debug((Object)"Entering createOS2200Elt");
                String string3 = properties.getProperty("hostID");
                LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string3);
                HostAccount hostAccount = loginAccount.getHostAccount();
                String string4 = OS2200FileInterface.getCIFSDir(properties);
                String string5 = OS2200ProjectUpdate.getShareName(properties);
                l = OS2200FileInterface.connectCifs(hostAccount, string5, true);
                if (l == 0L) {
                    Object object;
                    File file;
                    if (iResource instanceof IFile && !TDECoreUtilities.isPhysicallyInSync((File)(file = new File((object = (IFile)iResource).getRawLocation().toOSString())))) {
                        return -2L;
                    }
                    object = new File(String.valueOf(string4) + "/" + string);
                    file = new File(String.valueOf(string4) + "/" + string2);
                    if (file.exists()) {
                        l = -1006L;
                    } else {
                        try {
                            if (((File)object).renameTo(file)) {
                                l = 0L;
                                if (!(iResource instanceof IFile)) break block12;
                                IFile iFile = (IFile)iResource;
                                File file2 = new File(iFile.getRawLocation().toOSString());
                                File file3 = new File(String.valueOf(file2.getParent()) + "\\" + string2);
                                try {
                                    TDECoreUtilities.removeFromTOC((String)file2.getName(), (File)file2.getParentFile());
                                    if (file2.renameTo(file3)) {
                                        FileInfo fileInfo = new FileInfo(file3.getPath(), file.getPath(), file3.lastModified(), file.lastModified());
                                        TDECoreUtilities.getInstance().addFileInfo(fileInfo);
                                        OS2200CorePlugin.logger.info((Object)(String.valueOf(file2.getName()) + " renamed successfully"));
                                        break block12;
                                    }
                                    OS2200CorePlugin.logger.error((Object)"Delete failed from the cache....");
                                }
                                catch (IOException iOException) {
                                    OS2200CorePlugin.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                                }
                                break block12;
                            }
                            l = -1005L;
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.debug((Object)exception);
                            l = -1005L;
                        }
                    }
                } else {
                    String string6 = OS2200FileInterface.getConnectErrorMsg(l, hostAccount, string5);
                    OS2200CorePlugin.logger.error((Object)string6);
                    OS2200FileInterface.DisplayUserMessage("Rename", string6);
                }
            }
        }
        return l;
    }

    public static long copyOS2200Elt(Properties properties, String string) {
        OS2200CorePlugin.logger.debug((Object)"Entering copyOS2200Elt");
        long l = 0L;
        String string2 = properties.getProperty("CIFSDir");
        String string3 = properties.getProperty("hostID");
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string3);
        HostAccount hostAccount = loginAccount.getHostAccount();
        String string4 = OS2200ProjectUpdate.getShareName(properties);
        l = OS2200FileInterface.connectCifs(hostAccount, string4, true);
        if (l == 0L) {
            File file = new File(String.valueOf(string2) + "/" + string);
            if (file.exists()) {
                l = -1006L;
            } else {
                try {
                    if (!file.createNewFile()) {
                        l = -1005L;
                    }
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.debug((Object)exception);
                    l = -1005L;
                }
            }
        } else {
            String string5 = OS2200FileInterface.getConnectErrorMsg(l, hostAccount, string4);
            OS2200CorePlugin.logger.error((Object)string5);
        }
        return l;
    }

    private static void DisplayUserMessage(String string, String string2) {
        final String string3 = string;
        final String string4 = string2;
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)string3, (String)string4);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long deleteOS2200Elt(Properties properties, String string, boolean bl) {
        Object object;
        Object object2;
        File file;
        File file2;
        String string2;
        String string3;
        long l;
        block58: {
            string = string.toUpperCase();
            l = 0L;
            String string4 = properties.getProperty("hostID");
            LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string4);
            HostAccount hostAccount = loginAccount.getHostAccount();
            string3 = hostAccount.getCifsHostId();
            String string5 = OS2200FileInterface.getCIFSDir(properties);
            String string6 = OS2200ProjectUpdate.getShareName(properties);
            OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState(properties);
            string2 = EMPTY_STR;
            String string7 = null;
            l = OS2200FileInterface.connectCifs(hostAccount, string6, true);
            if (l != 0L) return l;
            file2 = new File(string5);
            file = new File(String.valueOf(string5) + File.separator + string);
            if (bl) {
                block56: {
                    String string8;
                    object2 = EMPTY_STR;
                    if (share == OS2200ProjectUpdate.Share.nShare) {
                        object2 = CIFS_SHARES + string6;
                    } else if (share == OS2200ProjectUpdate.Share.cstShare) {
                        string2 = string.contains(PERIOD) ? string.substring(0, string.indexOf(PERIOD)) : string;
                        OS2200CorePlugin.logger.info((Object)("osName: " + string2));
                    } else {
                        object = HOST_SHARE_PREFIX + string3 + "\\" + string6 + "\\";
                        string8 = String.valueOf(string5.substring(((String)object).length()).replace("\\", ASTERISK)) + PERIOD;
                        object2 = "/" + string6 + "/" + OS2200FileInterface.getOS2200Path(string8);
                    }
                    try {
                        try {
                            if (share == OS2200ProjectUpdate.Share.cstShare) break block56;
                            string7 = OS2200FileInterface.establishSession(properties);
                            if (string7 != null && string7.trim().length() == 0) {
                                object = OS2200FileInterface.executeCommand(CIFSUT);
                                if (((String)object).contains("CIFSUT")) {
                                    String string9;
                                    if (share == OS2200ProjectUpdate.Share.nShare) {
                                        string8 = OS2200FileInterface.executeCommand(GET_CIFS_SHARES);
                                        if (!string8.contains("ERROR")) {
                                            string9 = OS2200FileInterface.executeCommand("ls -2 \n");
                                            if (string9.contains(String.valueOf(string6) + SINGLE_SPACE)) {
                                                string9 = string9.substring(string9.indexOf(string6));
                                                string9 = string9.substring(0, string9.indexOf("\n")).trim();
                                                QSF = (string9 = string9.substring(string9.indexOf(SINGLE_SPACE)).trim()).substring(string9.indexOf("#") + 1).trim();
                                                if (!QSF.endsWith(PERIOD)) {
                                                    QSF = String.valueOf(QSF) + PERIOD;
                                                }
                                                OS2200CorePlugin.logger.info((Object)("QSF: " + QSF));
                                            } else {
                                                OS2200CorePlugin.logger.info((Object)("Share doesn't exist in CIFS: " + string6));
                                            }
                                        } else {
                                            OS2200CorePlugin.logger.info((Object)("cd command ended in error(shrResult): " + string8));
                                        }
                                    }
                                    if (!(string8 = OS2200FileInterface.executeCommand("cd " + (String)object2 + "\n")).contains("ERROR")) {
                                        string9 = OS2200FileInterface.executeCommand("ls -2 \n").toUpperCase();
                                        if (string9 != null && string9.contains(String.valueOf(string) + SINGLE_SPACE)) {
                                            string9 = string9.substring(string9.indexOf(String.valueOf(string) + SINGLE_SPACE));
                                            string9 = string9.substring(0, string9.indexOf("\n")).trim();
                                            if ((string9 = string9.substring(string9.indexOf(SINGLE_SPACE)).trim()).contains(PERIOD)) {
                                                string2 = string9.substring(string9.indexOf(46) + 1);
                                            }
                                            if (string2.contains("/")) {
                                                string2 = string2.substring(0, string2.indexOf("/"));
                                            }
                                            OS2200CorePlugin.logger.info((Object)("osName: " + string2));
                                            break block56;
                                        }
                                        if (string9 != null && string9.contains(String.valueOf(string) + CRLF)) {
                                            OS2200CorePlugin.logger.info((Object)("Selected resource is a directory: " + string));
                                            break block56;
                                        } else {
                                            OS2200CorePlugin.logger.info((Object)("Element doesn't exist in the workfile: " + string));
                                        }
                                        break block56;
                                    }
                                    OS2200CorePlugin.logger.info((Object)("cd command ended in error(dirResult): " + string8));
                                    break block56;
                                }
                                OS2200CorePlugin.logger.info((Object)"Couldn't get into Cifsut");
                                break block56;
                            }
                            OS2200CorePlugin.logger.error((Object)("Error while establishing session: " + string7));
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                            if (string7 != null && string7.trim().length() == 0) {
                                OS2200FileInterface.sessionLogout();
                            }
                            break block58;
                        }
                    }
                    catch (Throwable throwable) {
                        if (string7 == null) throw throwable;
                        if (string7.trim().length() != 0) throw throwable;
                        OS2200FileInterface.sessionLogout();
                        throw throwable;
                    }
                }
                if (string7 != null && string7.trim().length() == 0) {
                    OS2200FileInterface.sessionLogout();
                }
            }
        }
        try {
            if (!file2.exists()) {
                return -1004L;
            }
            if (!file.exists()) {
                if (!bl) return l;
                if (string2.trim().length() <= 0) return l;
                OS2200FileInterface.deleteObj(properties, string2);
                return l;
            }
            object2 = null;
            try {
                try {
                    object2 = new FileInputStream(file);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    try {
                        if (object2 != null) {
                            ((InputStream)object2).close();
                        }
                        object2 = null;
                        return -1010L;
                    }
                    catch (Exception exception2) {
                        OS2200CorePlugin.logger.error((Object)exception2.getMessage(), (Throwable)exception2);
                    }
                    return -1010L;
                }
            }
            finally {
                try {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                    object2 = null;
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            object = null;
            try {
                try {
                    object = new FileOutputStream(file);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    try {
                        if (object != null) {
                            ((OutputStream)object).close();
                        }
                        object = null;
                        return -1010L;
                    }
                    catch (Exception exception3) {
                        OS2200CorePlugin.logger.error((Object)exception3.getMessage(), (Throwable)exception3);
                    }
                    return -1010L;
                }
            }
            finally {
                try {
                    if (object != null) {
                        ((OutputStream)object).close();
                    }
                    object = null;
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            if (file.delete()) {
                if (!bl) return l;
                if (string2.trim().length() <= 0) return l;
                OS2200FileInterface.deleteObj(properties, string2);
                OS2200CorePlugin.logger.info((Object)("Versions deleted successfully: " + string2));
                return l;
            }
            if (!file.isDirectory()) return -1003L;
            return -1008L;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200FileInterface.45", (String)string3), (Throwable)exception);
            return -1003L;
        }
    }

    private static void deleteObj(Properties properties, String string) {
        String string2;
        String string3 = properties.getProperty("hostID");
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string3);
        HostAccount hostAccount = loginAccount.getHostAccount();
        String string4 = hostAccount.getCifsHostId();
        String string5 = OS2200FileInterface.getCIFSDir(properties);
        String string6 = OS2200ProjectUpdate.getShareName(properties);
        OS2200ProjectUpdate.Share share = OS2200ProjectUpdate.getShareState(properties);
        String string7 = EMPTY_STR;
        if (share == OS2200ProjectUpdate.Share.nShare) {
            string7 = QSF;
        } else {
            string2 = HOST_SHARE_PREFIX + string4 + "\\" + string6 + "\\";
            string7 = String.valueOf(string5.substring(string2.length()).replace("\\", ASTERISK)) + PERIOD;
        }
        string2 = ALL_VERSIONS;
        String string8 = DELETE_V + string7 + string + string2 + "\n";
        String string9 = OS2200FileInterface.establishSession(properties);
        if (string9 != null && string9.trim().length() == 0) {
            String string10 = OS2200FileInterface.executeCommand(string8);
            OS2200CorePlugin.logger.info((Object)("Result: " + string10));
            OS2200FileInterface.sessionLogout();
        } else {
            OS2200CorePlugin.logger.error((Object)("Error while establishing session: " + string9));
        }
    }

    public static String establishSession(Properties properties) {
        String string = properties.getProperty("hostID");
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
        sesso = Session.New((LoginAccount)loginAccount);
        return sesso.Login();
    }

    public static String executeCommand(String string) {
        sesso.SendCommand_ProtocolSpecific(string, false);
        return sesso.getOutput();
    }

    public static void sessionLogout() {
        sesso.Logout();
    }

    private static String stripSubType(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static IWorkbenchWindow UIActiveWindow() {
        Display display = Display.getDefault();
        iww = null;
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                iww = OS2200CorePlugin.myWorkbench.getActiveWorkbenchWindow();
            }
        });
        return iww;
    }

    public static IWorkbenchPage UIActivePage() {
        Display display = Display.getDefault();
        iwp = null;
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                iwp = OS2200CorePlugin.myWorkbench.getActiveWorkbenchWindow().getActivePage();
            }
        });
        return iwp;
    }

    public static void addSortedItem(List list, ElementSelectionObject elementSelectionObject) {
        int n = 0;
        int n2 = 0;
        int n3 = list.size();
        String string = elementSelectionObject.elementName.toLowerCase();
        while (n3 - n2 > 0) {
            n = (n3 - n2) / 2 + n2;
            ElementSelectionObject elementSelectionObject2 = (ElementSelectionObject)list.get(n);
            int n4 = string.compareTo(elementSelectionObject2.elementName.toLowerCase());
            if (n4 < 0) {
                n3 = n;
                continue;
            }
            if (n4 > 0) {
                n2 = ++n;
                continue;
            }
            list.add(n, elementSelectionObject);
            return;
        }
        list.add(n, elementSelectionObject);
    }

    private static Shell getShell() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        Shell shell = new Shell(display.getActiveShell(), 0);
        return shell;
    }

    public static String getFileAsString(String string) {
        File file = new File(string);
        int n = (int)file.length();
        if (n == 0) {
            return null;
        }
        int n2 = n + 0x100000;
        byte[] byArray = new byte[n2];
        FileInputStream fileInputStream = null;
        int n3 = 0;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200FileInterface.136", (String)string), (Throwable)fileNotFoundException);
            OS2200CorePlugin.logger.info((Object)(String.valueOf(Messages.getString((String)"OS2200FileInterface.137")) + string), (Throwable)fileNotFoundException);
            fileNotFoundException.printStackTrace();
        }
        if (fileInputStream != null) {
            try {
                OS2200CorePlugin.logger.debug((Object)("count " + n + SINGLE_SPACE + byArray.length));
                int n4 = 0;
                int n5 = 0;
                n3 = 0;
                while (n4 != -1) {
                    n4 = ((InputStream)fileInputStream).read(byArray, n5, byArray.length - n5);
                    OS2200CorePlugin.logger.debug((Object)("*** counting bkfile cntIn " + n4));
                    if (n4 == -1) continue;
                    n3 += n4;
                    n5 += n4;
                }
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200FileInterface.136", (String)string), (Throwable)iOException);
                OS2200CorePlugin.logger.info((Object)(String.valueOf(Messages.getString((String)"OS2200FileInterface.137")) + string), (Throwable)iOException);
                iOException.printStackTrace();
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200FileInterface.136", (String)string), (Throwable)iOException);
                OS2200CorePlugin.logger.info((Object)(String.valueOf(Messages.getString((String)"OS2200FileInterface.137")) + string), (Throwable)iOException);
                iOException.printStackTrace();
            }
        }
        return new String(byArray, 0, n3);
    }

    public static boolean isValidExtension(String string) {
        int n = 0;
        while (n < OS2200ProjectUpdate.eltTypes.length) {
            if (string.toUpperCase().equals(OS2200ProjectUpdate.eltTypes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void setCifsConnMap(String string, boolean bl) {
        fCifsConnMap.put(string, bl);
    }

    public static boolean isCifsConnected(HostAccount hostAccount) {
        boolean bl = false;
        String string = hostAccount.getConnectionName();
        Boolean bl2 = fCifsConnMap.get(string);
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    public static boolean createWorkFile(String string, String string2) {
        String string3;
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string2);
        ISession iSession = null;
        if (loginAccount != null && (string3 = (iSession = Session.New((LoginAccount)loginAccount)).Login()).length() == 0) {
            String string4 = "@cat,p " + string;
            iSession.SendCommand(String.valueOf(string4) + "\n");
            String string5 = iSession.getOutput().trim();
            OS2200CorePlugin.logger.debug((Object)string5);
            if (!string5.equalsIgnoreCase(CAT_ERROR)) {
                string4 = "@save " + string;
                iSession.SendCommand(String.valueOf(string4) + "\n");
                string5 = iSession.getOutput().trim();
                OS2200CorePlugin.logger.debug((Object)string5);
                iSession.Logout();
                return true;
            }
        }
        if (iSession != null) {
            iSession.Logout();
        }
        return false;
    }

    public static boolean isMASMEltExists(Properties properties, String string) {
        String string2 = properties.getProperty("hostID");
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string2);
        HostAccount hostAccount = loginAccount.getHostAccount();
        String string3 = OS2200ProjectUpdate.getShareName(properties);
        String string4 = OS2200FileInterface.getCIFSDir(properties);
        long l = OS2200FileInterface.connectCifs(hostAccount, string3, true);
        if (l == 0L) {
            File file = new File(String.valueOf(string4) + "/" + string);
            if (file.exists()) {
                return true;
            }
        } else {
            String string5 = OS2200FileInterface.getConnectErrorMsg(l, hostAccount, string3);
            OS2200CorePlugin.logger.error((Object)string5);
        }
        return false;
    }

    public static boolean checkAndConnectCIFS(IProject iProject, boolean bl) {
        Properties properties = null;
        try {
            properties = OS2200ProjectUpdate.getProperties(iProject);
            String string = properties.getProperty("hostID");
            LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
            if (loginAccount != null) {
                loginAccount.getHostAccount();
                OS2200ProjectUpdate.connectOS2200(iProject, bl);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return false;
    }

    private static String promtForPassword(HostAccount hostAccount) {
        String string = hostAccount.getCifsHostId();
        String string2 = hostAccount.getCifsUserId();
        String string3 = hostAccount.getCifsPassword();
        UserPrompt userPrompt = new UserPrompt();
        UserPromptData userPromptData = new UserPromptData();
        userPromptData.echo = false;
        userPromptData.Title = Messages.getString((String)"OS2200FileInterface.14", (String)string);
        userPromptData.Prompt = String.valueOf(Messages.getString((String)"OS2200FileInterface_pwdChange")) + com.unisys.telnet.lib.Messages.getString((String)"Session.29", (String)string2);
        if (userPrompt.show(userPromptData)) {
            string3 = userPromptData.Reply;
            HostAccount.savePassword((HostAccount)hostAccount, (String)string3);
            OS2200CorePlugin.logger.debug((Object)" =========> got password from prompt");
            return string3;
        }
        OS2200CorePlugin.logger.info((Object)com.unisys.telnet.lib.Messages.getString((String)"Session.19"));
        OS2200CorePlugin.logger.debug((Object)"=========> password prompt cancelled");
        return null;
    }

    public static List getHostNames() {
        HostAccount[] hostAccountArray = HostAccount.getHostAccounts();
        int n = 0;
        int n2 = hostAccountArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        n = 0;
        while (n < n2) {
            arrayList.add(hostAccountArray[n].getCifsHostId());
            ++n;
        }
        return arrayList;
    }

    public static HashMap<String, String> parseElementType() {
        try {
            String string = String.valueOf(OS2200FileInterface.getPluginDirectoryPath()) + "attributes.txt";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = EMPTY_STR;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string2.trim().length() <= 0 || (stringArray = string2.split("\\s+"))[0].trim().length() <= 0 || stringArray[1].trim().length() <= 0) continue;
                elementNameMap.put(stringArray[0], stringArray[1]);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return elementNameMap;
    }

    public static String getPluginDirectoryPath() {
        Path path = null;
        try {
            Bundle bundle = Platform.getBundle((String)"com.unisys.tde.core");
            URL uRL = Platform.resolve((URL)bundle.getEntry("/"));
            path = new Path(uRL.getFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return path.toOSString();
    }

    static File getFile(String string, String string2, String string3) {
        if (string2.contains(ASTERISK)) {
            String string4 = string2.substring(0, string2.indexOf(ASTERISK));
            String string5 = string2.substring(string2.indexOf(ASTERISK) + 1);
            if (string5.contains(PERIOD)) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            StringBuilder stringBuilder = new StringBuilder(HOST_SHARE_PREFIX);
            stringBuilder.append(string);
            stringBuilder.append(File.separator);
            stringBuilder.append(DEFAULT_SHARE);
            stringBuilder.append(File.separator);
            stringBuilder.append(string4);
            stringBuilder.append(File.separator);
            stringBuilder.append(string5);
            stringBuilder.append(File.separator);
            stringBuilder.append(string3);
            File file = new File(stringBuilder.toString());
            return file;
        }
        return null;
    }

    public static String[] getQualifierList(String string, String string2) {
        String string3;
        String string4;
        File file;
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
        String[] stringArray = null;
        long l = 0L;
        HostAccount hostAccount = loginAccount.getHostAccount();
        l = OS2200FileInterface.connectCifs(hostAccount, DEFAULT_SHARE, true);
        if (l == 0L && (file = new File(string4 = new Path(string3 = HOST_SHARE_PREFIX + hostAccount.getCifsHostId() + "\\" + string2 + "\\").toOSString())).exists() && (stringArray = file.list()) != null) {
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        }
        return stringArray;
    }

    public static File[] getFileList(String string, String string2, String string3) {
        Object object;
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
        File[] fileArray = null;
        long l = 0L;
        HostAccount hostAccount = loginAccount.getHostAccount();
        l = OS2200FileInterface.connectCifs(hostAccount, DEFAULT_SHARE, true);
        if (l == 0L) {
            object = HOST_SHARE_PREFIX + hostAccount.getCifsHostId() + "\\" + string2 + "\\" + string3;
            String string4 = new Path((String)object).toOSString();
            File file = new File(string4);
            if (file.exists()) {
                fileArray = file.listFiles();
            } else {
                MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface_2"), (String)(String.valueOf(string3) + Messages.getString((String)"OS2200FileInterface_22")));
            }
        }
        object = new MyComparator();
        if (fileArray != null) {
            Arrays.sort(fileArray, object);
        }
        return fileArray;
    }

    public static String[] getElementList(String string, String string2, String string3, String string4) {
        String string5;
        String string6;
        File file;
        LoginAccount loginAccount = LoginAccount.getLoginAccount((String)string);
        String[] stringArray = null;
        long l = 0L;
        HostAccount hostAccount = loginAccount.getHostAccount();
        l = OS2200FileInterface.connectCifs(hostAccount, DEFAULT_SHARE, true);
        if (l == 0L && (file = new File(string6 = new Path(string5 = HOST_SHARE_PREFIX + hostAccount.getCifsHostId() + "\\" + string2 + "\\" + string3 + "\\" + string4).toOSString())).exists()) {
            stringArray = file.list();
        }
        if (stringArray != null) {
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        }
        return stringArray;
    }

    public static InfoPack lnkProjWithElementNames(IProject iProject, InfoPack infoPack) {
        ArrayList arrayList = infoPack.getInfoList();
        if (arrayList == null) {
            return infoPack;
        }
        try {
            if (iProject.exists()) {
                IResource[] iResourceArray = iProject.members();
                int n = 0;
                while (n < iResourceArray.length) {
                    if (iResourceArray[n] instanceof IFile && iResourceArray[n].isLinked()) {
                        String string;
                        boolean bl = OS2200ProjectUpdate.isConverted((IFile)iResourceArray[n]);
                        IPath iPath = null;
                        if (bl) {
                            string = OS2200ProjectUpdate.getRawLoc((IFile)iResourceArray[n]);
                            iPath = new Path(string);
                        } else {
                            iPath = iResourceArray[n].getRawLocation();
                        }
                        if (iPath != null) {
                            string = iPath.lastSegment();
                            ElementSelectionObject elementSelectionObject = OS2200FileInterface.findbyeltname(arrayList, string);
                            if (elementSelectionObject == null) {
                                elementSelectionObject = new ElementSelectionObject(String.valueOf(OS2200ProjectUpdate.DeletedFlag) + SINGLE_SPACE + string, iResourceArray[n].getName(), OS2200ProjectUpdate.DeletedFlag);
                                OS2200FileInterface.addSortedItem(arrayList, elementSelectionObject);
                            } else {
                                elementSelectionObject.linkName = iResourceArray[n].getName();
                            }
                            if (bl || OS2200ProjectUpdate.hasCharConversion((IFile)iResourceArray[n])) {
                                elementSelectionObject.ConvName = OS2200ProjectUpdate.getCharConversion((IFile)iResourceArray[n]);
                            } else {
                                elementSelectionObject.editOpen = OS2200FileInterface.isEditOpen(iProject, elementSelectionObject.linkName);
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)Messages.getString((String)"OS2200Startup.9"), (Throwable)coreException);
        }
        infoPack.setInfoList(arrayList);
        return infoPack;
    }

    public static HashMap<String, ArrayList<String>> parseCopyProc(String string) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        try {
            if (Connectiob_CopyProc_Map.get(string) != null) {
                hashMap = Connectiob_CopyProc_Map.get(string);
            }
            hashMap.clear();
            File file = new File(String.valueOf(userHome) + copyProcDir + string);
            String string2 = file.getPath();
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                String string3 = EMPTY_STR;
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    if (string3.trim().length() <= 0 || (stringArray = string3.split("\\s+"))[0].trim().length() <= 0 || stringArray[1].trim().length() <= 0) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (hashMap.containsKey(stringArray[0].trim())) {
                        arrayList = hashMap.get(stringArray[0].trim());
                    }
                    arrayList.add(stringArray[1]);
                    hashMap.put(stringArray[0], arrayList);
                }
                bufferedReader.close();
                Connectiob_CopyProc_Map.put(string, hashMap);
            } else {
                hashMap = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static HashMap<String, ArrayList<String>> getCopyProcMap(IFile iFile) {
        HashMap<String, ArrayList<String>> hashMap = null;
        try {
            String string = null;
            string = OS2200ProjectUpdate.getProperties(iFile.getProject()).getProperty("hostID");
            if (string != null) {
                hashMap = OS2200FileInterface.parseCopyProc(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static boolean isCopyMapFileExsists(String string) {
        File file = new File(String.valueOf(userHome) + copyProcDir + string);
        return file.exists();
    }

    public static Properties loadTelnetMacroProperties() {
        Properties properties = null;
        File file = new File(String.valueOf(userHome) + copyProcDir + "telnetMap.properties");
        try {
            if (file.exists()) {
                properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception);
            return properties;
        }
        return properties;
    }

    public static Properties saveTelnetMacroProperties(Properties properties) {
        File file = new File(String.valueOf(userHome) + copyProcDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(String.valueOf(userHome) + copyProcDir + "telnetMap.properties");
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file2);
                properties.store(fileOutputStream, EMPTY_STR);
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception);
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)iOException);
                }
            }
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)iOException);
            }
        }
        return properties;
    }

    public static IEditorPart openFileInEditor(File file, OS2200FileEditorInput oS2200FileEditorInput) {
        OS2200CorePlugin.logger.debug((Object)("Trying to open " + file.getName() + " in OS2200FileInterface.openFileInEditor()"));
        if (MemChecker.getInstance().isLargeFile(file, true)) {
            OS2200CorePlugin.logger.warn((Object)("Due to low memory unable to open " + file.getName() + " in OS2200FileInterface.openFileInEditor()"));
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)oS2200FileEditorInput, oS2200FileEditorInput.getEditorid(), true);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return iEditorPart;
    }

    private static String getEditorType(String string) {
        if (string.equalsIgnoreCase(COBOL)) {
            return COBOL_EDITOR_ID;
        }
        if (string.equalsIgnoreCase(C)) {
            return C_EDITOR_ID;
        }
        if (string.equalsIgnoreCase(ELT)) {
            return UDT_EDITOR_ID;
        }
        return null;
    }

    public static String isFileReadable(File file, int n) {
        String string;
        block15: {
            string = null;
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (Exception exception) {
                    String string2 = OS2200FileInterface.getPath(file.getAbsolutePath(), n);
                    if (exception.getMessage().contains("A device attached to the system is not functioning")) {
                        string = string2.isEmpty() ? Messages.getString((String)"OS2200FileInterface.FileReadable2") : Messages.getString((String)"OS2200FileInterface.FileReadable1", (String)string2);
                    } else {
                        string = exception.getMessage();
                        if (string.contains(" (") && !string2.isEmpty()) {
                            string = String.valueOf(string2) + SINGLE_SPACE + string.substring(string.indexOf(" ("));
                        }
                    }
                    if (fileInputStream == null) break block15;
                    try {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException.getMessage());
                    }
                }
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.error((Object)iOException.getMessage());
                    }
                }
            }
        }
        return string;
    }

    private String getPosixMessage(String string) {
        String string2 = null;
        String[] stringArray = (string = string.replace('\\', '=')).split("=");
        if (stringArray.length == 7) {
            string2 = String.valueOf(stringArray[4]) + ASTERISK + stringArray[5] + PERIOD + stringArray[6];
        } else if (stringArray.length == 6) {
            string2 = String.valueOf(stringArray[4]) + ASTERISK + stringArray[5];
        }
        return string2;
    }

    public static IEditorPart OpenAction(File file, OS2200FileEditorInput oS2200FileEditorInput) {
        OS2200CorePlugin.logger.debug((Object)("Trying to open " + file.getName() + " in OS2200FileInterface.OpenAction()"));
        if (MemChecker.getInstance().isLargeFile(file, true)) {
            OS2200CorePlugin.logger.warn((Object)("Due to low memory unable to open " + file.getName() + " in OS2200FileInterface.OpenAction()"));
            return null;
        }
        OS2200CorePlugin.logger.debug((Object)("Opening element : " + file.getPath()));
        if (file.length() >= 0x500000L) {
            boolean bl = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"OpenFileAction.6"), (String)Messages.getString((String)"OpenFileAction.7"));
            if (!bl) {
                OS2200CorePlugin.logger.debug((Object)("User cancelled to open " + file.getName() + " with Text Editor."));
                return null;
            }
            String string = null;
            String string2 = file.getName();
            if (string2.contains(PERIOD)) {
                int n = string2.lastIndexOf(46);
                if (n > 0) {
                    String string3 = string2.substring(n + 1);
                    if (string3 != null && string3.equalsIgnoreCase(ELT)) {
                        string = string2;
                    } else {
                        string2 = string2.replace(PERIOD, "-");
                        string = String.valueOf(string2) + PERIOD + ELT;
                    }
                } else {
                    string2 = string2.replace(PERIOD, "-");
                    string = String.valueOf(string2) + PERIOD + ELT;
                }
            } else {
                string = String.valueOf(string2) + PERIOD + ELT;
            }
            oS2200FileEditorInput.setEditorid(UDT_EDITOR_ID);
            oS2200FileEditorInput.setFileName(string);
            IEditorPart iEditorPart = OS2200FileInterface.openFileInEditor(file, oS2200FileEditorInput);
            return iEditorPart;
        }
        OS2200FileInterface.getFileEditor(file);
        oS2200FileEditorInput.setEditorid(editorID);
        oS2200FileEditorInput.setFileName(fileNameStr);
        String string = PlatformUI.getPreferenceStore().getString(file.getName());
        if (string != null && string.equalsIgnoreCase("LETSJ")) {
            oS2200FileEditorInput.setCharConv(OS2200CharSetPlugin.JAPANESE);
        } else {
            oS2200FileEditorInput.setCharConv("<NONE>");
        }
        IEditorPart iEditorPart = OS2200FileInterface.openFileInEditor(file, oS2200FileEditorInput);
        return iEditorPart;
    }

    static void getFileEditor(File file) {
        editorID = null;
        fileNameStr = null;
        String string = EMPTY_STR;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string = string2.substring(n + 1);
        }
        if (Arrays.asList(OS2200ProjectUpdate.eltTypes).contains(string.toUpperCase())) {
            editorID = OS2200FileInterface.getEditorId(file);
            fileNameStr = string2;
        }
        if (editorID == null && fileNameStr == null) {
            String string3 = ELT;
            if (elementNameMap.isEmpty()) {
                OS2200FileInterface.parseElementType();
            }
            String string4 = null;
            String string5 = EMPTY_STR;
            if (file.getName().contains(PERIOD)) {
                string5 = file.getName().substring(0, file.getName().indexOf(PERIOD));
                fileNameStr = string2.replace(PERIOD, "-");
            } else {
                string5 = file.getName();
                fileNameStr = string2;
            }
            if (elementNameMap.containsKey(string5)) {
                string4 = elementNameMap.get(string5);
                if (string4.equalsIgnoreCase(COBOL) || string4.equalsIgnoreCase(C) || string4.equalsIgnoreCase(ELT)) {
                    string3 = string4;
                }
            } else {
                string3 = OS2200FileInterface.getEltType(file);
            }
            editorID = OS2200FileInterface.getEditorType(string3);
            fileNameStr = String.valueOf(fileNameStr) + PERIOD + string3;
        }
    }

    public static String getEditorId(File file) {
        String string = file.getName();
        if (OS2200FileInterface.endsWithIgnoreCase(string, ".cob")) {
            return COBOL_EDITOR_ID;
        }
        if (OS2200FileInterface.endsWithIgnoreCase(string, ".elt") || OS2200FileInterface.endsWithIgnoreCase(string, ".txt")) {
            return UDT_EDITOR_ID;
        }
        if (OS2200FileInterface.endsWithIgnoreCase(string, ".H") || OS2200FileInterface.endsWithIgnoreCase(string, ".c")) {
            return C_EDITOR_ID;
        }
        if (OS2200FileInterface.endsWithIgnoreCase(string, ".java")) {
            return JAVA_EDITOR_ID;
        }
        if (OS2200FileInterface.endsWithIgnoreCase(string, ".msm") || OS2200FileInterface.endsWithIgnoreCase(string, ".for")) {
            return DEFAULT_EDITOR_ID;
        }
        if (OS2200FileInterface.endsWithIgnoreCase(string, ".ASM")) {
            return ASM_EDITOR_EDITOR;
        }
        if (OS2200FileInterface.endsWithIgnoreCase(string, ".PLS")) {
            return PLUS_EDITOR_ID;
        }
        return null;
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        return OS2200FileInterface.endsWith(string, string2, true);
    }

    public static boolean verifyEltName(String string) {
        String string2;
        String string3 = null;
        if (string.length() <= 0) {
            return false;
        }
        int n = string.indexOf(47);
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string2 = string;
            string3 = null;
        }
        if (string3 != null) {
            if (string3.length() == 0) {
                return false;
            }
            if (!OS2200FileInterface.legalOS2200EltName(string2) || !OS2200FileInterface.legalOS2200EltName(string3)) {
                return false;
            }
        } else if (!OS2200FileInterface.legalOS2200EltName(string2)) {
            return false;
        }
        return true;
    }

    private static boolean endsWith(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (string2.length() > string.length()) {
            return false;
        }
        int n = string.length() - string2.length();
        return string.regionMatches(bl, n, string2, 0, string2.length());
    }

    public static void validatedWorkFileMsg(IProject iProject, String string) {
        try {
            Properties properties = OS2200ProjectUpdate.getProperties(iProject);
            if (properties == null) {
                MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.SaveProblems"), (String)Messages.getString((String)"OS2200FileInterface.SaveProb"));
                return;
            }
            String string2 = properties.getProperty("workFile");
            LoginAccount loginAccount = LoginAccount.getLoginAccount((String)properties.getProperty("hostID"));
            if (string2 != null && string2.length() > 0 && loginAccount != null) {
                String string3 = loginAccount.getHostAccount().getCifsHostId();
                if (string.equals("DIRNOTREACHABLE")) {
                    MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.SaveProblems"), (String)Messages.getString((String)"OS2200FileInterface.IsNotReachableMSG", (String)string2, (String)string3));
                } else if (string.equals("ISNOTDIR")) {
                    MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.SaveProblems"), (String)Messages.getString((String)"OS2200FileInterface.IsNotDirMSG", (String)string2, (String)string3));
                } else if (string.equals("READONLYDIR")) {
                    MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.SaveProblems"), (String)Messages.getString((String)"OS2200FileInterface.SaveProblemsMSG", (String)string2, (String)string3));
                } else {
                    MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.SaveProblems"), (String)Messages.getString((String)"OS2200FileInterface.SaveProb"));
                }
            } else {
                MessageDialog.openError((Shell)OS2200FileInterface.getShell(), (String)Messages.getString((String)"OS2200FileInterface.SaveProblems"), (String)Messages.getString((String)"OS2200FileInterface.SaveProb"));
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)coreException.getMessage(), (Throwable)coreException);
        }
    }

    /*
     * Exception decompiling
     */
    private static String getEltType(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[DOLOOP]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String derivefileName(String string, String string2) {
        String string3 = EMPTY_STR;
        String string4 = EMPTY_STR;
        if (string.contains("\\" + string2 + "\\") && (string = string.substring(string.indexOf(string2) + string2.length() + 1)).contains("\\")) {
            string3 = string.substring(0, string.indexOf("\\"));
            string4 = string.substring(string.indexOf("\\") + 1);
            if (string4.contains("\\")) {
                string4 = string4.substring(0, string4.indexOf("\\"));
            }
        }
        if (!string3.isEmpty() && !string4.isEmpty()) {
            return String.valueOf(string3) + ASTERISK + string4 + PERIOD;
        }
        return EMPTY_STR;
    }

    public static String getOS2200PathForCopyProc(String string) {
        String string2 = EMPTY_STR;
        if (string != null) {
            Path path;
            string2 = string;
            if (string.startsWith(HOST_SHARE_PREFIX) && (path = new Path(string)).segmentCount() == 5) {
                String string3 = path.segment(2);
                String string4 = path.segment(3);
                String string5 = path.segment(4);
                string2 = String.valueOf(string3) + ASTERISK + string4 + PERIOD + string5;
            }
        }
        return string2;
    }

    public static String getCurrentFileName() {
        String string = EMPTY_STR;
        try {
            IEditorPart iEditorPart;
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null) {
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                if (iEditorInput instanceof IFileEditorInput) {
                    IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                    string = iFile.getRawLocation().toFile().getName();
                } else if (iEditorInput instanceof OS2200FileEditorInput) {
                    string = ((OS2200FileEditorInput)iEditorInput).getfFile().getName();
                } else if (iEditorInput instanceof FileStoreEditorInput || iEditorInput instanceof NonExistingFileEditorInput) {
                    string = iEditorInput.getName();
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage());
        }
        return string;
    }

    public static LoginAccount getLoginAccount(String string) {
        return LoginAccount.getLoginAccount((String)string);
    }

    public static enum Type {
        DATA,
        PROGRAM,
        ELEMENT,
        NONE;

    }
}

