/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.common.util.CommonUtilLogger;
import com.unisys.logging.core.PluginLogManager;
import com.unisys.os2200.util.OS2200ArchitectureConstant;
import com.unisys.os2200.util.UtilLogger;
import com.unisys.tde.core.OS2200GeneralEditListener;
import com.unisys.tde.core.OS2200PageListener;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.OS2200WindowListener;
import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import com.unisys.tde.license.LicensePlugin;
import com.unisys.telnet.lib.TelnetLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OS2200CorePlugin
extends Plugin {
    private static OS2200CorePlugin plugin;
    private static ResourceBundle resourceBundle;
    public static final String PLUGIN_ID = "com.unisys.tde.core";
    public static final String NATURE_ID = "com.unisys.tde.core.OS2200";
    private ProjectListener projectListener;
    private static final String LOG_PROPERTIES_FILE = "logger.properties";
    private PluginLogManager logManager;
    public static Logger logger;
    private ILog log;
    public static IWindowListener windowListen;
    public static IPageListener pageListen;
    public static IPartListener2 editListen;
    public static IWorkbench myWorkbench;

    public OS2200CorePlugin() {
        plugin = this;
        try {
            resourceBundle = ResourceBundle.getBundle("com.unisys.tde.core.OS2200CorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        catch (Exception exception) {
            exception.getMessage();
            resourceBundle = null;
        }
        catch (Throwable throwable) {
            throwable.getMessage();
            resourceBundle = null;
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        if (!LicensePlugin.checkLicense()) {
            return;
        }
        try {
            super.start(bundleContext);
            this.projectListener = new ProjectListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.projectListener, 1);
            this.log = this.getLog();
            this.logManager = new PluginLogManager((Plugin)this);
            this.logManager.configure(LOG_PROPERTIES_FILE);
            logger = this.logManager.getLogger("com.unisys.os2200");
            logger.info((Object)"started OS2200CorePlugin");
            TelnetLogger.logger = logger;
            OS2200CharSetPlugin.logger = logger;
            UtilLogger.setLogger((Logger)logger);
            CommonUtilLogger.setLogger((Logger)logger);
            OS2200CorePlugin.addListeners();
        }
        catch (Throwable throwable) {
            logger.error((Object)"startup code", throwable);
        }
    }

    public static InputStream opnStream(String string) throws IOException {
        InputStream inputStream = FileLocator.openStream((Bundle)plugin.getBundle(), (IPath)new Path(string), (boolean)false);
        return inputStream;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
    }

    public static OS2200CorePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + string + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + string + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static URL pluginURLPath(String string) {
        URL uRL;
        try {
            URL uRL2;
            URL uRL3 = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(string), null);
            uRL = uRL2 = FileLocator.resolve((URL)uRL3);
        }
        catch (Exception exception) {
            System.out.println("error resolving " + exception.getMessage());
            uRL = null;
        }
        return uRL;
    }

    public static File getFilePath(String string) {
        URL uRL = OS2200CorePlugin.pluginURLPath(string);
        if (uRL != null) {
            return new File(uRL.getPath());
        }
        return null;
    }

    public static String getFormattedString(String string, String string2) {
        return MessageFormat.format(OS2200CorePlugin.getResourceString(string), string2);
    }

    public static String getFormattedString(String string, String[] stringArray) {
        return MessageFormat.format(OS2200CorePlugin.getResourceString(string), stringArray);
    }

    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public PluginLogManager getPluginLogManager() {
        return this.logManager;
    }

    public static OS2200CorePlugin getPlugin() {
        return plugin;
    }

    public static void log(Throwable throwable) {
        if (throwable instanceof CoreException) {
            OS2200CorePlugin.log(((CoreException)throwable).getStatus());
        } else {
            OS2200CorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", throwable));
        }
    }

    public static void log(IStatus iStatus) {
        OS2200CorePlugin.getDefault().getLog().log(iStatus);
    }

    private void checkForTransUpdate(IResource iResource, IResourceDelta iResourceDelta) {
        try {
            IPath iPath;
            String[] stringArray;
            IResourceDelta[] iResourceDeltaArray;
            if (iResource instanceof IProject && (iResourceDeltaArray = iResourceDelta.getAffectedChildren(4)).length > 0 && (stringArray = (iPath = iResourceDeltaArray[0].getFullPath()).segments()).length > 1) {
                IProject iProject;
                IResource iResource2;
                String string = stringArray[1];
                if (iResource instanceof IProject && (iResource2 = (iProject = (IProject)iResource).findMember(string)) != null && iResource2.isLinked()) {
                    String string2 = "";
                    try {
                        string2 = iResource2.getPersistentProperty(OS2200ArchitectureConstant.TRANS_WRITTEN);
                        iResource2.getPersistentProperty(OS2200ArchitectureConstant.ORIGINAL_RAW);
                    }
                    catch (CoreException coreException) {
                        logger.error((Object)"Eclipse not configured right ", (Throwable)coreException);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)"Unisys Internal Error", throwable);
        }
    }

    public static void addListeners() {
        windowListen = new OS2200WindowListener();
        pageListen = new OS2200PageListener();
        editListen = new OS2200GeneralEditListener();
        myWorkbench = PlatformUI.getWorkbench();
        myWorkbench.addWindowListener(windowListen);
        IWorkbenchWindow[] iWorkbenchWindowArray = myWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            iWorkbenchWindowArray[n].addPageListener(pageListen);
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                iWorkbenchPageArray[n2].addPartListener(editListen);
                ++n2;
            }
            ++n;
        }
    }

    private class ProjectListener
    implements IResourceChangeListener {
        private ProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            iResourceChangeEvent.getResource();
            try {
                switch (iResourceChangeEvent.getType()) {
                    case 1: {
                        iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)new deltaWalker());
                    }
                }
            }
            catch (Exception exception) {}
        }

        private class deltaWalker
        implements IResourceDeltaVisitor {
            private deltaWalker() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean visit(IResourceDelta iResourceDelta) {
                IResource iResource = iResourceDelta.getResource();
                OS2200CorePlugin.this.checkForTransUpdate(iResource, iResourceDelta);
                try {
                    if (iResource == null || !(iResource instanceof IProject) || !((IProject)iResource).isOpen() || !((IProject)iResource).hasNature(OS2200CorePlugin.NATURE_ID)) return true;
                    switch (iResourceDelta.getKind()) {
                        case 4: {
                            int n;
                            if (!((IProject)iResource).isOpen() || ((n = iResourceDelta.getFlags()) & 0x4000) == 0) return true;
                            OS2200ProjectUpdate.connectOS2200((IProject)iResource, true);
                            ((IProject)iResource).refreshLocal(0, null);
                        }
                        default: {
                            return true;
                        }
                    }
                }
                catch (Exception exception) {
                    logger.warn((Object)exception);
                }
                return true;
            }
        }
    }
}

