/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200Timer;
import com.unisys.tde.core.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class OS2200Connect {
    private static OS2200Connect os2200ConnObj = null;
    private static Runtime rt = null;
    private static Process process;
    private OS2200Timer timer;
    private boolean unReachableError;
    protected static final int TIME_OUT_PERIOD = 20;
    private static final String NET_USE_CMD = "net use ";
    protected static final String KILL = "taskkill /F /IM ";
    private ExecutorService executor;
    private Task task;
    private String out = null;
    private String result = null;

    private OS2200Connect() {
    }

    public static OS2200Connect getRuntimeExecInstance() {
        if (os2200ConnObj == null) {
            os2200ConnObj = new OS2200Connect();
            rt = Runtime.getRuntime();
        }
        return os2200ConnObj;
    }

    public static Process getProcess() {
        return process;
    }

    public String executeCMD(String string) {
        new StringBuffer();
        try {
            this.task = new Task();
            this.task.setSuccess(false);
            this.task.setConError(false);
            this.task.setUnKnownError(false);
            String string2 = string.substring(0, string.trim().lastIndexOf(" "));
            OS2200CorePlugin.logger.info((Object)("String to be executed in command prompt := " + string2));
            this.executor = Executors.newSingleThreadExecutor();
            this.task.setCmdString(string);
            Future<String> future = this.executor.submit(this.task);
            future.get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (TimeoutException timeoutException) {
            OS2200CorePlugin.logger.error((Object)"Connection timeout has occurred");
            this.executor.shutdownNow();
            return "-1111";
        }
        return this.task.getResValue();
    }

    public int executeCMDPing(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        this.setUnReachableError(false);
        try {
            process = rt.exec(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BufferedReader bufferedReader = this.getBufferedReader(process.getInputStream());
        try {
            while ((this.out = bufferedReader.readLine()) != null) {
                if (!this.out.contains("unreachable") && !this.out.contains("Request timed out") && !this.out.contains("Ping request could not find host")) continue;
                stringBuffer.append(this.out);
                this.setUnReachableError(true);
                n = -1;
                break;
            }
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)"Error in pinging host");
        }
        if (!this.isUnReachableError()) {
            n = 0;
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return n;
    }

    public Long doMappedDrive(String string, String string2, String string3) {
        string2 = string2.replace("\\", "\\");
        String string4 = NET_USE_CMD + string + " " + " /USER:" + string2 + " " + string3;
        String string5 = this.executeCMD(string4);
        long l = Long.parseLong(string5);
        this.executor.shutdownNow();
        return l;
    }

    public boolean disConnectMapDrive(String string) {
        String string2 = NET_USE_CMD + string + " /delete";
        String string3 = this.executeCMD(string2);
        return string3.endsWith("was deleted successfully.");
    }

    public String disConnectStatus() {
        String string = null;
        string = this.executeCMD(NET_USE_CMD);
        return string;
    }

    private BufferedReader getBufferedReader(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return bufferedReader;
    }

    public boolean isUnReachableError() {
        return this.unReachableError;
    }

    public void setUnReachableError(boolean bl) {
        this.unReachableError = bl;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public static Runtime getRt() {
        return rt;
    }

    public static void setRt(Runtime runtime) {
        rt = runtime;
    }
}

