/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.tde.core.JREEntry;
import com.unisys.tde.core.RegistryInterface;
import java.io.File;
import java.util.Hashtable;

public class JavaLevels {
    private static final String JREKey = "Software\\JavaSoft\\Java Runtime Environment";
    private static final String JREVal = "JavaHome";

    public static Hashtable<String, JREEntry> getJRELevels() {
        String[] stringArray = JavaLevels.getJavaVersions();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Hashtable<String, JREEntry> hashtable = new Hashtable<String, JREEntry>();
        int n = 0;
        while (n < stringArray.length) {
            if (!JavaLevels.isBaseLevel(stringArray[n])) {
                String string = JavaLevels.makeBaseLevel(stringArray[n]);
                String string2 = JavaLevels.getExtendedVersion(stringArray[n]);
                String string3 = "Software\\JavaSoft\\Java Runtime Environment\\" + stringArray[n];
                String string4 = RegistryInterface.getRegString(-2147483646, string3, JREVal);
                File file = new File(string4);
                if (file.exists()) {
                    JREEntry jREEntry;
                    if (hashtable.containsKey(string)) {
                        jREEntry = hashtable.get(string);
                        String string5 = jREEntry.getFullVersion();
                        if (string2.compareTo(string5) > 0) {
                            hashtable.remove(string);
                            jREEntry = new JREEntry(string, string2, string4);
                            hashtable.put(string, jREEntry);
                        }
                    } else {
                        jREEntry = new JREEntry(string, string2, string4);
                        hashtable.put(string, jREEntry);
                    }
                }
            }
            ++n;
        }
        return hashtable;
    }

    private static String[] getJavaVersions() {
        String[] stringArray = RegistryInterface.getSubKeys(JREKey);
        return stringArray;
    }

    private static boolean isBaseLevel(String string) {
        String[] stringArray = string.split("\\.");
        return stringArray.length == 2;
    }

    private static String makeBaseLevel(String string) {
        String string2 = null;
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 1) {
            string2 = String.valueOf(stringArray[0]) + "." + stringArray[1];
            return string2;
        }
        return "";
    }

    private static String getExtendedVersion(String string) {
        String string2 = null;
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 2) {
            string2 = stringArray[2];
        }
        return string2;
    }
}

