/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileCopy {
    private static File fromFile;
    private static File toFile;
    private static boolean flag;

    public static void copy(String string, String string2) throws IOException {
        OS2200CorePlugin.logger.debug((Object)"Inside Copy Method");
        fromFile = new File(string);
        toFile = new File(string2);
        flag = FileCopy.validateFile(fromFile, "Source");
        flag = FileCopy.validateFile(toFile, "Destination");
        if (flag) {
            FileCopy.copyFile();
        }
    }

    private static boolean validateFile(File file, String string) throws IOException {
        OS2200CorePlugin.logger.debug((Object)"Inside validate file method");
        if (string.equalsIgnoreCase("Source")) {
            if (!file.exists()) {
                throw new IOException(String.valueOf(Messages.getString((String)"FileCopy_FileCopy")) + string + Messages.getString((String)"FileCopy_file") + file + Messages.getString((String)"FileCopy_notFound"));
            }
            if (!file.isFile()) {
                throw new IOException(String.valueOf(Messages.getString((String)"FileCopy_FileCopy")) + string + Messages.getString((String)"FileCopy_file") + file + Messages.getString((String)"FileCopy_isdir"));
            }
            if (!file.canRead()) {
                throw new IOException(String.valueOf(Messages.getString((String)"FileCopy_FileCopy")) + string + Messages.getString((String)"FileCopy_file") + file + Messages.getString((String)"FileCopy_unreadable"));
            }
        }
        if (file.exists() && string.equalsIgnoreCase("Destination")) {
            if (!file.canWrite()) {
                throw new IOException(String.valueOf(Messages.getString((String)"FileCopy_FileCopy")) + string + Messages.getString((String)"FileCopy_file") + file + Messages.getString((String)"FileCopy_unwriteable"));
            }
            return MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"FileCopy_exists"), (String)(String.valueOf(Messages.getString((String)"FileCopy_overwrite")) + file));
        }
        return true;
    }

    private static void copyFile() throws IOException {
        OS2200CorePlugin.logger.debug((Object)"Inside copy file method");
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(fromFile);
            fileOutputStream = new FileOutputStream(toFile);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

