/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import java.util.ArrayList;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.photran.internal.core.preprocessor.c.FunctionStyleMacro;
import org.eclipse.photran.internal.core.preprocessor.c.ILexerLog;
import org.eclipse.photran.internal.core.preprocessor.c.Lexer;
import org.eclipse.photran.internal.core.preprocessor.c.ObjectStyleMacro;
import org.eclipse.photran.internal.core.preprocessor.c.OffsetLimitReachedException;
import org.eclipse.photran.internal.core.preprocessor.c.PreprocessorMacro;
import org.eclipse.photran.internal.core.preprocessor.c.Token;
import org.eclipse.photran.internal.core.preprocessor.c.TokenList;
import org.eclipse.photran.internal.core.preprocessor.c.TokenWithImage;

public class MacroDefinitionParser {
    private static final int ORIGIN_PREPROCESSOR_DIRECTIVE = 2;
    private int fHasVarArgs;
    private int fExpansionOffset;
    private int fExpansionEndOffset;
    private Token fNameToken;

    public static char[] getExpansion(char[] expansionImage, int offset, int endOffset) {
        TokenList tl = new TokenList();
        Lexer lex = new Lexer(expansionImage, offset, endOffset, new Lexer.LexerOptions(), ILexerLog.NULL, null);
        try {
            lex.nextToken();
            new MacroDefinitionParser().parseExpansion(lex, ILexerLog.NULL, null, new char[0][], tl);
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {}
        StringBuffer buf = new StringBuffer();
        Token t = tl.first();
        if (t == null) {
            return CharArrayUtils.EMPTY;
        }
        endOffset = t.getOffset();
        while (t != null) {
            if (endOffset < t.getOffset()) {
                buf.append(' ');
            }
            buf.append(t.getCharImage());
            endOffset = t.getEndOffset();
            t = (Token)t.getNext();
        }
        int length = buf.length();
        char[] expansion = new char[length];
        buf.getChars(0, length, expansion, 0);
        return expansion;
    }

    MacroDefinitionParser() {
    }

    public Token getNameToken() {
        return this.fNameToken;
    }

    public ObjectStyleMacro parseMacroDefinition(Lexer lexer, ILexerLog log) throws OffsetLimitReachedException, InvalidMacroDefinitionException {
        Token name = this.parseName(lexer);
        char[] source = lexer.getInput();
        char[] nameChars = name.getCharImage();
        char[][] paramList = this.parseParamList(lexer, name);
        TokenList replacement = new TokenList();
        this.parseExpansion(lexer, log, nameChars, paramList, replacement);
        if (paramList == null) {
            return new ObjectStyleMacro(nameChars, this.fExpansionOffset, this.fExpansionEndOffset, replacement, source);
        }
        return new FunctionStyleMacro(nameChars, paramList, this.fHasVarArgs, this.fExpansionOffset, this.fExpansionEndOffset, replacement, source);
    }

    public PreprocessorMacro parseMacroDefinition(Lexer lexer, ILexerLog log, char[] replacement) throws InvalidMacroDefinitionException, OffsetLimitReachedException {
        Token name = this.parseName(lexer);
        char[] nameChars = name.getCharImage();
        char[][] paramList = this.parseParamList(lexer, name);
        Token replacementToken = lexer.currentToken();
        if (replacementToken.getType() != 144) {
            throw new InvalidMacroDefinitionException(nameChars, replacementToken.getOffset(), replacementToken.getEndOffset());
        }
        if (paramList == null) {
            return new ObjectStyleMacro(nameChars, replacement);
        }
        return new FunctionStyleMacro(nameChars, paramList, this.fHasVarArgs, replacement);
    }

    public static PreprocessorMacro parseMacroDefinition(char[] name, char[][] paramList, char[] replacement) {
        int length;
        int hasVarargs = 0;
        if (paramList != null && (length = ((char[][])paramList).length) > 0) {
            char[] lastParam = paramList[length - 1];
            int lpl = lastParam.length;
            switch (lpl) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    if (!CharArrayUtils.equals((char[])lastParam, (char[])Keywords.cpELLIPSIS)) break;
                    hasVarargs = 1;
                    char[][] copy = new char[length][];
                    System.arraycopy(paramList, 0, copy, 0, length - 1);
                    copy[length - 1] = Keywords.cVA_ARGS;
                    paramList = copy;
                    break;
                }
                default: {
                    if (!CharArrayUtils.equals((char[])lastParam, (int)(lpl - 3), (int)3, (char[])Keywords.cpELLIPSIS)) break;
                    hasVarargs = 2;
                    char[][] copy = new char[length][];
                    System.arraycopy(paramList, 0, copy, 0, length - 1);
                    copy[length - 1] = CharArrayUtils.subarray((char[])lastParam, (int)0, (int)(lpl - 3));
                    paramList = copy;
                }
            }
        }
        if (paramList == null) {
            return new ObjectStyleMacro(name, replacement);
        }
        return new FunctionStyleMacro(name, (char[][])paramList, hasVarargs, replacement);
    }

    private Token parseName(Lexer lexer) throws OffsetLimitReachedException, InvalidMacroDefinitionException {
        Token name = lexer.nextToken();
        int tt = name.getType();
        if (tt != 1) {
            if (tt == 140) {
                throw new OffsetLimitReachedException(2, name);
            }
            throw new InvalidMacroDefinitionException(name.getCharImage(), name.getOffset(), name.getEndOffset());
        }
        this.fNameToken = name;
        return name;
    }

    private char[][] parseParamList(Lexer lex, Token name) throws OffsetLimitReachedException, InvalidMacroDefinitionException {
        Token lparen = lex.nextToken();
        this.fHasVarArgs = 0;
        if (lparen.getType() != 8 || name.getEndOffset() != lparen.getOffset()) {
            return null;
        }
        ArrayList<char[]> paramList = new ArrayList<char[]>();
        Token next = null;
        block6: do {
            Token param = lex.nextToken();
            switch (param.getType()) {
                case 140: {
                    throw new OffsetLimitReachedException(2, param);
                }
                case 1: {
                    paramList.add(param.getCharImage());
                    next = lex.nextToken();
                    if (next.getType() != 48) continue block6;
                    this.fHasVarArgs = 2;
                    next = lex.nextToken();
                    break;
                }
                case 48: {
                    this.fHasVarArgs = 1;
                    paramList.add(Keywords.cVA_ARGS);
                    next = lex.nextToken();
                    break;
                }
                case 9: {
                    if (next == null) {
                        next = param;
                        break;
                    }
                    throw new InvalidMacroDefinitionException(name.getCharImage(), name.getOffset(), param.getEndOffset());
                }
                default: {
                    throw new InvalidMacroDefinitionException(name.getCharImage(), name.getOffset(), param.getEndOffset());
                }
            }
        } while (this.fHasVarArgs == 0 && next.getType() == 6);
        if (next.getType() != 9) {
            throw new InvalidMacroDefinitionException(name.getCharImage(), name.getOffset(), next.getEndOffset());
        }
        next = lex.nextToken();
        return (char[][])paramList.toArray((T[])new char[paramList.size()][]);
    }

    public void parseExpansion(Lexer lexer, ILexerLog log, char[] name, char[][] paramList, TokenList result) throws OffsetLimitReachedException {
        boolean needParam = false;
        boolean isFirst = true;
        Token needAnotherToken = null;
        Token candidate = lexer.currentToken();
        this.fExpansionOffset = this.fExpansionEndOffset = candidate.getOffset();
        block7: while (true) {
            switch (candidate.getType()) {
                case 140: {
                    throw new OffsetLimitReachedException(2, candidate);
                }
                case -99: 
                case 144: {
                    break block7;
                }
                case 1: {
                    if (paramList != null) {
                        char[] image = candidate.getCharImage();
                        int idx = CharArrayUtils.indexOf((char[])image, (char[][])paramList);
                        if (idx >= 0) {
                            candidate = new TokenParameterReference(-195, idx, lexer.getSource(), candidate.getOffset(), candidate.getEndOffset(), paramList[idx], candidate.getCharPrecedingWhiteSpace());
                            needParam = false;
                        } else {
                            if (needParam) {
                                log.handleProblem(0x200000A, name, this.fExpansionOffset, candidate.getEndOffset());
                            } else if (CharArrayUtils.equals((char[])Keywords.cVA_ARGS, (char[])image)) {
                                log.handleProblem(0x200000D, null, this.fExpansionOffset, candidate.getEndOffset());
                            }
                            needParam = false;
                        }
                    }
                    needAnotherToken = null;
                    break;
                }
                case 138: {
                    needParam = paramList != null;
                    needAnotherToken = null;
                    break;
                }
                case 139: {
                    if (needParam || isFirst) {
                        log.handleProblem(0x200000A, name, this.fExpansionOffset, candidate.getEndOffset());
                    }
                    needAnotherToken = candidate;
                    needParam = false;
                    break;
                }
                default: {
                    if (needParam) {
                        log.handleProblem(0x200000A, name, this.fExpansionOffset, candidate.getEndOffset());
                        needParam = false;
                    }
                    needAnotherToken = null;
                }
            }
            isFirst = false;
            this.fExpansionEndOffset = candidate.getEndOffset();
            result.append(candidate);
            candidate = lexer.nextToken();
        }
        if (needAnotherToken != null) {
            log.handleProblem(0x200000A, name, needAnotherToken.getOffset(), needAnotherToken.getEndOffset());
        }
    }

    static class InvalidMacroDefinitionException
    extends Exception {
        public char[] fName;
        public int fStartOffset;
        public int fEndOffset;

        public InvalidMacroDefinitionException(char[] name, int startOffset, int endOffset) {
            this.fName = name;
            this.fStartOffset = startOffset;
            this.fEndOffset = endOffset;
        }
    }

    static class TokenParameterReference
    extends TokenWithImage {
        private final int fIndex;

        public TokenParameterReference(int type, int idx, Object source, int offset, int endOffset, char[] name, char[] precedingWhiteSpace) {
            super(type, source, offset, endOffset, name, precedingWhiteSpace);
            this.fIndex = idx;
        }

        public int getIndex() {
            return this.fIndex;
        }

        @Override
        public String toString() {
            return "[" + this.fIndex + "]";
        }
    }
}

