/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.awtui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.io.Serializable;
import org.eclipse.jgit.awtui.CommitGraphPane;
import org.eclipse.jgit.awtui.SwingCommitList;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.AbstractPlotRenderer;
import org.eclipse.jgit.revplot.PlotCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AWTPlotRenderer
extends AbstractPlotRenderer<SwingCommitList.SwingLane, Color>
implements Serializable {
    private static final long serialVersionUID = 1L;
    final CommitGraphPane.GraphCellRender cell;
    transient Graphics2D g;

    AWTPlotRenderer(CommitGraphPane.GraphCellRender c) {
        this.cell = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics in, PlotCommit<SwingCommitList.SwingLane> commit) {
        this.g = (Graphics2D)in.create();
        try {
            int h = this.cell.getHeight();
            this.g.setColor(this.cell.getBackground());
            this.g.fillRect(0, 0, this.cell.getWidth(), h);
            if (commit != null) {
                this.paintCommit(commit, h);
            }
        }
        finally {
            this.g.dispose();
            this.g = null;
        }
    }

    protected void drawLine(Color color, int x1, int y1, int x2, int y2, int width) {
        if (y1 == y2) {
            x1 -= width / 2;
            x2 -= width / 2;
        } else if (x1 == x2) {
            y1 -= width / 2;
            y2 -= width / 2;
        }
        this.g.setColor(color);
        this.g.setStroke(CommitGraphPane.stroke(width));
        this.g.drawLine(x1, y1, x2, y2);
    }

    protected void drawCommitDot(int x, int y, int w, int h) {
        this.g.setColor(Color.blue);
        this.g.setStroke(CommitGraphPane.strokeCache[1]);
        this.g.fillOval(x, y, w, h);
        this.g.setColor(Color.black);
        this.g.drawOval(x, y, w, h);
    }

    protected void drawBoundaryDot(int x, int y, int w, int h) {
        this.g.setColor(this.cell.getBackground());
        this.g.setStroke(CommitGraphPane.strokeCache[1]);
        this.g.fillOval(x, y, w, h);
        this.g.setColor(Color.black);
        this.g.drawOval(x, y, w, h);
    }

    protected void drawText(String msg, int x, int y) {
        int texth = this.g.getFontMetrics().getHeight();
        int y0 = (y - texth) / 2 + (this.cell.getHeight() - texth) / 2;
        this.g.setColor(this.cell.getForeground());
        this.g.drawString(msg, x, y0 + texth - this.g.getFontMetrics().getDescent());
    }

    protected Color laneColor(SwingCommitList.SwingLane myLane) {
        return myLane != null ? myLane.color : Color.black;
    }

    void paintTriangleDown(int cx, int y, int h) {
        int tipX = cx;
        int tipY = y + h;
        int baseX1 = cx - 5;
        int baseX2 = tipX + 5;
        int baseY = y;
        Polygon triangle = new Polygon();
        triangle.addPoint(tipX, tipY);
        triangle.addPoint(baseX1, baseY);
        triangle.addPoint(baseX2, baseY);
        this.g.fillPolygon(triangle);
        this.g.drawPolygon(triangle);
    }

    protected int drawLabel(int x, int y, Ref ref) {
        String txt;
        String name = ref.getName();
        if (name.startsWith("refs/heads/")) {
            this.g.setBackground(Color.GREEN);
            txt = name.substring("refs/heads/".length());
        } else if (name.startsWith("refs/remotes/")) {
            this.g.setBackground(Color.LIGHT_GRAY);
            txt = name.substring("refs/remotes/".length());
        } else if (name.startsWith("refs/tags/")) {
            this.g.setBackground(Color.YELLOW);
            txt = name.substring("refs/tags/".length());
        } else {
            this.g.setBackground(Color.WHITE);
            txt = name.startsWith("refs/") ? name.substring("refs/".length()) : name;
        }
        if (ref.getPeeledObjectId() != null) {
            float[] colorComponents = this.g.getBackground().getRGBColorComponents(null);
            colorComponents[0] = (float)((double)colorComponents[0] * 0.9);
            colorComponents[1] = (float)((double)colorComponents[1] * 0.9);
            colorComponents[2] = (float)((double)colorComponents[2] * 0.9);
            this.g.setBackground(new Color(colorComponents[0], colorComponents[1], colorComponents[2]));
        }
        if (txt.length() > 12) {
            txt = txt.substring(0, 11) + "\u2026";
        }
        int texth = this.g.getFontMetrics().getHeight();
        int textw = this.g.getFontMetrics().stringWidth(txt);
        this.g.setColor(this.g.getBackground());
        int arcHeight = texth / 4;
        int y0 = y - texth / 2 + (this.cell.getHeight() - texth) / 2;
        this.g.fillRoundRect(x, y0, textw + arcHeight * 2, texth - 1, arcHeight, arcHeight);
        this.g.setColor(this.g.getColor().darker());
        this.g.drawRoundRect(x, y0, textw + arcHeight * 2, texth - 1, arcHeight, arcHeight);
        this.g.setColor(Color.BLACK);
        this.g.drawString(txt, x + arcHeight, y0 + texth - this.g.getFontMetrics().getDescent());
        return arcHeight * 3 + textw;
    }
}

