/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class COBOLCVSReferenceProvider
implements IQuickDiffReferenceProvider {
    private ITextEditor fEditor = null;
    private IDocument fReference = null;
    private boolean fReferenceInitialized = false;
    private IDocumentProvider fDocumentProvider = null;
    private String fId;
    private SyncInfo fLastSyncState;
    private Job fUpdateJob;
    private boolean DEBUG = false;
    private ISubscriberChangeListener teamChangeListener = new ISubscriberChangeListener(){

        public void subscriberResourceChanged(ISubscriberChangeEvent[] iSubscriberChangeEventArray) {
            if (COBOLCVSReferenceProvider.this.fReferenceInitialized) {
                int n = 0;
                while (n < iSubscriberChangeEventArray.length) {
                    ISubscriberChangeEvent iSubscriberChangeEvent = iSubscriberChangeEventArray[n];
                    IResource iResource = iSubscriberChangeEvent.getResource();
                    if (iResource.getType() == 1 && COBOLCVSReferenceProvider.this.fLastSyncState != null && iResource.equals((Object)COBOLCVSReferenceProvider.this.fLastSyncState.getLocal()) && iSubscriberChangeEvent.getFlags() == 1) {
                        COBOLCVSReferenceProvider.this.fetchContentsInJob();
                    }
                    ++n;
                }
            }
        }
    };
    private IElementStateListener documentListener = new IElementStateListener(){

        public void elementDirtyStateChanged(Object object, boolean bl) {
        }

        public void elementContentAboutToBeReplaced(Object object) {
        }

        public void elementContentReplaced(Object object) {
            if (COBOLCVSReferenceProvider.this.fEditor != null && COBOLCVSReferenceProvider.this.fEditor.getEditorInput() == object) {
                COBOLCVSReferenceProvider.this.fetchContentsInJob();
            }
        }

        public void elementDeleted(Object object) {
        }

        public void elementMoved(Object object, Object object2) {
        }
    };

    public IDocument getReference(IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.fReferenceInitialized) {
            return null;
        }
        if (this.fReference == null) {
            this.readDocument(iProgressMonitor);
        }
        return this.fReference;
    }

    public void setActiveEditor(ITextEditor iTextEditor) {
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (iEditorInput == null || ResourceUtil.getFile((IEditorInput)iEditorInput) == null) {
            return;
        }
        this.fEditor = iTextEditor;
        this.fDocumentProvider = this.fEditor.getDocumentProvider();
        if (this.fDocumentProvider != null) {
            CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().addListener(this.teamChangeListener);
            this.fDocumentProvider.addElementStateListener(this.documentListener);
        }
        this.fReferenceInitialized = true;
    }

    public boolean isEnabled() {
        if (!this.fReferenceInitialized) {
            return false;
        }
        try {
            return this.getManagedCVSFile() != null;
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    public void dispose() {
        this.fReferenceInitialized = false;
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.removeElementStateListener(this.documentListener);
        }
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().removeListener(this.teamChangeListener);
    }

    public void setId(String string) {
        this.fId = string;
    }

    public String getId() {
        return this.fId;
    }

    private boolean computeChange(IProgressMonitor iProgressMonitor) throws TeamException {
        boolean bl = false;
        if (this.fReferenceInitialized) {
            SyncInfo syncInfo = this.getSyncState((IResource)this.getFileFromEditor());
            if (syncInfo == null && this.fLastSyncState != null) {
                return true;
            }
            if (syncInfo == null) {
                return false;
            }
            if (this.fLastSyncState == null) {
                bl = true;
            } else if (!this.fLastSyncState.equals((Object)syncInfo)) {
                bl = true;
            }
            if (this.DEBUG) {
                this.debug(this.fLastSyncState, syncInfo);
            }
            this.fLastSyncState = syncInfo;
        }
        return bl;
    }

    private void debug(SyncInfo syncInfo, SyncInfo syncInfo2) {
        String string = "[none]";
        if (syncInfo != null) {
            string = syncInfo.toString();
        }
        System.out.println("+ CVSQuickDiff: was " + string + " is " + syncInfo2.toString());
    }

    private SyncInfo getSyncState(IResource iResource) throws TeamException {
        if (iResource == null) {
            return null;
        }
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getSyncInfo(iResource);
    }

    private void readDocument(IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.fReferenceInitialized) {
            return;
        }
        if (this.fReference == null) {
            this.fReference = new Document();
        }
        if (this.computeChange(iProgressMonitor)) {
            ICVSRemoteFile iCVSRemoteFile = (ICVSRemoteFile)this.fLastSyncState.getRemote();
            if (this.fLastSyncState.getRemote() != null && this.fDocumentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider iStorageDocumentProvider = (IStorageDocumentProvider)this.fDocumentProvider;
                String string = iStorageDocumentProvider.getEncoding((Object)this.fEditor.getEditorInput());
                if (string == null) {
                    string = iStorageDocumentProvider.getDefaultEncoding();
                }
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                InputStream inputStream = iCVSRemoteFile.getContents(iProgressMonitor);
                if (inputStream == null || iProgressMonitor.isCanceled() || !this.fReferenceInitialized) {
                    return;
                }
                this.setDocumentContent(this.fReference, inputStream, string);
            } else {
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                this.fReference.set("");
            }
            if (this.DEBUG) {
                System.out.println("+ CVSQuickDiff: updating document " + (this.fReference != null ? "remote found" : "remote empty"));
            }
        }
    }

    private void setDocumentContent(IDocument iDocument, InputStream inputStream, String string) throws CoreException {
        BufferedReader bufferedReader = null;
        try {
            try {
                Object object;
                String string2 = "";
                try {
                    if (this.fEditor instanceof COBOLEditor) {
                        object = CBDTUiPlugin.getDefault().getPreferenceStore();
                        string2 = object.getString("Reference Format");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    CBDTUiPlugin.logError(nullPointerException);
                }
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string), 15360);
                object = new CharArrayWriter(15360);
                if (string2.equals("VARIABLE") || string2.equals("FIXED")) {
                    String string3 = System.getProperties().getProperty("line.separator");
                    String string4 = bufferedReader.readLine();
                    String string5 = bufferedReader.readLine();
                    while (string4 != null) {
                        if (string4.length() > 6) {
                            ((Writer)object).write(string4.substring(6, string4.length()));
                        }
                        if (string5 != null && string5.length() > 0 && string5.charAt(0) != '\u001a') {
                            ((Writer)object).write(string3);
                        }
                        string4 = string5;
                        string5 = bufferedReader.readLine();
                    }
                } else {
                    char[] cArray = new char[2048];
                    int n = bufferedReader.read(cArray);
                    while (n > 0) {
                        ((CharArrayWriter)object).write(cArray, 0, n);
                        n = bufferedReader.read(cArray);
                    }
                }
                iDocument.set(((CharArrayWriter)object).toString());
            }
            catch (IOException iOException) {
                throw CVSException.wrapException(null, (String)CVSUIMessages.RemoteRevisionQuickDiffProvider_readingFile, (IOException)iOException);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw CVSException.wrapException(null, (String)CVSUIMessages.RemoteRevisionQuickDiffProvider_closingFile, (IOException)iOException);
                }
            }
        }
    }

    private ICVSFile getManagedCVSFile() throws CVSException {
        IFile iFile;
        if (this.fEditor != null && (iFile = this.getFileFromEditor()) != null && CVSWorkspaceRoot.isSharedWithCVS((IResource)iFile)) {
            return CVSWorkspaceRoot.getCVSFileFor((IFile)iFile);
        }
        return null;
    }

    private IFile getFileFromEditor() {
        IEditorInput iEditorInput;
        if (this.fEditor != null && (iEditorInput = this.fEditor.getEditorInput()) != null) {
            IFile iFile = ResourceUtil.getFile((IEditorInput)iEditorInput);
            return iFile;
        }
        return null;
    }

    private void fetchContentsInJob() {
        if (!this.fReferenceInitialized) {
            return;
        }
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new Job(CVSUIMessages.RemoteRevisionQuickDiffProvider_fetchingFile){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    COBOLCVSReferenceProvider.this.readDocument(iProgressMonitor);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        this.fUpdateJob.schedule();
    }
}

