/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.wizards.projectmanagement;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.cobol.core.util.ValidationManager;
import org.eclipse.cobol.ui.views.structures.CreateControls;
import org.eclipse.cobol.ui.wizards.projectmanagement.NewProjectCreationPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class ProjectCreationTargetPage
extends WizardNewProjectCreationPage {
    private Text fTextTargetFileName = null;
    private Text fTextTargetName = null;
    private Group fExeLibGroup;
    private Button fExeButton;
    private Button fLibButton;
    private Group fDebugReleaseGroup;
    private Button fReleaseButton;
    private Button fDebugButton;
    private ModifyListener fModifyAdapter;
    private Composite fComposite;
    private ResourceBundle fBundle = null;
    private static final String EXE_EXTENSION = ".exe";
    private static final String DLL_EXTENSION = ".dll";
    private static final String LIB_PREFIX = "lib";
    private static final String SO_EXTENSION = ".so";
    private boolean changeTargetName = true;

    public ProjectCreationTargetPage(String string) {
        super(string);
        this.setTitle(Messages.getString((String)"COBOL_PAGE_TITLE"));
        this.setDescription(Messages.getString((String)"TARGET_PAGE_DESCRIPTION"));
        this.fBundle = Messages.getResourceBundle();
        this.fModifyAdapter = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProjectCreationTargetPage.this.setPageComplete(ProjectCreationTargetPage.this.validatePage());
                if (ProjectCreationTargetPage.this.fExeButton.getSelection()) {
                    ProjectCreationTargetPage.this.setTargetFileName(ProjectCreationTargetPage.this.fTextTargetName.getText(), true);
                } else {
                    ProjectCreationTargetPage.this.setTargetFileName(ProjectCreationTargetPage.this.fTextTargetName.getText(), false);
                }
            }
        };
    }

    public void createControl(Composite composite) {
        CreateControls createControls = new CreateControls();
        Composite composite2 = createControls.createComposite(composite, 2);
        GridData gridData = new GridData(768);
        createControls.createLabel(composite2, Messages.getString((String)"TargetName"));
        this.fTextTargetName = createControls.createTextField(composite2);
        gridData = new GridData(768);
        createControls.createLabel(composite2, Messages.getString((String)"TargetFileName"));
        this.fTextTargetFileName = createControls.createTextField(composite2);
        this.fTextTargetFileName.setEnabled(false);
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        GridData gridData2 = new GridData(256);
        gridData2.heightHint = ((GridLayout)composite2.getLayout()).verticalSpacing;
        gridData2.horizontalSpan = 2;
        label.setLayoutData((Object)gridData2);
        this.fExeLibGroup = new Group(composite2, 0);
        this.fExeLibGroup.setFont(composite2.getFont());
        this.fExeLibGroup.setText(Messages.getString((String)"TargetType"));
        GridLayout gridLayout = new GridLayout();
        this.fExeLibGroup.setLayout((Layout)gridLayout);
        gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.fExeLibGroup.setLayoutData((Object)gridData2);
        gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        this.fComposite = composite2;
        GridData gridData3 = new GridData(3);
        this.fExeButton = createControls.createRadioButton((Composite)this.fExeLibGroup, this.fBundle.getString("exe.label"));
        this.fExeButton.setLayoutData((Object)gridData3);
        this.fExeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProjectCreationTargetPage.this.setTargetFileName(ProjectCreationTargetPage.this.getTargetFileName(), true);
            }
        });
        gridData3 = new GridData(3);
        String string = this.fBundle.getString("windows.lib.label");
        String string2 = Platform.getOS();
        string = string2.equalsIgnoreCase("win32") ? this.fBundle.getString("windows.lib.label") : this.fBundle.getString("lib.label");
        this.fLibButton = createControls.createRadioButton((Composite)this.fExeLibGroup, string);
        this.fLibButton.setLayoutData((Object)gridData3);
        this.fLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProjectCreationTargetPage.this.setTargetFileName(ProjectCreationTargetPage.this.getTargetFileName(), false);
            }
        });
        this.fExeButton.setSelection(true);
        label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        gridData2 = new GridData(256);
        gridData2.heightHint = ((GridLayout)composite2.getLayout()).verticalSpacing;
        gridData2.horizontalSpan = 2;
        label.setLayoutData((Object)gridData2);
        this.fDebugReleaseGroup = new Group(composite2, 0);
        this.fDebugReleaseGroup.setFont(composite2.getFont());
        this.fDebugReleaseGroup.setText(this.fBundle.getString("Build.label"));
        gridLayout = new GridLayout();
        this.fDebugReleaseGroup.setLayout((Layout)gridLayout);
        gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.fDebugReleaseGroup.setLayoutData((Object)gridData2);
        this.fReleaseButton = new Button((Composite)this.fDebugReleaseGroup, 16);
        this.fReleaseButton.setFont(this.fDebugReleaseGroup.getFont());
        this.fReleaseButton.setText(this.fBundle.getString("Release"));
        this.fDebugButton = new Button((Composite)this.fDebugReleaseGroup, 16);
        this.fDebugButton.setFont(this.fDebugReleaseGroup.getFont());
        this.fDebugButton.setText(this.fBundle.getString("Debug"));
        this.fReleaseButton.setSelection(true);
        this.fTextTargetName.addModifyListener(this.fModifyAdapter);
        this.fTextTargetName.setFocus();
        this.setControl((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cobol.ui.target_type");
    }

    public void setVisible(boolean bl) {
        this.fComposite.setVisible(bl);
        this.fTextTargetName.setFocus();
        NewProjectCreationPage newProjectCreationPage = (NewProjectCreationPage)this.getPreviousPage();
        String string = newProjectCreationPage.getProjectHandle().getName();
        if (bl) {
            if (this.changeTargetName) {
                this.fTextTargetName.setText(string);
                if (Platform.getOS().equalsIgnoreCase("win32")) {
                    this.fTextTargetFileName.setText(String.valueOf(newProjectCreationPage.getProjectHandle().getName()) + EXE_EXTENSION);
                } else {
                    this.fTextTargetFileName.setText(newProjectCreationPage.getProjectHandle().getName());
                }
            }
        } else {
            this.changeTargetName = this.fTextTargetName.getText().equalsIgnoreCase(string);
        }
    }

    public String getTargetFileName() {
        return this.fTextTargetName.getText();
    }

    public void setTargetFileName(String string, boolean bl) {
        if (string != null) {
            if (Platform.getOS().equalsIgnoreCase("win32")) {
                if (bl) {
                    this.fTextTargetFileName.setText(String.valueOf(string) + EXE_EXTENSION);
                } else {
                    this.fTextTargetFileName.setText(String.valueOf(string) + DLL_EXTENSION);
                }
            } else if (bl) {
                this.fTextTargetFileName.setText(string);
            } else {
                this.fTextTargetFileName.setText(LIB_PREFIX + string + SO_EXTENSION);
            }
        }
    }

    public boolean getExeButton() {
        return this.fExeButton.getSelection();
    }

    public boolean getLibButton() {
        return this.fLibButton.getSelection();
    }

    public boolean getReleaseButton() {
        return this.fReleaseButton.getSelection();
    }

    public boolean getDebugButton() {
        return this.fDebugButton.getSelection();
    }

    protected boolean validatePage() {
        String string = this.fTextTargetName.getText();
        String string2 = new String();
        IStatus iStatus = ValidationManager.validateTargetFileName((String)string, (String)"targetname");
        if (!iStatus.isOK()) {
            this.fTextTargetName.setFocus();
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        if (iStatus.isOK()) {
            NewProjectCreationPage newProjectCreationPage = (NewProjectCreationPage)this.getPreviousPage();
            IPath iPath = newProjectCreationPage.getLocationPath().append(File.separator).append(string2);
            String string3 = iPath.toOSString();
            if (string3.length() > 251) {
                String string4 = Messages.getString((String)"TargetNameFullPathLength.error");
                this.fTextTargetName.setFocus();
                this.setErrorMessage(string4);
                return false;
            }
            if (string.length() > 150) {
                String string5 = Messages.getString((String)"TargetNameLength.error");
                this.fTextTargetName.setFocus();
                this.setErrorMessage(string5);
                return false;
            }
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

