/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.wizards.projectmanagement;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.registry.internal.ICOBOLContributorDescriptor;
import org.eclipse.cobol.core.registry.internal.ICOBOLContributorRegistry;
import org.eclipse.cobol.core.ui.wizards.common.ElementList;
import org.eclipse.cobol.core.ui.wizards.common.IProjectInfo;
import org.eclipse.cobol.core.ui.wizards.common.ProjectCodeGeneratorsPage;
import org.eclipse.cobol.core.ui.wizards.common.WizardElement;
import org.eclipse.cobol.core.util.CoreCommonUtility;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.build.DependencyModelManipulation;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.dependency.DependencyView;
import org.eclipse.cobol.ui.views.structures.RepositoryData;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.cobol.ui.wizards.projectmanagement.NewProjectCreationPage;
import org.eclipse.cobol.ui.wizards.projectmanagement.ProjectCreationTargetPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ProjectCreationNewWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IConfigurationElement fConfigElement;
    private int state = 0;
    protected ProjectCodeGeneratorsPage fCodegenPage;
    private IStructuredSelection fSelection;
    private IWorkbench fWorkbench;
    private NewProjectCreationPage fMainPage;
    private IProject fProject;
    private String fProjectName = "";
    private QualifiedName TARGET_NAME = new QualifiedName("org.eclipse.cobol.ui.common", "TargetName");
    private String fStrPathAndName = "";
    private Runnable fRunnable = null;
    private static final int LINUX_FILE_NAME_LENGTH = 254;
    private static final int WINDOWS_FILE_NAME_LENGTH = 249;
    private String fTitle = "";
    private IProjectInfo provider = null;
    private IProject fProjectHandle = null;
    private IPath fProjectLocation = null;
    private String fDescription = "";
    private final String CATEGORY = Messages.getString((String)"CATEGORY");
    private ProjectCreationTargetPage fTargetPage;
    private QualifiedName EXE_LIB_MODE = new QualifiedName("org.eclipse.cobol.ui.common", "ITargetType");
    private QualifiedName RELEASE_DEBUG_MODE = new QualifiedName("org.eclipse.cobol.ui.common", "BuildMode");
    private ElementList fElementList;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fWorkbench = iWorkbench;
        this.fSelection = iStructuredSelection;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString((String)"WindowTitleNew"));
    }

    public ProjectCreationNewWizard() {
        this.setDefaultPageImageDescriptor(COBOLPluginImages.DESC_IMG_NEW_PROJECT);
    }

    public ProjectCreationNewWizard(String string, String string2, ImageDescriptor imageDescriptor) {
        this.setDefaultPageImageDescriptor(imageDescriptor);
        this.fTitle = string;
        this.fDescription = string2;
    }

    public ProjectCreationNewWizard(String string, String string2, ImageDescriptor imageDescriptor, String string3) {
        this.setDefaultPageImageDescriptor(imageDescriptor);
        this.fTitle = string;
        this.fDescription = string2;
        CoreCommonUtility.setProjectId((String)string3);
    }

    public void addPages() {
        super.addPages();
        this.fMainPage = new NewProjectCreationPage(this.fWorkbench, this.fSelection);
        this.fTargetPage = new ProjectCreationTargetPage("");
        if (!this.fTitle.equals("")) {
            this.fMainPage.setTitle(this.fTitle);
            this.fTargetPage.setTitle(this.fTitle);
        }
        if (!this.fDescription.equals("")) {
            this.fMainPage.setDescription(this.fDescription);
            this.fTargetPage.setDescription(this.fDescription);
        }
        this.addPage((IWizardPage)this.fMainPage);
        this.addPage((IWizardPage)this.fTargetPage);
        this.provider = new IProjectInfo(){

            public String getProjectName() {
                return ProjectCreationNewWizard.this.getProjectNames();
            }

            public IProject getProject() {
                return ProjectCreationNewWizard.this.fProjectHandle;
            }

            public IPath getLocationPath() {
                return ProjectCreationNewWizard.this.fProjectLocation;
            }

            public String getCategory() {
                return ProjectCreationNewWizard.this.fConfigElement.getAttribute(ProjectCreationNewWizard.this.CATEGORY);
            }

            public IWorkbench getCurrentWorkbench() {
                return ProjectCreationNewWizard.this.fWorkbench;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public boolean performFinish() {
        block46: {
            block47: {
                block44: {
                    block45: {
                        block42: {
                            block43: {
                                block40: {
                                    block41: {
                                        var1_1 = ResourcesPlugin.getWorkspace().getDescription();
                                        var2_2 = var1_1.isAutoBuilding();
                                        this.fProject = this.getProjects();
                                        this.fProjectLocation = this.getLocationPaths();
                                        this.state = 0;
                                        if (var2_2) {
                                            var1_1.setAutoBuilding(false);
                                            try {
                                                ResourcesPlugin.getWorkspace().setDescription(var1_1);
                                            }
                                            catch (CoreException var3_3) {
                                                CBDTUiPlugin.logError("Could not save the new description to disk ", (Exception)var3_3);
                                            }
                                        }
                                        this.fProject = this.createNewProject();
                                        if (this.fProject != null) break block40;
                                        if (!var2_2) break block41;
                                        var1_1.setAutoBuilding(true);
                                        try {
                                            ResourcesPlugin.getWorkspace().setDescription(var1_1);
                                        }
                                        catch (CoreException var9_6) {
                                            CBDTUiPlugin.logError((Exception)var9_6);
                                        }
                                    }
                                    return false;
                                }
                                if (this.setApplicationTargetType()) break block42;
                                if (!var2_2) break block43;
                                var1_1.setAutoBuilding(true);
                                try {
                                    ResourcesPlugin.getWorkspace().setDescription(var1_1);
                                }
                                catch (CoreException var9_7) {
                                    CBDTUiPlugin.logError((Exception)var9_7);
                                }
                            }
                            return false;
                        }
                        if (this.attachNatureToProject()) break block44;
                        if (!var2_2) break block45;
                        var1_1.setAutoBuilding(true);
                        try {
                            ResourcesPlugin.getWorkspace().setDescription(var1_1);
                        }
                        catch (CoreException var9_8) {
                            CBDTUiPlugin.logError((Exception)var9_8);
                        }
                    }
                    return false;
                }
                if (this.state == 0) break block46;
                if (!var2_2) break block47;
                var1_1.setAutoBuilding(true);
                try {
                    ResourcesPlugin.getWorkspace().setDescription(var1_1);
                }
                catch (CoreException var9_9) {
                    CBDTUiPlugin.logError((Exception)var9_9);
                }
            }
            return false;
        }
        try {
            try {
                CBDTUiPlugin.getWorkspace().getRoot().refreshLocal(0, null);
                var3_4 = CBDTUiPlugin.getActivePage();
                var4_13 = null;
                if (var3_4 != null) {
                    var4_13 = var3_4.findView("org.eclipse.cobol.ui.views.dependency.DependencyView");
                }
                if (var4_13 != null) {
                    try {
                        var5_14 = (DependencyView)var4_13;
                        if (this.fProject.getLocation() == null) {
                            if (this.fStrPathAndName != null && !this.fStrPathAndName.equals("")) {
                                var5_14.addProject(this.fStrPathAndName, this.fProject.getName());
                            }
                        } else if (this.fProject.getLocation() != null) {
                            var6_17 = this.fProject.getLocation().toOSString();
                            var5_14.addProject((String)var6_17, this.fProject.getName());
                        }
                    }
                    catch (NullPointerException var5_15) {
                        CBDTUiPlugin.logError(var5_15);
                    }
                    catch (Exception var5_16) {
                        CBDTUiPlugin.logError(var5_16);
                    }
                } else if (this.fProject.getLocation() != null) {
                    var5_14 = ViewsTreeModel.getInstance().getRoot();
                    var6_17 = this.fProject.getLocation().toOSString();
                    var7_18 = var5_14.addChild((String)var6_17, this.fProject.getName(), IViewConstants.PROJECT_NAME, false);
                    var7_18.addChild(IViewConstants.SOURCE_FOLDER_VALUE, "SOURCE_FOLDER", "SOURCE_FOLDER", false);
                    var7_18.addChild(IViewConstants.LINKING_FILES_FOLDER_VALUE, IViewConstants.LINKING_FILES_FOLDER_NAME, IViewConstants.LINKING_FILES_FOLDER_NAME, false);
                    var7_18.addChild(IViewConstants.OTHER_FILES_FOLDER_VALUE, IViewConstants.OTHER_FILES_FOLDER_NAME, IViewConstants.OTHER_FILES_FOLDER_NAME, false);
                }
                if (this.fProject.getLocation() != null) {
                    var5_14 = this.fProject.getLocation().toOSString();
                    var6_17 = ViewsTreeModel.getInstance().getRoot().addChild((String)var5_14, this.fProject.getName(), IViewConstants.PROJECT_NAME, false);
                    if (var6_17 != null) {
                        var6_17.addChild(IViewConstants.SOURCE_FOLDER_VALUE, "SOURCE_FOLDER", "SOURCE_FOLDER", false);
                        var6_17.addChild(IViewConstants.LINKING_FILES_FOLDER_VALUE, IViewConstants.LINKING_FILES_FOLDER_NAME, IViewConstants.LINKING_FILES_FOLDER_NAME, false);
                        var6_17.addChild(IViewConstants.OTHER_FILES_FOLDER_VALUE, IViewConstants.OTHER_FILES_FOLDER_NAME, IViewConstants.OTHER_FILES_FOLDER_NAME, false);
                    }
                }
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
                this.updateOtherViews();
            }
            catch (Exception var3_5) {
                CBDTUiPlugin.logError("ERROR performFinish of ProjectCreationNewWizard", var3_5);
                if (!var2_2) ** GOTO lbl138
                var1_1.setAutoBuilding(true);
                try {
                    ResourcesPlugin.getWorkspace().setDescription(var1_1);
                }
                catch (CoreException var9_10) {
                    CBDTUiPlugin.logError((Exception)var9_10);
                }
            }
        }
        catch (Throwable var8_19) {
            if (var2_2) {
                var1_1.setAutoBuilding(true);
                try {
                    ResourcesPlugin.getWorkspace().setDescription(var1_1);
                }
                catch (CoreException var9_11) {
                    CBDTUiPlugin.logError((Exception)var9_11);
                }
            }
            throw var8_19;
        }
        if (var2_2) {
            var1_1.setAutoBuilding(true);
            try {
                ResourcesPlugin.getWorkspace().setDescription(var1_1);
            }
            catch (CoreException var9_12) {
                CBDTUiPlugin.logError((Exception)var9_12);
            }
        }
lbl138:
        // 7 sources

        DependencyModelManipulation.generateAntFile(this.fProject);
        RepositoryData.populateRepositoryData(ViewsTreeModel.getInstance().getRoot().getChildFromName(this.fProject.getName()));
        return true;
    }

    private void updateOtherViews() {
        try {
            IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray.length > 0) {
                Display.getDefault().asyncExec(this.getRunnable());
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public Runnable getRunnable() {
        try {
            if (this.fRunnable == null) {
                this.fRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ProjectCreationNewWizard.this.refreshWorkbenchViews();
                    }
                };
            }
            return this.fRunnable;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    private void refreshWorkbenchViews() {
        IWorkbenchWindow[] iWorkbenchWindowArray = CBDTUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IViewPart[] iViewPartArray = ViewsUtil.getViews(iWorkbenchWindowArray[n].getActivePage());
            int n2 = 0;
            while (n2 < iViewPartArray.length) {
                IMenuListener iMenuListener;
                if (iViewPartArray[n2] instanceof DependencyView) {
                    iMenuListener = (DependencyView)iViewPartArray[n2];
                    iMenuListener.refresh();
                }
                if (iViewPartArray[n2] instanceof StructuresView) {
                    iMenuListener = (StructuresView)iViewPartArray[n2];
                    iMenuListener.refresh();
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean attachNatureToProject() {
        try {
            String string;
            String[] stringArray = null;
            stringArray = this.getContributorId() != null && !this.getContributorId().equals("") ? ((string = this.getContributorNatureId()) != null && string.length() > 0 ? new String[]{"org.eclipse.cobol.core.COBOLNature", string} : new String[]{"org.eclipse.cobol.core.COBOLNature"}) : new String[]{"org.eclipse.cobol.core.COBOLNature"};
            string = this.fProject.getDescription();
            string.setNatureIds(stringArray);
            this.fProject.setDescription((IProjectDescription)string, null);
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)new Shell(), (String)"Creation Problems", (String)coreException.toString());
        }
        return true;
    }

    private IProject createNewProject() {
        Object object;
        final IProject iProject = this.fMainPage.getProjectHandle();
        if (ViewsUtil.isWindows()) {
            if (iProject.getName().length() > 249) {
                this.fMainPage.setErrorMessage(Messages.getString((String)"ProjectNameTooBigMessage"));
                this.fMainPage.setPageComplete(false);
                return null;
            }
        } else if (iProject.getName().length() > 254) {
            this.fMainPage.setErrorMessage(Messages.getString((String)"ProjectNameTooBigMessage"));
            this.fMainPage.setPageComplete(false);
            return null;
        }
        String string = this.fTargetPage.getTargetFileName();
        boolean bl = this.fTargetPage.getExeButton();
        if (string == null || string.trim().equals("")) {
            this.fMainPage.setErrorMessage("Set the value for target name");
            this.fMainPage.setPageComplete(false);
            return null;
        }
        string = this.fTargetPage.getTargetFileName().trim();
        boolean bl2 = this.fTargetPage.getReleaseButton();
        IPath iPath = Platform.getLocation();
        IPath iPath2 = this.fMainPage.getLocationPath();
        this.fStrPathAndName = String.valueOf(this.fMainPage.getLocationPath().toOSString()) + File.separator + iProject.getName();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        if (iPath.equals((Object)iPath2)) {
            iProjectDescription.setLocation(null);
        } else {
            object = iPath2.append(iProject.getName());
            iProjectDescription.setLocation(object);
        }
        object = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    ProjectCreationNewWizard.this.createProject(iProjectDescription, iProject, iProgressMonitor);
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                    ProjectCreationNewWizard.this.state = 0;
                }
            }
        };
        if (this.state != 0) {
            return null;
        }
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)object);
            try {
                if (iProject != null && iProject.exists()) {
                    if (bl) {
                        String string2 = this.fTargetPage.getTargetFileName().trim();
                        iProject.setPersistentProperty(this.TARGET_NAME, string2);
                        iProject.setPersistentProperty(this.EXE_LIB_MODE, "false");
                    } else {
                        String string3 = this.fTargetPage.getTargetFileName().trim();
                        iProject.setPersistentProperty(this.TARGET_NAME, string3);
                        iProject.setPersistentProperty(this.EXE_LIB_MODE, "true");
                    }
                    if (bl2) {
                        iProject.setPersistentProperty(this.RELEASE_DEBUG_MODE, "false");
                    } else {
                        iProject.setPersistentProperty(this.RELEASE_DEBUG_MODE, "true");
                    }
                }
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError((Exception)((Object)coreException));
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
            return iProject;
        }
        catch (InterruptedException interruptedException) {
            CBDTUiPlugin.logError("ERROR createNewProject of ProjectCreationNewWizard", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            CBDTUiPlugin.logError("ERROR createNewProject of ProjectCreationNewWizard", invocationTargetException);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private void createProject(IProjectDescription iProjectDescription, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        try {
            try {
                iProgressMonitor.beginTask("", Integer.parseInt(Messages.getString((String)"PROGRESSMONITOR_TOTALWORK")));
                iProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, Integer.parseInt(Messages.getString((String)"SUBPROGRESSMONITOR_TICKS"))));
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                iProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, Integer.parseInt(Messages.getString((String)"SUBPROGRESSMONITOR_TICKS"))));
            }
            catch (CoreException coreException) {
                CBDTUiPlugin.logError("ERROR createNewProject of ProjectCreationNewWizard", (Exception)((Object)coreException));
                this.state = -1;
                iProgressMonitor.done();
                return;
            }
            catch (OperationCanceledException operationCanceledException) {
                CBDTUiPlugin.logError("ERROR createNewProject of ProjectCreationNewWizard", (Exception)((Object)operationCanceledException));
                this.state = -1;
                iProgressMonitor.done();
                return;
            }
            catch (Exception exception) {
                this.state = -1;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                iProgressMonitor.done();
                return;
            }
        }
        finally {
            iProgressMonitor.done();
        }
        this.state = 0;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        this.fConfigElement = iConfigurationElement;
    }

    public NewProjectCreationPage getPage() {
        return this.fMainPage;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (this.getContainer().getCurrentPage() == this.fTargetPage && this.fCodegenPage == null) {
            return null;
        }
        if (this.getContainer().getCurrentPage() == this.fMainPage) {
            this.fProjectName = this.fMainPage.getProjectName();
            this.fProject = this.getProjects();
            this.fProjectLocation = this.getLocationPaths();
        }
        CoreCommonUtility.setProjectName((String)this.fProjectName);
        return super.getNextPage(iWizardPage);
    }

    public String getProjectNames() {
        return this.getPage().getProjectName();
    }

    public IPath getLocationPaths() {
        return this.getPage().getLocationPath();
    }

    public IProject getProjects() {
        return this.getPage().getProjectHandle();
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.fTargetPage && this.fCodegenPage == null) {
            return super.canFinish();
        }
        if (this.getContainer().getCurrentPage() == this.fMainPage || this.getContainer().getCurrentPage() == this.fTargetPage) {
            return false;
        }
        return super.canFinish();
    }

    private boolean setApplicationTargetType() {
        if (this.getContributorId() != null && !this.getContributorId().equals("")) {
            if (this.fCodegenPage != null && this.fElementList != null) {
                if (this.fElementList.size() == 0) {
                    CoreCommonUtility.setProjectId((String)"");
                    return true;
                }
                WizardElement wizardElement = this.fCodegenPage.getSelectedWizardElement();
                if (wizardElement != null) {
                    String string = wizardElement.getApplicationTargetType();
                    if (string.length() == 0) {
                        string = this.getContributorTargettype();
                    }
                    CoreCommonUtility.setProjectId((String)string);
                    return true;
                }
            }
            CoreCommonUtility.setProjectId((String)"");
            return true;
        }
        if (this.getContributorId().equals("")) {
            CoreCommonUtility.setProjectId((String)"");
            return true;
        }
        return false;
    }

    private String getContributorTargettype() {
        String string = CorePlugin.getDefault().getPreferenceStore().getString("COBOLContributor");
        ICOBOLContributorRegistry iCOBOLContributorRegistry = CorePlugin.getDefault().getCOBOLContributorRegistry();
        ICOBOLContributorDescriptor[] iCOBOLContributorDescriptorArray = iCOBOLContributorRegistry.getCOBOLContributors();
        int n = 0;
        while (iCOBOLContributorDescriptorArray != null && n < iCOBOLContributorDescriptorArray.length) {
            if (iCOBOLContributorDescriptorArray[n].getProviderID().equalsIgnoreCase(string)) {
                return iCOBOLContributorDescriptorArray[n].getConfigurationElement().getAttribute("targettype");
            }
            ++n;
        }
        return "";
    }

    private String getContributorNatureId() {
        String string = CorePlugin.getDefault().getPreferenceStore().getString("COBOLContributor");
        ICOBOLContributorRegistry iCOBOLContributorRegistry = CorePlugin.getDefault().getCOBOLContributorRegistry();
        ICOBOLContributorDescriptor[] iCOBOLContributorDescriptorArray = iCOBOLContributorRegistry.getCOBOLContributors();
        int n = 0;
        while (iCOBOLContributorDescriptorArray != null && n < iCOBOLContributorDescriptorArray.length) {
            if (iCOBOLContributorDescriptorArray[n].getProviderID().equalsIgnoreCase(string)) {
                return iCOBOLContributorDescriptorArray[n].getConfigurationElement().getAttribute("nature");
            }
            ++n;
        }
        return null;
    }

    private String getContributorId() {
        String string = CorePlugin.getDefault().getPreferenceStore().getString("COBOLContributor");
        return string;
    }
}

