/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.wizards.projectmanagement;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;

public class CustomWizardNewProjectCreationPage
extends WizardNewProjectCreationPage {
    private static final String WIN_PLATFORM = "win32";
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private Composite fComposite;
    private boolean fFlag = true;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event event) {
            CustomWizardNewProjectCreationPage.this.setLocationForSelection();
            CustomWizardNewProjectCreationPage.this.setPageComplete(CustomWizardNewProjectCreationPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event event) {
            CustomWizardNewProjectCreationPage.this.setPageComplete(CustomWizardNewProjectCreationPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public CustomWizardNewProjectCreationPage(String string) {
        super(string);
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
        this.customLocationFieldValue = "";
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        this.fComposite = composite2;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.ide.new_project_wizard_page_context");
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite2);
        this.createProjectLocationGroup(composite2);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    private final void createProjectLocationGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setFont(composite2.getFont());
        label.setText("Project contents:");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        final Button button = new Button(composite2, 131104);
        button.setFont(composite2.getFont());
        button.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationLabel);
        button.setSelection(this.useDefaults);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        button.setLayoutData((Object)gridData2);
        this.createUserSpecifiedProjectLocationGroup(composite2, !this.useDefaults);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CustomWizardNewProjectCreationPage.this.useDefaults = button.getSelection();
                CustomWizardNewProjectCreationPage.this.browseButton.setEnabled(!CustomWizardNewProjectCreationPage.this.useDefaults);
                CustomWizardNewProjectCreationPage.this.locationPathField.setEnabled(!CustomWizardNewProjectCreationPage.this.useDefaults);
                CustomWizardNewProjectCreationPage.this.locationLabel.setEnabled(!CustomWizardNewProjectCreationPage.this.useDefaults);
                if (CustomWizardNewProjectCreationPage.this.useDefaults) {
                    CustomWizardNewProjectCreationPage.this.customLocationFieldValue = CustomWizardNewProjectCreationPage.this.locationPathField.getText();
                    CustomWizardNewProjectCreationPage.this.setLocationForSelection();
                } else {
                    CustomWizardNewProjectCreationPage.this.setPageComplete(CustomWizardNewProjectCreationPage.this.validatePage());
                }
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private final void createProjectNameGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setFont(composite2.getFont());
        label.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_nameLabel);
        this.projectNameField = new Text(composite2, 2048);
        this.projectNameField.setFont(composite2.getFont());
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)gridData);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite composite, boolean bl) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setFont(composite.getFont());
        this.locationLabel.setText(com.unisys.os2200.i18nSupport.Messages.getString((String)"CustomWizardNewProjectCreationPage.Directory"));
        this.locationLabel.setEnabled(bl);
        this.locationPathField = new Text(composite, 2048);
        this.locationPathField.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.locationPathField.setLayoutData((Object)gridData);
        this.locationPathField.setEnabled(bl);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setFont(composite.getFont());
        this.browseButton.setText(PreferencesMessages.PreferencesExport_browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CustomWizardNewProjectCreationPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(bl);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    public String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText();
    }

    private String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.locationPathField.getShell());
        directoryDialog.setMessage(IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel);
        String string = this.getProjectLocationFieldValue();
        if (!string.equals("") && ((File)(object = new File(string))).exists()) {
            directoryDialog.setFilterPath(new Path(string).toOSString());
        }
        if ((object = directoryDialog.open()) != null) {
            this.customLocationFieldValue = object;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    public void setInitialProjectName(String string) {
        this.initialProjectFieldValue = string == null ? null : string.trim();
    }

    private void setLocationForSelection() {
        try {
            if (this.useDefaults) {
                IPath iPath = Platform.getLocation().append(this.getProjectNameFieldValue());
                this.locationPathField.setText(iPath.toOSString());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    protected boolean validatePage() {
        IStatus iStatus;
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        String string = this.getProjectNameFieldValue();
        if (string.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectNameEmpty);
            return false;
        }
        int n = Integer.parseInt(com.unisys.os2200.i18nSupport.Messages.getString((String)"com.unisys.os2200.i18nSupport.messages", (String)"CustomWizardNewProjectCreationPage.projectLength.length"));
        if (string.length() > n) {
            String string2 = MessageFormat.format(com.unisys.os2200.i18nSupport.Messages.getString((String)"com.unisys.os2200.i18nSupport.messages", (String)"CustomWizardNewProjectCreationPage.projectLength.err"), new Integer(n));
            this.setErrorMessage(string2);
            return false;
        }
        IStatus iStatus2 = iWorkspace.validateName(string, 4);
        if (!iStatus2.isOK()) {
            this.setErrorMessage(iStatus2.getMessage());
            return false;
        }
        iStatus2 = iWorkspace.validateName(string, 1);
        if (!iStatus2.isOK()) {
            this.setErrorMessage(iStatus2.getMessage());
            return false;
        }
        if (string.indexOf(32) != -1 || string.indexOf(46) != -1) {
            String string3 = null;
            if (string.indexOf(32) != -1) {
                string3 = "' '";
            } else if (string.indexOf(46) != -1) {
                string3 = ".";
            }
            this.setErrorMessage(String.valueOf(string3) + " " + com.unisys.os2200.i18nSupport.Messages.getString((String)"com.unisys.os2200.i18nSupport.messages", (String)"CustomWizardNewProjectCreationPage.errorMsg") + string);
            return false;
        }
        String string4 = this.getProjectLocationFieldValue();
        if (string4.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty);
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(string4)) {
            this.setErrorMessage("Project contents cannot be inside workspace directory.");
            return false;
        }
        if (!this.useDefaults && Platform.getLocation().isPrefixOf((IPath)new Path(string4))) {
            this.setErrorMessage("Project contents cannot be inside workspace directory");
            return false;
        }
        if (!this.useDefaults && !(iStatus = this.validateProjectLocation((IPath)new Path(string4))).isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
            return false;
        }
        iStatus = iWorkspace.getRoot();
        IPath iPath = iWorkspace.getRoot().getLocation();
        File file = new File(iPath.toOSString(), this.getProjectHandle().getName());
        if (file.exists() && file.isFile()) {
            this.setErrorMessage(com.unisys.os2200.i18nSupport.Messages.getString((String)"com.unisys.os2200.i18nSupport.messages", (String)"CustomWizardNewProjectCreationPage.projectExistsMessage"));
            return false;
        }
        if (SWT.getPlatform().equalsIgnoreCase(WIN_PLATFORM)) {
            String string5 = null;
            IProject[] iProjectArray = iStatus.getProjects();
            int n2 = 0;
            while (n2 < iProjectArray.length) {
                if (string.equalsIgnoreCase(iProjectArray[n2].getName())) {
                    string5 = iProjectArray[n2].getName();
                }
                ++n2;
            }
            if (string5 != null && file.exists() && file.isDirectory()) {
                this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean bl) {
        this.fComposite.setVisible(bl);
        if (bl) {
            this.projectNameField.setFocus();
        }
        if (this.fFlag) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            this.fFlag = false;
        }
    }

    private IStatus validateProjectLocation(IPath iPath) {
        IPath iPath2;
        String string = null;
        if (iPath == null) {
            string = Messages.resources_pathNull;
            return new ResourceStatus(0, string);
        }
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            IStatus iStatus = this.validateName(iPath.segment(n2), 4);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            ++n2;
        }
        if (iPath.getDevice() == null) {
            iPath = new Path(iPath.toFile().getAbsolutePath());
        }
        if ((iPath2 = Platform.getLocation()).isPrefixOf(iPath) || iPath.isPrefixOf(iPath2)) {
            string = Messages.bind((String)Messages.resources_overlapWorkspace, (Object[])new Object[]{iPath.toString(), iPath2.toString()});
            return new ResourceStatus(77, null, string);
        }
        string = "";
        return new ResourceStatus(0, string);
    }

    public IStatus validateName(String string, int n) {
        if (string == null) {
            String string2 = Messages.resources_nameNull;
            return new ResourceStatus(77, null, string2);
        }
        if (string.length() == 0) {
            String string3 = Messages.resources_nameEmpty;
            return new ResourceStatus(77, null, string3);
        }
        if (Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(string.length() - 1))) {
            String string4 = Messages.bind((String)Messages.resources_invalidCharInPath, (Object[])new Object[]{string});
            return new ResourceStatus(77, null, string4);
        }
        if (string.endsWith(".")) {
            String string5 = Messages.bind((String)Messages.resources_invalidCharInPath, (Object[])new Object[]{string});
            return new ResourceStatus(77, null, string5);
        }
        char[] cArray = OS.INVALID_RESOURCE_CHARACTERS;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (string.indexOf(cArray[n2]) != -1) {
                String string6 = Messages.bind((String)Messages.resources_invalidCharInPath, (Object[])new Object[]{String.valueOf(cArray[n2])});
                return new ResourceStatus(77, null, string6);
            }
            ++n2;
        }
        if (!OS.isNameValid((String)string)) {
            String string7 = Messages.bind((String)Messages.resources_invalidName, (Object[])new Object[]{string});
            return new ResourceStatus(77, null, string7);
        }
        return ResourceStatus.OK_STATUS;
    }
}

