/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.templates;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.ICOBOLHelpContextId;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.cobol.ui.templates.COBOLTemplate;
import org.eclipse.cobol.ui.templates.COBOLTemplateException;
import org.eclipse.cobol.ui.templates.COBOLTemplateManager;
import org.eclipse.cobol.ui.templates.Category;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.templates.COBOLTemplateDialog;
import org.eclipse.cobol.ui.views.templates.COBOLTemplateTreeContentProvider;
import org.eclipse.cobol.ui.views.templates.COBOLTemplateTreeLabelProvider;
import org.eclipse.cobol.ui.views.templates.COBOLTemplateViewDragListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ViewPart;

public class COBOLTemplateViewPart
extends ViewPart {
    private TreeViewer fTreeViewer;
    private Object fObject;
    private String fStrTemplatePasteIntoEditor = "";
    private Action addTemplateAction;
    private Runnable fRunnable = null;
    private static final String LINE_DELIMITER = "\n";
    private SashForm fSashForm = null;
    private SourceViewer fSourceViewer = null;
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{80, 20};
    private static final String DUMMY_ROOT_NAME = "TemplateRoot";

    public COBOLTemplateViewPart() {
        try {
            COBOLTemplateManager.getInstance();
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected void createActions() {
        this.addTemplateAction = new Action(Messages.getString((String)"InsertTemplate")){

            public void run() {
                COBOLTemplateViewPart.this.openPopupDialog();
            }
        };
    }

    private void updateActionEnablement() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
        this.addTemplateAction.setEnabled(iStructuredSelection.size() > 0);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                COBOLTemplateViewPart.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fTreeViewer);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        try {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
            if (iStructuredSelection.size() == 1) {
                this.fObject = this.getSelection();
                if (this.fObject != null && this.fObject instanceof COBOLTemplate) {
                    iMenuManager.add((IAction)this.addTemplateAction);
                    this.addTemplateAction.setEnabled(iStructuredSelection.size() > 0);
                }
            }
            iMenuManager.add((IContributionItem)new Separator("additions"));
            iMenuManager.add((IContributionItem)new Separator("additions-end"));
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void createPartControl(Composite composite) {
        try {
            this.fSashForm = new SashForm(composite, 512);
            this.fTreeViewer = new TreeViewer((Composite)this.fSashForm, 770);
            this.fTreeViewer.setContentProvider((IContentProvider)new COBOLTemplateTreeContentProvider());
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new COBOLTemplateTreeLabelProvider());
            this.fTreeViewer.setInput((Object)Category.getRootCategoryInstance().getParent());
            this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
            this.createActions();
            this.createContextMenu();
            this.initDragAndDrop();
            this.createEditor((Composite)this.fSashForm);
            this.fSashForm.setMaximizedControl(null);
            this.fSashForm.setWeights(DEFAULT_SASH_WEIGHTS);
            if (this.fTreeViewer != null) {
                this.fTreeViewer.refresh();
            }
            this.restoreState();
            this.initListeners(this.fTreeViewer);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, ICOBOLHelpContextId.COBOL_TEMPLATE_VIEW);
            this.fTreeViewer.expandToLevel(1);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void refresh() {
        if (this.fTreeViewer != null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray.length > 1) {
                Display display = this.getSite().getShell().getDisplay();
                display.asyncExec(this.getRunnable());
            }
            if (this.fTreeViewer != null) {
                this.fTreeViewer.refresh();
            }
        }
    }

    public void setFocus() {
    }

    private void initDragAndDrop() {
        try {
            int n = 7;
            Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance(), PluginTransfer.getInstance()};
            COBOLTemplateViewDragListener cOBOLTemplateViewDragListener = new COBOLTemplateViewDragListener(this);
            this.fTreeViewer.addDragSupport(n, transferArray, (DragSourceListener)cOBOLTemplateViewDragListener);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void openPopupDialog() {
        try {
            this.fObject = this.getSelection();
            if (this.fObject instanceof COBOLTemplate) {
                IWorkbenchPage iWorkbenchPage = CBDTUiPlugin.getActiveWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null) {
                    if (iWorkbenchPage.getActiveEditor() instanceof COBOLEditor) {
                        COBOLEditor cOBOLEditor = (COBOLEditor)iWorkbenchPage.getActiveEditor();
                        if (cOBOLEditor != null) {
                            COBOLTemplateDialog cOBOLTemplateDialog = new COBOLTemplateDialog(this.getSite().getShell(), this);
                            cOBOLTemplateDialog.open();
                        } else {
                            MessageDialog.openInformation((Shell)this.fTreeViewer.getControl().getShell(), (String)Messages.getString((String)"NoActiveCobolEditor"), (String)Messages.getString((String)"NoActiveCobolEditorMessage"));
                        }
                    } else {
                        MessageDialog.openInformation((Shell)this.fTreeViewer.getControl().getShell(), (String)Messages.getString((String)"NoActiveCobolEditor"), (String)Messages.getString((String)"NoActiveCobolEditorMessage"));
                    }
                } else {
                    MessageDialog.openInformation((Shell)this.fTreeViewer.getControl().getShell(), (String)Messages.getString((String)"NoActiveEditor"), (String)Messages.getString((String)"NoActiveEditorMessage"));
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void setObject(Object object) {
        this.fObject = object;
    }

    public Object getObject() {
        return this.fObject;
    }

    public Object getSelection() {
        try {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection();
            for (Object e : iStructuredSelection) {
                if (e instanceof Category) {
                    return (Category)e;
                }
                if (!(e instanceof COBOLTemplate)) continue;
                return (COBOLTemplate)e;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return null;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(ViewPart.class)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public void setTemplatePasteIntoEditor(String string) {
        this.fStrTemplatePasteIntoEditor = string;
    }

    protected void pasteIntoEditor() {
        try {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            COBOLEditor cOBOLEditor = null;
            if (iWorkbenchPage.getActiveEditor() instanceof COBOLEditor) {
                cOBOLEditor = (COBOLEditor)iWorkbenchPage.getActiveEditor();
                cOBOLEditor.pasteIntoEditor(this.fStrTemplatePasteIntoEditor);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public String getTemplatePasteIntoEditor() {
        return this.fStrTemplatePasteIntoEditor;
    }

    public Runnable getRunnable() {
        try {
            if (this.fRunnable == null) {
                this.fRunnable = new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow[] iWorkbenchWindowArray = COBOLTemplateViewPart.this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
                        int n = 0;
                        while (n < iWorkbenchWindowArray.length) {
                            IViewPart[] iViewPartArray = ViewsUtil.getViews(iWorkbenchWindowArray[n].getActivePage());
                            int n2 = 0;
                            while (n2 < iViewPartArray.length) {
                                COBOLTemplateViewPart cOBOLTemplateViewPart;
                                if (iViewPartArray[n2] instanceof COBOLTemplateViewPart && (cOBOLTemplateViewPart = (COBOLTemplateViewPart)iViewPartArray[n2]) != null) {
                                    cOBOLTemplateViewPart.refresh();
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                };
            }
            return this.fRunnable;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public void saveState(IMemento iMemento) {
        Object[] objectArray = this.fTreeViewer.getVisibleExpandedElements();
        int n = 0;
        while (n < objectArray.length) {
            Category category = (Category)objectArray[n];
            category.setExpandedState(true);
            ++n;
        }
        try {
            COBOLTemplateManager.getInstance().save();
        }
        catch (COBOLTemplateException cOBOLTemplateException) {}
        super.saveState(iMemento);
    }

    private void restoreState() {
        ArrayList arrayList = new ArrayList();
        COBOLTemplateManager.getInstance().getExpandedElements(Category.getRootCategoryInstance(), arrayList);
        this.fTreeViewer.setExpandedElements(arrayList.toArray());
    }

    private SourceViewer createEditor(Composite composite) {
        int n = 832;
        SourceViewer sourceViewer = new SourceViewer(composite, null, n);
        if (sourceViewer != null) {
            this.setSourceViewer(sourceViewer);
        }
        IDocument iDocument = this.getDocument();
        sourceViewer.configure(new SourceViewerConfiguration());
        sourceViewer.setEditable(false);
        sourceViewer.setDocument(iDocument);
        this.initializedViewerFont();
        return sourceViewer;
    }

    private IDocument getDocument() {
        Document document = new Document();
        document.set("");
        return document;
    }

    private void setSourceViewer(SourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
    }

    public void initializedViewerFont() {
        Font font = this.getFont((ISourceViewer)this.fSourceViewer);
        this.fSourceViewer.getTextWidget().setFont(font);
    }

    private Font getFont(ISourceViewer iSourceViewer) {
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        FontData fontData = PreferenceConverter.getDefaultFontData((IPreferenceStore)iPreferenceStore, (String)"org.eclipse.jface.textfont");
        if (iPreferenceStore != null && iPreferenceStore.contains("org.eclipse.jface.textfont") && !iPreferenceStore.isDefault("org.eclipse.jface.textfont")) {
            fontData = PreferenceConverter.getFontData((IPreferenceStore)iPreferenceStore, (String)"org.eclipse.jface.textfont");
        }
        font = fontData != null && iSourceViewer != null ? new Font((Device)iSourceViewer.getTextWidget().getDisplay(), fontData) : new Font(null, fontData);
        return font;
    }

    private void initListeners(TreeViewer treeViewer) {
        if (treeViewer == null) {
            return;
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                COBOLTemplateViewPart.this.doSelectionChanged(selectionChangedEvent);
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                COBOLTemplateViewPart.this.doDoubleClick(doubleClickEvent);
            }
        });
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                COBOLTemplateViewPart.this.doDoubleClick(treeExpansionEvent);
            }
        });
    }

    private void doSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        this.updateStatusMessage(iStructuredSelection);
    }

    private void updateStatusMessage(IStructuredSelection iStructuredSelection) {
        String string = "";
        String string2 = "";
        if (iStructuredSelection.size() == 1) {
            this.fObject = this.getSelection();
            if (this.fObject != null) {
                if (this.fObject instanceof COBOLTemplate) {
                    string2 = ((COBOLTemplate)this.fObject).getPattern();
                } else if (this.fObject instanceof Category) {
                    string2 = ((Category)this.fObject).getDescription();
                }
                string = this.getMessage(this.fObject);
                if (string.startsWith(File.separator)) {
                    string = string.substring(1);
                }
            }
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
        this.setDocumentText(string2);
    }

    private String getMessage(Object object) {
        String string = "";
        if (object != null) {
            if (object instanceof COBOLTemplate) {
                string = String.valueOf(this.getMessage(((COBOLTemplate)object).getParent())) + File.separator + ((COBOLTemplate)object).getName();
            } else if (object instanceof Category) {
                if (((Category)object).getName().equals(DUMMY_ROOT_NAME)) {
                    return "";
                }
                string = String.valueOf(this.getMessage(((Category)object).getParent())) + File.separator + ((Category)object).getName();
            }
        }
        return string;
    }

    public void setDocumentText(String string) {
        this.fSourceViewer.getDocument().set(string);
    }

    private void doDoubleClick(Object object) {
        IStructuredSelection iStructuredSelection;
        Object object2 = null;
        COBOLTemplate cOBOLTemplate = null;
        if (object instanceof DoubleClickEvent) {
            iStructuredSelection = (IStructuredSelection)((DoubleClickEvent)object).getSelection();
            object2 = iStructuredSelection.getFirstElement();
            if (object2 != null && object2 instanceof COBOLTemplate) {
                cOBOLTemplate = (COBOLTemplate)object2;
                if (this.isFileReadOnly()) {
                    this.nothingSelected(Messages.getString((String)"Common.error.readonly.message"));
                    return;
                }
                if (cOBOLTemplate.getPattern() == null || cOBOLTemplate.getPattern().trim().equals("")) {
                    this.nothingSelected(Messages.getString((String)"TemplateActionGroup.message.empty2"));
                    return;
                }
                this.setTemplatePasteIntoEditor(cOBOLTemplate.getPattern());
                this.pasteIntoEditor();
                return;
            }
        } else if (object instanceof TreeExpansionEvent) {
            object2 = ((TreeExpansionEvent)object).getElement();
        }
        if (object2 == null) {
            return;
        }
        iStructuredSelection = this.fTreeViewer;
        if (object2 != null && iStructuredSelection.isExpandable(object2)) {
            iStructuredSelection.setExpandedState(object2, !iStructuredSelection.getExpandedState(object2));
        }
    }

    public boolean isFileReadOnly() {
        IEditorPart iEditorPart = COBOLTemplateViewPart.getActiveEditor();
        if (iEditorPart == null) {
            return false;
        }
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFile iFile = iFileEditorInput.getFile();
            return iFile.isReadOnly();
        }
        return false;
    }

    protected static IEditorPart getActiveEditor() {
        IEditorPart iEditorPart = null;
        IWorkbenchWindow iWorkbenchWindow = null;
        try {
            iWorkbenchWindow = CBDTUiPlugin.getActiveWorkbenchWindow();
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
        if (iWorkbenchWindow == null) {
            return iEditorPart;
        }
        IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindow.getPages();
        if (iWorkbenchPageArray != null && iWorkbenchPageArray.length > 0) {
            iEditorPart = iWorkbenchPageArray[0].getActiveEditor();
        }
        return iEditorPart;
    }

    private void nothingSelected(String string) {
        Display.getDefault().beep();
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.getString((String)"TemplateActionGroup.message.title"), (String)string);
    }
}

