/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.templates;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.templates.COBOLTemplate;
import org.eclipse.cobol.ui.views.structures.CreateControls;
import org.eclipse.cobol.ui.views.templates.COBOLTemplateViewPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class COBOLTemplateDialog
extends Dialog {
    private COBOLTemplateViewPart fTemplateViewPart = null;
    private COBOLTemplate fTemplate = null;
    private Table fTable = null;
    private final String[] fColumnTitles = new String[]{Messages.getString((String)"TemplateColumnName"), Messages.getString((String)"TemplateColumnValue")};
    private String fTemplatePattern = "";
    private String fReadKey = "";
    private String fEditedValue = "";
    private Hashtable fHtblParams = null;
    private static final String PARAM_PREFIX = "${";
    private static final String PARAM_SUFFIX = "}";
    private static final int FIRST_COLUMN_WIDTH = 150;
    private static final int SECOND_COLUMN_WIDTH = 150;
    private Text text = null;
    private TableCursor cursor = null;
    private ControlEditor editor = null;
    private TableItem[] tblItem = null;
    private String fTemplateDesc = "";

    public COBOLTemplateDialog(Shell shell, COBOLTemplateViewPart cOBOLTemplateViewPart) {
        super(shell);
        this.fTemplateViewPart = cOBOLTemplateViewPart;
        this.fTemplate = (COBOLTemplate)cOBOLTemplateViewPart.getObject();
        if (this.fTemplate != null) {
            if (this.fTemplate.getPattern() != null) {
                this.fTemplatePattern = this.fTemplate.getPattern();
            }
            if (this.fTemplate.getDescription() != null) {
                this.fTemplateDesc = this.fTemplate.getDescription();
            }
        }
        this.fHtblParams = new Hashtable();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString((String)"TemplateInputAssistance"));
    }

    protected Control createDialogArea(Composite composite) {
        try {
            if (this.fTemplatePattern != null && !this.fTemplatePattern.equals("")) {
                CreateControls createControls = new CreateControls();
                Composite composite2 = createControls.createComposite(composite, 1);
                createControls.createLabel(composite2, Messages.getString((String)"TemplatePatternPreview"));
                Text text = new Text(composite2, 2826);
                text.setFont(composite2.getFont());
                text.setText(this.fTemplatePattern);
                Label label = new Label(composite2, 16384);
                label.setFont(composite2.getFont());
                GridData gridData = new GridData(256);
                gridData.heightHint = ((GridLayout)composite2.getLayout()).verticalSpacing;
                label.setLayoutData((Object)gridData);
                createControls.createLabel(composite2, Messages.getString((String)"TemplateDescription"));
                Text text2 = new Text(composite2, 2056);
                text2.setFont(composite2.getFont());
                text2.setText(this.fTemplateDesc);
                GC gC = new GC((Drawable)text2);
                FontMetrics fontMetrics = gC.getFontMetrics();
                int n = fontMetrics.getHeight();
                gC.dispose();
                this.readParametersFromTemplate();
                Point point = text.computeSize(-1, -1);
                text.setSize(point);
                GridData gridData2 = new GridData(768);
                gridData2.grabExcessHorizontalSpace = true;
                gridData2.heightHint = 75;
                text.setLayoutData((Object)gridData2);
                Point point2 = text.computeSize(-1, -1);
                text2.setSize(point2);
                GridData gridData3 = new GridData(768);
                gridData3.grabExcessHorizontalSpace = true;
                gridData3.heightHint = n;
                text2.setLayoutData((Object)gridData3);
                if (this.fHtblParams.isEmpty()) {
                    return composite2;
                }
                label = new Label(composite2, 16384);
                label.setFont(composite2.getFont());
                gridData = new GridData(256);
                gridData.heightHint = ((GridLayout)composite2.getLayout()).verticalSpacing;
                label.setLayoutData((Object)gridData);
                createControls.createLabel(composite2, Messages.getString((String)"TemplateEnterParameterValue"));
                this.createTable(composite2);
                this.fillTableData();
                this.addTableNavigation();
                this.fTable.setHeaderVisible(true);
                this.fTable.setLinesVisible(true);
                Point point3 = this.fTable.computeSize(-1, -1);
                this.fTable.setSize(point3);
                this.fTable.setFocus();
                GridData gridData4 = new GridData(768);
                gridData4.grabExcessHorizontalSpace = true;
                gridData4.heightHint = this.fHtblParams.size() > 3 ? 70 : 50;
                this.fTable.setLayoutData((Object)gridData4);
                composite.layout();
                return composite2;
            }
            MessageDialog.openInformation((Shell)composite.getShell(), (String)Messages.getString((String)"TemplateEmpty"), (String)Messages.getString((String)"TemplateEmptyMessage"));
            this.close();
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    private void createTable(Composite composite) {
        try {
            this.fTable = new Table(composite, 2820);
            this.fTable.setFont(composite.getFont());
            this.fTable.setHeaderVisible(true);
            this.fTable.setLinesVisible(true);
            TableLayout tableLayout = new TableLayout();
            int[] nArray = new int[]{150, 150};
            int n = this.fColumnTitles.length;
            TableColumn tableColumn = null;
            int n2 = 0;
            while (n2 < n) {
                tableColumn = new TableColumn(this.fTable, 0);
                tableColumn.setWidth(nArray[n2]);
                tableColumn.setText(this.fColumnTitles[n2]);
                tableColumn.setResizable(false);
                tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(nArray[n2]));
                ++n2;
            }
            this.fTable.setLayout((Layout)tableLayout);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private void readParametersFromTemplate() {
        try {
            int n = 0;
            int n2 = 0;
            String string = this.fTemplatePattern;
            while (string.indexOf(PARAM_PREFIX) != -1) {
                n = string.indexOf(PARAM_PREFIX);
                String string2 = string.substring(n + 1);
                String string3 = string2.substring(1, n2 = string2.indexOf(PARAM_SUFFIX));
                if (string3 != null || !string3.equals("")) {
                    this.fHtblParams.put(string3, "");
                }
                string = string2.substring(n2 + 1);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private void fillTableData() {
        try {
            int n = this.fHtblParams.size();
            if (n > 0) {
                String string;
                Object[] objectArray = new String[n];
                Enumeration enumeration = this.fHtblParams.keys();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    objectArray[n2] = string;
                    ++n2;
                }
                Arrays.sort(objectArray);
                string = null;
                int n3 = 0;
                while (n3 < n2) {
                    string = new TableItem(this.fTable, 16386);
                    Object object = objectArray[n3];
                    String string2 = (String)this.fHtblParams.get(object);
                    String[] stringArray = new String[]{object, string2};
                    string.setText(stringArray);
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void addTableNavigation() {
        try {
            if (this.cursor == null) {
                this.cursor = new TableCursor(this.fTable, 0);
            }
            if (this.editor == null) {
                this.editor = new ControlEditor((Composite)this.cursor);
            }
            this.editor.grabHorizontal = true;
            this.editor.grabVertical = true;
            this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    try {
                        COBOLTemplateDialog.this.tblItem = new TableItem[]{COBOLTemplateDialog.this.cursor.getRow()};
                        COBOLTemplateDialog.this.fTable.setSelection(COBOLTemplateDialog.this.tblItem);
                        if (COBOLTemplateDialog.this.cursor.getColumn() == 1) {
                            COBOLTemplateDialog.this.editCell();
                        } else {
                            if (COBOLTemplateDialog.this.text != null) {
                                if (!COBOLTemplateDialog.this.text.isDisposed()) {
                                    COBOLTemplateDialog.this.text.dispose();
                                }
                                COBOLTemplateDialog.this.text = null;
                            }
                            COBOLTemplateDialog.this.fTable.setSelection(new TableItem[]{COBOLTemplateDialog.this.cursor.getRow()});
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        CBDTUiPlugin.logError(nullPointerException);
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    try {
                        COBOLTemplateDialog.this.tblItem = new TableItem[]{COBOLTemplateDialog.this.cursor.getRow()};
                        COBOLTemplateDialog.this.fTable.setSelection(COBOLTemplateDialog.this.tblItem);
                        if (COBOLTemplateDialog.this.cursor.getColumn() == 1) {
                            COBOLTemplateDialog.this.editCell();
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        CBDTUiPlugin.logError(nullPointerException);
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                }
            });
            this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    try {
                        COBOLTemplateDialog.this.tblItem = new TableItem[]{COBOLTemplateDialog.this.cursor.getRow()};
                        COBOLTemplateDialog.this.fTable.setSelection(COBOLTemplateDialog.this.tblItem);
                        COBOLTemplateDialog.this.fTable.setSelection(new TableItem[]{COBOLTemplateDialog.this.cursor.getRow()});
                    }
                    catch (NullPointerException nullPointerException) {
                        CBDTUiPlugin.logError(nullPointerException);
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                }
            });
            this.fTable.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    COBOLTemplateDialog.this.fTable.setSelection(new TableItem[]{COBOLTemplateDialog.this.cursor.getRow()});
                }
            });
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void editCell() {
        int n = this.cursor.getColumn();
        try {
            if (n == 1) {
                if (this.text == null) {
                    this.text = new Text((Composite)this.cursor, 0);
                }
                TableItem tableItem = this.cursor.getRow();
                this.tblItem = new TableItem[]{this.cursor.getRow()};
                this.fTable.setSelection(this.tblItem);
                this.text.setText(tableItem.getText(n));
                this.text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent keyEvent) {
                        if (COBOLTemplateDialog.this.text != null) {
                            COBOLTemplateDialog.this.captureEditedValue(COBOLTemplateDialog.this.cursor);
                        }
                        if ((keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000002) && COBOLTemplateDialog.this.text != null) {
                            COBOLTemplateDialog.this.captureEditedValue(COBOLTemplateDialog.this.cursor);
                            if (!COBOLTemplateDialog.this.text.isDisposed()) {
                                COBOLTemplateDialog.this.text.dispose();
                            }
                            if (COBOLTemplateDialog.this.text != null) {
                                COBOLTemplateDialog.this.text = null;
                            }
                            int n = COBOLTemplateDialog.this.fTable.getSelectionIndex();
                            if (keyEvent.keyCode == 0x1000002 && n >= 0 && n < COBOLTemplateDialog.this.fTable.getItemCount() - 1) {
                                COBOLTemplateDialog.this.fTable.setSelection(n + 1);
                                COBOLTemplateDialog.this.cursor.setSelection(n + 1, COBOLTemplateDialog.this.cursor.getColumn());
                            } else if (keyEvent.keyCode == 0x1000001 && n > 0 && n < COBOLTemplateDialog.this.fTable.getItemCount()) {
                                COBOLTemplateDialog.this.fTable.setSelection(n - 1);
                                COBOLTemplateDialog.this.cursor.setSelection(n - 1, COBOLTemplateDialog.this.cursor.getColumn());
                            }
                            COBOLTemplateDialog.this.editCell();
                        }
                    }
                });
                this.text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                        COBOLTemplateDialog.this.fTable.setSelection(new TableItem[]{COBOLTemplateDialog.this.cursor.getRow()});
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        if (COBOLTemplateDialog.this.cursor.getColumn() == 1 && COBOLTemplateDialog.this.text != null) {
                            COBOLTemplateDialog.this.captureEditedValue(COBOLTemplateDialog.this.cursor);
                        }
                    }
                });
                if (this.text != null) {
                    this.editor.setEditor((Control)this.text);
                    this.text.setFocus();
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public void captureEditedValue(TableCursor tableCursor) {
        try {
            if (this.text != null) {
                TableItem tableItem = tableCursor.getRow();
                int n = tableCursor.getColumn();
                this.fReadKey = tableItem.getText(n - 1);
                this.fEditedValue = this.text.getText();
                if (this.fEditedValue != null) {
                    tableItem.setText(n, this.fEditedValue);
                    this.fHtblParams.put(this.fReadKey, this.fEditedValue);
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public String fillTemplateWithParams() {
        String[] stringArray = new String[]{""};
        try {
            if (this.fHtblParams != null) {
                Enumeration enumeration = this.fHtblParams.keys();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    stringArray[n] = (String)enumeration.nextElement();
                }
                int n2 = 0;
                int n3 = 0;
                String string = this.fTemplatePattern;
                while (string.indexOf(PARAM_PREFIX) != -1) {
                    n2 = string.indexOf(PARAM_PREFIX);
                    n3 = string.indexOf(PARAM_SUFFIX, n2 + 2);
                    String string2 = string.substring(n2 + 2, n3);
                    String string3 = "";
                    if (string2 != null && !string2.equals("")) {
                        string3 = (String)this.fHtblParams.get(string2);
                    }
                    StringBuffer stringBuffer = new StringBuffer(string);
                    if (string3 == null || string3.equals("")) {
                        stringBuffer.replace(n2, n3 + 1, " ");
                    } else {
                        stringBuffer.replace(n2, n3 + 1, string3);
                    }
                    string = stringBuffer.toString();
                }
                return string;
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
        return null;
    }

    protected void okPressed() {
        try {
            String string = this.fillTemplateWithParams();
            if (string != null && !string.equals("")) {
                this.fTemplateViewPart.setTemplatePasteIntoEditor(string);
                this.fTemplateViewPart.pasteIntoEditor();
            }
            this.close();
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            this.close();
        }
    }

    protected void cancelPressed() {
        this.close();
    }
}

