/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.structures;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLClassBrowser;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferenceGeneralBlock;
import org.eclipse.cobol.ui.views.actions.SelectionAction;
import org.eclipse.cobol.ui.views.common.COBOLTreeLabelProvider;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.ProblemTreeViewer;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.common.TreeElementDragSourceAdapter;
import org.eclipse.cobol.ui.views.common.TreeElementDropTargetListener;
import org.eclipse.cobol.ui.views.common.TreeElementMapper;
import org.eclipse.cobol.ui.views.common.ViewsDoubleClickListener;
import org.eclipse.cobol.ui.views.common.ViewsTreeModel;
import org.eclipse.cobol.ui.views.common.ViewsUtil;
import org.eclipse.cobol.ui.views.structures.RepositoryData;
import org.eclipse.cobol.ui.views.structures.StructureFrameSource;
import org.eclipse.cobol.ui.views.structures.StructureViewActionGroup;
import org.eclipse.cobol.ui.views.structures.StructuresViewContentProvider;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class StructuresView
extends PageBookView
implements IMenuListener,
ISetSelectionTarget,
IResourceNavigator {
    private TreeViewer fTreeViewer = null;
    private FrameList fFrameList = null;
    private static ViewsTreeModel fTreeModel = null;
    private String fStrPasteIntoEditor = "";
    private Runnable fRunnable = null;
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private IDialogSettings settings;
    private static final String STORE_WORKING_SET = "ResourceWorkingSetFilter.STORE_WORKING_SET";
    private ResourcePatternFilter patternFilter = new ResourcePatternFilter();
    private static final String STORE_SORT_TYPE = "ResourceViewer.STORE_SORT_TYPE";
    private ResourceNavigatorActionGroup actionGroup;
    static final String COMMA_SEPARATOR = ",";
    static final String FILTERS_TAG = "resourceFilters";
    Menu fContextMenu = null;
    StructureViewActionGroup fStructureViewActionGroup = null;
    private boolean linkingEnabled;
    private boolean dragDetected;
    private Listener dragDetectListener;
    public IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart && COBOLEditorPreferenceGeneralBlock.isStructureLink() && StructuresView.this.fTreeViewer != null) {
                ViewsUtil.editorActivated((IEditorPart)iWorkbenchPart, StructuresView.this.fTreeViewer, ViewsTreeModel.getInstance().getRoot());
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart && COBOLEditorPreferenceGeneralBlock.isStructureLink() && StructuresView.this.fTreeViewer != null) {
                ViewsUtil.editorActivated((IEditorPart)iWorkbenchPart, StructuresView.this.fTreeViewer, ViewsTreeModel.getInstance().getRoot());
            }
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    private ISelectionChangedListener fTreeSelectionChangedListener;
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{6, 2};
    private int[] fLastSashWeights;
    private ViewsDoubleClickListener fDoubleClickListener = null;
    private ITreeViewerListener fTreeViewerListener = null;

    private void initLinkingEnabled() {
        this.linkingEnabled = COBOLEditorPreferenceGeneralBlock.isStructureLink();
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean bl) {
        this.linkingEnabled = bl;
        COBOLEditorPreferenceGeneralBlock.setStructureLink(this.linkingEnabled);
    }

    protected final IPage createDefaultPage(PageBook pageBook) {
        ViewerPage viewerPage = new ViewerPage();
        viewerPage.createControl((Composite)pageBook);
        this.initPage((IPageBookViewPage)viewerPage);
        this.fStructureViewActionGroup.fillActionBars(viewerPage.getSite().getActionBars());
        return viewerPage;
    }

    public void updateProjectRepository(String string, IProgressMonitor iProgressMonitor) {
        TreeElement treeElement = ViewsTreeModel.getInstance().getRoot().getChildFromName(string);
        RepositoryData.populateProjectRepositoryData(treeElement, iProgressMonitor);
    }

    public void updateRepository(String string, IProgressMonitor iProgressMonitor) {
    }

    private void setViewer(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
    }

    public TreeViewer getViewer() {
        return this.fTreeViewer;
    }

    public ResourceComparator getComparator() {
        return (ResourceComparator)this.fTreeViewer.getComparator();
    }

    public void setComparator(ResourceComparator resourceComparator) {
        this.fTreeViewer.setComparator((ViewerComparator)resourceComparator);
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    protected boolean isImportant(IWorkbenchPart iWorkbenchPart) {
        return false;
    }

    protected void doDestroyPage(IWorkbenchPart iWorkbenchPart, PageBookView.PageRec pageRec) {
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart iWorkbenchPart) {
        return null;
    }

    public StructuresView() {
        if (fTreeModel == null) {
            fTreeModel = ViewsTreeModel.getInstance();
        }
        this.initLinkingEnabled();
    }

    public void refresh() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.refresh();
        }
    }

    public void refreshAllViews() {
        try {
            IWorkbenchWindow[] iWorkbenchWindowArray = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray.length > 1) {
                Display display = this.getSite().getShell().getDisplay();
                display.asyncExec(this.getRunnable());
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    public Viewer createViewer(Composite composite) {
        this.fTreeViewer = new ProblemTreeViewer(composite, 770, (ViewPart)this){

            protected void createChildren(Widget widget) {
                TreeElement treeElement;
                String string;
                Object object = widget.getData();
                if (object instanceof TreeElement && ((string = (treeElement = (TreeElement)object).getAttribute("TYPE")).equalsIgnoreCase(IViewConstants.REPOSITORY_FOLDER_NAME) || string.equalsIgnoreCase(IViewConstants.REPOSITORY_CLASS_NAME))) {
                    StructuresView.this.updateRepositoryElements(treeElement);
                    Item[] itemArray = this.getChildren(widget);
                    if (itemArray != null && itemArray.length > 0) {
                        int n = 0;
                        while (n < itemArray.length) {
                            if (itemArray[n] != null && !itemArray[n].isDisposed()) {
                                itemArray[n].dispose();
                            }
                            ++n;
                        }
                    }
                }
                super.createChildren(widget);
            }
        };
        this.fTreeViewer.setContentProvider(this.createContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new COBOLTreeLabelProvider(), this.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator()));
        if (fTreeModel == null) {
            fTreeModel = ViewsTreeModel.getInstance();
        }
        this.fTreeViewer.setInput(this.findInputElement());
        this.fTreeViewer.addSelectionChangedListener(this.getTreeSelectionChangedListener());
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.createActions();
        this.refreshProjects();
        Object[] objectArray = this.getExpandedNodes(ViewsTreeModel.getInstance().getRoot().getAllChildren());
        if (objectArray != null && objectArray.length > 0) {
            this.fTreeViewer.setExpandedElements(objectArray);
        }
        this.findInputElement();
        this.updateTitle();
        if (this.fTreeViewer != null) {
            this.fTreeViewer.refresh();
        }
        this.fDoubleClickListener = new ViewsDoubleClickListener(this.fTreeViewer);
        this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this.fDoubleClickListener);
        this.fTreeViewerListener = new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                if (treeExpansionEvent.getElement() != null && treeExpansionEvent.getElement() instanceof TreeElement) {
                    StructuresView.this.setExpansionProperty((TreeElement)treeExpansionEvent.getElement(), false);
                }
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                if (treeExpansionEvent.getElement() != null && treeExpansionEvent.getElement() instanceof TreeElement) {
                    StructuresView.this.setExpansionProperty((TreeElement)treeExpansionEvent.getElement(), true);
                }
            }
        };
        this.fTreeViewer.addTreeListener(this.fTreeViewerListener);
        this.getSite().getPage().addPartListener(this.partListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cobol.ui.structure_view");
        this.initDragAndDrop();
        return this.fTreeViewer;
    }

    private void refreshProjects() {
        ArrayList arrayList = ViewsTreeModel.getInstance().getRoot().getAllChildrenOfType(IViewConstants.PROJECT_NAME);
        if (arrayList != null && arrayList.size() > 0) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            int n = 0;
            while (n < arrayList.size()) {
                TreeElement treeElement = (TreeElement)arrayList.get(n);
                IProject iProject = iWorkspace.getRoot().getProject(treeElement.getName());
                if (iProject != null && iProject.getLocation() != null && !iProject.isOpen()) {
                    treeElement.setAttribute("OPENED", "false");
                }
                if (iProject == null || iProject.getLocation() == null) {
                    RepositoryData.deleteRepositoryData(treeElement);
                }
                ++n;
            }
        }
    }

    private Object[] getExpandedNodes(ArrayList arrayList) {
        Vector vector = new Vector(10);
        try {
            Object[] objectArray = this.getExpandedNodes(arrayList, vector);
            return objectArray;
        }
        catch (Exception exception) {
        }
        finally {
            if (vector != null && vector.size() > 0) {
                vector.clear();
            }
        }
        return vector.toArray();
    }

    private Object[] getExpandedNodes(ArrayList arrayList, Vector vector) {
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                if (((TreeElement)arrayList.get(n)).getAttribute("TYPE").equals(IViewConstants.PROJECT_NAME) || ((TreeElement)arrayList.get(n)).getAttribute("TYPE").equals("SOURCE_FOLDER") || ((TreeElement)arrayList.get(n)).getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_FOLDER_NAME) || ((TreeElement)arrayList.get(n)).getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_SUBFOLDER_NAME) || ((TreeElement)arrayList.get(n)).getAttribute("TYPE").equals(IViewConstants.LINKING_FILES_FOLDER_NAME) || ((TreeElement)arrayList.get(n)).getAttribute("TYPE").equals("SOURCE_FILE") || ((TreeElement)arrayList.get(n)).getAttribute("TYPE").equals(IViewConstants.OTHER_FILES_NAME) || ((TreeElement)arrayList.get(n)).getAttribute("TYPE").equals(IViewConstants.LINKING_FILES_NAME)) {
                    if (((TreeElement)arrayList.get(n)).getAttribute("SV_EXPANDED").equalsIgnoreCase("TRUE") && ((TreeElement)arrayList.get(n)).getAttribute("OPENED").equalsIgnoreCase("TRUE") && SelectionAction.isProject((TreeElement)arrayList.get(n))) {
                        vector.add((TreeElement)arrayList.get(n));
                        this.getExpandedNodes(((TreeElement)arrayList.get(n)).getAllChildren(), vector);
                    } else if (((TreeElement)arrayList.get(n)).getAttribute("SV_EXPANDED").equalsIgnoreCase("TRUE") && !SelectionAction.isProject((TreeElement)arrayList.get(n)) && ((TreeElement)arrayList.get(n)).hasChildren()) {
                        vector.add((TreeElement)arrayList.get(n));
                        this.getExpandedNodes(((TreeElement)arrayList.get(n)).getAllChildren(), vector);
                    }
                }
                ++n;
            }
        }
        return vector.toArray();
    }

    private void updateStatusLine(IStructuredSelection iStructuredSelection) {
        String string = ViewsUtil.setOSString(ViewsUtil.getStatusLineMessage(iStructuredSelection));
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        if (this.fStructureViewActionGroup != null) {
            this.fStructureViewActionGroup.dispose();
            this.fStructureViewActionGroup = null;
        }
        if (this.fTreeSelectionChangedListener != null) {
            this.fTreeViewer.removeSelectionChangedListener(this.fTreeSelectionChangedListener);
            this.fTreeSelectionChangedListener = null;
        }
        if (this.fDoubleClickListener != null) {
            this.fTreeViewer.removeDoubleClickListener((IDoubleClickListener)this.fDoubleClickListener);
            this.fDoubleClickListener = null;
        }
        if (this.fTreeViewerListener != null) {
            this.fTreeViewer.removeTreeListener(this.fTreeViewerListener);
            this.fTreeViewerListener = null;
        }
        if (this.fFrameList != null) {
            this.fFrameList = null;
        }
        TreeElementMapper.getInstance().clearMapper(this.getViewer());
        if (this.fTreeViewer != null && this.fTreeViewer instanceof ProblemTreeViewer) {
            ((ProblemTreeViewer)this.fTreeViewer).dispose();
        }
        this.partListener = null;
        this.fTreeViewer = null;
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(ISelectionProvider.class)) {
            return this.fTreeViewer;
        }
        return super.getAdapter(clazz);
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    protected IContentProvider createContentProvider() {
        return StructuresViewContentProvider.getStructuresViewContentProvider();
    }

    protected int[] getLastSashWeights() {
        if (this.fLastSashWeights == null) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        }
        return this.fLastSashWeights;
    }

    protected void setLastSashWeights(int[] nArray) {
        this.fLastSashWeights = nArray;
    }

    protected void createActions() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.fStructureViewActionGroup = new StructureViewActionGroup(this);
    }

    public String getStringPasteIntoEditor() {
        return this.fStrPasteIntoEditor;
    }

    public void setStringPasteIntoEditor(String string) {
        if (!string.equals("")) {
            this.fStrPasteIntoEditor = string;
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        if (this.fStructureViewActionGroup != null) {
            this.fStructureViewActionGroup.createStandardGroups(iMenuManager);
            this.fStructureViewActionGroup.setContext(new ActionContext(this.getSelectionProvider().getSelection()));
            this.fStructureViewActionGroup.fillContextMenu(iMenuManager);
            this.fStructureViewActionGroup.setContext(null);
        }
    }

    protected ISelectionChangedListener getTreeSelectionChangedListener() {
        if (this.fTreeSelectionChangedListener == null) {
            this.fTreeSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    TreeElement treeElement;
                    String string;
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    StructuresView.this.updateStatusLine(iStructuredSelection);
                    final IEditorPart iEditorPart = ViewsUtil.getEditorPart(iStructuredSelection);
                    Object[] objectArray = iStructuredSelection.toArray();
                    if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof TreeElement && ViewsUtil.canHighlightElement(string = (treeElement = (TreeElement)objectArray[0]).getAttribute("TYPE")) && iEditorPart != null) {
                        StructuresView.this.dragDetected = false;
                        if (StructuresView.this.isLinkingEnabled()) {
                            StructuresView.this.getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!StructuresView.this.dragDetected) {
                                        CBDTUiPlugin.getActivePage().bringToTop((IWorkbenchPart)iEditorPart);
                                        ViewsUtil.highlightCOBOLKeyWord(iEditorPart, treeElement);
                                    }
                                }
                            });
                        }
                    }
                }
            };
        }
        return this.fTreeSelectionChangedListener;
    }

    public void deleteFile(String string, String string2, String string3) {
        if (fTreeModel != null) {
            try {
                TreeElement treeElement = fTreeModel.getRoot().getChildFromName(string);
                TreeElement treeElement2 = null;
                if (string3.equals("SOURCE_FILE")) {
                    treeElement2 = treeElement.getChildFromName("SOURCE_FOLDER").getChildFromLocation(string2);
                } else if (string3.equals(IViewConstants.OTHER_FILES_NAME)) {
                    treeElement2 = treeElement.getChildFromName(IViewConstants.OTHER_FILES_FOLDER_NAME).getChildFromLocation(string2);
                } else if (string3.equals(IViewConstants.LINKING_FILES_NAME)) {
                    treeElement2 = treeElement.getChildFromName(IViewConstants.LINKING_FILES_FOLDER_NAME).getChildFromLocation(string2);
                } else if (string3.equals(IViewConstants.PROJECT_NAME)) {
                    treeElement2 = treeElement;
                }
                if (treeElement2 != null) {
                    TreeElement treeElement3 = treeElement2.getParent();
                    treeElement2.deleteChildren();
                    treeElement3.deleteChild(treeElement2);
                    if (this.fTreeViewer != null) {
                        this.fTreeViewer.refresh();
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public Runnable getRunnable() {
        try {
            if (this.fRunnable == null) {
                this.fRunnable = new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow[] iWorkbenchWindowArray = StructuresView.this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkbenchWindows();
                        int n = 0;
                        while (n < iWorkbenchWindowArray.length) {
                            IViewPart[] iViewPartArray = ViewsUtil.getViews(iWorkbenchWindowArray[n].getActivePage());
                            int n2 = 0;
                            while (n2 < iViewPartArray.length) {
                                if (iViewPartArray[n2] instanceof StructuresView) {
                                    StructuresView structuresView = (StructuresView)iViewPartArray[n2];
                                    structuresView.refresh();
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                };
            }
            return this.fRunnable;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    public String getToolTipText(Object object) {
        IPath iPath;
        String string = "";
        string = !(object instanceof IResource) ? "" : ((iPath = ((IResource)object).getFullPath()).isRoot() ? "Dependency" : iPath.makeRelative().toOSString());
        return string;
    }

    public void updateTitle() {
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        try {
            String string = this.getConfigurationElement().getAttribute("name");
            if (iAdaptable instanceof IWorkspace || iAdaptable instanceof IWorkspaceRoot) {
                this.setTitle(string);
                this.setTitleToolTip(string);
            } else if (iAdaptable instanceof IContainer) {
                Object object;
                String string2 = "";
                if (iAdaptable instanceof IProject && (object = fTreeModel.getRoot().getChildFromName(((IProject)iAdaptable).getName())) != null) {
                    string2 = ((Project)iAdaptable).getName();
                }
                object = string;
                if (!string2.equals("")) {
                    object = String.valueOf(object) + " : " + string2;
                }
                this.setTitle((String)object);
                if (!string2.equals("")) {
                    this.setTitleToolTip(string2);
                } else {
                    this.setTitleToolTip((String)object);
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private Object findInputElement() {
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        if (iAdaptable instanceof IWorkspace || iAdaptable instanceof IWorkspaceRoot) {
            return fTreeModel;
        }
        if (iAdaptable instanceof IContainer) {
            if (iAdaptable instanceof IProject) {
                TreeElement treeElement = fTreeModel.getRoot().getChildFromName(((IProject)iAdaptable).getName());
                if (treeElement != null) {
                    return treeElement;
                }
            } else if (iAdaptable instanceof IFolder) {
                IProject iProject = ((IFolder)iAdaptable).getProject();
                TreeElement treeElement = fTreeModel.getRoot().getChildFromName(iProject.getName());
                if (treeElement != null) {
                    return treeElement;
                }
            }
        }
        return fTreeModel;
    }

    private void setExpansionProperty(TreeElement treeElement, boolean bl) {
        if (bl) {
            treeElement.setAttribute("SV_EXPANDED", "true");
        } else {
            treeElement.setAttribute("SV_EXPANDED", "false");
        }
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    private void updateRepositoryElements(TreeElement treeElement) {
        String string = treeElement.getAttribute("TYPE");
        if (string.equalsIgnoreCase(IViewConstants.REPOSITORY_FOLDER_NAME)) {
            String string2 = treeElement.getLocation();
            if (string2 != null) {
                String string3 = Messages.getString((String)"PROJECT_REPOSITORY");
                String string4 = " " + Messages.getString((String)"HYPHEN") + " ";
                String string5 = "";
                int n = -1;
                if (string3 != null && string3.length() > 0 && (n = string2.indexOf(String.valueOf(string3) + string4)) > 0) {
                    string2 = string2.substring(n + (String.valueOf(string3) + string4).length()).trim();
                    string5 = string3;
                }
                if (string2 != null && string2.length() > 0) {
                    treeElement.deleteChildren();
                    RepositoryData.updateRepositoryTree(treeElement, string2.trim(), string5.trim(), (IProgressMonitor)new NullProgressMonitor());
                }
            }
        } else if (string.equalsIgnoreCase(IViewConstants.REPOSITORY_CLASS_NAME)) {
            ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
            ICOBOLClassBrowser iCOBOLClassBrowser = null;
            if (iCOBOLContributor != null) {
                iCOBOLClassBrowser = iCOBOLContributor.getClassBrowser(treeElement.getName(), treeElement.getProject().getName());
            }
            treeElement.deleteChildren();
            if (iCOBOLClassBrowser != null) {
                if (iCOBOLClassBrowser.getSuperClasses() != null && iCOBOLClassBrowser.getSuperClasses().length > 0) {
                    int n = iCOBOLClassBrowser.getSuperClasses().length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string6 = iCOBOLClassBrowser.getSuperClasses()[n2].getSourceFileName();
                        iCOBOLClassBrowser.getSuperClasses()[n2].constructRepositoryTree(string6, treeElement.getProject().getName());
                        ++n2;
                    }
                }
                RepositoryData.constructTree(treeElement, iCOBOLClassBrowser);
                iCOBOLClassBrowser.release();
            }
        }
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        Object[] objectArray = this.fTreeViewer.getExpandedElements();
        ISelection iSelection = this.fTreeViewer.getSelection();
        this.workingSetFilter.setWorkingSet(iWorkingSet);
        if (iWorkingSet != null) {
            this.settings.put(STORE_WORKING_SET, iWorkingSet.getName());
        } else {
            this.settings.put(STORE_WORKING_SET, "");
        }
        this.updateTitle();
        this.fTreeViewer.refresh();
        this.fTreeViewer.setExpandedElements(objectArray);
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            this.fTreeViewer.reveal(iStructuredSelection.getFirstElement());
        }
    }

    public ResourcePatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    public ResourceSorter getSorter() {
        return (ResourceSorter)this.fTreeViewer.getSorter();
    }

    public void setSorter(ResourceSorter resourceSorter) {
        TreeViewer treeViewer = this.fTreeViewer;
        treeViewer.getControl().setRedraw(false);
        treeViewer.setSorter((ViewerSorter)resourceSorter);
        treeViewer.getControl().setRedraw(true);
        this.settings.put(STORE_SORT_TYPE, resourceSorter.getCriteria());
        this.updateActionBars((IStructuredSelection)treeViewer.getSelection());
    }

    protected void updateActionBars(IStructuredSelection iStructuredSelection) {
        this.getActionGroup().setContext(new ActionContext((ISelection)iStructuredSelection));
        this.getActionGroup().updateActionBars();
    }

    protected ResourceNavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public void setFiltersPreference(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(COMMA_SEPARATOR);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        this.getPlugin().getPreferenceStore().setValue(FILTERS_TAG, stringBuffer.toString());
    }

    public AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
    }

    public FrameList getFrameList() {
        if (this.fFrameList == null) {
            StructureFrameSource structureFrameSource = new StructureFrameSource(this);
            this.fFrameList = new FrameList((IFrameSource)structureFrameSource);
            structureFrameSource.connectTo(this.fFrameList);
        }
        return this.fFrameList;
    }

    public void selectReveal(ISelection iSelection) {
        StructuredSelection structuredSelection = this.convertSelection(iSelection);
        if (!structuredSelection.isEmpty()) {
            this.getViewer().getControl().setRedraw(false);
            this.getViewer().setSelection((ISelection)structuredSelection, true);
            this.getViewer().getControl().setRedraw(true);
        }
    }

    private StructuredSelection convertSelection(ISelection iSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
                }
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
        }
        return new StructuredSelection(arrayList);
    }

    private void initDragAndDrop() {
        int n = 3;
        Transfer[] transferArray = new Transfer[]{FileTransfer.getInstance()};
        TreeElementDragSourceAdapter treeElementDragSourceAdapter = null;
        TreeViewer treeViewer = this.getViewer();
        treeElementDragSourceAdapter = new TreeElementDragSourceAdapter(treeViewer);
        treeViewer.addDragSupport(n, transferArray, (DragSourceListener)treeElementDragSourceAdapter);
        n = 19;
        DropTarget dropTarget = new DropTarget(treeViewer.getControl(), n);
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener((DropTargetListener)new TreeElementDropTargetListener(treeElementDragSourceAdapter, this.getViewer()));
    }

    private class ViewerPage
    extends Page {
        private Control fControl = null;

        private ViewerPage() {
        }

        public void createControl(Composite composite) {
            TreeViewer treeViewer = (TreeViewer)StructuresView.this.createViewer(composite);
            StructuresView.this.setViewer(treeViewer);
            this.fControl = treeViewer.getControl();
        }

        public Control getControl() {
            return this.fControl;
        }

        public void setFocus() {
            try {
                Control control;
                TreeViewer treeViewer = StructuresView.this.getViewer();
                if (treeViewer != null && !(control = treeViewer.getControl()).isFocusControl()) {
                    control.setFocus();
                }
            }
            catch (SWTException sWTException) {
                CBDTUiPlugin.logError((Exception)((Object)sWTException));
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }
}

