/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.structures;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLCILMethod;
import org.eclipse.cobol.core.common.ICOBOLClassBrowser;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.common.IViewConstants;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public final class RepositoryData {
    protected static final String CLOSE_BRACKET = ")";

    public static void deleteRepositoryData(TreeElement treeElement) {
        ArrayList arrayList;
        if (treeElement != null && (arrayList = treeElement.getAllChildrenOfType(IViewConstants.REPOSITORY_FOLDER_NAME)) != null && arrayList.size() > 0) {
            int n = 0;
            while (n < arrayList.size()) {
                RepositoryData.deleteNodes(treeElement, (TreeElement)arrayList.get(n));
                ++n;
            }
        }
    }

    private static void deleteNodes(TreeElement treeElement, TreeElement treeElement2) {
        ResourcesPlugin.getWorkspace().getRoot().getProject(treeElement.getName());
        if (treeElement2 != null) {
            if (treeElement2.hasChildren()) {
                ArrayList arrayList = treeElement2.getAllChildren();
                int n = 0;
                while (n < arrayList.size()) {
                    RepositoryData.deleteNodes(treeElement2, (TreeElement)arrayList.get(n));
                    ++n;
                }
            }
            treeElement.deleteChild(treeElement2);
        }
    }

    public static void populateRepositoryData(TreeElement treeElement) {
        RepositoryData.populateRepositoryData(treeElement, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void populateRepositoryData(TreeElement treeElement, IProgressMonitor iProgressMonitor) {
        if (treeElement != null) {
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(treeElement.getName());
            try {
                if (iProject != null && iProject.getLocation() != null && iProject.isOpen()) {
                    String string = iProject.getLocation().toOSString();
                    iProgressMonitor.beginTask(Messages.getString((String)"RepositoryData.UpdateRepository"), 5);
                    iProgressMonitor.setTaskName(Messages.getString((String)"RepositoryData.UpdateProjectFolder"));
                    if (string != null && !string.equals("")) {
                        RepositoryData.constructRepositoryTree(treeElement, String.valueOf(string) + File.separator, Messages.getString((String)"PROJECT_REPOSITORY"), iProgressMonitor);
                    }
                    iProgressMonitor.worked(1);
                    iProgressMonitor.done();
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public static void populateRepositoryDataWithoutElement(TreeElement treeElement) {
        if (treeElement != null) {
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(treeElement.getName());
            try {
                String string;
                if (iProject != null && iProject.getLocation() != null && iProject.isOpen() && (string = iProject.getLocation().toOSString()) != null && !string.equals("")) {
                    RepositoryData.constructRepositoryTreeWithDummyChild(treeElement, String.valueOf(string) + File.separator, Messages.getString((String)"PROJECT_REPOSITORY"));
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    private static void constructRepositoryTreeWithDummyChild(TreeElement treeElement, String string, String string2) {
        if (treeElement.getChildFromLocation(String.valueOf(Messages.getString((String)"COBOL")) + Messages.getString((String)"HYPHEN") + string2 + " " + Messages.getString((String)"HYPHEN") + " " + string) != null) {
            return;
        }
        TreeElement treeElement2 = treeElement.addChild(String.valueOf(Messages.getString((String)"COBOL")) + Messages.getString((String)"HYPHEN") + string2 + " " + Messages.getString((String)"HYPHEN") + " " + string, "Repository", IViewConstants.REPOSITORY_FOLDER_NAME, false);
        treeElement2.addChild("Repository Classes not available", "Repository Classes not available", "DUMMYY", false);
    }

    public static void populateProjectRepositoryData(TreeElement treeElement, IProgressMonitor iProgressMonitor) {
        if (treeElement != null) {
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(treeElement.getName());
            try {
                if (iProject != null && iProject.getLocation() != null && iProject.isOpen()) {
                    String string = iProject.getLocation().toOSString();
                    iProgressMonitor.setTaskName(Messages.getString((String)"RepositoryData.UpdateProjectFolder"));
                    if (string != null && !string.equals("")) {
                        TreeElement treeElement2 = treeElement.getChildFromLocation(String.valueOf(Messages.getString((String)"COBOL")) + Messages.getString((String)"HYPHEN") + Messages.getString((String)"PROJECT_REPOSITORY") + " " + Messages.getString((String)"HYPHEN") + " " + string + File.separator);
                        if (treeElement2 != null) {
                            if (treeElement2.hasChildren()) {
                                treeElement2.deleteChildren();
                            }
                            treeElement.deleteChild(treeElement2);
                        }
                        RepositoryData.constructRepositoryTree(treeElement, String.valueOf(string) + File.separator, Messages.getString((String)"PROJECT_REPOSITORY"), iProgressMonitor);
                    }
                }
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
    }

    public static void updateRepositoryTree(TreeElement treeElement, String string, String string2, IProgressMonitor iProgressMonitor) {
        String string3 = "";
        ICOBOLClassBrowser iCOBOLClassBrowser = null;
        try {
            TreeElement treeElement2 = treeElement.getProject();
            File file = new File(string);
            File[] fileArray = null;
            fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return;
            }
            try {
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (fileArray[n2].getName().endsWith(Messages.getString((String)".rep")) || fileArray[n2].getName().endsWith(Messages.getString((String)".REP"))) {
                        string3 = fileArray[n2].getName().indexOf(Messages.getString((String)".REP")) == -1 ? fileArray[n2].getName().substring(0, fileArray[n2].getName().indexOf(Messages.getString((String)".rep"))) : fileArray[n2].getName().substring(0, fileArray[n2].getName().indexOf(Messages.getString((String)".REP")));
                        iProgressMonitor.subTask(string3);
                        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
                        if (iCOBOLContributor != null) {
                            iProgressMonitor.subTask(string3);
                            iCOBOLClassBrowser = iCOBOLContributor.getClassBrowser(String.valueOf(string) + string3, treeElement2.getName());
                            TreeElement treeElement3 = treeElement.addChild(iCOBOLClassBrowser.getSourceFileName(), iCOBOLClassBrowser.getSourceFileName(), IViewConstants.REPOSITORY_CLASS_NAME);
                            RepositoryData.constructTree(treeElement3, iCOBOLClassBrowser);
                            if (iCOBOLClassBrowser != null) {
                                iCOBOLClassBrowser.release();
                                iCOBOLClassBrowser = null;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (SecurityException securityException) {
                CBDTUiPlugin.logError(securityException);
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
        finally {
            if (iCOBOLClassBrowser != null) {
                iCOBOLClassBrowser.release();
                iCOBOLClassBrowser = null;
            }
        }
    }

    public static void constructRepositoryTree(TreeElement treeElement, String string, String string2, IProgressMonitor iProgressMonitor) {
        String string3 = "";
        ICOBOLClassBrowser iCOBOLClassBrowser = null;
        try {
            if (treeElement.getChildFromLocation(String.valueOf(Messages.getString((String)"COBOL")) + Messages.getString((String)"HYPHEN") + string2 + " " + Messages.getString((String)"HYPHEN") + " " + string) != null) {
                return;
            }
            TreeElement treeElement2 = treeElement.addChild(String.valueOf(Messages.getString((String)"COBOL")) + Messages.getString((String)"HYPHEN") + string2 + " " + Messages.getString((String)"HYPHEN") + " " + string, "Repository", IViewConstants.REPOSITORY_FOLDER_NAME, false);
            File file = new File(string);
            File[] fileArray = null;
            fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return;
            }
            try {
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (fileArray[n2].getName().endsWith(Messages.getString((String)".rep")) || fileArray[n2].getName().endsWith(Messages.getString((String)".REP"))) {
                        string3 = fileArray[n2].getName().indexOf(Messages.getString((String)".REP")) == -1 ? fileArray[n2].getName().substring(0, fileArray[n2].getName().indexOf(Messages.getString((String)".rep"))) : fileArray[n2].getName().substring(0, fileArray[n2].getName().indexOf(Messages.getString((String)".REP")));
                        iProgressMonitor.subTask(string3);
                        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
                        if (iCOBOLContributor != null) {
                            iProgressMonitor.subTask(string3);
                            iCOBOLClassBrowser = iCOBOLContributor.getClassBrowser(String.valueOf(string) + string3, treeElement.getName());
                            TreeElement treeElement3 = treeElement2.addChild(iCOBOLClassBrowser.getSourceFileName(), iCOBOLClassBrowser.getSourceFileName(), IViewConstants.REPOSITORY_CLASS_NAME);
                            RepositoryData.constructTree(treeElement3, iCOBOLClassBrowser);
                            if (iCOBOLClassBrowser != null) {
                                iCOBOLClassBrowser.release();
                                iCOBOLClassBrowser = null;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (SecurityException securityException) {
                CBDTUiPlugin.logError(securityException);
            }
            catch (NullPointerException nullPointerException) {
                CBDTUiPlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CBDTUiPlugin.logError(exception);
            }
        }
        finally {
            if (iCOBOLClassBrowser != null) {
                iCOBOLClassBrowser.release();
                iCOBOLClassBrowser = null;
            }
        }
    }

    public static void constructTree(TreeElement treeElement, ICOBOLClassBrowser iCOBOLClassBrowser) {
        String string;
        Object object;
        int n;
        int n2;
        String[] stringArray = null;
        ArrayList<String> arrayList = null;
        HashMap<String, ICOBOLCILMethod> hashMap = null;
        if (iCOBOLClassBrowser.getSuperClasses() != null && iCOBOLClassBrowser.getSuperClasses().length > 0) {
            n2 = iCOBOLClassBrowser.getSuperClasses().length;
            n = 0;
            while (n < n2) {
                object = iCOBOLClassBrowser.getSuperClasses()[n].getSourceFileName();
                Vector vector = iCOBOLClassBrowser.getPaths(treeElement.getProject().getName());
                string = treeElement.getIProject().getLocation().toString();
                if (vector != null && vector.size() > 0) {
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        TreeElement treeElement2;
                        Path path = new Path((String)vector.get(n3));
                        if ((path = path.append(String.valueOf(File.separator) + (String)object + ".rep")).toFile().exists()) {
                            treeElement2 = null;
                            treeElement2 = string.equalsIgnoreCase((String)vector.get(n3)) ? treeElement.addChild((String)object, (String)object, IViewConstants.REPOSITORY_CLASS_NAME, false) : treeElement.addChild((String)vector.get(n3), (String)object, IViewConstants.REPOSITORY_CLASS_NAME, false);
                            RepositoryData.constructTree(treeElement2, iCOBOLClassBrowser.getSuperClasses()[n]);
                            break;
                        }
                        path = new Path((String)vector.get(n3));
                        if ((path = path.append(String.valueOf(File.separator) + (String)object + ".REP")).toFile().exists()) {
                            treeElement2 = null;
                            treeElement2 = string.equalsIgnoreCase((String)vector.get(n3)) ? treeElement.addChild((String)object, (String)object, IViewConstants.REPOSITORY_CLASS_NAME, false) : treeElement.addChild((String)vector.get(n3), (String)object, IViewConstants.REPOSITORY_CLASS_NAME, false);
                            RepositoryData.constructTree(treeElement2, iCOBOLClassBrowser.getSuperClasses()[n]);
                            break;
                        }
                        ++n3;
                    }
                } else {
                    TreeElement treeElement3 = treeElement.addChild((String)object, (String)object, IViewConstants.REPOSITORY_CLASS_NAME, false);
                    RepositoryData.constructTree(treeElement3, iCOBOLClassBrowser.getSuperClasses()[n]);
                }
                ++n;
            }
        }
        if (iCOBOLClassBrowser != null && iCOBOLClassBrowser.getFactoryProperties() != null && iCOBOLClassBrowser.getFactoryProperties().length > 0) {
            n2 = iCOBOLClassBrowser.getFactoryProperties().length;
            stringArray = iCOBOLClassBrowser.getFactoryProperties();
            arrayList = new ArrayList<String>(n2);
            n = 0;
            while (n < n2) {
                arrayList.add(stringArray[n]);
                ++n;
            }
            Collections.sort(arrayList);
            n = 0;
            while (n < n2) {
                object = (String)arrayList.get(n);
                treeElement.addChild((String)object, (String)object, IViewConstants.FACTORY_PROPERTY_NAME, false);
                ++n;
            }
            stringArray = null;
            arrayList = null;
        }
        if (iCOBOLClassBrowser.getFactoryMethods() != null && iCOBOLClassBrowser.getFactoryMethods().length > 0) {
            n2 = iCOBOLClassBrowser.getFactoryMethods().length;
            ICOBOLCILMethod[] iCOBOLCILMethodArray = iCOBOLClassBrowser.getFactoryMethods();
            hashMap = new HashMap<String, ICOBOLCILMethod>(n2);
            arrayList = new ArrayList(n2);
            int n4 = 0;
            while (n4 < n2) {
                arrayList.add(iCOBOLCILMethodArray[n4].getMethodName());
                hashMap.put(iCOBOLCILMethodArray[n4].getMethodName(), iCOBOLCILMethodArray[n4]);
                ++n4;
            }
            Collections.sort(arrayList);
            object = new ICOBOLCILMethod[n2];
            int n5 = 0;
            while (n5 < n2) {
                object[n5] = (ICOBOLCILMethod)hashMap.get((String)arrayList.get(n5));
                ++n5;
            }
            n5 = 0;
            while (n5 < n2) {
                TreeElement treeElement4;
                string = object[n5].getMethodName();
                if (object[n5].getSourceUnit() < 0) {
                    treeElement4 = treeElement.getChildFromName(string);
                    if (treeElement4 != null && object[n5].getRetParamDataItem().getPictureItem().length() > 0) {
                        treeElement4.setAttribute("RETURN_PARAMETER", object[n5].getRetParamDataItem());
                    }
                } else {
                    treeElement4 = treeElement.addChild(string, string, IViewConstants.FACTORY_METHOD_NAME, false);
                    if (object[n5].getRetParamDataItem() != null) {
                        treeElement4.setAttribute("RETURN_PARAMETER", object[n5].getRetParamDataItem());
                    }
                    if (object[n5].getUsingParamDataItems() != null && object[n5].getUsingParamDataItems().length > 0) {
                        int n6 = object[n5].getUsingParamDataItems().length;
                        if (n6 != 0) {
                            treeElement4.setAttribute("NO_OF_INPUT_PARAMETERS", Integer.toString(n6));
                        } else {
                            treeElement4.setAttribute("NO_OF_INPUT_PARAMETERS", Integer.toString(0));
                        }
                        int n7 = 0;
                        while (n7 < n6) {
                            treeElement4.setAttribute("INPUT_PARAMETER" + n7, object[n5].getUsingParamDataItems()[n7]);
                            ++n7;
                        }
                    }
                }
                ++n5;
            }
            hashMap = null;
            arrayList = null;
            iCOBOLCILMethodArray = null;
            object = null;
        }
        if (iCOBOLClassBrowser != null && iCOBOLClassBrowser.getObjectProperties() != null && iCOBOLClassBrowser.getObjectProperties().length > 0) {
            n2 = iCOBOLClassBrowser.getObjectProperties().length;
            stringArray = iCOBOLClassBrowser.getObjectProperties();
            arrayList = new ArrayList(n2);
            int n8 = 0;
            while (n8 < n2) {
                arrayList.add(stringArray[n8]);
                ++n8;
            }
            Collections.sort(arrayList);
            n8 = 0;
            while (n8 < n2) {
                object = (String)arrayList.get(n8);
                treeElement.addChild((String)object, (String)object, IViewConstants.OBJECT_PROPERTY_NAME, false);
                ++n8;
            }
            arrayList = null;
            stringArray = null;
        }
        if (iCOBOLClassBrowser.getObjectMethods() != null && iCOBOLClassBrowser.getObjectMethods().length > 0) {
            ICOBOLCILMethod[] iCOBOLCILMethodArray = iCOBOLClassBrowser.getObjectMethods();
            int n9 = iCOBOLCILMethodArray.length;
            hashMap = new HashMap(n9);
            arrayList = new ArrayList(n9);
            int n10 = 0;
            while (n10 < n9) {
                arrayList.add(iCOBOLCILMethodArray[n10].getMethodName());
                hashMap.put(iCOBOLCILMethodArray[n10].getMethodName(), iCOBOLCILMethodArray[n10]);
                ++n10;
            }
            Collections.sort(arrayList);
            ICOBOLCILMethod[] iCOBOLCILMethodArray2 = new ICOBOLCILMethod[n9];
            int n11 = 0;
            while (n11 < n9) {
                iCOBOLCILMethodArray2[n11] = (ICOBOLCILMethod)hashMap.get((String)arrayList.get(n11));
                ++n11;
            }
            n11 = 0;
            while (n11 < n9) {
                TreeElement treeElement5;
                string = iCOBOLCILMethodArray2[n11].getMethodName();
                if (iCOBOLCILMethodArray2[n11].getSourceUnit() < 0) {
                    treeElement5 = treeElement.getChildFromName(string);
                    if (treeElement5 != null && iCOBOLCILMethodArray2[n11].getRetParamDataItem().getPictureItem().length() > 0) {
                        treeElement5.setAttribute("RETURN_PARAMETER", iCOBOLCILMethodArray2[n11].getRetParamDataItem());
                    }
                } else {
                    treeElement5 = treeElement.addChild(string, string, IViewConstants.OBJECT_METHOD_NAME, false);
                    if (iCOBOLCILMethodArray2[n11].getRetParamDataItem() != null) {
                        treeElement5.setAttribute("RETURN_PARAMETER", iCOBOLCILMethodArray2[n11].getRetParamDataItem());
                    }
                    if (iCOBOLCILMethodArray2[n11].getUsingParamDataItems() != null && iCOBOLCILMethodArray2[n11].getUsingParamDataItems().length > 0) {
                        int n12 = iCOBOLCILMethodArray2[n11].getUsingParamDataItems().length;
                        if (n12 > 0) {
                            treeElement5.setAttribute("NO_OF_INPUT_PARAMETERS", Integer.toString(n12));
                            int n13 = 0;
                            while (n13 < n12) {
                                treeElement5.setAttribute("INPUT_PARAMETER" + n13, iCOBOLCILMethodArray2[n11].getUsingParamDataItems()[n13]);
                                ++n13;
                            }
                        } else {
                            treeElement5.setAttribute("NO_OF_INPUT_PARAMETERS", Integer.toString(0));
                        }
                    }
                }
                ++n11;
            }
            hashMap.clear();
            hashMap = null;
            arrayList.clear();
            arrayList = null;
            iCOBOLCILMethodArray = null;
            iCOBOLCILMethodArray2 = null;
        }
    }
}

