/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.structures;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.core.common.ICOBOLCILDataItem;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.cobol.ui.views.structures.CreateControls;
import org.eclipse.cobol.ui.views.structures.ParameterDetails;
import org.eclipse.cobol.ui.views.structures.StructuresView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MethodDetails
extends Dialog {
    private Label fLabelMethodBody;
    private Label fLabelObjectName;
    private Label fLabelReturn;
    private Label fLabelParameterName;
    private Label fLabelParameterNameData;
    private Label fLabelTypeName;
    private Label fLabelTypeNameData;
    private Text fTextObjectName = null;
    private Text fTextReturn = null;
    private int fParametersCount = 0;
    private String fStringMethodBody = "";
    private String fStringObjectNameData = "";
    private String fStringMethodNameData = "";
    private String fStringMethodTypeData = "";
    private String fStringReturnData = "";
    private String fStringReturnDataType = "";
    private Button fBtnObjectName;
    private Button fBtnReturn;
    private String[] fParameters = new String[]{""};
    private String[] fParamDataTypes = new String[]{""};
    private Label[] fLabelInputParams = null;
    private Text[] fTextInputParams = null;
    private Button[] fBtnInputParams = null;
    private StructuresView fStructuresView;
    private Image fImageEnabled = null;
    private Image fImageDisabled = null;
    private int[] fDataForms = null;
    private static final int DATA_FORM_OBJECT_REFERENCE = 19;
    private static final String OBJECT_REFERENCE_CLASS_NAME = "";

    public MethodDetails(Shell shell) {
        super(shell);
    }

    public MethodDetails(Shell shell, String string, String string2, TreeElement treeElement, StructuresView structuresView) {
        super(shell);
        this.fStringMethodNameData = string;
        this.fStringMethodTypeData = string2;
        this.fStructuresView = structuresView;
        try {
            ICOBOLCILDataItem iCOBOLCILDataItem;
            if (treeElement.getDataAttribute("RETURN_PARAMETER") != null && (iCOBOLCILDataItem = treeElement.getDataAttribute("RETURN_PARAMETER")) != null) {
                this.fStringReturnData = iCOBOLCILDataItem.getDataItemName();
                this.fStringReturnDataType = iCOBOLCILDataItem.getPictureItem();
            }
            if (treeElement.getAttribute("NO_OF_INPUT_PARAMETERS") != null) {
                this.fParametersCount = Integer.parseInt(treeElement.getAttribute("NO_OF_INPUT_PARAMETERS"));
                if (this.fParametersCount > 0) {
                    this.fParameters = new String[this.fParametersCount];
                    this.fParamDataTypes = new String[this.fParametersCount];
                    this.fLabelInputParams = new Label[this.fParametersCount];
                    this.fTextInputParams = new Text[this.fParametersCount];
                    this.fBtnInputParams = new Button[this.fParametersCount];
                    this.fDataForms = new int[this.fParametersCount];
                    int n = 0;
                    while (n < this.fParametersCount) {
                        ICOBOLCILDataItem iCOBOLCILDataItem2 = treeElement.getDataAttribute("INPUT_PARAMETER" + n);
                        this.fParameters[n] = iCOBOLCILDataItem2.getDataItemName();
                        this.fParamDataTypes[n] = iCOBOLCILDataItem2.getPictureItem() != null && !iCOBOLCILDataItem2.getPictureItem().equals(OBJECT_REFERENCE_CLASS_NAME) ? iCOBOLCILDataItem2.getPictureItem() : OBJECT_REFERENCE_CLASS_NAME;
                        this.fDataForms[n] = iCOBOLCILDataItem2.getDataForm();
                        ++n;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            CBDTUiPlugin.logError(numberFormatException);
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        this.fImageEnabled = COBOLPluginImages.get("org.eclipse.cobol.ui.ReferenceButton.gif");
        this.fImageDisabled = COBOLPluginImages.get("org.eclipse.cobol.ui.ReferenceButtonGray.gif");
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString((String)"AddMethod"));
    }

    private Label createMethodLabel(Composite composite, String string, int n) {
        Label label = new Label(composite, 16384);
        label.setFont(composite.getFont());
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        gridData.widthHint = n;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Control createDialogArea(Composite composite) {
        try {
            CreateControls createControls = new CreateControls();
            Composite composite2 = createControls.createComposite(composite, 1);
            Group group = createControls.createGroupComposite(composite2, 1);
            group.setText(Messages.getString((String)"Group1"));
            this.fStringMethodBody = this.getMethodBody(this.fStringObjectNameData, this.fStringMethodNameData, this.fParameters, this.fStringReturnData);
            this.fLabelMethodBody = this.createMethodLabel((Composite)group, this.fStringMethodBody, 350);
            Group group2 = createControls.createGroupComposite(composite2, 1);
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)group2, 2816);
            scrolledComposite.setFont(group2.getFont());
            Composite composite3 = new Composite((Composite)scrolledComposite, 0);
            composite3.setFont(scrolledComposite.getFont());
            scrolledComposite.setContent((Control)composite3);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite3.setLayout((Layout)gridLayout);
            group2.setText(Messages.getString((String)"Parameter"));
            this.fLabelObjectName = createControls.createLabel(composite3, Messages.getString((String)"ObjectName"));
            this.fTextObjectName = createControls.createTextField(composite3);
            this.fTextObjectName.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                    MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextObjectName.getText());
                    MethodDetails.this.fLabelTypeNameData.setText("--");
                    if (MethodDetails.this.fTextReturn != null) {
                        MethodDetails.this.fStringReturnData = MethodDetails.this.fTextReturn.getText();
                    } else {
                        MethodDetails.this.fStringReturnData = MethodDetails.OBJECT_REFERENCE_CLASS_NAME;
                    }
                    MethodDetails.this.fStringMethodBody = MethodDetails.this.getMethodBody(MethodDetails.this.fTextObjectName.getText(), MethodDetails.this.fStringMethodNameData, MethodDetails.this.fParameters, MethodDetails.this.fStringReturnData);
                    MethodDetails.this.fLabelMethodBody.setText(MethodDetails.this.fStringMethodBody);
                }
            });
            this.fTextObjectName.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextObjectName.getText());
                    MethodDetails.this.fLabelTypeNameData.setText("--");
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.fBtnObjectName = createControls.createPushButton(composite3, Messages.getString((String)"ButtonObjectName"));
            this.fBtnObjectName.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextObjectName.getText());
                    MethodDetails.this.fLabelTypeNameData.setText("--");
                    MethodDetails.this.getParameterListDialog(MethodDetails.this.fTextObjectName, 19);
                    if (MethodDetails.this.fTextReturn != null) {
                        MethodDetails.this.fStringReturnData = MethodDetails.this.fTextReturn.getText();
                    } else {
                        MethodDetails.this.fStringReturnData = MethodDetails.OBJECT_REFERENCE_CLASS_NAME;
                    }
                    if (MethodDetails.this.fTextObjectName != null) {
                        MethodDetails.this.fStringObjectNameData = MethodDetails.this.fTextObjectName.getText();
                    } else {
                        MethodDetails.this.fStringObjectNameData = MethodDetails.OBJECT_REFERENCE_CLASS_NAME;
                    }
                    MethodDetails.this.fStringMethodBody = MethodDetails.this.getMethodBody(MethodDetails.this.fStringObjectNameData, MethodDetails.this.fStringMethodNameData, MethodDetails.this.fParameters, MethodDetails.this.fStringReturnData);
                    MethodDetails.this.fLabelMethodBody.setText(MethodDetails.this.fStringMethodBody);
                }
            });
            this.fBtnObjectName.setImage(this.fImageEnabled);
            if (this.fParametersCount > 0) {
                this.createParameterInput(createControls, composite3);
            }
            if (!this.fStringReturnData.equals(OBJECT_REFERENCE_CLASS_NAME)) {
                this.fLabelReturn = createControls.createLabel(composite3, Messages.getString((String)"ReturnItem"));
                this.fTextReturn = createControls.createTextField(composite3);
                this.fTextReturn.setText(this.fStringReturnData);
                this.fTextReturn.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent keyEvent) {
                    }

                    public void keyReleased(KeyEvent keyEvent) {
                        if (MethodDetails.this.fTextObjectName != null) {
                            MethodDetails.this.fStringObjectNameData = MethodDetails.this.fTextObjectName.getText();
                        } else {
                            MethodDetails.this.fStringObjectNameData = MethodDetails.OBJECT_REFERENCE_CLASS_NAME;
                        }
                        MethodDetails.this.fStringMethodBody = MethodDetails.this.getMethodBody(MethodDetails.this.fStringObjectNameData, MethodDetails.this.fStringMethodNameData, MethodDetails.this.fParameters, MethodDetails.this.fTextReturn.getText());
                        MethodDetails.this.fLabelMethodBody.setText(MethodDetails.this.fStringMethodBody);
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                        MethodDetails.this.fLabelTypeNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextReturn.getText());
                        if (!MethodDetails.this.fStringReturnDataType.equals(MethodDetails.OBJECT_REFERENCE_CLASS_NAME)) {
                            MethodDetails.this.fLabelTypeNameData.setText(String.valueOf(Messages.getString((String)"PIC")) + " " + MethodDetails.this.fStringReturnDataType);
                        } else {
                            MethodDetails.this.fLabelTypeNameData.setText("--");
                        }
                    }
                });
                this.fTextReturn.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent focusEvent) {
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                        MethodDetails.this.fLabelTypeNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextReturn.getText());
                        if (!MethodDetails.this.fStringReturnDataType.equals(MethodDetails.OBJECT_REFERENCE_CLASS_NAME)) {
                            MethodDetails.this.fLabelTypeNameData.setText(String.valueOf(Messages.getString((String)"PIC")) + " " + MethodDetails.this.fStringReturnDataType);
                        } else {
                            MethodDetails.this.fLabelTypeNameData.setText("--");
                        }
                    }

                    public void focusLost(FocusEvent focusEvent) {
                    }
                });
                this.fBtnReturn = createControls.createPushButton(composite3, Messages.getString((String)"ButtonReturn"));
                this.fBtnReturn.setImage(this.fImageDisabled);
                this.fBtnReturn.setEnabled(false);
            }
            Composite composite4 = createControls.createComposite((Composite)group2, 2, 0, 0);
            this.fLabelParameterName = createControls.createLabel(composite4, Messages.getString((String)"ParameterName"));
            this.fLabelParameterNameData = this.createMethodLabel(composite4, OBJECT_REFERENCE_CLASS_NAME, 230);
            this.fLabelTypeName = createControls.createLabel(composite4, Messages.getString((String)"TypeName"));
            this.fLabelTypeNameData = this.createMethodLabel(composite4, OBJECT_REFERENCE_CLASS_NAME, 230);
            Point point = composite3.computeSize(-1, -1);
            composite3.setSize(point);
            GridData gridData = new GridData();
            gridData.widthHint = Math.min(point.x, 400);
            gridData.heightHint = Math.min(point.y, 225);
            scrolledComposite.setLayoutData((Object)gridData);
            composite.layout();
            return composite2;
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
            return null;
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return null;
        }
    }

    private void createParameterInput(CreateControls createControls, Composite composite) {
        int n = this.fParameters.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            this.fLabelInputParams[n2] = createControls.createLabel(composite, String.valueOf(Messages.getString((String)"Parameter")) + " " + n3 + " :");
            this.fTextInputParams[n2] = createControls.createTextField(composite);
            this.fTextInputParams[n2].setText(this.fParameters[n2]);
            final int n4 = n2;
            this.fTextInputParams[n2].addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                    try {
                        ((MethodDetails)MethodDetails.this).fParameters[n4] = MethodDetails.this.fTextInputParams[n4].getText();
                        if (MethodDetails.this.fTextObjectName != null) {
                            MethodDetails.this.fStringObjectNameData = MethodDetails.this.fTextObjectName.getText();
                        } else {
                            MethodDetails.this.fStringObjectNameData = MethodDetails.OBJECT_REFERENCE_CLASS_NAME;
                        }
                        if (MethodDetails.this.fTextReturn != null) {
                            MethodDetails.this.fStringReturnData = MethodDetails.this.fTextReturn.getText();
                        } else {
                            MethodDetails.this.fStringReturnData = MethodDetails.OBJECT_REFERENCE_CLASS_NAME;
                        }
                        MethodDetails.this.fStringMethodBody = MethodDetails.this.getMethodBody(MethodDetails.this.fStringObjectNameData, MethodDetails.this.fStringMethodNameData, MethodDetails.this.fParameters, MethodDetails.this.fStringReturnData);
                        MethodDetails.this.fLabelMethodBody.setText(MethodDetails.this.fStringMethodBody);
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                        MethodDetails.this.fLabelTypeNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextInputParams[n4].getText());
                        if (!MethodDetails.this.fParamDataTypes[n4].equals(MethodDetails.OBJECT_REFERENCE_CLASS_NAME)) {
                            MethodDetails.this.fLabelTypeNameData.setText("PIC " + MethodDetails.this.fParamDataTypes[n4]);
                        } else {
                            MethodDetails.this.fLabelTypeNameData.setText("--");
                        }
                    }
                    catch (Exception exception) {
                        CBDTUiPlugin.logError(exception);
                    }
                }
            });
            this.fTextInputParams[n2].addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                    MethodDetails.this.fLabelTypeNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                    MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextInputParams[n4].getText());
                    if (!MethodDetails.this.fParamDataTypes[n4].equals(MethodDetails.OBJECT_REFERENCE_CLASS_NAME)) {
                        MethodDetails.this.fLabelTypeNameData.setText(String.valueOf(Messages.getString((String)"PIC")) + " " + MethodDetails.this.fParamDataTypes[n4]);
                    } else {
                        MethodDetails.this.fLabelTypeNameData.setText("--");
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.fBtnInputParams[n2] = createControls.createPushButton(composite, Messages.getString((String)"ButtonInputParam"));
            this.fBtnInputParams[n2].setImage(this.fImageEnabled);
            if (this.fDataForms[n4] == 9 || this.fDataForms[n4] == 25 || this.fDataForms[n4] < 1 || this.fDataForms[n4] > 25) {
                this.fBtnInputParams[n2].setImage(this.fImageDisabled);
                this.fBtnInputParams[n2].setEnabled(false);
            } else {
                this.fBtnInputParams[n2].setImage(this.fImageEnabled);
                this.fBtnInputParams[n2].addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                        MethodDetails.this.fLabelTypeNameData.setText(MethodDetails.OBJECT_REFERENCE_CLASS_NAME);
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextInputParams[n4].getText());
                        if (!MethodDetails.this.fParamDataTypes[n4].equals(MethodDetails.OBJECT_REFERENCE_CLASS_NAME)) {
                            MethodDetails.this.fLabelTypeNameData.setText(String.valueOf(Messages.getString((String)"PIC")) + " " + MethodDetails.this.fParamDataTypes[n4]);
                        } else {
                            MethodDetails.this.fLabelTypeNameData.setText("--");
                        }
                        MethodDetails.this.getParameterListDialog(MethodDetails.this.fTextInputParams[n4], MethodDetails.this.fDataForms[n4]);
                        ((MethodDetails)MethodDetails.this).fParameters[n4] = MethodDetails.this.fTextInputParams[n4].getText();
                        if (MethodDetails.this.fTextObjectName != null) {
                            MethodDetails.this.fStringObjectNameData = MethodDetails.this.fTextObjectName.getText();
                        } else {
                            MethodDetails.this.fStringObjectNameData = MethodDetails.OBJECT_REFERENCE_CLASS_NAME;
                        }
                        if (MethodDetails.this.fTextReturn != null) {
                            MethodDetails.this.fStringReturnData = MethodDetails.this.fTextReturn.getText();
                        } else {
                            MethodDetails.this.fStringReturnData = MethodDetails.OBJECT_REFERENCE_CLASS_NAME;
                        }
                        MethodDetails.this.fStringMethodBody = MethodDetails.this.getMethodBody(MethodDetails.this.fStringObjectNameData, MethodDetails.this.fStringMethodNameData, MethodDetails.this.fParameters, MethodDetails.this.fStringReturnData);
                        MethodDetails.this.fLabelMethodBody.setText(MethodDetails.this.fStringMethodBody);
                        MethodDetails.this.fLabelParameterNameData.setText(MethodDetails.this.fTextInputParams[n4].getText());
                    }
                });
            }
            ++n2;
        }
    }

    public String getMethodBody(String string, String string2, String[] stringArray, String string3) {
        this.fStringObjectNameData = string;
        this.fStringMethodNameData = string2;
        this.fParameters = stringArray;
        this.fStringReturnData = string3;
        String string4 = OBJECT_REFERENCE_CLASS_NAME;
        String string5 = OBJECT_REFERENCE_CLASS_NAME;
        if (this.fParametersCount > 0) {
            int n = 0;
            while (n < this.fParametersCount) {
                string5 = string5 != null && !string5.equals(OBJECT_REFERENCE_CLASS_NAME) ? String.valueOf(string5) + ", " + stringArray[n] : stringArray[n];
                ++n;
            }
        }
        string4 = Messages.getString((String)"INVOKE");
        string4 = !this.fStringObjectNameData.equals(OBJECT_REFERENCE_CLASS_NAME) ? String.valueOf(string4) + " " + this.fStringObjectNameData + " \"" + string2 + "\" " : String.valueOf(string4) + " \"" + string2 + "\" ";
        if (this.fParametersCount > 0 && !string5.equals(OBJECT_REFERENCE_CLASS_NAME)) {
            string4 = String.valueOf(string4) + Messages.getString((String)"NEWLINE") + Messages.getString((String)"USING") + " " + string5;
        }
        if (!this.fStringReturnData.equals(OBJECT_REFERENCE_CLASS_NAME)) {
            string4 = String.valueOf(string4) + Messages.getString((String)"NEWLINE") + Messages.getString((String)"RETURNING") + " " + string3;
        }
        return string4;
    }

    protected void getParameterListDialog(Text text, int n) {
        ParameterDetails parameterDetails = new ParameterDetails(this.getShell(), text, n);
        parameterDetails.open();
    }

    public String getMethodBody() {
        return this.fStringMethodBody;
    }

    protected void okPressed() {
        this.fStructuresView.setStringPasteIntoEditor(this.fStringMethodBody);
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }
}

