/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.outlineview;

import java.util.ArrayList;
import org.eclipse.cobol.ui.CBDTUiPlugin;

public class Element {
    private Element fParentElement;
    private int blockType = 10;
    private ArrayList childElements = new ArrayList();
    private String data;
    private int lineNumber = -1;
    private int startLine = -1;
    private int endLine = -1;
    private static String DOT = ".";
    private String fLiteralName = "";
    public static final int ENVIRONMENT = 0;
    public static final int DATA = 1;
    public static final int PROCEDURE = 2;
    public static final int DECLARATIVES = 3;
    public static final int SECTION = 4;
    public static final int PARA = 5;
    public static final int PROGRAM = 10;
    public static final int CLASS = 11;
    public static final int FACTORY = 12;
    public static final int OBJECT = 13;
    public static final int METHOD = 14;

    public Element getParent() {
        return this.fParentElement;
    }

    public void setParent(Element element) {
        this.fParentElement = element;
    }

    public void addChildElement(Element element) {
        this.childElements.add(element);
    }

    public ArrayList getChildElements() {
        return this.childElements;
    }

    public void setData(String string) {
        this.data = string;
    }

    public String getData() {
        return this.data;
    }

    public void setBlockType(int n) {
        this.blockType = n;
    }

    public int getBlockType() {
        return this.blockType;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int n) {
        this.startLine = n;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int n) {
        this.endLine = n;
    }

    public boolean getAffectedElement(int n, int n2) {
        return n == this.startLine || n2 == this.startLine || n == this.endLine || n2 == this.endLine || n == this.lineNumber || n2 == this.lineNumber;
    }

    public void insertChildElement(Element element) {
        int n = element.getStartLine();
        int n2 = 0;
        if (this.childElements.size() > 0) {
            int n3 = 0;
            while (n3 < this.childElements.size()) {
                Element element2 = (Element)this.childElements.get(n3);
                n2 = n3;
                if (element2.getStartLine() >= n) break;
                n2 = n3 + 1;
                ++n3;
            }
        }
        this.childElements.add(n2, element);
    }

    public void removeChild(Element element) {
        if (this.childElements.contains(element)) {
            this.childElements.remove(element);
        }
    }

    public void clearElements() {
        try {
            if (this.childElements != null) {
                this.childElements.clear();
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public String getPath() {
        Element element = this;
        String string = "";
        while (element.getParent() != null) {
            DOT = string.trim().length() == 0 ? string : ".";
            string = String.valueOf(element.getData()) + DOT + string;
            element = element.getParent();
        }
        return string;
    }

    public String getLiteralName() {
        return this.fLiteralName;
    }

    public void setLiteralName(String string) {
        this.fLiteralName = string;
    }
}

