/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui.views.outlineview;

import java.util.ArrayList;
import org.eclipse.cobol.ui.views.outlineview.Element;
import org.eclipse.core.resources.IFile;

public class COBOLParserRegistry {
    private static COBOLParserRegistry fCOBOLParserRegistry = null;
    private ArrayList list = new ArrayList(15);

    public void update(IFile iFile, Element element) {
        RegistryElement registryElement = null;
        registryElement = this.exist(iFile);
        if (registryElement != null) {
            registryElement.setStartElement(element);
        } else {
            this.register(iFile, element);
        }
    }

    private void register(IFile iFile, Element element) {
        if (iFile != null) {
            String string = iFile.getFullPath().toOSString();
            RegistryElement registryElement = new RegistryElement(string, element);
            this.list.add(registryElement);
        }
    }

    private RegistryElement exist(IFile iFile) {
        int n = this.list.size();
        String string = iFile.getFullPath().toOSString();
        int n2 = 0;
        while (this.list != null && n2 < n) {
            RegistryElement registryElement = (RegistryElement)this.list.get(n2);
            if (registryElement.getFilePath() != null && registryElement.getFilePath().equals(string)) {
                return registryElement;
            }
            ++n2;
        }
        return null;
    }

    private RegistryElement exist(Element element) {
        int n = this.list.size();
        int n2 = 0;
        while (this.list != null && n2 < n) {
            RegistryElement registryElement = (RegistryElement)this.list.get(n2);
            if (registryElement.getStartElement() != null && registryElement.getStartElement().equals(element)) {
                return registryElement;
            }
            ++n2;
        }
        return null;
    }

    public Element getStartElement(IFile iFile) {
        RegistryElement registryElement = null;
        registryElement = this.exist(iFile);
        if (registryElement != null) {
            return registryElement.getStartElement();
        }
        return null;
    }

    public void remove(IFile iFile) {
        RegistryElement registryElement;
        if (iFile != null && (registryElement = this.exist(iFile)) != null) {
            registryElement.dispose();
            this.list.remove(registryElement);
        }
    }

    public void dispose() {
        if (this.list != null && this.list.size() > 0) {
            int n = 0;
            while (n < this.list.size()) {
                RegistryElement registryElement = (RegistryElement)this.list.get(n);
                if (registryElement != null) {
                    registryElement.dispose();
                    registryElement = null;
                }
                ++n;
            }
            this.list.clear();
            this.list = null;
        }
    }

    class RegistryElement {
        String fFilePath = null;
        Element fStartElement = null;

        public RegistryElement(String string, Element element) {
            this.fFilePath = string;
            this.fStartElement = element;
        }

        public String getFilePath() {
            return this.fFilePath;
        }

        public Element getStartElement() {
            return this.fStartElement;
        }

        public void setStartElement(Element element) {
            if (this.fStartElement != null) {
                this.fStartElement.clearElements();
            }
            this.fStartElement = element;
        }

        public void dispose() {
            this.fStartElement = null;
            this.fFilePath = null;
        }
    }
}

